import { AIMLIcon } from "@/icons/AIML";
import { DuckDuckGoIcon } from "@/icons/DuckDuckGo";
import Perplexity from "@/icons/Perplexity/Perplexity";
import { TavilyIcon } from "@/icons/Tavily";
import { UnstructuredIcon } from "@/icons/Unstructured";
import { AthenaIcon } from "@/icons/athena/index";
import { freezeAllIcon } from "@/icons/freezeAll";
import { GlobeOkIcon } from "@/icons/globe-ok";
import {
  AlertCircle,
  AlertTriangle,
  ArrowBigUp,
  ArrowLeft,
  ArrowRight,
  ArrowUpRight,
  ArrowUpToLine,
  Bell,
  Binary,
  Blocks,
  BookMarked,
  BookmarkPlus,
  Bot,
  BotMessageSquare,
  Boxes,
  Braces,
  BrainCircuit,
  Check,
  CheckCheck,
  CheckCircle2,
  ChevronDown,
  ChevronLeft,
  ChevronRight,
  ChevronRightSquare,
  ChevronUp,
  ChevronsDownUp,
  ChevronsLeft,
  ChevronsRight,
  ChevronsUpDown,
  ChevronsUpDownIcon,
  Circle,
  CircleCheckBig,
  CircleDot,
  CircleOff,
  Clipboard,
  Code,
  Code2,
  Combine,
  Command,
  Compass,
  Copy,
  CornerDownLeft,
  Cpu,
  CpuIcon,
  Database,
  Delete,
  Dot,
  Download,
  DownloadCloud,
  Edit,
  Ellipsis,
  Eraser,
  ExternalLink,
  Eye,
  EyeOff,
  File,
  FileClock,
  FileDown,
  FileSearch,
  FileSearch2,
  FileSliders,
  FileText,
  FileType2,
  FileUp,
  Filter,
  FlaskConical,
  FolderIcon,
  FolderPlus,
  FolderPlusIcon,
  FolderUp,
  FormInput,
  Forward,
  Gift,
  GitBranchPlus,
  GitFork,
  GithubIcon,
  Globe,
  GripVertical,
  Group,
  Hammer,
  Heart,
  HelpCircle,
  Home,
  Image,
  Info,
  Key,
  Keyboard,
  Laptop2,
  Layers,
  LayoutPanelTop,
  Link,
  Link2,
  ListFilter,
  ListOrdered,
  Loader2,
  Lock,
  LockOpen,
  LogIn,
  LogOut,
  LucideSend,
  Maximize2,
  Menu,
  MessageCircle,
  MessageSquare,
  MessageSquareMore,
  MessagesSquare,
  Minimize2,
  Minus,
  MoonIcon,
  MoreHorizontal,
  Network,
  OptionIcon,
  Package2,
  Palette,
  PanelLeftClose,
  PanelLeftOpen,
  Paperclip,
  PaperclipIcon,
  Pencil,
  PencilLine,
  Pin,
  Plane,
  Play,
  Plus,
  PlusCircle,
  PlusSquare,
  PocketKnife,
  Redo,
  RefreshCcw,
  RefreshCcwDot,
  Repeat,
  RotateCcw,
  Save,
  SaveAll,
  Scan,
  ScanEye,
  Scissors,
  ScreenShare,
  Scroll,
  ScrollText,
  Search,
  Settings,
  Settings2,
  Share,
  Share2,
  Shield,
  Sliders,
  SlidersHorizontal,
  Snowflake,
  Sparkles,
  Square,
  SquarePen,
  SquarePlay,
  StickyNote,
  Store,
  SunIcon,
  Table,
  TerminalIcon,
  TerminalSquare,
  TextCursorInput,
  TextSearch,
  ToyBrick,
  Trash2,
  Type,
  Undo,
  Ungroup,
  Unplug,
  Upload,
  User,
  UserCog2,
  UserMinus2,
  UserPlus2,
  Users,
  Users2,
  Variable,
  Wand2,
  Workflow,
  Wrench,
  X,
  XCircle,
  Zap,
  ZoomIn,
  ZoomOut,
} from "lucide-react";
import { FaApple, FaDiscord, FaGithub } from "react-icons/fa";
import { AWSIcon } from "../icons/AWS";
import { AirbyteIcon } from "../icons/Airbyte";
import { AnthropicIcon } from "../icons/Anthropic";
import { AssemblyAIIcon } from "../icons/AssemblyAI";
import { AstraDBIcon } from "../icons/AstraDB";
import { AzureIcon } from "../icons/Azure";
import { BingIcon } from "../icons/Bing";
import { BotMessageSquareIcon } from "../icons/BotMessageSquare";
import { CassandraIcon } from "../icons/Cassandra";
import { ChromaIcon } from "../icons/ChromaIcon";
import { ClickhouseIcon } from "../icons/Clickhouse";
import { CohereIcon } from "../icons/Cohere";
import { ComposioIcon } from "../icons/Composio";
import { ConfluenceIcon } from "../icons/Confluence";
import { CouchbaseIcon } from "../icons/Couchbase";
import { CrewAiIcon } from "../icons/CrewAI";
import { ElasticsearchIcon } from "../icons/ElasticsearchStore";
import { EvernoteIcon } from "../icons/Evernote";
import { FBIcon } from "../icons/FacebookMessenger";
import { FirecrawlIcon } from "../icons/Firecrawl";
import { GitBookIcon } from "../icons/GitBook";
import { GitLoaderIcon } from "../icons/GitLoader";
import { GoogleIcon } from "../icons/Google";
import { GoogleGenerativeAIIcon } from "../icons/GoogleGenerativeAI";
import {
  GradientInfinity,
  GradientSave,
  GradientUngroup,
} from "../icons/GradientSparkles";
import { GroqIcon } from "../icons/Groq";
import { HCDIcon } from "../icons/HCD";
import { HuggingFaceIcon } from "../icons/HuggingFace";
import { IFixIcon } from "../icons/IFixIt";
import { LMStudioIcon } from "../icons/LMStudio";
import { LangChainIcon } from "../icons/LangChain";
import { MaritalkIcon } from "../icons/Maritalk";
import { MetaIcon } from "../icons/Meta";
import { MidjourneyIcon } from "../icons/Midjorney";
import { MongoDBIcon } from "../icons/MongoDB";
import { NotionIcon } from "../icons/Notion";
import { NvidiaIcon } from "../icons/Nvidia";
import { OllamaIcon } from "../icons/Ollama";
import { OpenAiIcon } from "../icons/OpenAi";
import { OpenSearch } from "../icons/OpenSearch";
import { PineconeIcon } from "../icons/Pinecone";
import { PostgresIcon } from "../icons/Postgres";
import { PythonIcon } from "../icons/Python";
import { QDrantIcon } from "../icons/QDrant";
import { QianFanChatIcon } from "../icons/QianFanChat";
import { RedisIcon } from "../icons/Redis";
import { SearxIcon } from "../icons/Searx";
import { ShareIcon } from "../icons/Share";
import { Share2Icon } from "../icons/Share2";
import SvgSlackIcon from "../icons/Slack/SlackIcon";
import { SpiderIcon } from "../icons/Spider";
import { Streamlit } from "../icons/Streamlit";
import { UpstashSvgIcon } from "../icons/Upstash";
import { VectaraIcon } from "../icons/VectaraIcon";
import { VertexAIIcon } from "../icons/VertexAI";
import { WeaviateIcon } from "../icons/Weaviate";
import SvgWikipedia from "../icons/Wikipedia/Wikipedia";
import SvgWolfram from "../icons/Wolfram/Wolfram";
import { HackerNewsIcon } from "../icons/hackerNews";
import { MistralIcon } from "../icons/mistral";
import { SupabaseIcon } from "../icons/supabase";
import { iconsType } from "../types/components";

export const BG_NOISE =
  "url(data:image/png;base64,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)";

export const gradients = [
  "bg-gradient-to-br from-gray-800 via-rose-700 to-violet-900",
  "bg-gradient-to-br from-green-200 via-green-300 to-blue-500",
  "bg-gradient-to-br from-yellow-200 via-yellow-400 to-yellow-700",
  "bg-gradient-to-br from-green-200 via-green-400 to-purple-700",
  "bg-gradient-to-br from-blue-100 via-blue-300 to-blue-500",
  "bg-gradient-to-br from-purple-400 to-yellow-400",
  "bg-gradient-to-br from-red-800 via-yellow-600 to-yellow-500",
  "bg-gradient-to-br from-blue-300 via-green-200 to-yellow-300",
  "bg-gradient-to-br from-blue-700 via-blue-800 to-gray-900",
  "bg-gradient-to-br from-green-300 to-purple-400",
  "bg-gradient-to-br from-yellow-200 via-pink-200 to-pink-400",
  "bg-gradient-to-br from-green-500 to-green-700",
  "bg-gradient-to-br from-rose-400 via-fuchsia-500 to-indigo-500",
  "bg-gradient-to-br from-sky-400 to-blue-500",
  "bg-gradient-to-br from-green-200 via-green-400 to-green-500",
  "bg-gradient-to-br from-red-400 via-gray-300 to-blue-500",
  "bg-gradient-to-br from-gray-900 to-gray-600 bg-gradient-to-r",
  "bg-gradient-to-br from-rose-500 via-red-400 to-red-500",
  "bg-gradient-to-br from-fuchsia-600 to-pink-600",
  "bg-gradient-to-br from-emerald-500 to-lime-600",
  "bg-gradient-to-br from-rose-500 to-indigo-700",
  "bg-gradient-to-br bg-gradient-to-tr from-violet-500 to-orange-300",
  "bg-gradient-to-br from-gray-900 via-purple-900 to-violet-600",
  "bg-gradient-to-br from-yellow-200 via-red-500 to-fuchsia-500",
  "bg-gradient-to-br from-sky-400 to-indigo-900",
  "bg-gradient-to-br from-amber-200 via-violet-600 to-sky-900",
  "bg-gradient-to-br from-amber-700 via-orange-300 to-rose-800",
  "bg-gradient-to-br from-gray-300 via-fuchsia-600 to-orange-600",
  "bg-gradient-to-br from-fuchsia-500 via-red-600 to-orange-400",
  "bg-gradient-to-br from-sky-400 via-rose-400 to-lime-400",
  "bg-gradient-to-br from-lime-600 via-yellow-300 to-red-600",
];

/*
Specifications
#FF3276 -> #F480FF
#1A0250 -> #2F10FE
#98F4FE -> #9BFEAA
#F480FF -> #7528FC
#F480FF -> #9BFEAA
#2F10FE -> #9BFEAA
#BB277F -> #050154
#7528FC -> #9BFEAA
#2F10FE -> #98F4FE
*/
export const flowGradients = [
  "linear-gradient(90deg, #FF3276 0%, #F480FF 100%)",
  "linear-gradient(90deg, #1A0250 0%, #2F10FE 100%)",
  "linear-gradient(90deg, #98F4FE 0%, #9BFEAA 100%)",
  "linear-gradient(90deg, #F480FF 0%, #7528FC 100%)",
  "linear-gradient(90deg, #F480FF 0%, #9BFEAA 100%)",
  "linear-gradient(90deg, #2F10FE 0%, #9BFEAA 100%)",
  "linear-gradient(90deg, #BB277F 0%, #050154 100%)",
  "linear-gradient(90deg, #7528FC 0%, #9BFEAA 100%)",
  "linear-gradient(90deg, #2F10FE 0%, #98F4FE 100%)",
];

export const nodeColors: { [char: string]: string } = {
  inputs: "#10B981",
  outputs: "#AA2411",
  data: "#198BF6",
  prompts: "#4367BF",
  models: "#ab11ab",
  model_specs: "#6344BE",
  chains: "#FE7500",
  list: "#9AAE42",
  agents: "#903BBE",
  tools: "#00fbfc",
  memories: "#F5B85A",
  saved_components: "#a5B85A",
  advanced: "#000000",
  chat: "#198BF6",
  thought: "#272541",
  embeddings: "#42BAA7",
  documentloaders: "#7AAE42",
  vectorstores: "#AA8742",
  vectorsearch: "#AA8742",
  textsplitters: "#B47CB5",
  toolkits: "#DB2C2C",
  wrappers: "#E6277A",
  notion: "#000000",
  Notion: "#000000",
  AssemblyAI: "#213ED7",
  assemblyai: "#213ED7",
  helpers: "#31A3CC",
  prototypes: "#E6277A",
  astra_assistants: "#272541",
  langchain_utilities: "#31A3CC",
  output_parsers: "#E6A627",
  // custom_components: "#ab11ab",
  retrievers: "#e6b25a",
  str: "#4F46E5",
  Text: "#4F46E5",
  unknown: "#9CA3AF",
  Document: "#65a30d",
  Data: "#dc2626",
  Message: "#4f46e5",
  Prompt: "#7c3aed",
  Embeddings: "#10b981",
  BaseLanguageModel: "#c026d3",
  LanguageModel: "#c026d3",
  Agent: "#903BBE",
  Tool: "#00fbfc",
};

export const nodeColorsName: { [char: string]: string } = {
  inputs: "emerald",
  outputs: "red",
  data: "sky",
  prompts: "blue",
  models: "fuchsia",
  model_specs: "violet",
  chains: "orange",
  list: "lime",
  agents: "purple",
  tools: "cyan",
  memories: "amber",
  saved_components: "lime",
  advanced: "slate",
  chat: "sky",
  thought: "zinc",
  embeddings: "teal",
  documentloaders: "lime",
  vectorstores: "yellow",
  vectorsearch: "yellow",
  textsplitters: "fuchsia",
  toolkits: "red",
  wrappers: "pink",
  notion: "slate",
  Notion: "slate",
  AssemblyAI: "blue",
  assemblyai: "blue",
  helpers: "cyan",
  prototypes: "pink",
  astra_assistants: "indigo",
  langchain_utilities: "sky",
  output_parsers: "yellow",
  // custom_components: "#ab11ab",
  retrievers: "yellow",
  str: "indigo",
  Text: "indigo",
  unknown: "gray",
  Document: "lime",
  Data: "red",
  Message: "indigo",
  Prompt: "violet",
  Embeddings: "emerald",
  BaseLanguageModel: "fuchsia",
  LanguageModel: "fuchsia",
  Agent: "purple",
  Tool: "cyan",
  BaseChatMemory: "cyan",
};

export const SIDEBAR_CATEGORIES = [
  { display_name: "Saved", name: "saved_components", icon: "GradientSave" },
  { display_name: "Inputs", name: "inputs", icon: "Download" },
  { display_name: "Outputs", name: "outputs", icon: "Upload" },
  { display_name: "Prompts", name: "prompts", icon: "TerminalSquare" },
  { display_name: "Data", name: "data", icon: "Database" },
  { display_name: "Models", name: "models", icon: "BrainCircuit" },
  { display_name: "Helpers", name: "helpers", icon: "Wand2" },
  { display_name: "Vector Stores", name: "vectorstores", icon: "Layers" },
  { display_name: "Embeddings", name: "embeddings", icon: "Binary" },
  { display_name: "Agents", name: "agents", icon: "Bot" },
  { display_name: "Chains", name: "chains", icon: "Link" },
  { display_name: "Loaders", name: "documentloaders", icon: "Paperclip" },
  {
    display_name: "Utilities",
    name: "langchain_utilities",
    icon: "PocketKnife",
  },
  { display_name: "Link Extractors", name: "link_extractors", icon: "Link2" },
  { display_name: "Memories", name: "memories", icon: "Cpu" },
  { display_name: "Output Parsers", name: "output_parsers", icon: "Compass" },
  { display_name: "Prototypes", name: "prototypes", icon: "FlaskConical" },
  { display_name: "Retrievers", name: "retrievers", icon: "FileSearch" },
  { display_name: "Text Splitters", name: "textsplitters", icon: "Scissors" },
  { display_name: "Toolkits", name: "toolkits", icon: "Package2" },
  { display_name: "Tools", name: "tools", icon: "Hammer" },
];

export const SIDEBAR_BUNDLES = [
  { display_name: "CrewAI", name: "crewai", icon: "CrewAi" },
  { display_name: "LangChain", name: "langchain_utilities", icon: "LangChain" },
  { display_name: "AssemblyAI", name: "assemblyai", icon: "AssemblyAI" },
  {
    display_name: "Astra Assistants",
    name: "astra_assistants",
    icon: "Sparkles",
  },
  { display_name: "Google", name: "google", icon: "Google" },
  { display_name: "Firecrawl", name: "firecrawl", icon: "FirecrawlCrawlApi" },
  { display_name: "Notion", name: "Notion", icon: "Notion" },
  { display_name: "NVIDIA", name: "nvidia", icon: "NVIDIA" },
  { display_name: "Vectara", name: "vectara", icon: "Vectara" },
];

export const categoryIcons = {
  saved_components: GradientSave,
  inputs: Download,
  outputs: Upload,
  prompts: TerminalSquare,
  data: Database,
  models: BrainCircuit,
  helpers: Wand2,
  vectorstores: Layers,
  embeddings: Binary,
  agents: Bot,
  astra_assistants: Sparkles,
  chains: Link,
  documentloaders: Paperclip,
  langchain_utilities: PocketKnife,
  link_extractors: Link2,
  memories: Cpu,
  output_parsers: Compass,
  prototypes: FlaskConical,
  retrievers: FileSearch,
  textsplitters: Scissors,
  toolkits: Package2,
  tools: Hammer,
  custom: Edit,
  custom_components: GradientInfinity,
};

export const nodeIconsLucide: iconsType = {
  //Category Icons
  inputs: Download,
  outputs: Upload,
  prompts: TerminalSquare,
  data: Database,
  models: BrainCircuit,
  helpers: Wand2,
  vectorstores: Layers,
  embeddings: Binary,
  agents: Bot,
  astra_assistants: Sparkles,
  chains: Link,
  documentloaders: Paperclip,
  langchain_utilities: PocketKnife,
  link_extractors: Link2,
  memories: Cpu,
  output_parsers: Compass,
  prototypes: FlaskConical,
  retrievers: FileSearch,
  textsplitters: Scissors,
  toolkits: Package2,
  tools: Hammer,
  custom_components: GradientInfinity,
  ChatInput: MessagesSquare,
  ChatOutput: MessagesSquare,
  //Integration Icons
  LMStudio: LMStudioIcon,
  Notify: Bell,
  ListFlows: Group,
  ClearMessageHistory: FileClock,
  Python: PythonIcon,
  AzureChatOpenAi: AzureIcon,
  Ollama: OllamaIcon,
  ChatOllama: OllamaIcon,
  AzureOpenAiEmbeddings: AzureIcon,
  Azure: AzureIcon,
  OllamaEmbeddings: OllamaIcon,
  ChatOllamaModel: OllamaIcon,
  FAISS: MetaIcon,
  Maritalk: MaritalkIcon,
  FaissSearch: MetaIcon,
  LangChain: LangChainIcon,
  AzureOpenAiModel: AzureIcon,
  Redis: RedisIcon,
  RedisSearch: RedisIcon,
  PostgresChatMessageHistory: PostgresIcon,
  BaiduQianfan: QianFanChatIcon,
  Vectara: VectaraIcon,
  ArrowUpToLine: ArrowUpToLine,
  Cassandra: CassandraIcon,
  Chroma: ChromaIcon,
  Couchbase: CouchbaseIcon,
  Clickhouse: ClickhouseIcon,
  AirbyteJSONLoader: AirbyteIcon,
  AmazonBedrockEmbeddings: AWSIcon,
  Amazon: AWSIcon,
  Anthropic: AnthropicIcon,
  ChatAnthropic: AnthropicIcon,
  assemblyai: AssemblyAIIcon,
  AssemblyAI: AssemblyAIIcon,
  AstraDB: AstraDBIcon,
  BingSearchAPIWrapper: BingIcon,
  BingSearchRun: BingIcon,
  Cohere: CohereIcon,
  ChevronsUpDownIcon,
  CohereEmbeddings: CohereIcon,
  EverNoteLoader: EvernoteIcon,
  FacebookChatLoader: FBIcon,
  FirecrawlCrawlApi: FirecrawlIcon,
  FirecrawlScrapeApi: FirecrawlIcon,
  GitbookLoader: GitBookIcon,
  GoogleSearchAPIWrapper: GoogleIcon,
  GoogleSearchResults: GoogleIcon,
  GoogleSearchRun: GoogleIcon,
  Google: GoogleIcon,
  GoogleGenerativeAI: GoogleGenerativeAIIcon,
  Groq: GroqIcon,
  HCD: HCDIcon,
  HNLoader: HackerNewsIcon,
  Unstructured: UnstructuredIcon,
  Filter: Filter,
  HuggingFaceHub: HuggingFaceIcon,
  HuggingFace: HuggingFaceIcon,
  HuggingFaceEmbeddings: HuggingFaceIcon,
  IFixitLoader: IFixIcon,
  CrewAI: CrewAiIcon,
  Composio: ComposioIcon,
  Meta: MetaIcon,
  Midjorney: MidjourneyIcon,
  MongoDBAtlasVectorSearch: MongoDBIcon,
  MongoDB: MongoDBIcon,
  MongoDBChatMessageHistory: MongoDBIcon,
  notion: NotionIcon,
  Notion: NotionIcon,
  NotionDirectoryLoader: NotionIcon,
  NVIDIA: NvidiaIcon,
  ChatOpenAI: OpenAiIcon,
  AzureChatOpenAI: OpenAiIcon,
  OpenAI: OpenAiIcon,
  OpenAIEmbeddings: OpenAiIcon,
  Pinecone: PineconeIcon,
  Qdrant: QDrantIcon,
  ElasticsearchStore: ElasticsearchIcon,
  Weaviate: WeaviateIcon,
  Searx: SearxIcon,
  SlackDirectoryLoader: SvgSlackIcon,
  SpiderTool: SpiderIcon,
  SupabaseVectorStore: SupabaseIcon,
  Supabase: SupabaseIcon,
  VertexAI: VertexAIIcon,
  ChatVertexAI: VertexAIIcon,
  VertexAIEmbeddings: VertexAIIcon,
  Share3: ShareIcon,
  Share4: Share2Icon,
  WikipediaAPIWrapper: SvgWikipedia,
  WolframAlphaAPIWrapper: SvgWolfram,
  WikipediaQueryRun: SvgWikipedia,
  WolframAlphaQueryRun: SvgWolfram,
  group_components: GradientUngroup,
  Streamlit,
  Discord: FaDiscord,
  MistralAI: MistralIcon,
  Upstash: UpstashSvgIcon,
  PGVector: CpuIcon,
  Confluence: ConfluenceIcon,
  AIML: AIMLIcon,
  "AI/ML": AIMLIcon,
  GitLoader: GitLoaderIcon,
  athenaIcon: AthenaIcon,
  DuckDuckGo: DuckDuckGoIcon,
  Perplexity,
  TavilyIcon,
  OpenSearch,
  GithubIcon,
  FaGithub,
  FaApple,

  //Node Icons
  model_specs: FileSliders,
  advanced: Laptop2,
  chat: MessageCircle,
  saved_components: GradientSave,
  vectorsearch: TextSearch,
  wrappers: Gift,
  unknown: HelpCircle,
  custom: Edit,
  Keyboard,
  ArrowRight,
  Play,
  BotMessageSquareIcon,
  CheckCheck,
  ListFilter,
  ScrollText,
  Workflow,
  User,
  ScanEye,
  Type,
  FolderIcon,
  X,
  Trash2,
  CircleOff,
  Boxes,
  Network,
  XCircle,
  Info,
  CheckCircle2,
  SquarePen,
  Zap,
  MessagesSquare,
  ExternalLink,
  ChevronsUpDown,
  Check,
  Home,
  Users2,
  SunIcon,
  MoonIcon,
  Bell,
  AlertTriangle,
  ChevronLeft,
  SlidersHorizontal,
  Palette,
  RefreshCcwDot,
  FolderUp,
  SquarePlay,
  LayoutPanelTop,
  Database,
  Blocks,
  ChevronDown,
  ArrowLeft,
  BrainCircuit,
  Wand2,
  Layers,
  Binary,
  Paperclip,
  PocketKnife,
  Scissors,
  Cpu,
  Hammer,
  GradientSave,
  Shield,
  Plus,
  Redo,
  Settings2,
  FileType2,
  Undo,
  FileSearch2,
  ChevronRight,
  Circle,
  CircleDot,
  Clipboard,
  PlusCircle,
  PlusSquare,
  Code2,
  Globe,
  Variable,
  Snowflake,
  Store,
  Download,
  Eraser,
  Lock,
  LockOpen,
  LucideSend,
  Sparkles,
  DownloadCloud,
  File,
  FileText,
  FolderPlus,
  GitFork,
  FileDown,
  FileUp,
  Menu,
  Save,
  Search,
  Copy,
  Upload,
  MessageSquare,
  MoreHorizontal,
  UserMinus2,
  UserPlus2,
  Pencil,
  ChevronsRight,
  ChevronsLeft,
  EyeOff,
  Eye,
  UserCog2,
  Key,
  Unplug,
  Group,
  LogIn,
  ChevronUp,
  PencilLine,
  Ungroup,
  BookMarked,
  Minus,
  LogOut,
  BotMessageSquare,
  Square,
  Minimize2,
  Maximize2,
  FormInput,
  ChevronRightSquare,
  Plane,
  Users,
  ListOrdered,
  SaveAll,
  MessageSquareMore,
  Forward,
  Share2,
  Share,
  GitBranchPlus,
  Loader2,
  BookmarkPlus,
  Heart,
  Package2,
  FileSearch,
  Compass,
  Link2,
  Pin,
  Link,
  ToyBrick,
  RefreshCcw,
  Combine,
  TerminalIcon,
  TerminalSquare,
  TextCursorInput,
  Repeat,
  Sliders,
  ScreenShare,
  Code,
  Ellipsis,
  Braces,
  FlaskConical,
  AlertCircle,
  Bot,
  Delete,
  Command,
  ArrowBigUp,
  Dot,
  StickyNote,
  note: StickyNote,
  RotateCcw,
  Wrench,
  GripVertical,
  FolderPlusIcon,
  PaperclipIcon,
  Settings,
  PanelLeftClose,
  PanelLeftOpen,
  ArrowUpRight,
  Scroll,
  Image,
  CornerDownLeft,
  ChevronsDownUp,
  OptionIcon,
  Option: OptionIcon,
  FreezeAll: freezeAllIcon,
  Table,
  Scan,
  GlobeOkIcon,
  CircleCheckBig,
  ZoomIn,
  ZoomOut,
};
