const SvgCrewAiIcon = (props) => (
  <svg
    version="1.1"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
    width="1856"
    height="640"
    viewBox="0 0 1856 640"
    style={{ width: "20%", height: "25%" }}
    {...props}
  >
    <path
      d="M0 0 C1.29195282 0.00182281 2.58390564 0.00364563 3.91500854 0.00552368 C28.44466527 0.06336198 52.75720004 1.17052794 77.1875 3.3125 C78.14779114 3.395 79.10808228 3.4775 80.09747314 3.5625 C162.75674065 10.67724112 244.77476948 24.60656275 326.1875 40.3125 C327.42462234 40.5508683 327.42462234 40.5508683 328.68673706 40.79405212 C392.75627044 53.14070168 456.64332972 66.34761292 520.50215197 79.73350489 C522.8103573 80.21725859 525.11861427 80.70076509 527.42689133 81.18417645 C528.17686606 81.34124563 528.9268408 81.49831482 529.69954205 81.66014367 C531.19345428 81.97301537 532.68736918 82.28587435 534.18128681 82.59872025 C537.73611766 83.34334518 541.29074231 84.08892686 544.84488297 84.83683968 C546.18533291 85.1188657 547.5257857 85.40087819 548.86624146 85.68287659 C549.8440098 85.88861387 549.8440098 85.88861387 550.84153104 86.09850746 C555.22339309 87.01904766 559.6084231 87.92327295 563.99478149 88.82211304 C568.87722425 89.82296796 573.74432595 90.87725216 578.60848999 91.96328735 C580.95572685 92.46586605 583.30310238 92.96779766 585.65063477 93.46899414 C587.24624379 93.84245295 587.24624379 93.84245295 588.87408733 94.22345638 C595.26923801 95.57579208 595.26923801 95.57579208 601.28048706 93.53863525 C604.58771139 90.89919861 606.91616231 88.16705294 609.4375 84.8125 C610.3743232 83.7114717 611.32101423 82.61876777 612.27709961 81.53442383 C614.13232578 79.42320585 615.95132445 77.28898838 617.74755859 75.12744141 C620.78842848 71.61921349 624.02248383 68.74670314 627.75 66 C628.29438721 65.59281738 628.83877441 65.18563477 629.3996582 64.76611328 C630.98427502 63.59936187 632.58581947 62.45571424 634.1875 61.3125 C635.33195404 60.46388898 636.47515401 59.61358447 637.6171875 58.76171875 C645.81164262 52.70907418 654.34457522 47.36126903 663.1875 42.3125 C664.321875 41.65636719 665.45625 41.00023437 666.625 40.32421875 C691.14862939 26.48815866 718.45873383 17.78722058 746.1875 13.3125 C747.0734082 13.16296875 747.95931641 13.0134375 748.87207031 12.859375 C810.48495664 2.85994189 882.91456827 11.15742334 935.171875 47.13671875 C950.37650242 58.10689682 964.94427179 70.19158907 976.1875 85.3125 C976.63029297 85.90691895 977.07308594 86.50133789 977.52929688 87.11376953 C978.9468329 89.02666537 980.35176233 90.94795904 981.75 92.875 C982.19255127 93.4834375 982.63510254 94.091875 983.09106445 94.71875 C986.1875 99.07189788 986.1875 99.07189788 986.1875 101.3125 C986.76193848 101.135979 987.33637695 100.95945801 987.92822266 100.77758789 C990.55512803 99.97279046 993.18378101 99.17385271 995.8125 98.375 C996.71613281 98.09720703 997.61976562 97.81941406 998.55078125 97.53320312 C999.87529297 97.13198242 999.87529297 97.13198242 1001.2265625 96.72265625 C1002.03303223 96.47652588 1002.83950195 96.23039551 1003.67041016 95.97680664 C1021.37884927 91.3032215 1042.77294738 92.9872214 1060.1875 98.3125 C1060.89148926 98.52680664 1061.59547852 98.74111328 1062.32080078 98.96191406 C1084.12317859 105.85955788 1103.54743981 120.15462132 1114.51171875 140.4609375 C1127.03464323 165.15382917 1128.03927933 191.38439299 1120.125 217.625 C1110.37135065 245.23131111 1090.37246577 271.79168406 1067.734375 290.3203125 C1065.87682899 292.23956863 1065.87682899 292.23956863 1066.453125 294.921875 C1066.77796875 295.95828125 1067.1028125 296.9946875 1067.4375 298.0625 C1076.1432187 333.17800398 1060.45054416 370.09988153 1049.1875 402.8125 C1036.87725477 438.56988551 1026.13155656 474.70398462 1021.1875 512.3125 C1021.0836499 513.07159668 1020.9797998 513.83069336 1020.87280273 514.61279297 C1019.9632795 522.21986127 1020.00070622 529.86119779 1020.00109863 537.51104736 C1020.00035921 539.14415257 1019.99514984 540.77726121 1019.98571777 542.41033936 C1019.93334271 551.7132893 1020.20911393 560.69226333 1021.5168457 569.92163086 C1023.12001362 581.41549813 1023.12001362 581.41549813 1021.23339844 585.25341797 C1018.66086337 588.63047243 1015.57880139 590.87760459 1011.97241211 593.11669922 C1009.17787449 594.988898 1006.75659085 597.25448742 1004.25 599.48999023 C976.81874908 623.72937093 942.87375621 641.96694084 905.51660156 640.46484375 C885.65974929 639.16603077 869.02901672 630.04970776 855.421875 615.88671875 C851.98764891 611.93015407 849.0172876 607.71647409 846.1875 603.3125 C841.31885449 604.35578118 836.50532487 605.49297047 831.69555664 606.78320312 C800.08982724 615.1140507 765.61025247 612.99238468 736.93359375 596.43359375 C732.71309028 593.70980077 728.7322819 590.81743677 724.921875 587.546875 C724.38079102 587.0825708 723.83970703 586.6182666 723.28222656 586.13989258 C721.76595065 584.81837409 720.27287586 583.47037359 718.78125 582.12109375 C716.44001566 580.04925807 716.44001566 580.04925807 714.23999023 580.5949707 C710.92030637 581.75549775 707.86289569 583.44332192 704.75 585.0625 C674.88599085 600.16288532 641.99822363 602.88140675 610 592.625 C582.65713561 583.25275103 562.82538309 563.81625338 550.04931641 538.14453125 C548.09463663 533.98931396 546.56978327 529.68669903 545.1875 525.3125 C541.6202081 527.9988259 538.86867276 530.73450407 536.125 534.25 C524.60723048 548.59468476 511.67609218 561.97360177 497.1875 573.3125 C496.14557539 574.1455108 495.10391637 574.97885389 494.0625 575.8125 C486.77950225 581.58886066 479.2589614 586.67351407 471.1875 591.3125 C470.60242676 591.65023437 470.01735352 591.98796875 469.41455078 592.3359375 C435.2616975 611.86758807 396.93045915 615.78205387 359.0625 605.5625 C338.21706381 599.67929967 318.55331675 592.25659937 301.82421875 578.18359375 C299.18267512 575.92668594 299.18267512 575.92668594 295.1875 576.3125 C293.49738471 577.51668809 293.49738471 577.51668809 292.0078125 579.2421875 C291.41589111 579.86810791 290.82396973 580.49402832 290.21411133 581.13891602 C289.58657959 581.81494873 288.95904785 582.49098145 288.3125 583.1875 C273.08065705 598.974176 254.55721784 610.83173939 232.0625 611.5625 C195.56826202 611.15296366 157.14066176 597.97177566 130.1875 573.3125 C128.25 570.9375 128.25 570.9375 127.1875 569.3125 C122.75582986 570.2263397 119.55850446 572.61391125 115.875 575.125 C65.51596954 608.35010575 3.21046538 618.78071709 -55.82836914 607.1809082 C-78.74530259 602.25648421 -101.57993229 593.33723249 -119.8125 578.3125 C-120.34891113 577.88388672 -120.88532227 577.45527344 -121.43798828 577.01367188 C-139.14643932 562.83113075 -160.48067666 539.7721876 -163.8125 516.3125 C-164.68390625 516.57804688 -165.5553125 516.84359375 -166.453125 517.1171875 C-167.64421875 517.47039063 -168.8353125 517.82359375 -170.0625 518.1875 C-171.22265625 518.53554688 -172.3828125 518.88359375 -173.578125 519.2421875 C-183.91296946 521.99031946 -194.09467143 522.65922945 -204.73754883 522.62817383 C-206.97983175 522.62502829 -209.22077089 522.64851427 -211.46289062 522.67382812 C-239.33359732 522.79648892 -265.84530267 514.3312582 -286 494.5 C-291.25792444 489.20652616 -295.65896953 483.51836317 -299.8125 477.3125 C-320.91143244 509.99317834 -320.91143244 509.99317834 -337.8125 544.9375 C-343.0208897 557.72726372 -349.84737112 568.76998764 -358.8125 579.3125 C-359.575625 580.323125 -360.33875 581.33375 -361.125 582.375 C-377.61982832 600.40423096 -401.6040005 610.92329319 -425.83032227 612.4387207 C-441.96467034 613.04906292 -457.36866948 611.05284397 -472.515625 605.3984375 C-480.21899536 602.86107143 -484.2353236 603.43060621 -491.3125 606.8125 C-537.35999578 627.41544707 -591.34643269 630.78040647 -638.9375 613.5625 C-674.48780291 599.98802136 -702.20291477 573.15009849 -718 538.6875 C-722.30966604 528.86451028 -725.3554911 518.74233342 -727.8125 508.3125 C-727.99184082 507.55936523 -728.17118164 506.80623047 -728.35595703 506.03027344 C-741.93334361 445.43764654 -718.17438422 380.58304029 -686.25537109 329.83691406 C-668.12087723 301.60241186 -645.81524962 273.58237406 -618.8125 253.3125 C-618.19922852 252.83925293 -617.58595703 252.36600586 -616.95410156 251.87841797 C-582.62449764 225.46154946 -542.58988916 210.11181418 -498.89746094 214.61279297 C-493.72897602 215.39574562 -488.76997841 216.66631442 -483.8125 218.3125 C-482.86262207 218.62598389 -482.86262207 218.62598389 -481.89355469 218.94580078 C-467.15447643 223.9988746 -452.99532152 231.62631217 -440.8125 241.3125 C-439.92433594 241.99828125 -439.03617187 242.6840625 -438.12109375 243.390625 C-430.80404485 249.17765087 -424.2944334 255.62694566 -417.8125 262.3125 C-413.94686284 260.71916946 -411.47406903 258.20841231 -408.5 255.3125 C-386.01348077 234.13819144 -359.0270948 226.41888485 -328.71289062 227.17626953 C-307.28252699 228.18284722 -288.27881619 238.93620586 -273.8125 254.3125 C-273.8125 254.9725 -273.8125 255.6325 -273.8125 256.3125 C-272.81992187 255.80460938 -271.82734375 255.29671875 -270.8046875 254.7734375 C-234.4897253 236.30728598 -200.1400663 229.59553252 -159.8125 238.3125 C-160.2971875 237.54550781 -160.781875 236.77851563 -161.28125 235.98828125 C-183.7275879 198.82232561 -188.12680522 151.66513969 -177.90039062 109.92236328 C-172.73019143 89.97437965 -163.20568691 70.99028374 -149.8125 55.3125 C-148.99910156 54.34828125 -148.18570313 53.3840625 -147.34765625 52.390625 C-141.71109995 45.94375808 -135.64310068 40.46557188 -128.8125 35.3125 C-127.40291016 34.23742188 -127.40291016 34.23742188 -125.96484375 33.140625 C-105.71381022 18.40309866 -82.87219845 9.65969104 -58.5 4.4375 C-57.60756592 4.24623535 -56.71513184 4.0549707 -55.7956543 3.85791016 C-37.30992786 0.2062039 -18.78289093 -0.05510038 0 0 Z "
      fill="#461816"
      transform="translate(730.8125,-0.3125)"
    />
    <path
      d="M0 0 C1.34292618 -0.00009064 1.34292618 -0.00009064 2.71298218 -0.00018311 C19.23182773 0.01555593 35.63811177 0.72997246 52.10986328 1.92285156 C55.50859744 2.16174586 58.90674121 2.36655193 62.30859375 2.5546875 C142.04437069 7.20335166 221.42285318 21.87144393 299.875 36.1875 C300.64676575 36.32822937 301.41853149 36.46895874 302.21368408 36.61395264 C307.20659491 37.52555299 312.19764624 38.44682177 317.1875 39.375 C318.34088867 39.58866211 319.49427734 39.80232422 320.68261719 40.02246094 C329.24398588 41.63335325 337.76752007 43.40672577 346.29348755 45.19410706 C356.90260162 47.41335163 367.53185916 49.52724565 378.16311646 51.63735962 C400.68470039 56.1102973 423.17733496 60.71114334 445.65454102 65.40161133 C457.2594636 67.82214011 468.86939363 70.20611708 480.5 72.5 C489.17611533 74.21226532 497.81346423 76.04265529 506.4375 78 C519.66915767 81.00202234 532.9682502 83.63741691 546.27639771 86.27490234 C557.99571164 88.59802298 569.70028398 90.96147811 581.375 93.5 C589.51057799 95.26042464 597.64773164 97.00443013 605.8125 98.625 C606.66585937 98.80135986 607.51921875 98.97771973 608.3984375 99.15942383 C614.21521559 100.40509977 614.21521559 100.40509977 619.875 99.1875 C621.77382974 97.11416722 623.371026 95.14191681 625 92.875 C625.97143821 91.58435381 626.94678495 90.29664132 627.92578125 89.01171875 C628.41771973 88.36509277 628.9096582 87.7184668 629.41650391 87.05224609 C633.25031776 82.15056042 637.56960228 77.67269581 641.875 73.1875 C642.41527832 72.61999023 642.95555664 72.05248047 643.51220703 71.46777344 C681.24919873 32.01791229 734.05401973 11.32351986 788.25 9.984375 C831.92854347 9.46568204 880.89907775 15.47269963 915.875 44.1875 C916.37902344 44.58904297 916.88304687 44.99058594 917.40234375 45.40429688 C937.19855324 61.18904425 955.1126207 82.54854529 958.5625 108.5625 C958.68881844 110.10250989 958.79166646 111.64456697 958.875 113.1875 C958.92785156 114.06792969 958.98070312 114.94835937 959.03515625 115.85546875 C959.6040908 134.18505579 954.02947946 151.02417076 941.98046875 164.9609375 C913.34811925 195.2400455 865.59328179 204.97750822 825.47390747 206.26452637 C797.96305511 206.94457641 770.99873118 206.12019333 743.72229004 202.55517578 C738.1588915 201.83676393 732.59070716 201.15639149 727.0234375 200.46875 C719.75631692 199.56942468 712.48981061 198.66626556 705.22631836 197.73803711 C689.45916046 195.72584502 673.6781761 193.8940171 657.875 192.1875 C657.57415497 192.95843994 657.27330994 193.72937988 656.96334839 194.52368164 C655.79234234 197.38981113 654.37891544 199.95019437 652.8203125 202.625 C651.9077771 204.19761597 651.9077771 204.19761597 650.97680664 205.80200195 C650.32446045 206.91921631 649.67211426 208.03643066 649 209.1875 C648.31654152 210.36457535 647.6335229 211.54190621 646.95092773 212.71948242 C645.57277421 215.0967043 644.19345198 217.47324001 642.81298828 219.84912109 C629.65916215 242.50790398 617.03049802 265.4502458 604.59790039 288.51098633 C600.41423432 296.24737114 596.09874889 303.90378326 591.74707031 311.54663086 C587.88060253 318.35591022 584.13908127 325.22494325 580.4375 332.125 C573.87799717 344.32180798 566.93657853 356.27585688 559.875 368.1875 C559.10373779 369.49412598 559.10373779 369.49412598 558.31689453 370.82714844 C546.30608225 391.15915152 533.68184685 411.02317011 519.875 430.1875 C519.24368164 431.06390137 519.24368164 431.06390137 518.59960938 431.95800781 C508.58458569 445.76918613 497.68457043 458.88138141 485.875 471.1875 C485.02164063 472.08210938 484.16828125 472.97671875 483.2890625 473.8984375 C462.58491352 495.12508866 434.0474046 514.02240894 403.44458008 514.56787109 C375.82138182 514.51013139 346.18865006 505.42233223 326.30078125 485.625 C315.19531469 472.95458653 309.23582592 455.85761753 307.875 439.1875 C303.68144972 442.98951487 300.6004911 447.55523447 297.3125 452.125 C292.24668707 459.08644581 287.01678424 465.7889715 281.375 472.2890625 C279.03703709 474.99963825 276.79436138 477.76446791 274.5625 480.5625 C248.56668026 512.30427633 248.56668026 512.30427633 233.96484375 514.65625 C212.52025913 514.86883572 183.80144553 507.22497652 167.8359375 492.26953125 C154.08063324 477.66479585 147.68228752 460.03918715 141.875 441.1875 C139.60909922 440.95244676 139.60909922 440.95244676 137.73828125 443.3125 C136.89652344 444.26125 136.05476563 445.21 135.1875 446.1875 C134.7347168 446.69297363 134.28193359 447.19844727 133.81542969 447.71923828 C131.89651325 449.86796098 130.0032237 452.03456198 128.15234375 454.2421875 C99.68861738 488.16570793 55.80055875 510.30330413 11.875 514.1875 C5.62985209 514.54007923 -0.62194752 514.52897012 -6.875 514.5 C-7.71327332 514.49784485 -8.55154663 514.4956897 -9.41522217 514.49346924 C-21.53860377 514.44344312 -33.31338376 514.17174545 -45.125 511.1875 C-46.30787598 510.90543701 -46.30787598 510.90543701 -47.51464844 510.61767578 C-73.32953477 504.30212262 -95.16939784 491.14116624 -109.33789062 468.19238281 C-127.81169175 436.93304136 -126.00300197 397.77132437 -117.4375 363.75 C-107.77446012 327.59415087 -89.46961362 296.51000543 -64.125 269.1875 C-63.26068359 268.22457031 -63.26068359 268.22457031 -62.37890625 267.2421875 C-43.13830965 246.75887976 -12.86667617 229.3663136 15.58862305 228.06323242 C29.30765679 227.70966601 42.52437862 227.84984466 55.875 231.1875 C56.54144531 231.35378906 57.20789063 231.52007812 57.89453125 231.69140625 C78.53751265 237.01990049 95.62499819 247.6388393 106.875 266.1875 C113.7450024 278.84770943 116.45062677 290.89718769 116.375 305.25 C116.36927979 306.5191626 116.36355957 307.7883252 116.35766602 309.09594727 C115.95961775 330.22735113 109.02062825 347.66307573 95.875 364.1875 C95.35679687 364.87070312 94.83859375 365.55390625 94.3046875 366.2578125 C75.99995839 388.97775265 44.01150385 400.77580358 15.875 404.1875 C12.87735794 404.36646665 9.88098465 404.44080247 6.87890625 404.50390625 C6.04536118 404.52468735 5.2118161 404.54546844 4.35301208 404.56687927 C1.71458439 404.63177856 -0.92393491 404.69097978 -3.5625 404.75 C-5.36133724 404.79324206 -7.16016554 404.83685808 -8.95898438 404.88085938 C-13.3475646 404.98739799 -17.7362361 405.08882975 -22.125 405.1875 C-17.85114648 417.7885286 -12.26812741 427.78882182 -0.125 434.1875 C2.52875838 435.40626826 5.21412885 436.50916254 7.9375 437.5625 C8.58589844 437.81362549 9.23429688 438.06475098 9.90234375 438.32348633 C29.1342045 445.24338401 51.62635126 441.67622194 69.80078125 433.64453125 C86.50982382 425.72525186 101.41373826 415.93115772 114.875 403.1875 C116.22396373 402.0148213 117.57795411 400.84789366 118.9375 399.6875 C123.46307736 395.73907117 127.75595956 391.55797199 131.875 387.1875 C132.75671875 386.42308594 133.6384375 385.65867187 134.546875 384.87109375 C138.3648474 380.20060008 137.96090359 373.77380865 138.30459595 368.00436401 C138.53081042 364.27361726 138.8391469 360.54951314 139.140625 356.82421875 C139.19930252 356.0808577 139.25798004 355.33749664 139.31843567 354.5716095 C142.66159353 313.42188332 154.59798014 266.28749376 186.875 238.1875 C199.48037789 228.98357328 213.02910886 226.58266056 228.27734375 228.6484375 C237.67897384 230.7054222 245.1857197 234.95397623 250.65625 243.0078125 C259.17135328 258.23674721 253.87366225 275.50169665 250.0625 291.3125 C249.56453768 293.42878855 249.06764794 295.54532973 248.57177734 297.66210938 C244.96519836 312.97426691 241.14589544 328.23351426 237.29327393 343.48529053 C234.02246972 356.43705659 230.83145522 369.37726946 228.37792969 382.51416016 C228.02826084 384.37283681 227.66599851 386.22917044 227.29394531 388.08349609 C224.99876738 399.55002533 223.51205705 410.72678066 223.4375 422.4375 C223.4223938 423.93591431 223.4223938 423.93591431 223.40698242 425.46459961 C223.52071818 435.1321389 225.04749997 445.24090904 230.875 453.1875 C232.73759537 454.50801497 232.73759537 454.50801497 234.875 454.1875 C245.81093786 448.58396159 252.00321965 435.50095598 257.875 425.1875 C258.55457185 424.0103499 259.23425731 422.83326537 259.9140625 421.65625 C262.28195194 417.5260795 264.58298164 413.36014881 266.875 409.1875 C267.3714502 408.28628418 267.86790039 407.38506836 268.37939453 406.45654297 C276.9981661 390.75001696 285.15942056 374.82744471 293.1875 358.8125 C293.64522797 357.90222046 294.10295593 356.99194092 294.57455444 356.05407715 C300.12013561 345.01245005 305.45888356 333.90272808 310.50630188 322.62368774 C312.85984209 317.3687325 315.31383807 312.18799493 317.9375 307.0625 C320.51769923 302.01491238 322.88229444 296.92324474 325.12670898 291.71679688 C331.28446115 277.50886448 338.87733467 265.20527075 349.875 254.1875 C350.50792969 253.54296875 351.14085937 252.8984375 351.79296875 252.234375 C362.05270459 242.50349153 374.29706106 238.63752999 388.14453125 238.875 C397.83034296 239.6863769 407.6250789 242.45862046 414.875 249.1875 C421.92468784 257.53140699 423.83245305 266.13068236 423.11767578 276.92919922 C420.03300412 305.63464478 408.69068531 334.40915882 399.34277344 361.5925293 C396.80212079 369.00795119 394.62592591 376.48286593 392.625 384.0625 C392.3784668 384.98998047 392.13193359 385.91746094 391.87792969 386.87304688 C386.94289159 406.0534854 383.56425456 430.44664998 391.875 449.1875 C394.01905325 452.1969967 394.01905325 452.1969967 396.875 454.1875 C406.61523722 455.11054935 415.08803344 449.35231668 422.27734375 443.46484375 C426.06141174 440.16784409 429.10881199 436.49817003 432.125 432.5 C432.68582275 431.7579834 433.24664551 431.0159668 433.82446289 430.25146484 C439.94405227 421.97950397 444.9955036 413.23150652 449.875 404.1875 C450.39642578 403.23214355 450.91785156 402.27678711 451.45507812 401.29248047 C460.78022866 384.12022125 468.78479918 366.49623672 476.60868835 348.60740662 C480.94201324 338.71917229 485.41250155 328.89292658 489.875 319.0625 C491.41727721 315.66433908 492.95907209 312.26596051 494.5 308.8671875 C494.86777557 308.05613556 495.23555115 307.24508362 495.61447144 306.40945435 C498.120992 300.87384209 500.59711527 295.3253008 503.05859375 289.76953125 C516.10976833 260.32500451 529.66414381 230.90068946 545.41796875 202.79443359 C547.50561741 199.05919358 549.56192282 195.30694692 551.62011719 191.55541992 C553.70048242 187.76357966 555.78781501 183.97558886 557.875 180.1875 C557.15042603 180.15043442 556.42585205 180.11336884 555.67932129 180.07518005 C543.4592987 179.33197019 531.35754052 177.70888323 519.21875 176.16015625 C516.78387838 175.85226745 514.34896631 175.54469837 511.91401672 175.23742676 C506.08231663 174.50063698 500.25106837 173.76035111 494.42001671 173.01844847 C487.65767498 172.15827581 480.89472291 171.30294669 474.13176358 170.44764602 C450.10140811 167.4080441 426.07323333 164.35151277 402.05078125 161.25 C401.20878866 161.14131151 400.36679607 161.03262302 399.49928856 160.92064095 C396.23146217 160.49878344 392.96364937 160.0768208 389.69583797 159.65484715 C387.35972988 159.35319608 385.02361587 159.05159082 382.6875 158.75 C381.92026485 158.65092724 381.15302971 158.55185448 380.36254501 158.44977951 C347.65649946 154.22812871 314.91520092 150.33485729 282.15423584 146.56518555 C278.44519033 146.13799673 274.7364737 145.70801813 271.02780151 145.27760315 C264.22344494 144.48824114 257.41772235 143.71236467 250.61032104 142.94960022 C246.46680898 142.48395967 242.32458926 142.00826832 238.18310547 141.52490234 C192.57414577 136.20318366 146.90732418 132.03742616 101.0625 129.375 C99.99450165 129.31156403 98.9265033 129.24812805 97.82614136 129.18276978 C79.11283196 128.08809097 60.20296164 127.24109782 41.5 128.9375 C40.50871094 129.02620361 39.51742187 129.11490723 38.49609375 129.20629883 C13.1240664 131.70698619 -8.90447908 140.70426778 -25.48486328 160.83886719 C-27.3746797 163.20726058 -29.23279245 165.59906427 -31.08544922 167.99658203 C-39.36845892 178.71318397 -48.07046357 189.62436266 -62.125 192.1875 C-76.86679155 193.46017265 -90.09895317 190.3342233 -101.7890625 181.078125 C-104.32336546 178.85773872 -106.7386841 176.5656155 -109.125 174.1875 C-109.75148438 173.58421875 -110.37796875 172.9809375 -111.0234375 172.359375 C-122.08091383 160.85159421 -126.6102371 145.34868697 -130.125 130.1875 C-130.32077637 129.34324463 -130.51655273 128.49898926 -130.71826172 127.62915039 C-132.33888254 119.81012476 -132.51073405 112.09161877 -132.5 104.125 C-132.49945618 103.44252197 -132.49891235 102.76004395 -132.49835205 102.05688477 C-132.45802182 91.02898561 -131.62286498 80.70521814 -128.125 70.1875 C-127.91601074 69.53974609 -127.70702148 68.89199219 -127.49169922 68.22460938 C-119.36642891 43.80619405 -102.15122815 26.44685595 -79.60107422 14.7199707 C-54.81105738 2.38811537 -27.27734332 -0.02836302 0 0 Z "
      fill="#FEFEFE"
      transform="translate(729.125,47.8125)"
    />
    <path
      d="M0 0 C4.52912795 3.4436127 8.7765219 7.19203929 13 11 C13.66773438 11.58394531 14.33546875 12.16789062 15.0234375 12.76953125 C23.40240396 20.53876072 30.73429753 31.03216905 34 42 C34.19078125 42.59683594 34.3815625 43.19367188 34.578125 43.80859375 C39.29111742 68.28997107 27.69667778 92.05645791 17.20629883 113.32983398 C13.75564333 120.33037135 10.42676731 127.34930022 7.4375 134.5625 C7.12522461 135.3155542 6.81294922 136.0686084 6.49121094 136.84448242 C5.15527897 140.09889189 3.85851052 143.36466763 2.5859375 146.64453125 C-1.86342244 157.93171122 -1.86342244 157.93171122 -8 161 C-18.58290755 162.36481472 -26.19029967 157.39417176 -34.359375 151.1875 C-44.93464866 142.42691827 -51.75248041 130.46158625 -53.25 116.703125 C-54.4346566 92.26958266 -40.74258933 66.90351979 -30.35327148 45.63818359 C-27.12857949 39.13405073 -27.12857949 39.13405073 -27 32 C-27.66 31.01 -28.32 30.02 -29 29 C-44.79548673 30.41804868 -57.83380899 46.60888034 -67.65039062 57.89794922 C-70.46076166 61.26542198 -73.12251736 64.73183614 -75.72167969 68.26416016 C-77.04153014 70.05639406 -78.38250617 71.83133345 -79.7265625 73.60546875 C-90.32039857 87.69512142 -99.620201 102.50129083 -108 118 C-108.44907715 118.82048828 -108.8981543 119.64097656 -109.36083984 120.48632812 C-124.71192169 148.60293627 -135.80379399 180.74726768 -127.375 213.1875 C-126.30899728 216.23743319 -126.30899728 216.23743319 -125 219 C-124.36384766 220.40185547 -124.36384766 220.40185547 -123.71484375 221.83203125 C-119.53340318 229.78725105 -113.5599242 234.0372038 -105.125 236.875 C-84.28731061 241.75067106 -61.61517297 236.07219423 -42 229 C-41.27570801 228.74234863 -40.55141602 228.48469727 -39.80517578 228.21923828 C-22.40274711 221.90872864 -7.75051011 212.27795186 6 200 C7.23206177 199.16202881 7.23206177 199.16202881 8.48901367 198.30712891 C11.59098576 195.45699413 12.63398936 192.58229693 13.875 188.67578125 C14.12097427 187.95000885 14.36694855 187.22423645 14.62037659 186.47647095 C15.14993289 184.91086494 15.67258198 183.34290892 16.18899536 181.7729187 C17.57686405 177.56241494 19.02299324 173.37194974 20.46484375 169.1796875 C20.75801987 168.32388596 21.05119598 167.46808441 21.35325623 166.58634949 C24.21213131 158.2858653 27.32344358 150.09625532 30.5625 141.9375 C30.83018188 141.26285706 31.09786377 140.58821411 31.37365723 139.89312744 C36.97823679 125.81334028 42.9030878 111.87354123 49 98 C49.41765625 97.04754395 49.8353125 96.09508789 50.265625 95.11376953 C54.86196342 84.66568046 59.65039978 74.33988936 64.87402344 64.18994141 C65.68323671 62.61608125 66.48805619 61.03995912 67.29003906 59.46240234 C80.27470223 33.94066389 95.07115936 9.18996883 123.46875 -0.875 C133.79472414 -3.56873238 145.78427472 -2.96356741 155.21875 2.21875 C163.75099382 8.12568803 170.01836469 16.77893364 172 27 C173.63020034 41.0702186 171.15437359 53.39849649 166.72753906 66.70947266 C165.64946374 70.10360108 164.82125814 73.53556638 164 77 C164.59941406 76.25621094 165.19882812 75.51242187 165.81640625 74.74609375 C179.53307737 58.0878948 195.22477576 41.35301562 213 29 C213.55381348 28.61247559 214.10762695 28.22495117 214.67822266 27.82568359 C228.45039506 18.28507483 242.84414729 11.41820855 259 7 C259.66257812 6.80664062 260.32515625 6.61328125 261.0078125 6.4140625 C279.72663849 2.52348298 300.61815653 5.50800565 316.9375 15.375 C327.44329332 22.5380409 335.26932394 32.35054474 338 45 C340.97829886 63.81292116 335.15820133 80.88113743 327.4375 97.8125 C319.19056855 114.38976132 319.19056855 114.38976132 318.8125 132.375 C322.87546387 137.25055664 328.87873824 139.89468195 335.125 140.8125 C336.07375 140.874375 337.0225 140.93625 338 141 C339.94809123 145.96643011 337.34354163 150.03732658 335.44921875 154.6875 C328.06812782 171.55856498 316.13033134 184.33048774 298.9921875 191.4921875 C279.29508573 199.16450298 255.71941148 200.29519159 236 192.0625 C224.92657138 186.64882379 217.22168571 178.5749505 213 167 C205.60705033 138.73283951 223.04660123 110.76916304 236.63061523 87.52929688 C239.04157687 83.07617466 240.29129066 79.52067147 240.3125 74.4375 C240.32925781 73.50808594 240.34601563 72.57867187 240.36328125 71.62109375 C239.93387852 68.52292994 239.20192888 67.20192888 237 65 C233.05030526 63.27200855 229.31814594 63.52416275 225.31640625 64.96875 C218.23408863 68.58525261 212.72503392 73.56121778 207 79 C205.60963624 80.19389931 204.21415402 81.38187604 202.8125 82.5625 C199.61914485 85.35668576 196.81982369 88.30849298 194.08203125 91.546875 C192.47769323 93.43716445 190.85231138 95.29372908 189.19921875 97.140625 C180.86845835 106.50296173 173.31004082 116.33724948 165.890625 126.43164062 C164.00923203 128.98745855 162.11566812 131.5338147 160.21875 134.078125 C154.34154183 141.97659524 148.54024809 149.88969952 143.1953125 158.16210938 C141.73750611 160.4036058 140.25895879 162.63094948 138.78125 164.859375 C121.34286254 191.24798257 103.52605519 218.35866186 91.60107422 247.74414062 C87.38537488 258.09975483 81.84231511 266.00527241 74 274 C73.43539063 274.58910156 72.87078125 275.17820312 72.2890625 275.78515625 C62.03345504 285.56550385 48.71221063 286.46286625 35.3671875 286.27734375 C24.26199336 285.88669901 15.40166529 282.33600719 7.4765625 274.4921875 C4.52550966 271.2340887 3.27720824 268.14229699 2 264 C1.030625 264.6290625 0.06125 265.258125 -0.9375 265.90625 C-10.34150756 271.93865193 -19.87426533 277.28075437 -30 282 C-31.13824219 282.53367187 -32.27648437 283.06734375 -33.44921875 283.6171875 C-68.9931825 299.55211201 -110.51750897 304.29067147 -147.578125 290.78515625 C-169.0911833 282.41844317 -186.95518038 266.90408408 -197 246 C-197.65935547 244.67548828 -197.65935547 244.67548828 -198.33203125 243.32421875 C-206.10431745 227.09869075 -208.40616649 210.77390948 -208.3125 192.9375 C-208.31067719 192.21488983 -208.30885437 191.49227966 -208.30697632 190.74777222 C-208.25708518 178.96387447 -207.60346841 167.52342267 -205 156 C-204.83371094 155.25862793 -204.66742188 154.51725586 -204.49609375 153.75341797 C-200.42876624 136.34299658 -193.36352086 119.85963905 -185.07714844 104.06884766 C-183.92831757 101.86232163 -182.81098981 99.64142724 -181.6953125 97.41796875 C-173.67369643 81.59526215 -164.00605698 66.91150209 -153 53 C-152.24203125 52.03707031 -151.4840625 51.07414062 -150.703125 50.08203125 C-138.59022083 35.24184276 -124.86108842 20.83739758 -109 10 C-108.45746582 9.62375488 -107.91493164 9.24750977 -107.35595703 8.85986328 C-73.80001077 -14.26117887 -35.93543631 -24.29053543 0 0 Z "
      fill="#FEFEFE"
      transform="translate(257,277)"
    />
    <path
      d="M0 0 C1.13904785 0.00491455 2.2780957 0.0098291 3.45166016 0.01489258 C20.74095178 0.25396589 38.2794393 3.20081891 50.95703125 15.96875 C54.63348167 20.06403654 57.5320124 24.57582865 60.3125 29.3125 C61.01375 28.78140625 61.715 28.2503125 62.4375 27.703125 C67.82577183 23.69120521 73.05840068 19.84421956 79.3125 17.3125 C80.18777344 16.95671875 81.06304688 16.6009375 81.96484375 16.234375 C91.29680442 13.66454686 103.71332098 13.77415039 112.4375 18.12109375 C117.99661528 21.65344825 121.00305438 26.26718645 123.3125 32.3125 C123.82147868 35.19380277 123.83940112 37.95584499 123.75 40.875 C123.72691772 42.05715088 123.72691772 42.05715088 123.70336914 43.26318359 C122.86630519 69.11568203 111.49401828 95.12701555 103.07104492 119.25170898 C94.52752407 143.77415328 86.24449468 168.733311 85.9375 194.9375 C85.92348145 195.74276123 85.90946289 196.54802246 85.89501953 197.37768555 C85.9417683 203.14396582 87.21153537 207.95719381 89.3125 213.3125 C95.4803165 213.73786666 98.32418724 213.30315021 103.3125 209.3125 C104.11171875 208.70277344 104.9109375 208.09304688 105.734375 207.46484375 C120.7771055 194.90644298 131.4587579 174.35669814 141.63647461 157.94360352 C142.7486424 156.19767019 143.90342904 154.47812853 145.09985352 152.78881836 C150.11558216 145.54538996 152.56344992 138.26761445 154.9692688 129.89602661 C156.09564666 125.99498594 157.28762725 122.11431391 158.484375 118.234375 C158.72160782 117.46468887 158.95884064 116.69500275 159.20326233 115.9019928 C162.48562727 105.3890229 166.70049898 95.30577941 171.3125 85.3125 C171.71823242 84.43078125 172.12396484 83.5490625 172.54199219 82.640625 C180.16486609 66.29466859 189.21995805 50.78401604 201.3125 37.3125 C202.06789063 36.46300781 202.82328125 35.61351562 203.6015625 34.73828125 C214.28561421 23.37560085 227.86507112 14.47135838 243.875 13.875 C253.77557615 14.32175089 262.73946216 16.72025899 270.3125 23.3125 C276.50847421 30.77944328 276.99100535 38.98852321 276.3125 48.3125 C273.57780456 69.09618533 265.72376488 89.21992069 258.9375 108.9375 C242.51036512 156.69803154 224.90662595 208.94820905 226.51953125 260.05078125 C226.54073532 260.88177841 226.56193939 261.71277557 226.58378601 262.56895447 C226.69112851 266.66773709 226.85500505 270.74832017 227.12573242 274.83959961 C227.62272223 285.61796297 227.62272223 285.61796297 224.06103516 290.22436523 C221.25797827 292.55340031 218.445371 294.45763804 215.3125 296.3125 C214.12709381 297.16002672 212.94615644 298.01390933 211.7734375 298.87890625 C205.50871257 302.93115237 199.17623057 306.53738377 192.4375 309.75 C191.74833496 310.08008057 191.05916992 310.41016113 190.34912109 310.75024414 C179.97060534 315.52486095 167.92993787 317.44768119 156.6796875 314.66015625 C154.64129307 313.72888977 153.05796954 312.71391064 151.3125 311.3125 C150.714375 310.86132812 150.11625 310.41015625 149.5 309.9453125 C138.3585356 300.29257826 135.94585142 284.36660272 134.9140625 270.41015625 C134.27282125 260.05172038 134.18208905 249.68741551 134.3125 239.3125 C133.81363281 239.95574219 133.31476563 240.59898437 132.80078125 241.26171875 C115.7477381 262.7234481 93.85682725 281.79800067 65.82958984 286.03125 C45.97519734 288.24970394 27.32650771 286.749899 10.87890625 274.5 C-1.74864356 263.93800218 -10.07094853 247.49635536 -12.6875 231.3125 C-12.86731013 228.90958275 -12.85176377 226.72170195 -12.6875 224.3125 C-13.3475 224.3125 -14.0075 224.3125 -14.6875 224.3125 C-14.93266357 224.88145996 -15.17782715 225.45041992 -15.43041992 226.03662109 C-18.00264456 230.69350168 -22.25336149 234.21469723 -26 237.9375 C-26.9077417 238.83960205 -27.8154834 239.7417041 -28.75073242 240.67114258 C-46.63250289 258.23214956 -68.43224985 273.92698879 -94.375 274.625 C-111.05670979 274.33519831 -127.15404388 269.63117499 -139.6875 258.3125 C-156.76978137 239.10222113 -157.96690049 215.45128363 -156.55419922 191.00585938 C-152.36664687 136.12334047 -113.89320389 65.34210036 -73.04296875 28.95703125 C-70.30565673 26.67147142 -67.52408083 24.47331907 -64.6875 22.3125 C-63.50220703 21.40371094 -63.50220703 21.40371094 -62.29296875 20.4765625 C-43.75547706 6.88855035 -23.00411775 -0.11787347 0 0 Z "
      fill="#CC3F54"
      transform="translate(1475.6875,275.6875)"
    />
    <path
      d="M0 0 C1.29195282 0.00182281 2.58390564 0.00364563 3.91500854 0.00552368 C28.44466527 0.06336198 52.75720004 1.17052794 77.1875 3.3125 C78.14779114 3.395 79.10808228 3.4775 80.09747314 3.5625 C162.75674065 10.67724112 244.77476948 24.60656275 326.1875 40.3125 C327.42462234 40.5508683 327.42462234 40.5508683 328.68673706 40.79405212 C392.75627044 53.14070168 456.64332972 66.34761292 520.50215197 79.73350489 C522.8103573 80.21725859 525.11861427 80.70076509 527.42689133 81.18417645 C528.17686606 81.34124563 528.9268408 81.49831482 529.69954205 81.66014367 C531.19345428 81.97301537 532.68736918 82.28587435 534.18128681 82.59872025 C537.73611766 83.34334518 541.29074231 84.08892686 544.84488297 84.83683968 C546.18533291 85.1188657 547.5257857 85.40087819 548.86624146 85.68287659 C549.8440098 85.88861387 549.8440098 85.88861387 550.84153104 86.09850746 C555.22339309 87.01904766 559.6084231 87.92327295 563.99478149 88.82211304 C568.87722425 89.82296796 573.74432595 90.87725216 578.60848999 91.96328735 C580.95572685 92.46586605 583.30310238 92.96779766 585.65063477 93.46899414 C587.24624379 93.84245295 587.24624379 93.84245295 588.87408733 94.22345638 C595.26923801 95.57579208 595.26923801 95.57579208 601.28048706 93.53863525 C604.58771139 90.89919861 606.91616231 88.16705294 609.4375 84.8125 C610.3743232 83.7114717 611.32101423 82.61876777 612.27709961 81.53442383 C614.13232578 79.42320585 615.95132445 77.28898838 617.74755859 75.12744141 C620.78842848 71.61921349 624.02248383 68.74670314 627.75 66 C628.29438721 65.59281738 628.83877441 65.18563477 629.3996582 64.76611328 C630.98427502 63.59936187 632.58581947 62.45571424 634.1875 61.3125 C635.33195404 60.46388898 636.47515401 59.61358447 637.6171875 58.76171875 C645.81164262 52.70907418 654.34457522 47.36126903 663.1875 42.3125 C664.321875 41.65636719 665.45625 41.00023437 666.625 40.32421875 C691.14862939 26.48815866 718.45873383 17.78722058 746.1875 13.3125 C747.0734082 13.16296875 747.95931641 13.0134375 748.87207031 12.859375 C810.48495664 2.85994189 882.91456827 11.15742334 935.171875 47.13671875 C950.37650242 58.10689682 964.94427179 70.19158907 976.1875 85.3125 C976.63029297 85.90691895 977.07308594 86.50133789 977.52929688 87.11376953 C978.9468329 89.02666537 980.35176233 90.94795904 981.75 92.875 C982.19255127 93.4834375 982.63510254 94.091875 983.09106445 94.71875 C986.1875 99.07189788 986.1875 99.07189788 986.1875 101.3125 C986.76193848 101.135979 987.33637695 100.95945801 987.92822266 100.77758789 C990.55512803 99.97279046 993.18378101 99.17385271 995.8125 98.375 C996.71613281 98.09720703 997.61976562 97.81941406 998.55078125 97.53320312 C999.87529297 97.13198242 999.87529297 97.13198242 1001.2265625 96.72265625 C1002.03303223 96.47652588 1002.83950195 96.23039551 1003.67041016 95.97680664 C1021.37884927 91.3032215 1042.77294738 92.9872214 1060.1875 98.3125 C1060.89148926 98.52680664 1061.59547852 98.74111328 1062.32080078 98.96191406 C1084.12317859 105.85955788 1103.54743981 120.15462132 1114.51171875 140.4609375 C1127.03464323 165.15382917 1128.03927933 191.38439299 1120.125 217.625 C1110.37135065 245.23131111 1090.37246577 271.79168406 1067.734375 290.3203125 C1065.87682899 292.23956863 1065.87682899 292.23956863 1066.453125 294.921875 C1066.77796875 295.95828125 1067.1028125 296.9946875 1067.4375 298.0625 C1076.1432187 333.17800398 1060.45054416 370.09988153 1049.1875 402.8125 C1036.87725477 438.56988551 1026.13155656 474.70398462 1021.1875 512.3125 C1021.0836499 513.07159668 1020.9797998 513.83069336 1020.87280273 514.61279297 C1019.9632795 522.21986127 1020.00070622 529.86119779 1020.00109863 537.51104736 C1020.00035921 539.14415257 1019.99514984 540.77726121 1019.98571777 542.41033936 C1019.93334271 551.7132893 1020.20911393 560.69226333 1021.5168457 569.92163086 C1023.12001362 581.41549813 1023.12001362 581.41549813 1021.23339844 585.25341797 C1018.66086337 588.63047243 1015.57880139 590.87760459 1011.97241211 593.11669922 C1009.17787449 594.988898 1006.75659085 597.25448742 1004.25 599.48999023 C976.81874908 623.72937093 942.87375621 641.96694084 905.51660156 640.46484375 C885.65974929 639.16603077 869.02901672 630.04970776 855.421875 615.88671875 C851.98764891 611.93015407 849.0172876 607.71647409 846.1875 603.3125 C841.31885449 604.35578118 836.50532487 605.49297047 831.69555664 606.78320312 C800.08982724 615.1140507 765.61025247 612.99238468 736.93359375 596.43359375 C732.71309028 593.70980077 728.7322819 590.81743677 724.921875 587.546875 C724.38079102 587.0825708 723.83970703 586.6182666 723.28222656 586.13989258 C721.76595065 584.81837409 720.27287586 583.47037359 718.78125 582.12109375 C716.44001566 580.04925807 716.44001566 580.04925807 714.23999023 580.5949707 C710.92030637 581.75549775 707.86289569 583.44332192 704.75 585.0625 C674.88599085 600.16288532 641.99822363 602.88140675 610 592.625 C582.65713561 583.25275103 562.82538309 563.81625338 550.04931641 538.14453125 C548.09463663 533.98931396 546.56978327 529.68669903 545.1875 525.3125 C541.6202081 527.9988259 538.86867276 530.73450407 536.125 534.25 C524.60723048 548.59468476 511.67609218 561.97360177 497.1875 573.3125 C496.14557539 574.1455108 495.10391637 574.97885389 494.0625 575.8125 C486.77950225 581.58886066 479.2589614 586.67351407 471.1875 591.3125 C470.60242676 591.65023437 470.01735352 591.98796875 469.41455078 592.3359375 C435.2616975 611.86758807 396.93045915 615.78205387 359.0625 605.5625 C338.21706381 599.67929967 318.55331675 592.25659937 301.82421875 578.18359375 C299.18267512 575.92668594 299.18267512 575.92668594 295.1875 576.3125 C293.49738471 577.51668809 293.49738471 577.51668809 292.0078125 579.2421875 C291.41589111 579.86810791 290.82396973 580.49402832 290.21411133 581.13891602 C289.58657959 581.81494873 288.95904785 582.49098145 288.3125 583.1875 C273.08065705 598.974176 254.55721784 610.83173939 232.0625 611.5625 C195.56826202 611.15296366 157.14066176 597.97177566 130.1875 573.3125 C128.25 570.9375 128.25 570.9375 127.1875 569.3125 C122.75582986 570.2263397 119.55850446 572.61391125 115.875 575.125 C65.51596954 608.35010575 3.21046538 618.78071709 -55.82836914 607.1809082 C-78.74530259 602.25648421 -101.57993229 593.33723249 -119.8125 578.3125 C-120.34891113 577.88388672 -120.88532227 577.45527344 -121.43798828 577.01367188 C-139.14643932 562.83113075 -160.48067666 539.7721876 -163.8125 516.3125 C-164.68390625 516.57804688 -165.5553125 516.84359375 -166.453125 517.1171875 C-167.64421875 517.47039063 -168.8353125 517.82359375 -170.0625 518.1875 C-171.22265625 518.53554688 -172.3828125 518.88359375 -173.578125 519.2421875 C-183.91296946 521.99031946 -194.09467143 522.65922945 -204.73754883 522.62817383 C-206.97983175 522.62502829 -209.22077089 522.64851427 -211.46289062 522.67382812 C-239.33359732 522.79648892 -265.84530267 514.3312582 -286 494.5 C-291.25792444 489.20652616 -295.65896953 483.51836317 -299.8125 477.3125 C-320.91143244 509.99317834 -320.91143244 509.99317834 -337.8125 544.9375 C-343.0208897 557.72726372 -349.84737112 568.76998764 -358.8125 579.3125 C-359.575625 580.323125 -360.33875 581.33375 -361.125 582.375 C-377.61982832 600.40423096 -401.6040005 610.92329319 -425.83032227 612.4387207 C-441.96467034 613.04906292 -457.36866948 611.05284397 -472.515625 605.3984375 C-480.21899536 602.86107143 -484.2353236 603.43060621 -491.3125 606.8125 C-537.35999578 627.41544707 -591.34643269 630.78040647 -638.9375 613.5625 C-674.48780291 599.98802136 -702.20291477 573.15009849 -718 538.6875 C-722.30966604 528.86451028 -725.3554911 518.74233342 -727.8125 508.3125 C-727.99184082 507.55936523 -728.17118164 506.80623047 -728.35595703 506.03027344 C-741.93334361 445.43764654 -718.17438422 380.58304029 -686.25537109 329.83691406 C-668.12087723 301.60241186 -645.81524962 273.58237406 -618.8125 253.3125 C-618.19922852 252.83925293 -617.58595703 252.36600586 -616.95410156 251.87841797 C-582.62449764 225.46154946 -542.58988916 210.11181418 -498.89746094 214.61279297 C-493.72897602 215.39574562 -488.76997841 216.66631442 -483.8125 218.3125 C-482.86262207 218.62598389 -482.86262207 218.62598389 -481.89355469 218.94580078 C-467.15447643 223.9988746 -452.99532152 231.62631217 -440.8125 241.3125 C-439.92433594 241.99828125 -439.03617187 242.6840625 -438.12109375 243.390625 C-430.80404485 249.17765087 -424.2944334 255.62694566 -417.8125 262.3125 C-413.94686284 260.71916946 -411.47406903 258.20841231 -408.5 255.3125 C-386.01348077 234.13819144 -359.0270948 226.41888485 -328.71289062 227.17626953 C-307.28252699 228.18284722 -288.27881619 238.93620586 -273.8125 254.3125 C-273.8125 254.9725 -273.8125 255.6325 -273.8125 256.3125 C-272.81992187 255.80460938 -271.82734375 255.29671875 -270.8046875 254.7734375 C-234.4897253 236.30728598 -200.1400663 229.59553252 -159.8125 238.3125 C-160.2971875 237.54550781 -160.781875 236.77851563 -161.28125 235.98828125 C-183.7275879 198.82232561 -188.12680522 151.66513969 -177.90039062 109.92236328 C-172.73019143 89.97437965 -163.20568691 70.99028374 -149.8125 55.3125 C-148.99910156 54.34828125 -148.18570313 53.3840625 -147.34765625 52.390625 C-141.71109995 45.94375808 -135.64310068 40.46557188 -128.8125 35.3125 C-127.40291016 34.23742188 -127.40291016 34.23742188 -125.96484375 33.140625 C-105.71381022 18.40309866 -82.87219845 9.65969104 -58.5 4.4375 C-57.60756592 4.24623535 -56.71513184 4.0549707 -55.7956543 3.85791016 C-37.30992786 0.2062039 -18.78289093 -0.05510038 0 0 Z M-122.8125 50.3125 C-123.68003906 51.02921875 -124.54757812 51.7459375 -125.44140625 52.484375 C-151.49339147 74.82629659 -165.14647388 107.54913843 -167.8125 141.3125 C-169.91671306 178.45915227 -160.31842703 215.91893284 -136.20703125 244.671875 C-131.42724279 249.94289784 -126.29408739 254.87079035 -120.1875 258.5625 C-114.83498034 262.12658827 -111.90664821 268.82340072 -108.8125 274.3125 C-120.02075053 273.13998335 -131.50479935 270.65423622 -140.6796875 263.8515625 C-161.23407108 249.01927838 -191.76639323 246.49535961 -216.02246094 250.390625 C-238.46381414 254.56732713 -259.01029343 264.55235082 -277.8125 277.3125 C-278.07675781 276.57773437 -278.34101563 275.84296875 -278.61328125 275.0859375 C-284.92937963 260.47867414 -299.5506475 251.26045234 -313.59765625 245.35546875 C-330.19372402 239.97132526 -348.39650335 240.80414232 -364.8125 246.3125 C-365.84246094 246.65152344 -366.87242187 246.99054688 -367.93359375 247.33984375 C-387.14490178 254.50900385 -406.24964045 270.860819 -416.8125 288.3125 C-417.6478125 287.26255859 -417.6478125 287.26255859 -418.5 286.19140625 C-437.23080711 262.872817 -458.5816433 242.50416823 -487.8125 233.3125 C-488.7408667 233.02052734 -488.7408667 233.02052734 -489.68798828 232.72265625 C-520.76902994 223.3036924 -553.45712799 232.09942302 -581.34765625 246.8359375 C-587.10242757 249.97622229 -592.51553263 253.44075982 -597.8125 257.3125 C-598.78058594 258.00859375 -599.74867188 258.7046875 -600.74609375 259.421875 C-612.54733699 268.07714313 -623.19196982 277.51001197 -633.5625 287.8125 C-634.43769287 288.67842773 -635.31288574 289.54435547 -636.21459961 290.43652344 C-652.66183944 306.9630683 -666.11132108 326.21477105 -677.8125 346.3125 C-678.38145996 347.2710791 -678.38145996 347.2710791 -678.96191406 348.24902344 C-693.32354947 372.45502214 -704.33135195 397.92701867 -710.8125 425.3125 C-711.11027344 426.570625 -711.40804687 427.82875 -711.71484375 429.125 C-712.47461239 432.51182937 -713.16081407 435.903368 -713.8125 439.3125 C-714.121875 440.79169922 -714.121875 440.79169922 -714.4375 442.30078125 C-721.11671651 479.54668997 -713.62739445 521.05643988 -692.6328125 552.5859375 C-670.64517127 583.02434475 -639.68533525 601.09016401 -602.8125 607.3125 C-594.58373706 608.55168615 -586.28554494 608.49868782 -577.98339844 608.49780273 C-575.71269589 608.49997589 -573.44249126 608.51815475 -571.171875 608.53710938 C-541.92946499 608.65036595 -511.78436023 601.67737958 -486.06225586 587.52441406 C-482.86005304 585.84741014 -481.22989261 585.22789339 -477.6328125 585.95703125 C-475.18303531 587.13441724 -472.80135784 588.3476961 -470.4375 589.6875 C-465.96349612 591.97873229 -461.54043297 593.36025262 -456.6875 594.5625 C-456.03088379 594.72540527 -455.37426758 594.88831055 -454.69775391 595.05615234 C-433.26654541 600.09154989 -409.98216883 597.69930775 -390.8046875 586.56640625 C-369.87098739 573.26199582 -358.62863144 555.08001895 -349.0234375 532.90039062 C-337.709543 506.84623927 -322.07135928 483.19145492 -306.5625 459.5 C-306.03860687 458.69809235 -305.51471375 457.89618469 -304.97494507 457.06997681 C-303.48204232 454.78751455 -301.98412218 452.50843788 -300.484375 450.23046875 C-300.02768936 449.5315451 -299.57100372 448.83262146 -299.10047913 448.11251831 C-298.03102506 446.49465296 -296.9257041 444.90057963 -295.8125 443.3125 C-295.4825 443.3125 -295.1525 443.3125 -294.8125 443.3125 C-294.60496094 444.30507813 -294.39742188 445.29765625 -294.18359375 446.3203125 C-289.7052536 466.54176001 -279.8132177 482.90052726 -262.14892578 494.39501953 C-238.53195407 509.03210365 -206.58109457 511.14706997 -179.76171875 505.44140625 C-171.31853763 503.1740335 -162.64273632 500.22761816 -154.8125 496.3125 C-154.6580542 496.8386792 -154.5036084 497.3648584 -154.34448242 497.90698242 C-148.9148583 516.05340935 -141.81520653 534.18481081 -128.8125 548.3125 C-127.80509766 549.51132813 -127.80509766 549.51132813 -126.77734375 550.734375 C-110.11338793 570.21094043 -87.81912849 582.42372328 -63.4375 589.625 C-62.67356934 589.85533936 -61.90963867 590.08567871 -61.12255859 590.32299805 C-44.34004293 594.98290789 -27.31698465 595.83008103 -10 595.6875 C-8.9905835 595.68284729 -7.98116699 595.67819458 -6.94116211 595.67340088 C39.98564549 595.41983785 82.65058202 582.1065544 119.96166992 553.24682617 C120.5879126 552.76318604 121.21415527 552.2795459 121.859375 551.78125 C122.4069043 551.35263672 122.95443359 550.92402344 123.51855469 550.48242188 C125.33035639 549.21235842 127.18887637 548.25571965 129.1875 547.3125 C129.58839844 547.84617187 129.98929688 548.37984375 130.40234375 548.9296875 C150.91958254 575.82076238 180.15720786 590.22527821 213.57373047 595.03125 C218.7718273 595.59058192 223.96242695 595.74779798 229.1875 595.8125 C230.72748657 595.84053711 230.72748657 595.84053711 232.29858398 595.86914062 C249.15097751 595.72716825 262.3551933 586.53698272 274.1875 575.3125 C275.43330486 574.26581968 276.68315436 573.22392966 277.9375 572.1875 C282.82002783 567.96803151 287.09780349 563.13995064 291.44042969 558.37841797 C292.02469727 557.74049316 292.60896484 557.10256836 293.2109375 556.4453125 C293.73606934 555.86668457 294.26120117 555.28805664 294.80224609 554.69189453 C296.1875 553.3125 296.1875 553.3125 298.1875 552.3125 C298.45820312 552.90675781 298.72890625 553.50101563 299.0078125 554.11328125 C309.05235916 572.83871095 337.61633607 583.17122447 356.60644531 589.06298828 C370.52857649 593.2498187 383.56716661 595.70725478 398.1875 595.6875 C398.86903137 595.68695618 399.55056274 595.68641235 400.25274658 595.68585205 C411.63015416 595.64423267 422.26671075 594.63301025 433.1875 591.3125 C434.25581055 590.99901611 434.25581055 590.99901611 435.34570312 590.67919922 C453.49647567 585.22661566 469.18711592 575.73407338 484.1875 564.3125 C484.7326123 563.89871094 485.27772461 563.48492188 485.83935547 563.05859375 C493.95455446 556.78787575 501.17153565 549.52681452 508.4375 542.3125 C509.36071045 541.39871582 510.2839209 540.48493164 511.23510742 539.54345703 C517.31117903 533.43845954 522.83293638 527.05425626 528.1875 520.3125 C529.18886223 519.09295875 530.19241849 517.87521198 531.19921875 516.66015625 C539.42569003 506.60240877 546.84640163 496.02781865 554.1875 485.3125 C554.29964844 487.22095703 554.29964844 487.22095703 554.4140625 489.16796875 C556.01618988 512.03888581 561.77142206 534.69412522 577.1875 552.3125 C577.70570312 552.9725 578.22390625 553.6325 578.7578125 554.3125 C592.96033476 571.87697198 616.2207641 580.96311648 638.1875 583.3125 C669.05214396 585.01473732 694.09796634 575.87984573 719.1875 558.3125 C719.58775391 559.18648437 719.58775391 559.18648437 719.99609375 560.078125 C728.63541604 576.28039499 748.23635598 587.08664864 765.1875 592.3125 C775.19162861 595.26392989 784.84535012 595.87603787 795.1875 595.8125 C795.95518707 595.81073761 796.72287415 595.80897522 797.51382446 595.80715942 C815.38399323 595.71590809 830.87173548 592.51806844 847.03515625 584.765625 C849.48319483 583.63716112 851.56061404 582.81036367 854.1875 582.3125 C854.538125 583.570625 854.88875 584.82875 855.25 586.125 C859.80715203 599.5444477 870.13939879 611.21869821 882.5078125 618.03515625 C902.61441248 627.61949764 920.79535349 626.81327192 941.546875 620.25 C961.66251582 613.04439732 979.74473445 600.94101064 995.1875 586.3125 C997.27935932 584.46864462 999.38641947 582.6437053 1001.49609375 580.8203125 C1002.33333984 580.07394531 1002.33333984 580.07394531 1003.1875 579.3125 C1003.72036621 578.90338379 1004.25323242 578.49426758 1004.80224609 578.07275391 C1006.81437532 575.5159242 1006.35470548 573.83624202 1006.04296875 570.640625 C1005.94306641 569.49980469 1005.84316406 568.35898437 1005.74023438 567.18359375 C1005.61970703 565.98863281 1005.49917969 564.79367187 1005.375 563.5625 C1000.17258243 508.70623903 1015.27927709 454.87153056 1032.76925659 403.44589233 C1044.52064924 369.813781 1044.52064924 369.813781 1053.1875 335.3125 C1053.48333984 333.87003906 1053.48333984 333.87003906 1053.78515625 332.3984375 C1055.60894229 318.4101756 1054.82295852 304.40144535 1048.89453125 291.5390625 C1048.05214703 288.8862503 1048.02415925 287.83730502 1049.1875 285.3125 C1051.09375 283.55078125 1051.09375 283.55078125 1053.6875 281.625 C1080.71363538 260.23665036 1105.42189958 228.31962088 1110.1875 193.3125 C1111.38012554 170.92783595 1105.65607837 151.50735125 1091.0625 134.1875 C1076.20020151 118.31758805 1054.4680818 109.96452154 1032.9921875 108.8984375 C1014.20636519 108.43077109 997.5413832 111.67210077 981.1875 121.3125 C980.58164063 120.23613281 979.97578125 119.15976563 979.3515625 118.05078125 C956.76197812 78.45181835 919.9911522 47.96253228 875.63061523 35.82836914 C870.83355626 34.58005939 866.01492415 33.43654104 861.1875 32.3125 C860.38376953 32.11672363 859.58003906 31.92094727 858.75195312 31.71923828 C823.10028944 23.04864463 783.3455556 22.0381047 747.1875 28.3125 C746.22473145 28.47878906 745.26196289 28.64507812 744.27001953 28.81640625 C707.00810111 35.54036145 670.84234786 51.69132248 641.1875 75.3125 C640.32511719 75.9828125 639.46273438 76.653125 638.57421875 77.34375 C632.79034257 81.93657612 627.34187488 86.8449272 621.9375 91.875 C621.27588867 92.48811035 620.61427734 93.1012207 619.93261719 93.73291016 C612.12248694 100.97755338 612.12248694 100.97755338 605.92480469 109.54907227 C604.1875 111.3125 604.1875 111.3125 601.05200195 111.66577148 C596.72986974 111.27066596 592.59665249 110.560251 588.35546875 109.66015625 C587.07703094 109.39728569 587.07703094 109.39728569 585.77276611 109.12910461 C582.97205115 108.55121159 580.17355765 107.96324375 577.375 107.375 C575.4031735 106.96583928 573.43124801 106.55715531 571.45922852 106.14892578 C557.29210063 103.20761788 543.14423998 100.17587236 529.00128174 97.12072754 C516.21088859 94.35799546 503.40079454 91.72448904 490.56259155 89.19381714 C481.15771779 87.33812495 471.78657106 85.37202042 462.4375 83.25 C451.64673844 80.80138959 440.81655277 78.62901245 429.94433594 76.57983398 C419.05805375 74.52028714 408.21913745 72.25116142 397.3755188 69.97927856 C364.85647156 63.17787462 332.29236052 56.72112865 299.59521484 50.8339386 C293.51621337 49.73841322 287.44187747 48.62061859 281.37109375 47.48046875 C239.15604842 39.55980069 196.80593454 32.90542418 154.24365234 27.13623047 C149.34377834 26.47190653 144.44690862 25.78899499 139.55078125 25.09765625 C114.53285263 21.63091474 89.34603859 19.47129588 64.1875 17.3125 C62.94290009 17.20424896 62.94290009 17.20424896 61.67315674 17.09381104 C41.48248141 15.34927177 21.31935256 15.09593842 1.0625 15 C-0.74559143 14.98542252 -0.74559143 14.98542252 -2.59020996 14.97055054 C-45.19992563 14.67861851 -89.37943563 21.87834375 -122.8125 50.3125 Z "
      fill="#FDFDFD"
      transform="translate(730.8125,-0.3125)"
    />
    <path
      d="M0 0 C7.24455112 5.55309205 12.13776066 13.90325263 14.0859375 22.734375 C15.32381784 34.52858782 14.54958794 45.07054964 9.0859375 55.734375 C8.32410156 57.32958984 8.32410156 57.32958984 7.546875 58.95703125 C1.3318918 71.3133604 -7.44535619 81.72878328 -16.9140625 91.734375 C-17.70554687 92.57871094 -18.49703125 93.42304688 -19.3125 94.29296875 C-28.7543914 104.07738933 -41.45029906 115.54562923 -55.6640625 116.546875 C-60.61781375 116.19151264 -63.5564698 114.75804378 -67.01171875 111.2109375 C-83.24712677 90.07490324 -87.73448775 59.67001687 -85.9140625 33.734375 C-85.37185622 29.78078753 -84.46814455 26.40177317 -82.9140625 22.734375 C-82.511875 21.75597656 -82.1096875 20.77757812 -81.6953125 19.76953125 C-75.38800284 5.8759297 -65.3559713 -3.05037601 -51.2734375 -8.50390625 C-34.51179817 -13.91536266 -14.40112692 -9.5223778 0 0 Z "
      fill="#CC3F54"
      transform="translate(1792.9140625,152.265625)"
    />
    <path
      d="M0 0 C5.73334246 5.05944145 9.67072032 10.11282058 13 17 C13.33 17.66 13.66 18.32 14 19 C14.76112933 25.71291115 14.29973301 31.59328966 10 37 C0.0734134 46.06614252 -13.58608096 48.13793339 -26.515625 48.203125 C-27.43581924 48.21009399 -28.35601349 48.21706299 -29.30409241 48.22424316 C-32.28610794 48.24166582 -35.26793556 48.24797161 -38.25 48.25 C-39.26653656 48.25100708 -40.28307312 48.25201416 -41.33041382 48.25305176 C-56.11583755 48.24312914 -70.54770292 47.77473519 -85.17724609 45.44873047 C-88.03720594 44.99408541 -90.90132426 44.59037283 -93.76953125 44.19140625 C-105.59582202 42.46395942 -117.16320893 39.88942194 -128.75 37 C-129.42395813 36.8325528 -130.09791626 36.66510559 -130.79229736 36.49258423 C-139.32430454 34.35808175 -147.69994241 31.91801931 -156 29 C-155.51479668 17.84032365 -147.4665983 9.60058294 -140 2 C-139.26136719 1.236875 -138.52273438 0.47375 -137.76171875 -0.3125 C-102.30900852 -34.63310688 -36.21481133 -31.36402009 0 0 Z "
      fill="#461816"
      transform="translate(1596,138)"
    />
    <path
      d="M0 0 C3.8452266 2.5634844 5.03118614 5.55960315 6 10 C9.52569412 46.49402687 -16.8492668 87.48074499 -38.859375 114.54296875 C-58.01457315 137.72876042 -58.01457315 137.72876042 -71 142 C-74.125 142.0625 -74.125 142.0625 -77 141 C-81.10726093 135.30283162 -80.3929403 128.88405987 -79.39550781 122.16357422 C-72.51527788 84.52616824 -50.8806638 27.94825886 -18.625 4.8125 C-12.62588154 0.84987159 -7.20484882 -1.0793781 0 0 Z "
      fill="#461816"
      transform="translate(1491,330)"
    />
    <path
      d="M0 0 C4.44496055 2.49696987 7.0635749 5.44072469 8.6875 10.3125 C10.30682302 23.82052365 5.65349093 36.49212893 -2.55078125 47.15234375 C-3.42283203 48.22162109 -3.42283203 48.22162109 -4.3125 49.3125 C-5.07626953 50.33537109 -5.07626953 50.33537109 -5.85546875 51.37890625 C-16.72332967 65.09119497 -34.3853234 72.6198274 -51.3125 75.3125 C-55.3524089 75.58182726 -59.27545225 75.53298392 -63.3125 75.3125 C-62.88455336 68.43549709 -61.71068264 62.35237304 -59.375 55.875 C-59.06925049 55.020271 -58.76350098 54.16554199 -58.44848633 53.28491211 C-52.98601975 38.57203859 -45.56932649 25.20623937 -35.3125 13.3125 C-34.70792969 12.60738281 -34.10335937 11.90226562 -33.48046875 11.17578125 C-25.16672651 2.20005485 -12.12767048 -5.58868397 0 0 Z "
      fill="#471917"
      transform="translate(769.3125,340.6875)"
    />
  </svg>
);
export default SvgCrewAiIcon;
