{ *********************************************************************** }
{                                                                         }
{ Delphi / Kylix Cross-Platform Runtime Library                           }
{                                                                         }
{ Copyright (c) 1995, 2001 Borland Software Corporation                   }
{                                                                         }
{ *********************************************************************** }

unit SysConst;                                   

interface

resourcestring
  SUnknown = '<unbekannt>';
  SInvalidInteger = '''%s'' ist kein gltiger Integerwert';
  SInvalidFloat = '''%s'' ist kein gltiger Gleitkommawert';
  SInvalidCurrency = '''%s'' ist kein gltiger Whrungwert';
  SInvalidDate = '''%s'' ist kein gltiges Datum';
  SInvalidTime = '''%s'' ist keine gltige Uhrzeit';
  SInvalidDateTime = '''%s'' ist keine gltige Datums- und Uhrzeitangabe';
  SInvalidDateTimeFloat = '''%g'' kein gltiger Datums- und Zeitwet';
  SInvalidTimeStamp = '''%d.%d'' ist kein gltiger Zeitstempel';
  SInvalidGUID = '''%s'' kein gltiger Wert fr GUID';
  SInvalidBoolean = '''%s'' ist kein gltiger boolescher Wert';
  STimeEncodeError = 'Ungltiges Argument fr Codierung der Uhrzeit';
  SDateEncodeError = 'Ungltiges Argument zum Codieren des Datums';
  SOutOfMemory = 'Zu wenig Arbeitsspeicher';
  SInOutError = 'E/A-Fehler %d';
  SFileNotFound = 'Datei nicht gefunden';
  SInvalidFilename = 'Ungltiger Dateiname';
  STooManyOpenFiles = 'Zu viele geffnete Dateien';
  SAccessDenied = 'Dateizugriff verweigert';
  SEndOfFile = 'Versuch hinter dem Dateiende zu lesen';
  SDiskFull = 'Zu wenig Speicherplatz';
  SInvalidInput = 'Ungltige numerische Eingabe';
  SDivByZero = 'Division durch Null';
  SRangeError = 'Fehler bei Bereichsprfung';
  SIntOverflow = 'Integerberlauf';
  SInvalidOp = 'Ungltige Gleitkommaoperation';
  SZeroDivide = 'Gleitkommadivision durch Null';
  SOverflow = 'Gleitkommaberlauf';
  SUnderflow = 'Gleitkommaunterlauf';
  SInvalidPointer = 'Ungltige Zeigeroperation';
  SInvalidCast = 'Ungltige Typumwandlung';
{$IFDEF MSWINDOWS}
  SAccessViolation = 'Zugriffsverletzung bei Adresse %p. %s von Adresse %p';
{$ENDIF}
{$IFDEF LINUX}
  SAccessViolation = 'Zugriffsverletzung bei Adresse %p beim Zugriff auf Adresse %p';
{$ENDIF}
  SStackOverflow = 'Stack-berlauf';
  SControlC = 'Strg+C gedrckt';
  SQuit = 'Taste zum Verlassen gedrckt';
  SPrivilege = 'Privilegierte Anweisung';
  SOperationAborted = 'Operation abgebrochen';
  SException = 'Exception %s in Modul %s bei %p.' + sLineBreak + '%s%s' + sLineBreak;
  SExceptTitle = 'Anwendungsfehler';
{$IFDEF LINUX}
  SSigactionFailed = 'sigaction-Aufruf fehlgeschlagen';
{$ENDIF}
  SInvalidFormat = 'Format ''%s'' ungltig oder nicht kompatibel mit Argument';
  SArgumentMissing = 'Kein Argument fr Format ''%s''';
  SDispatchError = 'Variant-Methodenaufruf nicht untersttzt';
  SReadAccess = 'Lesen';
  SWriteAccess = 'Schreiben';
  SResultTooLong = 'Formatergebnis lnger als 4096 Zeichen';
  SFormatTooLong = 'Format-String zu lang';

  SVarArrayCreate = 'Fehler beim Erstellen des Variant-Arrays';
  SVarArrayBounds = 'Index des Variant-Arrays auerhalb des Bereichs';
  SVarArrayLocked = 'Variant-Array ist gesperrt';

  SInvalidVarCast = 'Ungltige Variant-Typumwandlung';
  SInvalidVarOp = 'Ungltige Variant-Operation';
  SInvalidVarOpWithHResult = 'Ungltige Variant-Operation ($%.8x)';

  SVarNotArray = 'Variant ist kein Array' deprecated; // use SVarInvalid
  SVarTypeUnknown = 'Unbekannter selbstdefinierter Variant-Typ (%.4x)' deprecated; // not used anymore

  SVarTypeOutOfRange = 'Selbstdefinierter Variant-Typ (%.4x) ist nicht im gltigen Bereich';
  SVarTypeAlreadyUsed = 'Selbstdefinierter Variant-Typ (%.4x) wird bereits von %s verwendet';
  SVarTypeNotUsable = 'Selbstdefinierter Variant-Typ (%.4x) ist nicht verwendbar';
  SVarTypeTooManyCustom = 'Es wurden zu viele benutzerdefinierte Variant-Typen registriert';

  SVarTypeCouldNotConvert = 'Variante des Typs (%s) konnte nicht in Typ (%s) konvertiert werden';
  SVarTypeConvertOverflow = 'berlauf bei der Konvertierung einer Variante vom Typ (%s) in Typ (%s)';
  SVarOverflow = 'Variant-berlauf';
  SVarInvalid = 'Ungltiges Argument';
  SVarBadType = 'Ungltiger Variant-Typ';
  SVarNotImplemented = 'Operation wird nicht untersttzt';
  SVarOutOfMemory = 'Speichermangel bei Varinat-Operation';
  SVarUnexpected = 'Unerwarteter Variant-Fehler';

  SVarDataClearRecursing = 'Rekursion beim Durchfhren eines VarDataClear';
  SVarDataCopyRecursing = 'Rekursion beim Durchfhren eines VarDataCopy';
  SVarDataCopyNoIndRecursing = 'Rekursion beim Durchfhren eines VarDataCopyNoInd';
  SVarDataInitRecursing = 'Rekursion beim Durchfhren eines VarDataInit';
  SVarDataCastToRecursing = 'Rekursion beim Durchfhren eines VarDataCastTo';
  SVarIsEmpty = 'Die Variante ist leer';
  sUnknownFromType = 'Konvertierung des angegebenen Typs kann nicht durchgefhrt werden';
  sUnknownToType = 'Konvertierung in den angegebenen Typ kann nicht durchgefhrt werden';
  SExternalException = 'Externe Exception %x';
  SAssertionFailed = 'Auswertung von assert fehlgeschlagen';
  SIntfCastError = 'Schnittstelle nicht untersttzt';
  SSafecallException = 'Exception in safecall-Methode';
  SAssertError = '%s (%s, Zeile %d)';
  SAbstractError = 'Abstrakter Fehler';
  SModuleAccessViolation = 'Zugriffsverletzung bei Adresse %p in Modul ''%s''. %s von Adresse %p';
  SCannotReadPackageInfo = 'Zugriff auf Package-Informationen von ''%s'' nicht mglich';
  sErrorLoadingPackage = 'Package %s kann nicht geladen werden.'+sLineBreak+'%s';
  SInvalidPackageFile = 'Ungltige Package-Datei ''%s''';
  SInvalidPackageHandle = 'Ungltiges Package-Handle';
  SDuplicatePackageUnit = 'Package ''%s kann nicht geladen werden.''  Es enthlt die Unit ''%s,''' +
    'die auch im Package ''%s'' enthalten ist';
  SOSError = 'Systemfehler.  Code: %d.'+sLineBreak+'%s';
  SUnkOSError = 'Ein Aufruf einer Betriebssystemfunktion ist fehlgeschlagen';
{$IFDEF MSWINDOWS}
  SWin32Error = 'Win32 Fehler.  Code: %d.'#10'%s' deprecated; // use SOSError
  SUnkWin32Error = 'Fehler bei einer Win32 API-Funktion' deprecated; // use SUnkOSError
{$ENDIF}
  SNL = 'Die Anwendung ist fr diese Funktion nicht lizenziert.';

  SConvIncompatibleTypes2 = 'Inkompatible Konvertierungstypen [%s, %s]';
  SConvIncompatibleTypes3 = 'Inkompatible Konvertierungstypen [%s, %s, %s]';
  SConvIncompatibleTypes4 = 'Inkompatible Konvertierungstypen [%s - %s, %s - %s]';
  SConvUnknownType = 'Unkannter Konvertierungstyp %s';
  SConvDuplicateType = 'Konvertierungstyp (%s) ist bereits registriert';
  SConvUnknownFamily = 'Unbekannte Konvertierungsfamilie %s';
  SConvDuplicateFamily = 'Konvertierungsfamilie (%s) bereits registriert';
  SConvUnknownDescription = '[%.8x]';
  SConvIllegalType = 'Ungltiger Typ';
  SConvIllegalFamily = 'Ungltige Familie';
  SConvFactorZero = '%s hat den Faktor Null';

  SShortMonthNameJan = 'Jan';
  SShortMonthNameFeb = 'Feb';
  SShortMonthNameMar = 'Mr';
  SShortMonthNameApr = 'Apr';
  SShortMonthNameMay = 'Mai';
  SShortMonthNameJun = 'Jun';
  SShortMonthNameJul = 'Jul';
  SShortMonthNameAug = 'Aug';
  SShortMonthNameSep = 'Sep';
  SShortMonthNameOct = 'Okt';
  SShortMonthNameNov = 'Nov';
  SShortMonthNameDec = 'Dez';

  SLongMonthNameJan = 'Januar';
  SLongMonthNameFeb = 'Februar';
  SLongMonthNameMar = 'Mrz';
  SLongMonthNameApr = 'April';
  SLongMonthNameMay = 'Mai';
  SLongMonthNameJun = 'Juni';
  SLongMonthNameJul = 'Juli';
  SLongMonthNameAug = 'August';
  SLongMonthNameSep = 'September';
  SLongMonthNameOct = 'Oktober';
  SLongMonthNameNov = 'November';
  SLongMonthNameDec = 'Dezember';

  SShortDayNameSun = 'So';
  SShortDayNameMon = 'Mo';
  SShortDayNameTue = 'Di';
  SShortDayNameWed = 'Mi';
  SShortDayNameThu = 'Do';
  SShortDayNameFri = 'Fr';
  SShortDayNameSat = 'Sa';

  SLongDayNameSun = 'Sonntag';
  SLongDayNameMon = 'Montag';
  SLongDayNameTue = 'Dienstag';
  SLongDayNameWed = 'Mittwoch';
  SLongDayNameThu = 'Donnerstag';
  SLongDayNameFri = 'Freitag';
  SLongDayNameSat = 'Samstag';

{$IFDEF LINUX}
  SEraEntries = '';
{$ENDIF}

  SCannotCreateDir = 'Das Verzeichnis kann nicht erstellt werden';

implementation

end.
