program msgstripCR;
// This tool can strip all \r away from a .po file.
// It is useful for converting all pre-march 2003 .po files
// generated by dxgettext to post-february 2003 .po files,
// that conform to the uniforum po file format

uses
  {$ifdef mswindows}
  gnugettext in '..\..\sample\gnugettext.pas',
  {$else}
  gnugettext in '../../sample/gnugettext.pas',
  {$endif}
  SysUtils;

var
  line:string;
  inside:boolean;
  src,dst:TextFile;
  i:integer;
  p:integer;
begin
  if paramcount<>2 then begin
    // Messages about how to use this program
    writeln (_('msgstripCR usage:'));
    writeln (_('  msgstripCR source.po destination.po'));
    writeln;
    writeln (_('This will strip all Carriage Return codes (\r).'));
    writeln;
    exit;
  end;
  AssignFile (src,paramstr(1));
  AssignFile (dst,paramstr(2));
  Reset (src);
  Rewrite (dst);
  try
    inside:=False;
    while not eof(src) do begin
      readln (src,line);
      if trim(line)='' then inside:=False;
      if (not inside) and (uppercase(copy(trim(line),1,5))='MSGID') then
        inside:=True;
      if inside then begin
        p:=pos('"',line);
        if p<>0 then begin
          i:=p+1;
          while i<length(line) do begin
            if (uppercase(copy(line,i,2))='\R') and (line[i-1]<>'\') then begin
              delete (line,i,2);
            end else
              inc(i);
          end;
        end;
      end;
      writeln (dst,line);
    end;
  finally
    CloseFile (dst);
    CloseFile (src);
  end;
end.
