unit AWS.SSM.Transform.UpdatePatchBaselineResponseUnmarshaller;

interface

uses
  AWS.SSM.Model.UpdatePatchBaselineResponse, 
  AWS.Transform.ResponseUnmarshaller, 
  AWS.Runtime.Model, 
  AWS.Transform.JsonUnmarshallerContext, 
  AWS.SSM.Transform.PatchRuleGroupUnmarshaller, 
  AWS.Transform.SimpleTypeUnmarshaller, 
  AWS.SSM.Transform.PatchFilterGroupUnmarshaller, 
  AWS.SSM.Transform.PatchSourceUnmarshaller, 
  AWS.SSM.Model.PatchSource, 
  AWS.Runtime.Exceptions, 
  System.SysUtils, 
  AWS.Internal.ErrorResponse, 
  AWS.Transform.JsonErrorResponseUnmarshaller, 
  System.Classes, 
  AWS.SSM.Transform.DoesNotExistExceptionUnmarshaller, 
  AWS.SSM.Transform.InternalServerErrorExceptionUnmarshaller, 
  AWS.SSM.Exception;

type
  IUpdatePatchBaselineResponseUnmarshaller = IResponseUnmarshaller;
  
  TUpdatePatchBaselineResponseUnmarshaller = class(TJsonResponseUnmarshaller, IUpdatePatchBaselineResponseUnmarshaller)
  strict private
    class var FInstance: IUpdatePatchBaselineResponseUnmarshaller;
    class constructor Create;
  public
    function Unmarshall(AContext: TJsonUnmarshallerContext): TAmazonWebServiceResponse; overload; override;
    function UnmarshallException(AContext: TJsonUnmarshallerContext; AInnerException: Exception; AStatusCode: Integer): EAmazonServiceException; override;
    class function Instance: IUpdatePatchBaselineResponseUnmarshaller; static;
  end;
  
implementation

{ TUpdatePatchBaselineResponseUnmarshaller }

function TUpdatePatchBaselineResponseUnmarshaller.Unmarshall(AContext: TJsonUnmarshallerContext): TAmazonWebServiceResponse;
var
  Response: TUpdatePatchBaselineResponse;
begin
  Response := TUpdatePatchBaselineResponse.Create;
  try
    AContext.Read;
    var TargetDepth := AContext.CurrentDepth;
    while AContext.ReadAtDepth(TargetDepth) do
    begin
      if AContext.TestExpression('ApprovalRules', TargetDepth) then
      begin
        var Unmarshaller := TPatchRuleGroupUnmarshaller.JsonInstance;
        Response.ApprovalRules := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('ApprovedPatches', TargetDepth) then
      begin
        var Unmarshaller := TJsonListUnmarshaller<string, IJsonStringUnmarshaller>.JsonNew(TStringUnmarshaller.JsonInstance);
        Response.ApprovedPatches := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('ApprovedPatchesComplianceLevel', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.ApprovedPatchesComplianceLevel := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('ApprovedPatchesEnableNonSecurity', TargetDepth) then
      begin
        var Unmarshaller := TBooleanUnmarshaller.JsonInstance;
        Response.ApprovedPatchesEnableNonSecurity := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('BaselineId', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.BaselineId := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('CreatedDate', TargetDepth) then
      begin
        var Unmarshaller := TDateTimeUnmarshaller.JsonInstance;
        Response.CreatedDate := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('Description', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.Description := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('GlobalFilters', TargetDepth) then
      begin
        var Unmarshaller := TPatchFilterGroupUnmarshaller.JsonInstance;
        Response.GlobalFilters := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('ModifiedDate', TargetDepth) then
      begin
        var Unmarshaller := TDateTimeUnmarshaller.JsonInstance;
        Response.ModifiedDate := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('Name', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.Name := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('OperatingSystem', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.OperatingSystem := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('RejectedPatches', TargetDepth) then
      begin
        var Unmarshaller := TJsonListUnmarshaller<string, IJsonStringUnmarshaller>.JsonNew(TStringUnmarshaller.JsonInstance);
        Response.RejectedPatches := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('RejectedPatchesAction', TargetDepth) then
      begin
        var Unmarshaller := TStringUnmarshaller.JsonInstance;
        Response.RejectedPatchesAction := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
      if AContext.TestExpression('Sources', TargetDepth) then
      begin
        var Unmarshaller := TJsonObjectListUnmarshaller<TPatchSource, IPatchSourceUnmarshaller>.JsonNew(TPatchSourceUnmarshaller.JsonInstance);
        Response.Sources := Unmarshaller.Unmarshall(AContext);
        Continue;
      end;
    end;
    Result := Response;
    Response := nil;
  finally
    Response.Free;
  end;
end;

function TUpdatePatchBaselineResponseUnmarshaller.UnmarshallException(AContext: TJsonUnmarshallerContext; AInnerException: Exception; AStatusCode: Integer): EAmazonServiceException;
var
  ErrorResponse: TErrorResponse;
  StreamCopy: TStream;
  ContextCopy: TJsonUnmarshallerContext;
begin
  ErrorResponse := TJsonErrorResponseUnmarshaller.Instance.Unmarshall(AContext);
  try
    ErrorResponse.InnerException := AInnerException;
    ErrorResponse.StatusCode := AStatusCode;
    StreamCopy := TBytesStream.Create(AContext.GetResponseBodyBytes);
    try
      ContextCopy := TJsonUnmarshallerContext.Create(StreamCopy, False, nil);
      try
        if ErrorResponse.Code = 'DoesNotExistException' then
          Exit(TDoesNotExistExceptionUnmarshaller.Instance.Unmarshall(ContextCopy, ErrorResponse));
        if ErrorResponse.Code = 'InternalServerErrorException' then
          Exit(TInternalServerErrorExceptionUnmarshaller.Instance.Unmarshall(ContextCopy, ErrorResponse));
      finally
        ContextCopy.Free;
      end;
    finally
      StreamCopy.Free;
    end;
    Exit(EAmazonSimpleSystemsManagementException.Create(ErrorResponse.Message, AInnerException, ErrorResponse.ErrorType, ErrorResponse.Code, ErrorResponse.RequestId, AStatusCode));
  finally
    ErrorResponse.Free;
  end;
end;

class constructor TUpdatePatchBaselineResponseUnmarshaller.Create;
begin
  FInstance := TUpdatePatchBaselineResponseUnmarshaller.Create;
end;

class function TUpdatePatchBaselineResponseUnmarshaller.Instance: IUpdatePatchBaselineResponseUnmarshaller;
begin
  Result := FInstance;
end;

end.
