unit AWS.S3Control.Transform.DeleteAccessPointResponseUnmarshaller;

interface

uses
  AWS.S3Control.Model.DeleteAccessPointResponse, 
  AWS.Transform.ResponseUnmarshaller, 
  AWS.Runtime.Model, 
  AWS.Transform.UnmarshallerContext, 
  AWS.Runtime.Exceptions, 
  System.SysUtils, 
  AWS.Internal.ErrorResponse, 
  AWS.Transform.ErrorResponseUnmarshaller, 
  System.Classes, 
  AWS.S3Control.Exception;

type
  IDeleteAccessPointResponseUnmarshaller = IResponseUnmarshaller;
  
  TDeleteAccessPointResponseUnmarshaller = class(TXmlResponseUnmarshaller, IDeleteAccessPointResponseUnmarshaller)
  strict private
    class var FInstance: IDeleteAccessPointResponseUnmarshaller;
    class constructor Create;
  public
    function Unmarshall(AContext: TXmlUnmarshallerContext): TAmazonWebServiceResponse; overload; override;
    function UnmarshallException(AContext: TXmlUnmarshallerContext; AInnerException: Exception; AStatusCode: Integer): EAmazonServiceException; override;
    class function Instance: IDeleteAccessPointResponseUnmarshaller; static;
  end;
  
implementation

{ TDeleteAccessPointResponseUnmarshaller }

function TDeleteAccessPointResponseUnmarshaller.Unmarshall(AContext: TXmlUnmarshallerContext): TAmazonWebServiceResponse;
var
  Response: TDeleteAccessPointResponse;
begin
  Response := TDeleteAccessPointResponse.Create;
  try
    Result := Response;
  except
    Response.Free;
    raise;
  end;
end;

function TDeleteAccessPointResponseUnmarshaller.UnmarshallException(AContext: TXmlUnmarshallerContext; AInnerException: Exception; AStatusCode: Integer): EAmazonServiceException;
var
  ErrorResponse: TErrorResponse;
  StreamCopy: TStream;
  ContextCopy: TXmlUnmarshallerContext;
begin
  ErrorResponse := TErrorResponseUnmarshaller.Instance.Unmarshall(AContext);
  try
    ErrorResponse.InnerException := AInnerException;
    ErrorResponse.StatusCode := AStatusCode;
    StreamCopy := TBytesStream.Create(AContext.GetResponseBodyBytes);
    try
      ContextCopy := TXmlUnmarshallerContext.Create(StreamCopy, False, nil);
      try
      finally
        ContextCopy.Free;
      end;
    finally
      StreamCopy.Free;
    end;
    Exit(EAmazonS3ControlException.Create(ErrorResponse.Message, AInnerException, ErrorResponse.ErrorType, ErrorResponse.Code, ErrorResponse.RequestId, AStatusCode));
  finally
    ErrorResponse.Free;
  end;
end;

class constructor TDeleteAccessPointResponseUnmarshaller.Create;
begin
  FInstance := TDeleteAccessPointResponseUnmarshaller.Create;
end;

class function TDeleteAccessPointResponseUnmarshaller.Instance: IDeleteAccessPointResponseUnmarshaller;
begin
  Result := FInstance;
end;

end.
