unit AWS.Rekognition.Transform.CreateCollectionRequestMarshaller;

interface

uses
  System.Classes, 
  System.SysUtils, 
  AWS.Internal.Request, 
  AWS.Transform.RequestMarshaller, 
  AWS.Runtime.Model, 
  AWS.Rekognition.Model.CreateCollectionRequest, 
  AWS.Internal.DefaultRequest, 
  AWS.SDKUtils, 
  AWS.Json.Writer;

type
  ICreateCollectionRequestMarshaller = IMarshaller<IRequest, TAmazonWebServiceRequest>;
  
  TCreateCollectionRequestMarshaller = class(TInterfacedObject, IMarshaller<IRequest, TCreateCollectionRequest>, ICreateCollectionRequestMarshaller)
  strict private
    class var FInstance: ICreateCollectionRequestMarshaller;
    class constructor Create;
  public
    function Marshall(AInput: TAmazonWebServiceRequest): IRequest; overload;
    function Marshall(PublicRequest: TCreateCollectionRequest): IRequest; overload;
    class function Instance: ICreateCollectionRequestMarshaller; static;
  end;
  
implementation

{ TCreateCollectionRequestMarshaller }

function TCreateCollectionRequestMarshaller.Marshall(AInput: TAmazonWebServiceRequest): IRequest;
begin
  Result := Marshall(TCreateCollectionRequest(AInput));
end;

function TCreateCollectionRequestMarshaller.Marshall(PublicRequest: TCreateCollectionRequest): IRequest;
var
  Request: IRequest;
begin
  Request := TDefaultRequest.Create(PublicRequest, 'Amazon.Rekognition');
  Request.Headers.Add('X-Amz-Target', 'RekognitionService.CreateCollection');
  Request.Headers.AddOrSetValue('Content-Type', 'application/x-amz-json-1.1');
  Request.Headers.AddOrSetValue(THeaderKeys.XAmzApiVersion, '2016-06-27');
  Request.HttpMethod := 'POST';
  Request.ResourcePath := '/';
  var Stream: TStringStream := TStringStream.Create('', TEncoding.UTF8, False);
  try
    var Writer: TJsonWriter := TJsonWriter.Create(Stream);
    try
      var Context: TJsonMarshallerContext := TJsonMarshallerContext.Create(Request, Writer);
      try
        Writer.WriteBeginObject;
        if PublicRequest.IsSetCollectionId then
        begin
          Context.Writer.WriteName('CollectionId');
          Context.Writer.WriteString(PublicRequest.CollectionId);
        end;
        if PublicRequest.IsSetTags then
        begin
          Context.Writer.WriteName('Tags');
          Context.Writer.WriteBeginObject;
          for var PublicRequestTagsKvp in PublicRequest.Tags do
          begin
            Context.Writer.WriteName(PublicRequestTagsKvp.Key);
            var PublicRequestTagsValue := PublicRequestTagsKvp.Value;
            Context.Writer.WriteString(PublicRequestTagsValue);
          end;
          Context.Writer.WriteEndObject;
        end;
        Writer.WriteEndObject;
        Writer.Flush;
        var Snippet: string := Stream.DataString;
        Request.Content := TEncoding.UTF8.GetBytes(Snippet);
      finally
        Context.Free;
      end;
    finally
      Writer.Free;
    end;
  finally
    Stream.Free;
  end;
  Result := Request;
end;

class constructor TCreateCollectionRequestMarshaller.Create;
begin
  FInstance := TCreateCollectionRequestMarshaller.Create;
end;

class function TCreateCollectionRequestMarshaller.Instance: ICreateCollectionRequestMarshaller;
begin
  Result := FInstance;
end;

end.
