# Samples

This is a collection of deep learning examples that use [labml](https://github.com/labmlai/labml).

### PyTorch

#### MNIST

* [Without labml 🤮](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/a_no_labml.py)
* [With tracker](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/b_labml_tracker.py) [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/labmlai/labml/blob/master/samples/pytorch/mnist/mnist.ipynb)
* [With monitoring module](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/c1_labml_monit.py)
* [With monitoring module - improved](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/c2_labml_monit_mix.py)
* [With configurations module](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/d_labml_configs.py)
* [With helpers](https://github.com/labmlai/labml/blob/master/samples/pytorch/mnist/e_labml_helpers.py)


#### CIFAR

* [Extending from MNIST example](https://github.com/labmlai/labml/blob/master/samples/pytorch/cifar10/cifar10.py)
  Reuses the training step from MNIST implementation.
* [CIFAR10 with automatic batch size](https://colab.research.google.com/github/labmlai/labml/blob/master/samples/pytorch/cifar10/batch_size.ipynb)

### PyTorch Lightening

* [Simple MNIST](https://github.com/labmlai/labml/blob/master/samples/lightning/mnist.py) [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/labmlai/labml/blob/master/samples/lightning/mnist.ipynb)
* [Detailed MNIST](https://github.com/labmlai/labml/blob/master/samples/lightning/lit_mnist.py)

### Keras

* [MNIST](https://github.com/labmlai/labml/blob/master/samples/keras/mnist.py) [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/labmlai/labml/blob/master/samples/keras/mnist.ipynb)

### FastAI

* [Pets](https://github.com/labmlai/labml/blob/master/samples/fastai/pets.py)