# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

# -- Project information -----------------------------------------------------

project = 'labml library'
copyright = '2020-2024, labml.ai contributors'
author = 'labml contributors'

# The full version, including alpha/beta/rc tags
release = '0.5'

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.napoleon',
    'sphinx.ext.viewcode',
    'sphinxcontrib.katex',
    'sphinx.ext.autosectionlabel',
    'sphinx_sitemap',
]

# autosectionlabel throws warnings if section names are duplicated.
# The following tells autosectionlabel to not throw a warning for
# duplicated section names that are in different documents.
autosectionlabel_prefix_document = True

katex_prerender = True

napoleon_use_ivar = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

source_suffix = '.rst'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# Disable docstring inheritance
autodoc_inherit_docstrings = False

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'alabaster'
# import pytorch_sphinx_theme
import sphinx_rtd_theme

# html_theme = 'pytorch_sphinx_theme'
html_theme = 'sphinx_rtd_theme'
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.

html_theme_options = {
    # 'pytorch_project': '',
    # 'analytics_id': 'UA-164228270-1',
    'canonical_url': 'https://docs.labml.ai/',
    'collapse_navigation': False,
    'display_version': True,
    # 'logo_only': True,
}

html_favicon = '_static/img/lab_icon.png'
# html_logo = '_static/img/lab_logo.png'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

master_doc = 'index'

# To automatically generate a sitemap
html_baseurl = 'https://docs.labml.ai/'

html_css_files = [
    'https://cdn.jsdelivr.net/npm/katex@0.10.0-beta/dist/katex.min.css'
]


# Called automatically by Sphinx, making this `conf.py` an "extension".
def setup(app):
    pass
    # # NOTE: in Sphinx 1.8+ `html_css_files` is an official configuration value
    # # and can be moved outside of this function (and the setup(app) function
    # # can be deleted).
    # html_css_files = [
    #     'https://cdn.jsdelivr.net/npm/katex@0.10.0-beta/dist/katex.min.css'
    # ]
    #
    # # In Sphinx 1.8 it was renamed to `add_css_file`, 1.7 and prior it is
    # # `add_stylesheet` (deprecated in 1.8).
    # add_css = getattr(app, 'add_css_file', app.add_stylesheet)
    # for css_file in html_css_files:
    #     add_css(css_file)
