/*
    Copyright (c) 2022 IBM Corp.
    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

import {} from "./Combobox.module.css"

interface ComboboxProps {
    name: string;
    options: {
        value: string;
        title: string;
    }[];
    handleChange: () => string;
}

const Combobox = ({ name, options, handleChange, ...rest } : ComboboxProps) => {
    return (
        <select id={name} onChange={handleChange} name={name} {...rest}>
            {options.map((option) => (
                <option key={option.value} value={option.value}>
                    {option.title}
                </option>
            ))}
        </select>
    )
}

export default Combobox