#!/usr/bin/python3

#------------------------------------------------------------------------------

class Solution:
    def rotate(self, matrix):
        """
        :type matrix: List[List[int]]
        :rtype: void Do not return anything, modify matrix in-place instead.
        """

        # A clockwise matrix rotation is reversing the columns of the transpose
        n = len(matrix)

        # Transpose the matrix
        for i in range(n):
            for j in range(i+1,n):
                matrix[i][j], matrix[j][i] = matrix[j][i], matrix[i][j]

        # Reverse the columns
        for i in range(n):
            for j in range(n//2):
                matrix[i][j], matrix[i][n-1-j] = matrix[i][n-1-j], matrix[i][j]

#------------------------------------------------------------------------------
#Testing
