# Swarms ChangeLog 5.6.8 -

The biggest update in Swarms history! We've introduced major fixes, updates, and new features to enhance your agent workflows and performance. To get the latest updates run the following: 

## Installation

```bash
$ pip3 install -U swarms
```

# Log
Here’s the breakdown of the latest changes:

---

### 🐞 **Fixes:**
- **[BUGF-AGENTS]:** Fixed various response issues within agents, leading to smoother performance.
- **[BUGF-MIXTURE]:** Resolved issues with the Mixture of Agents, ensuring more reliable and stable execution.
- **[CLEA-FILES]:** Removed unnecessary files, resulting in a significant speed boost and cleaner environment.

---

### 🛠 **Updates:**
- **[REFA-MODULES]:** Refactored the `swarms.models` module into its own package: `swarm_models` for improved code organization.
- **[CLEA-AGENTS]:** Cleaned up tool logic in the `agents` class for streamlined and efficient operations.

---

### ✨ **New Features:**
- **[FEAT-SWARMS]:** Introduced JSON outputs for `AgentRearrange`, `SpreadsheetSwarm`, and other swarms, improving data handling.
- **[FEAT-AGENTS]:** Added YAML file support for creating agents, making the setup process simpler than ever.
- **[FEAT-METADATA]:** Enhanced the `Agent` class with JSON metadata output, supporting OpenAI-like API responses with `output_type="json"` and `return_step_meta=True`.
- **[FEAT-FOREST]:** Released `ForestSwarm`, a new architecture that clusters agents into trees, enabling precise task execution.
- **[FEAT-REGISTRY]:** Fully implemented `AgentRegistry`, allowing you to store multiple agents for future use.

---

### 🚀 **Performance Enhancements:**
- **[PERF-AGENTS]:** Accelerated agent execution by **4x**, with a **10x** boost coming soon, powered by our Rust backend.
- **[PERF-ARCH]:** Optimized multi-threading, concurrency, and asynchrony in swarm architectures, making them faster than ever.

---

**Ready to dive in?** Get started now: [https://buff.ly/444kDjA](https://buff.ly/444kDjA)
