# Frontend Contributor Guide

## Mission
At the heart of Swarms is the mission to democratize multi-agent technology, making it accessible to businesses of all sizes around the globe. This technology, which allows for the orchestration of multiple autonomous agents to achieve complex goals, has the potential to revolutionize industries by enhancing efficiency, scalability, and innovation. Swarms is committed to leading this charge by developing a platform that empowers businesses and individuals to harness the power of multi-agent systems without the need for specialized knowledge or resources.


## Understanding Your Impact as a Frontend Engineer 
Crafting User Experiences: As a frontend engineer at Swarms, you play a crucial role in making multi-agent technology understandable and usable for businesses worldwide. Your work involves translating complex systems into intuitive interfaces, ensuring users can easily navigate, manage, and benefit from multi-agent solutions. By focusing on user-centric design and seamless integration, you help bridge the gap between advanced technology and practical business applications.

Skills and Attributes for Success: Successful frontend engineers at Swarms combine technical expertise with a passion for innovation and a deep understanding of user needs. Proficiency in modern frontend technologies, such as React, NextJS, and Tailwind, is just the beginning. You also need a strong grasp of usability principles, accessibility standards, and the ability to work collaboratively with cross-functional teams. Creativity, problem-solving skills, and a commitment to continuous learning are essential for developing solutions that meet diverse business needs.


## Joining the Team
As you contribute to Swarms, you become part of a collaborative effort to change the world. We value each contribution and provide constructive feedback to help you grow. Outstanding contributors who share our vision and demonstrate exceptional skill and dedication are invited to join our team, where they can have an even greater impact on our mission.


### Becoming a Full-Time Swarms Engineer:
Swarms is radically devoted to open source and transparency. To join the full time team, you must first contribute to the open source repository so we can assess your technical capability and general way of working. After a series of quality contributions, we'll offer you a full time position!

Joining Swarms full-time means more than just a job. It's an opportunity to be at the forefront of technological innovation, working alongside passionate professionals dedicated to making a difference. We look for individuals who are not only skilled but also driven by the desire to make multi-agent technology accessible and beneficial to businesses worldwide.


## Resources
- **Project Management Details**
  - **Linear**: Our projects and tasks at a glance. Get a sense of our workflow and priorities.
    - [View on Linear](https://linear.app/swarms/join/e7f4c6c560ffa0e1395820682f4e110a?s=1)  

- **Design System and UI/UX Guidelines**
  - **Figma**: Dive into our design system to grasp the aesthetics and user experience objectives of Swarms.
    - [View on Figma](https://www.figma.com/file/KL4VIXfZKwwLgAes2WbGNa/Swarms-Cloud-Platform?type=design&node-id=0%3A1&mode=design&t=MkrM0mBQa6qsTDtJ-1)

- **Swarms Platform Repository**
  - **GitHub**: The hub of our development activities. Familiarize yourself with our codebase and current projects.
    - [Visit GitHub Repository](https://github.com/kyegomez/swarms-platform)

- **[Swarms Community](https://discord.gg/pSTSxqDk)**


### Design Style & User Experience
- [How to build great products with game design, not gamification](https://blog.superhuman.com/game-design-not-gamification/)