/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TrialLister helps list Trials.
// All objects returned here must be treated as read-only.
type TrialLister interface {
	// List lists all Trials in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Trial, err error)
	// Trials returns an object that can list and get Trials.
	Trials(namespace string) TrialNamespaceLister
	TrialListerExpansion
}

// trialLister implements the TrialLister interface.
type trialLister struct {
	indexer cache.Indexer
}

// NewTrialLister returns a new TrialLister.
func NewTrialLister(indexer cache.Indexer) TrialLister {
	return &trialLister{indexer: indexer}
}

// List lists all Trials in the indexer.
func (s *trialLister) List(selector labels.Selector) (ret []*v1beta1.Trial, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Trial))
	})
	return ret, err
}

// Trials returns an object that can list and get Trials.
func (s *trialLister) Trials(namespace string) TrialNamespaceLister {
	return trialNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TrialNamespaceLister helps list and get Trials.
// All objects returned here must be treated as read-only.
type TrialNamespaceLister interface {
	// List lists all Trials in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Trial, err error)
	// Get retrieves the Trial from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.Trial, error)
	TrialNamespaceListerExpansion
}

// trialNamespaceLister implements the TrialNamespaceLister
// interface.
type trialNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Trials in the indexer for a given namespace.
func (s trialNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.Trial, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Trial))
	})
	return ret, err
}

// Get retrieves the Trial from the indexer for a given namespace and name.
func (s trialNamespaceLister) Get(name string) (*v1beta1.Trial, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("trial"), name)
	}
	return obj.(*v1beta1.Trial), nil
}
