/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SuggestionLister helps list Suggestions.
// All objects returned here must be treated as read-only.
type SuggestionLister interface {
	// List lists all Suggestions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Suggestion, err error)
	// Suggestions returns an object that can list and get Suggestions.
	Suggestions(namespace string) SuggestionNamespaceLister
	SuggestionListerExpansion
}

// suggestionLister implements the SuggestionLister interface.
type suggestionLister struct {
	indexer cache.Indexer
}

// NewSuggestionLister returns a new SuggestionLister.
func NewSuggestionLister(indexer cache.Indexer) SuggestionLister {
	return &suggestionLister{indexer: indexer}
}

// List lists all Suggestions in the indexer.
func (s *suggestionLister) List(selector labels.Selector) (ret []*v1beta1.Suggestion, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Suggestion))
	})
	return ret, err
}

// Suggestions returns an object that can list and get Suggestions.
func (s *suggestionLister) Suggestions(namespace string) SuggestionNamespaceLister {
	return suggestionNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SuggestionNamespaceLister helps list and get Suggestions.
// All objects returned here must be treated as read-only.
type SuggestionNamespaceLister interface {
	// List lists all Suggestions in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.Suggestion, err error)
	// Get retrieves the Suggestion from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.Suggestion, error)
	SuggestionNamespaceListerExpansion
}

// suggestionNamespaceLister implements the SuggestionNamespaceLister
// interface.
type suggestionNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Suggestions in the indexer for a given namespace.
func (s suggestionNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.Suggestion, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Suggestion))
	})
	return ret, err
}

// Get retrieves the Suggestion from the indexer for a given namespace and name.
func (s suggestionNamespaceLister) Get(name string) (*v1beta1.Suggestion, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("suggestion"), name)
	}
	return obj.(*v1beta1.Suggestion), nil
}
