/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	suggestionsv1beta1 "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1"
	versioned "github.com/kubeflow/katib/pkg/client/controller/clientset/versioned"
	internalinterfaces "github.com/kubeflow/katib/pkg/client/controller/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/kubeflow/katib/pkg/client/controller/listers/suggestions/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// SuggestionInformer provides access to a shared informer and lister for
// Suggestions.
type SuggestionInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.SuggestionLister
}

type suggestionInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewSuggestionInformer constructs a new informer for Suggestion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewSuggestionInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredSuggestionInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredSuggestionInformer constructs a new informer for Suggestion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredSuggestionInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.SuggestionV1beta1().Suggestions(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.SuggestionV1beta1().Suggestions(namespace).Watch(context.TODO(), options)
			},
		},
		&suggestionsv1beta1.Suggestion{},
		resyncPeriod,
		indexers,
	)
}

func (f *suggestionInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredSuggestionInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *suggestionInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&suggestionsv1beta1.Suggestion{}, f.defaultInformer)
}

func (f *suggestionInformer) Lister() v1beta1.SuggestionLister {
	return v1beta1.NewSuggestionLister(f.Informer().GetIndexer())
}
