/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1"
	suggestionsv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/suggestions/v1beta1"
	scheme "github.com/kubeflow/katib/pkg/client/controller/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SuggestionsGetter has a method to return a SuggestionInterface.
// A group's client should implement this interface.
type SuggestionsGetter interface {
	Suggestions(namespace string) SuggestionInterface
}

// SuggestionInterface has methods to work with Suggestion resources.
type SuggestionInterface interface {
	Create(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.CreateOptions) (*v1beta1.Suggestion, error)
	Update(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (*v1beta1.Suggestion, error)
	UpdateStatus(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (*v1beta1.Suggestion, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Suggestion, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.SuggestionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Suggestion, err error)
	Apply(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error)
	ApplyStatus(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error)
	SuggestionExpansion
}

// suggestions implements SuggestionInterface
type suggestions struct {
	client rest.Interface
	ns     string
}

// newSuggestions returns a Suggestions
func newSuggestions(c *SuggestionV1beta1Client, namespace string) *suggestions {
	return &suggestions{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the suggestion, and returns the corresponding suggestion object, and an error if there is any.
func (c *suggestions) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Suggestion, err error) {
	result = &v1beta1.Suggestion{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("suggestions").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Suggestions that match those selectors.
func (c *suggestions) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.SuggestionList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.SuggestionList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("suggestions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested suggestions.
func (c *suggestions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("suggestions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a suggestion and creates it.  Returns the server's representation of the suggestion, and an error, if there is any.
func (c *suggestions) Create(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.CreateOptions) (result *v1beta1.Suggestion, err error) {
	result = &v1beta1.Suggestion{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("suggestions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(suggestion).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a suggestion and updates it. Returns the server's representation of the suggestion, and an error, if there is any.
func (c *suggestions) Update(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (result *v1beta1.Suggestion, err error) {
	result = &v1beta1.Suggestion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("suggestions").
		Name(suggestion.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(suggestion).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *suggestions) UpdateStatus(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (result *v1beta1.Suggestion, err error) {
	result = &v1beta1.Suggestion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("suggestions").
		Name(suggestion.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(suggestion).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the suggestion and deletes it. Returns an error if one occurs.
func (c *suggestions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("suggestions").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *suggestions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("suggestions").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched suggestion.
func (c *suggestions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Suggestion, err error) {
	result = &v1beta1.Suggestion{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("suggestions").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied suggestion.
func (c *suggestions) Apply(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error) {
	if suggestion == nil {
		return nil, fmt.Errorf("suggestion provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(suggestion)
	if err != nil {
		return nil, err
	}
	name := suggestion.Name
	if name == nil {
		return nil, fmt.Errorf("suggestion.Name must be provided to Apply")
	}
	result = &v1beta1.Suggestion{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("suggestions").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *suggestions) ApplyStatus(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error) {
	if suggestion == nil {
		return nil, fmt.Errorf("suggestion provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(suggestion)
	if err != nil {
		return nil, err
	}

	name := suggestion.Name
	if name == nil {
		return nil, fmt.Errorf("suggestion.Name must be provided to Apply")
	}

	result = &v1beta1.Suggestion{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("suggestions").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
