/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1"
	suggestionsv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/suggestions/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSuggestions implements SuggestionInterface
type FakeSuggestions struct {
	Fake *FakeSuggestionV1beta1
	ns   string
}

var suggestionsResource = v1beta1.SchemeGroupVersion.WithResource("suggestions")

var suggestionsKind = v1beta1.SchemeGroupVersion.WithKind("Suggestion")

// Get takes name of the suggestion, and returns the corresponding suggestion object, and an error if there is any.
func (c *FakeSuggestions) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Suggestion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(suggestionsResource, c.ns, name), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// List takes label and field selectors, and returns the list of Suggestions that match those selectors.
func (c *FakeSuggestions) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.SuggestionList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(suggestionsResource, suggestionsKind, c.ns, opts), &v1beta1.SuggestionList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.SuggestionList{ListMeta: obj.(*v1beta1.SuggestionList).ListMeta}
	for _, item := range obj.(*v1beta1.SuggestionList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested suggestions.
func (c *FakeSuggestions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(suggestionsResource, c.ns, opts))

}

// Create takes the representation of a suggestion and creates it.  Returns the server's representation of the suggestion, and an error, if there is any.
func (c *FakeSuggestions) Create(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.CreateOptions) (result *v1beta1.Suggestion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(suggestionsResource, c.ns, suggestion), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// Update takes the representation of a suggestion and updates it. Returns the server's representation of the suggestion, and an error, if there is any.
func (c *FakeSuggestions) Update(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (result *v1beta1.Suggestion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(suggestionsResource, c.ns, suggestion), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSuggestions) UpdateStatus(ctx context.Context, suggestion *v1beta1.Suggestion, opts v1.UpdateOptions) (*v1beta1.Suggestion, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(suggestionsResource, "status", c.ns, suggestion), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// Delete takes name of the suggestion and deletes it. Returns an error if one occurs.
func (c *FakeSuggestions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(suggestionsResource, c.ns, name, opts), &v1beta1.Suggestion{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSuggestions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(suggestionsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.SuggestionList{})
	return err
}

// Patch applies the patch and returns the patched suggestion.
func (c *FakeSuggestions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Suggestion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(suggestionsResource, c.ns, name, pt, data, subresources...), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied suggestion.
func (c *FakeSuggestions) Apply(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error) {
	if suggestion == nil {
		return nil, fmt.Errorf("suggestion provided to Apply must not be nil")
	}
	data, err := json.Marshal(suggestion)
	if err != nil {
		return nil, err
	}
	name := suggestion.Name
	if name == nil {
		return nil, fmt.Errorf("suggestion.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(suggestionsResource, c.ns, *name, types.ApplyPatchType, data), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeSuggestions) ApplyStatus(ctx context.Context, suggestion *suggestionsv1beta1.SuggestionApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Suggestion, err error) {
	if suggestion == nil {
		return nil, fmt.Errorf("suggestion provided to Apply must not be nil")
	}
	data, err := json.Marshal(suggestion)
	if err != nil {
		return nil, err
	}
	name := suggestion.Name
	if name == nil {
		return nil, fmt.Errorf("suggestion.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(suggestionsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1beta1.Suggestion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Suggestion), err
}
