/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1"
	experimentsv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/experiments/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeExperiments implements ExperimentInterface
type FakeExperiments struct {
	Fake *FakeExperimentV1beta1
	ns   string
}

var experimentsResource = v1beta1.SchemeGroupVersion.WithResource("experiments")

var experimentsKind = v1beta1.SchemeGroupVersion.WithKind("Experiment")

// Get takes name of the experiment, and returns the corresponding experiment object, and an error if there is any.
func (c *FakeExperiments) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Experiment, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(experimentsResource, c.ns, name), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// List takes label and field selectors, and returns the list of Experiments that match those selectors.
func (c *FakeExperiments) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ExperimentList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(experimentsResource, experimentsKind, c.ns, opts), &v1beta1.ExperimentList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.ExperimentList{ListMeta: obj.(*v1beta1.ExperimentList).ListMeta}
	for _, item := range obj.(*v1beta1.ExperimentList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested experiments.
func (c *FakeExperiments) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(experimentsResource, c.ns, opts))

}

// Create takes the representation of a experiment and creates it.  Returns the server's representation of the experiment, and an error, if there is any.
func (c *FakeExperiments) Create(ctx context.Context, experiment *v1beta1.Experiment, opts v1.CreateOptions) (result *v1beta1.Experiment, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(experimentsResource, c.ns, experiment), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// Update takes the representation of a experiment and updates it. Returns the server's representation of the experiment, and an error, if there is any.
func (c *FakeExperiments) Update(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (result *v1beta1.Experiment, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(experimentsResource, c.ns, experiment), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeExperiments) UpdateStatus(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (*v1beta1.Experiment, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(experimentsResource, "status", c.ns, experiment), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// Delete takes name of the experiment and deletes it. Returns an error if one occurs.
func (c *FakeExperiments) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(experimentsResource, c.ns, name, opts), &v1beta1.Experiment{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeExperiments) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(experimentsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.ExperimentList{})
	return err
}

// Patch applies the patch and returns the patched experiment.
func (c *FakeExperiments) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Experiment, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(experimentsResource, c.ns, name, pt, data, subresources...), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied experiment.
func (c *FakeExperiments) Apply(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error) {
	if experiment == nil {
		return nil, fmt.Errorf("experiment provided to Apply must not be nil")
	}
	data, err := json.Marshal(experiment)
	if err != nil {
		return nil, err
	}
	name := experiment.Name
	if name == nil {
		return nil, fmt.Errorf("experiment.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(experimentsResource, c.ns, *name, types.ApplyPatchType, data), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeExperiments) ApplyStatus(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error) {
	if experiment == nil {
		return nil, fmt.Errorf("experiment provided to Apply must not be nil")
	}
	data, err := json.Marshal(experiment)
	if err != nil {
		return nil, err
	}
	name := experiment.Name
	if name == nil {
		return nil, fmt.Errorf("experiment.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(experimentsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1beta1.Experiment{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Experiment), err
}
