/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1"
	experimentsv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/experiments/v1beta1"
	scheme "github.com/kubeflow/katib/pkg/client/controller/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ExperimentsGetter has a method to return a ExperimentInterface.
// A group's client should implement this interface.
type ExperimentsGetter interface {
	Experiments(namespace string) ExperimentInterface
}

// ExperimentInterface has methods to work with Experiment resources.
type ExperimentInterface interface {
	Create(ctx context.Context, experiment *v1beta1.Experiment, opts v1.CreateOptions) (*v1beta1.Experiment, error)
	Update(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (*v1beta1.Experiment, error)
	UpdateStatus(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (*v1beta1.Experiment, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Experiment, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ExperimentList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Experiment, err error)
	Apply(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error)
	ApplyStatus(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error)
	ExperimentExpansion
}

// experiments implements ExperimentInterface
type experiments struct {
	client rest.Interface
	ns     string
}

// newExperiments returns a Experiments
func newExperiments(c *ExperimentV1beta1Client, namespace string) *experiments {
	return &experiments{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the experiment, and returns the corresponding experiment object, and an error if there is any.
func (c *experiments) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Experiment, err error) {
	result = &v1beta1.Experiment{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("experiments").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Experiments that match those selectors.
func (c *experiments) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ExperimentList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ExperimentList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("experiments").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested experiments.
func (c *experiments) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("experiments").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a experiment and creates it.  Returns the server's representation of the experiment, and an error, if there is any.
func (c *experiments) Create(ctx context.Context, experiment *v1beta1.Experiment, opts v1.CreateOptions) (result *v1beta1.Experiment, err error) {
	result = &v1beta1.Experiment{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("experiments").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(experiment).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a experiment and updates it. Returns the server's representation of the experiment, and an error, if there is any.
func (c *experiments) Update(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (result *v1beta1.Experiment, err error) {
	result = &v1beta1.Experiment{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("experiments").
		Name(experiment.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(experiment).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *experiments) UpdateStatus(ctx context.Context, experiment *v1beta1.Experiment, opts v1.UpdateOptions) (result *v1beta1.Experiment, err error) {
	result = &v1beta1.Experiment{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("experiments").
		Name(experiment.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(experiment).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the experiment and deletes it. Returns an error if one occurs.
func (c *experiments) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("experiments").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *experiments) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("experiments").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched experiment.
func (c *experiments) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Experiment, err error) {
	result = &v1beta1.Experiment{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("experiments").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied experiment.
func (c *experiments) Apply(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error) {
	if experiment == nil {
		return nil, fmt.Errorf("experiment provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(experiment)
	if err != nil {
		return nil, err
	}
	name := experiment.Name
	if name == nil {
		return nil, fmt.Errorf("experiment.Name must be provided to Apply")
	}
	result = &v1beta1.Experiment{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("experiments").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *experiments) ApplyStatus(ctx context.Context, experiment *experimentsv1beta1.ExperimentApplyConfiguration, opts v1.ApplyOptions) (result *v1beta1.Experiment, err error) {
	if experiment == nil {
		return nil, fmt.Errorf("experiment provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(experiment)
	if err != nil {
		return nil, err
	}

	name := experiment.Name
	if name == nil {
		return nil, fmt.Errorf("experiment.Name must be provided to Apply")
	}

	result = &v1beta1.Experiment{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("experiments").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
