/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	commonv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/common/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// TrialStatusApplyConfiguration represents an declarative configuration of the TrialStatus type for use
// with apply.
type TrialStatusApplyConfiguration struct {
	StartTime         *v1.Time                                     `json:"startTime,omitempty"`
	CompletionTime    *v1.Time                                     `json:"completionTime,omitempty"`
	LastReconcileTime *v1.Time                                     `json:"lastReconcileTime,omitempty"`
	Conditions        []TrialConditionApplyConfiguration           `json:"conditions,omitempty"`
	Observation       *commonv1beta1.ObservationApplyConfiguration `json:"observation,omitempty"`
}

// TrialStatusApplyConfiguration constructs an declarative configuration of the TrialStatus type for use with
// apply.
func TrialStatus() *TrialStatusApplyConfiguration {
	return &TrialStatusApplyConfiguration{}
}

// WithStartTime sets the StartTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StartTime field is set to the value of the last call.
func (b *TrialStatusApplyConfiguration) WithStartTime(value v1.Time) *TrialStatusApplyConfiguration {
	b.StartTime = &value
	return b
}

// WithCompletionTime sets the CompletionTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CompletionTime field is set to the value of the last call.
func (b *TrialStatusApplyConfiguration) WithCompletionTime(value v1.Time) *TrialStatusApplyConfiguration {
	b.CompletionTime = &value
	return b
}

// WithLastReconcileTime sets the LastReconcileTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastReconcileTime field is set to the value of the last call.
func (b *TrialStatusApplyConfiguration) WithLastReconcileTime(value v1.Time) *TrialStatusApplyConfiguration {
	b.LastReconcileTime = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *TrialStatusApplyConfiguration) WithConditions(values ...*TrialConditionApplyConfiguration) *TrialStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithObservation sets the Observation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Observation field is set to the value of the last call.
func (b *TrialStatusApplyConfiguration) WithObservation(value *commonv1beta1.ObservationApplyConfiguration) *TrialStatusApplyConfiguration {
	b.Observation = value
	return b
}
