/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	unstructured "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

// TrialTemplateApplyConfiguration represents an declarative configuration of the TrialTemplate type for use
// with apply.
type TrialTemplateApplyConfiguration struct {
	Retain                        *bool `json:"retain,omitempty"`
	TrialSourceApplyConfiguration `json:",inline"`
	TrialParameters               []TrialParameterSpecApplyConfiguration `json:"trialParameters,omitempty"`
	PrimaryPodLabels              map[string]string                      `json:"primaryPodLabels,omitempty"`
	PrimaryContainerName          *string                                `json:"primaryContainerName,omitempty"`
	SuccessCondition              *string                                `json:"successCondition,omitempty"`
	FailureCondition              *string                                `json:"failureCondition,omitempty"`
}

// TrialTemplateApplyConfiguration constructs an declarative configuration of the TrialTemplate type for use with
// apply.
func TrialTemplate() *TrialTemplateApplyConfiguration {
	return &TrialTemplateApplyConfiguration{}
}

// WithRetain sets the Retain field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Retain field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithRetain(value bool) *TrialTemplateApplyConfiguration {
	b.Retain = &value
	return b
}

// WithTrialSpec sets the TrialSpec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialSpec field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithTrialSpec(value unstructured.Unstructured) *TrialTemplateApplyConfiguration {
	b.TrialSpec = &value
	return b
}

// WithConfigMap sets the ConfigMap field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConfigMap field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithConfigMap(value *ConfigMapSourceApplyConfiguration) *TrialTemplateApplyConfiguration {
	b.ConfigMap = value
	return b
}

// WithTrialParameters adds the given value to the TrialParameters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TrialParameters field.
func (b *TrialTemplateApplyConfiguration) WithTrialParameters(values ...*TrialParameterSpecApplyConfiguration) *TrialTemplateApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTrialParameters")
		}
		b.TrialParameters = append(b.TrialParameters, *values[i])
	}
	return b
}

// WithPrimaryPodLabels puts the entries into the PrimaryPodLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the PrimaryPodLabels field,
// overwriting an existing map entries in PrimaryPodLabels field with the same key.
func (b *TrialTemplateApplyConfiguration) WithPrimaryPodLabels(entries map[string]string) *TrialTemplateApplyConfiguration {
	if b.PrimaryPodLabels == nil && len(entries) > 0 {
		b.PrimaryPodLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.PrimaryPodLabels[k] = v
	}
	return b
}

// WithPrimaryContainerName sets the PrimaryContainerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PrimaryContainerName field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithPrimaryContainerName(value string) *TrialTemplateApplyConfiguration {
	b.PrimaryContainerName = &value
	return b
}

// WithSuccessCondition sets the SuccessCondition field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SuccessCondition field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithSuccessCondition(value string) *TrialTemplateApplyConfiguration {
	b.SuccessCondition = &value
	return b
}

// WithFailureCondition sets the FailureCondition field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FailureCondition field is set to the value of the last call.
func (b *TrialTemplateApplyConfiguration) WithFailureCondition(value string) *TrialTemplateApplyConfiguration {
	b.FailureCondition = &value
	return b
}
