/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/common/v1beta1"
)

// OptimalTrialApplyConfiguration represents an declarative configuration of the OptimalTrial type for use
// with apply.
type OptimalTrialApplyConfiguration struct {
	BestTrialName        *string                                         `json:"bestTrialName,omitempty"`
	ParameterAssignments []v1beta1.ParameterAssignmentApplyConfiguration `json:"parameterAssignments,omitempty"`
	Observation          *v1beta1.ObservationApplyConfiguration          `json:"observation,omitempty"`
}

// OptimalTrialApplyConfiguration constructs an declarative configuration of the OptimalTrial type for use with
// apply.
func OptimalTrial() *OptimalTrialApplyConfiguration {
	return &OptimalTrialApplyConfiguration{}
}

// WithBestTrialName sets the BestTrialName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BestTrialName field is set to the value of the last call.
func (b *OptimalTrialApplyConfiguration) WithBestTrialName(value string) *OptimalTrialApplyConfiguration {
	b.BestTrialName = &value
	return b
}

// WithParameterAssignments adds the given value to the ParameterAssignments field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ParameterAssignments field.
func (b *OptimalTrialApplyConfiguration) WithParameterAssignments(values ...*v1beta1.ParameterAssignmentApplyConfiguration) *OptimalTrialApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParameterAssignments")
		}
		b.ParameterAssignments = append(b.ParameterAssignments, *values[i])
	}
	return b
}

// WithObservation sets the Observation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Observation field is set to the value of the last call.
func (b *OptimalTrialApplyConfiguration) WithObservation(value *v1beta1.ObservationApplyConfiguration) *OptimalTrialApplyConfiguration {
	b.Observation = value
	return b
}
