/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// OperationApplyConfiguration represents an declarative configuration of the Operation type for use
// with apply.
type OperationApplyConfiguration struct {
	OperationType *string                           `json:"operationType,omitempty"`
	Parameters    []ParameterSpecApplyConfiguration `json:"parameters,omitempty"`
}

// OperationApplyConfiguration constructs an declarative configuration of the Operation type for use with
// apply.
func Operation() *OperationApplyConfiguration {
	return &OperationApplyConfiguration{}
}

// WithOperationType sets the OperationType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OperationType field is set to the value of the last call.
func (b *OperationApplyConfiguration) WithOperationType(value string) *OperationApplyConfiguration {
	b.OperationType = &value
	return b
}

// WithParameters adds the given value to the Parameters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Parameters field.
func (b *OperationApplyConfiguration) WithParameters(values ...*ParameterSpecApplyConfiguration) *OperationApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParameters")
		}
		b.Parameters = append(b.Parameters, *values[i])
	}
	return b
}
