/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// GraphConfigApplyConfiguration represents an declarative configuration of the GraphConfig type for use
// with apply.
type GraphConfigApplyConfiguration struct {
	NumLayers   *int32  `json:"numLayers,omitempty"`
	InputSizes  []int32 `json:"inputSizes,omitempty"`
	OutputSizes []int32 `json:"outputSizes,omitempty"`
}

// GraphConfigApplyConfiguration constructs an declarative configuration of the GraphConfig type for use with
// apply.
func GraphConfig() *GraphConfigApplyConfiguration {
	return &GraphConfigApplyConfiguration{}
}

// WithNumLayers sets the NumLayers field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NumLayers field is set to the value of the last call.
func (b *GraphConfigApplyConfiguration) WithNumLayers(value int32) *GraphConfigApplyConfiguration {
	b.NumLayers = &value
	return b
}

// WithInputSizes adds the given value to the InputSizes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the InputSizes field.
func (b *GraphConfigApplyConfiguration) WithInputSizes(values ...int32) *GraphConfigApplyConfiguration {
	for i := range values {
		b.InputSizes = append(b.InputSizes, values[i])
	}
	return b
}

// WithOutputSizes adds the given value to the OutputSizes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OutputSizes field.
func (b *GraphConfigApplyConfiguration) WithOutputSizes(values ...int32) *GraphConfigApplyConfiguration {
	for i := range values {
		b.OutputSizes = append(b.OutputSizes, values[i])
	}
	return b
}
