/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// ExperimentStatusApplyConfiguration represents an declarative configuration of the ExperimentStatus type for use
// with apply.
type ExperimentStatusApplyConfiguration struct {
	StartTime                   *v1.Time                                `json:"startTime,omitempty"`
	CompletionTime              *v1.Time                                `json:"completionTime,omitempty"`
	LastReconcileTime           *v1.Time                                `json:"lastReconcileTime,omitempty"`
	Conditions                  []ExperimentConditionApplyConfiguration `json:"conditions,omitempty"`
	CurrentOptimalTrial         *OptimalTrialApplyConfiguration         `json:"currentOptimalTrial,omitempty"`
	RunningTrialList            []string                                `json:"runningTrialList,omitempty"`
	PendingTrialList            []string                                `json:"pendingTrialList,omitempty"`
	FailedTrialList             []string                                `json:"failedTrialList,omitempty"`
	SucceededTrialList          []string                                `json:"succeededTrialList,omitempty"`
	KilledTrialList             []string                                `json:"killedTrialList,omitempty"`
	EarlyStoppedTrialList       []string                                `json:"earlyStoppedTrialList,omitempty"`
	MetricsUnavailableTrialList []string                                `json:"metricsUnavailableTrialList,omitempty"`
	Trials                      *int32                                  `json:"trials,omitempty"`
	TrialsSucceeded             *int32                                  `json:"trialsSucceeded,omitempty"`
	TrialsFailed                *int32                                  `json:"trialsFailed,omitempty"`
	TrialsKilled                *int32                                  `json:"trialsKilled,omitempty"`
	TrialsPending               *int32                                  `json:"trialsPending,omitempty"`
	TrialsRunning               *int32                                  `json:"trialsRunning,omitempty"`
	TrialsEarlyStopped          *int32                                  `json:"trialsEarlyStopped,omitempty"`
	TrialMetricsUnavailable     *int32                                  `json:"trialMetricsUnavailable,omitempty"`
}

// ExperimentStatusApplyConfiguration constructs an declarative configuration of the ExperimentStatus type for use with
// apply.
func ExperimentStatus() *ExperimentStatusApplyConfiguration {
	return &ExperimentStatusApplyConfiguration{}
}

// WithStartTime sets the StartTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StartTime field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithStartTime(value v1.Time) *ExperimentStatusApplyConfiguration {
	b.StartTime = &value
	return b
}

// WithCompletionTime sets the CompletionTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CompletionTime field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithCompletionTime(value v1.Time) *ExperimentStatusApplyConfiguration {
	b.CompletionTime = &value
	return b
}

// WithLastReconcileTime sets the LastReconcileTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastReconcileTime field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithLastReconcileTime(value v1.Time) *ExperimentStatusApplyConfiguration {
	b.LastReconcileTime = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *ExperimentStatusApplyConfiguration) WithConditions(values ...*ExperimentConditionApplyConfiguration) *ExperimentStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithCurrentOptimalTrial sets the CurrentOptimalTrial field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CurrentOptimalTrial field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithCurrentOptimalTrial(value *OptimalTrialApplyConfiguration) *ExperimentStatusApplyConfiguration {
	b.CurrentOptimalTrial = value
	return b
}

// WithRunningTrialList adds the given value to the RunningTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RunningTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithRunningTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.RunningTrialList = append(b.RunningTrialList, values[i])
	}
	return b
}

// WithPendingTrialList adds the given value to the PendingTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PendingTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithPendingTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.PendingTrialList = append(b.PendingTrialList, values[i])
	}
	return b
}

// WithFailedTrialList adds the given value to the FailedTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the FailedTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithFailedTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.FailedTrialList = append(b.FailedTrialList, values[i])
	}
	return b
}

// WithSucceededTrialList adds the given value to the SucceededTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SucceededTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithSucceededTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.SucceededTrialList = append(b.SucceededTrialList, values[i])
	}
	return b
}

// WithKilledTrialList adds the given value to the KilledTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the KilledTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithKilledTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.KilledTrialList = append(b.KilledTrialList, values[i])
	}
	return b
}

// WithEarlyStoppedTrialList adds the given value to the EarlyStoppedTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EarlyStoppedTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithEarlyStoppedTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.EarlyStoppedTrialList = append(b.EarlyStoppedTrialList, values[i])
	}
	return b
}

// WithMetricsUnavailableTrialList adds the given value to the MetricsUnavailableTrialList field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the MetricsUnavailableTrialList field.
func (b *ExperimentStatusApplyConfiguration) WithMetricsUnavailableTrialList(values ...string) *ExperimentStatusApplyConfiguration {
	for i := range values {
		b.MetricsUnavailableTrialList = append(b.MetricsUnavailableTrialList, values[i])
	}
	return b
}

// WithTrials sets the Trials field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Trials field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrials(value int32) *ExperimentStatusApplyConfiguration {
	b.Trials = &value
	return b
}

// WithTrialsSucceeded sets the TrialsSucceeded field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsSucceeded field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsSucceeded(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsSucceeded = &value
	return b
}

// WithTrialsFailed sets the TrialsFailed field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsFailed field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsFailed(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsFailed = &value
	return b
}

// WithTrialsKilled sets the TrialsKilled field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsKilled field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsKilled(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsKilled = &value
	return b
}

// WithTrialsPending sets the TrialsPending field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsPending field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsPending(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsPending = &value
	return b
}

// WithTrialsRunning sets the TrialsRunning field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsRunning field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsRunning(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsRunning = &value
	return b
}

// WithTrialsEarlyStopped sets the TrialsEarlyStopped field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialsEarlyStopped field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialsEarlyStopped(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialsEarlyStopped = &value
	return b
}

// WithTrialMetricsUnavailable sets the TrialMetricsUnavailable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialMetricsUnavailable field is set to the value of the last call.
func (b *ExperimentStatusApplyConfiguration) WithTrialMetricsUnavailable(value int32) *ExperimentStatusApplyConfiguration {
	b.TrialMetricsUnavailable = &value
	return b
}
