/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	experimentsv1beta1 "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1"
	commonv1beta1 "github.com/kubeflow/katib/pkg/client/controller/applyconfiguration/common/v1beta1"
)

// ExperimentSpecApplyConfiguration represents an declarative configuration of the ExperimentSpec type for use
// with apply.
type ExperimentSpecApplyConfiguration struct {
	Parameters           []ParameterSpecApplyConfiguration                     `json:"parameters,omitempty"`
	Objective            *commonv1beta1.ObjectiveSpecApplyConfiguration        `json:"objective,omitempty"`
	Algorithm            *commonv1beta1.AlgorithmSpecApplyConfiguration        `json:"algorithm,omitempty"`
	EarlyStopping        *commonv1beta1.EarlyStoppingSpecApplyConfiguration    `json:"earlyStopping,omitempty"`
	TrialTemplate        *TrialTemplateApplyConfiguration                      `json:"trialTemplate,omitempty"`
	ParallelTrialCount   *int32                                                `json:"parallelTrialCount,omitempty"`
	MaxTrialCount        *int32                                                `json:"maxTrialCount,omitempty"`
	MaxFailedTrialCount  *int32                                                `json:"maxFailedTrialCount,omitempty"`
	MetricsCollectorSpec *commonv1beta1.MetricsCollectorSpecApplyConfiguration `json:"metricsCollectorSpec,omitempty"`
	NasConfig            *NasConfigApplyConfiguration                          `json:"nasConfig,omitempty"`
	ResumePolicy         *experimentsv1beta1.ResumePolicyType                  `json:"resumePolicy,omitempty"`
}

// ExperimentSpecApplyConfiguration constructs an declarative configuration of the ExperimentSpec type for use with
// apply.
func ExperimentSpec() *ExperimentSpecApplyConfiguration {
	return &ExperimentSpecApplyConfiguration{}
}

// WithParameters adds the given value to the Parameters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Parameters field.
func (b *ExperimentSpecApplyConfiguration) WithParameters(values ...*ParameterSpecApplyConfiguration) *ExperimentSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParameters")
		}
		b.Parameters = append(b.Parameters, *values[i])
	}
	return b
}

// WithObjective sets the Objective field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Objective field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithObjective(value *commonv1beta1.ObjectiveSpecApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.Objective = value
	return b
}

// WithAlgorithm sets the Algorithm field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Algorithm field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithAlgorithm(value *commonv1beta1.AlgorithmSpecApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.Algorithm = value
	return b
}

// WithEarlyStopping sets the EarlyStopping field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EarlyStopping field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithEarlyStopping(value *commonv1beta1.EarlyStoppingSpecApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.EarlyStopping = value
	return b
}

// WithTrialTemplate sets the TrialTemplate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrialTemplate field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithTrialTemplate(value *TrialTemplateApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.TrialTemplate = value
	return b
}

// WithParallelTrialCount sets the ParallelTrialCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ParallelTrialCount field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithParallelTrialCount(value int32) *ExperimentSpecApplyConfiguration {
	b.ParallelTrialCount = &value
	return b
}

// WithMaxTrialCount sets the MaxTrialCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxTrialCount field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithMaxTrialCount(value int32) *ExperimentSpecApplyConfiguration {
	b.MaxTrialCount = &value
	return b
}

// WithMaxFailedTrialCount sets the MaxFailedTrialCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxFailedTrialCount field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithMaxFailedTrialCount(value int32) *ExperimentSpecApplyConfiguration {
	b.MaxFailedTrialCount = &value
	return b
}

// WithMetricsCollectorSpec sets the MetricsCollectorSpec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MetricsCollectorSpec field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithMetricsCollectorSpec(value *commonv1beta1.MetricsCollectorSpecApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.MetricsCollectorSpec = value
	return b
}

// WithNasConfig sets the NasConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NasConfig field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithNasConfig(value *NasConfigApplyConfiguration) *ExperimentSpecApplyConfiguration {
	b.NasConfig = value
	return b
}

// WithResumePolicy sets the ResumePolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResumePolicy field is set to the value of the last call.
func (b *ExperimentSpecApplyConfiguration) WithResumePolicy(value experimentsv1beta1.ResumePolicyType) *ExperimentSpecApplyConfiguration {
	b.ResumePolicy = &value
	return b
}
