/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// ObservationApplyConfiguration represents an declarative configuration of the Observation type for use
// with apply.
type ObservationApplyConfiguration struct {
	Metrics []MetricApplyConfiguration `json:"metrics,omitempty"`
}

// ObservationApplyConfiguration constructs an declarative configuration of the Observation type for use with
// apply.
func Observation() *ObservationApplyConfiguration {
	return &ObservationApplyConfiguration{}
}

// WithMetrics adds the given value to the Metrics field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Metrics field.
func (b *ObservationApplyConfiguration) WithMetrics(values ...*MetricApplyConfiguration) *ObservationApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMetrics")
		}
		b.Metrics = append(b.Metrics, *values[i])
	}
	return b
}
