/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1"
)

// ObjectiveSpecApplyConfiguration represents an declarative configuration of the ObjectiveSpec type for use
// with apply.
type ObjectiveSpecApplyConfiguration struct {
	Type                  *v1beta1.ObjectiveType             `json:"type,omitempty"`
	Goal                  *float64                           `json:"goal,omitempty"`
	ObjectiveMetricName   *string                            `json:"objectiveMetricName,omitempty"`
	AdditionalMetricNames []string                           `json:"additionalMetricNames,omitempty"`
	MetricStrategies      []MetricStrategyApplyConfiguration `json:"metricStrategies,omitempty"`
}

// ObjectiveSpecApplyConfiguration constructs an declarative configuration of the ObjectiveSpec type for use with
// apply.
func ObjectiveSpec() *ObjectiveSpecApplyConfiguration {
	return &ObjectiveSpecApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *ObjectiveSpecApplyConfiguration) WithType(value v1beta1.ObjectiveType) *ObjectiveSpecApplyConfiguration {
	b.Type = &value
	return b
}

// WithGoal sets the Goal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Goal field is set to the value of the last call.
func (b *ObjectiveSpecApplyConfiguration) WithGoal(value float64) *ObjectiveSpecApplyConfiguration {
	b.Goal = &value
	return b
}

// WithObjectiveMetricName sets the ObjectiveMetricName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ObjectiveMetricName field is set to the value of the last call.
func (b *ObjectiveSpecApplyConfiguration) WithObjectiveMetricName(value string) *ObjectiveSpecApplyConfiguration {
	b.ObjectiveMetricName = &value
	return b
}

// WithAdditionalMetricNames adds the given value to the AdditionalMetricNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AdditionalMetricNames field.
func (b *ObjectiveSpecApplyConfiguration) WithAdditionalMetricNames(values ...string) *ObjectiveSpecApplyConfiguration {
	for i := range values {
		b.AdditionalMetricNames = append(b.AdditionalMetricNames, values[i])
	}
	return b
}

// WithMetricStrategies adds the given value to the MetricStrategies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the MetricStrategies field.
func (b *ObjectiveSpecApplyConfiguration) WithMetricStrategies(values ...*MetricStrategyApplyConfiguration) *ObjectiveSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMetricStrategies")
		}
		b.MetricStrategies = append(b.MetricStrategies, *values[i])
	}
	return b
}
