/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1"
	v1 "k8s.io/api/core/v1"
)

// CollectorSpecApplyConfiguration represents an declarative configuration of the CollectorSpec type for use
// with apply.
type CollectorSpecApplyConfiguration struct {
	Kind            *v1beta1.CollectorKind `json:"kind,omitempty"`
	CustomCollector *v1.Container          `json:"customCollector,omitempty"`
}

// CollectorSpecApplyConfiguration constructs an declarative configuration of the CollectorSpec type for use with
// apply.
func CollectorSpec() *CollectorSpecApplyConfiguration {
	return &CollectorSpecApplyConfiguration{}
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *CollectorSpecApplyConfiguration) WithKind(value v1beta1.CollectorKind) *CollectorSpecApplyConfiguration {
	b.Kind = &value
	return b
}

// WithCustomCollector sets the CustomCollector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CustomCollector field is set to the value of the last call.
func (b *CollectorSpecApplyConfiguration) WithCustomCollector(value v1.Container) *CollectorSpecApplyConfiguration {
	b.CustomCollector = &value
	return b
}
