/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// AlgorithmSpecApplyConfiguration represents an declarative configuration of the AlgorithmSpec type for use
// with apply.
type AlgorithmSpecApplyConfiguration struct {
	AlgorithmName     *string                              `json:"algorithmName,omitempty"`
	AlgorithmSettings []AlgorithmSettingApplyConfiguration `json:"algorithmSettings,omitempty"`
}

// AlgorithmSpecApplyConfiguration constructs an declarative configuration of the AlgorithmSpec type for use with
// apply.
func AlgorithmSpec() *AlgorithmSpecApplyConfiguration {
	return &AlgorithmSpecApplyConfiguration{}
}

// WithAlgorithmName sets the AlgorithmName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AlgorithmName field is set to the value of the last call.
func (b *AlgorithmSpecApplyConfiguration) WithAlgorithmName(value string) *AlgorithmSpecApplyConfiguration {
	b.AlgorithmName = &value
	return b
}

// WithAlgorithmSettings adds the given value to the AlgorithmSettings field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AlgorithmSettings field.
func (b *AlgorithmSpecApplyConfiguration) WithAlgorithmSettings(values ...*AlgorithmSettingApplyConfiguration) *AlgorithmSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAlgorithmSettings")
		}
		b.AlgorithmSettings = append(b.AlgorithmSettings, *values[i])
	}
	return b
}
