//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2022 The Kubeflow Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1beta1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSetting":         schema_apis_controller_common_v1beta1_AlgorithmSetting(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSpec":            schema_apis_controller_common_v1beta1_AlgorithmSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.CollectorSpec":            schema_apis_controller_common_v1beta1_CollectorSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingRule":        schema_apis_controller_common_v1beta1_EarlyStoppingRule(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSetting":     schema_apis_controller_common_v1beta1_EarlyStoppingSetting(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSpec":        schema_apis_controller_common_v1beta1_EarlyStoppingSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FileSystemPath":           schema_apis_controller_common_v1beta1_FileSystemPath(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FilterSpec":               schema_apis_controller_common_v1beta1_FilterSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Metric":                   schema_apis_controller_common_v1beta1_Metric(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricStrategy":           schema_apis_controller_common_v1beta1_MetricStrategy(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricsCollectorSpec":     schema_apis_controller_common_v1beta1_MetricsCollectorSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ObjectiveSpec":            schema_apis_controller_common_v1beta1_ObjectiveSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Observation":              schema_apis_controller_common_v1beta1_Observation(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment":      schema_apis_controller_common_v1beta1_ParameterAssignment(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.SourceSpec":               schema_apis_controller_common_v1beta1_SourceSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ConfigMapSource":     schema_apis_controller_experiments_v1beta1_ConfigMapSource(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Experiment":          schema_apis_controller_experiments_v1beta1_Experiment(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentCondition": schema_apis_controller_experiments_v1beta1_ExperimentCondition(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentList":      schema_apis_controller_experiments_v1beta1_ExperimentList(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentSpec":      schema_apis_controller_experiments_v1beta1_ExperimentSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentStatus":    schema_apis_controller_experiments_v1beta1_ExperimentStatus(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.FeasibleSpace":       schema_apis_controller_experiments_v1beta1_FeasibleSpace(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.GraphConfig":         schema_apis_controller_experiments_v1beta1_GraphConfig(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.NasConfig":           schema_apis_controller_experiments_v1beta1_NasConfig(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Operation":           schema_apis_controller_experiments_v1beta1_Operation(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.OptimalTrial":        schema_apis_controller_experiments_v1beta1_OptimalTrial(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ParameterSpec":       schema_apis_controller_experiments_v1beta1_ParameterSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialParameterSpec":  schema_apis_controller_experiments_v1beta1_TrialParameterSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialSource":         schema_apis_controller_experiments_v1beta1_TrialSource(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialTemplate":       schema_apis_controller_experiments_v1beta1_TrialTemplate(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.Suggestion":          schema_apis_controller_suggestions_v1beta1_Suggestion(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionCondition": schema_apis_controller_suggestions_v1beta1_SuggestionCondition(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionList":      schema_apis_controller_suggestions_v1beta1_SuggestionList(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionSpec":      schema_apis_controller_suggestions_v1beta1_SuggestionSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionStatus":    schema_apis_controller_suggestions_v1beta1_SuggestionStatus(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.TrialAssignment":     schema_apis_controller_suggestions_v1beta1_TrialAssignment(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.Trial":                    schema_apis_controller_trials_v1beta1_Trial(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialCondition":           schema_apis_controller_trials_v1beta1_TrialCondition(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialList":                schema_apis_controller_trials_v1beta1_TrialList(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialSpec":                schema_apis_controller_trials_v1beta1_TrialSpec(ref),
		"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialStatus":              schema_apis_controller_trials_v1beta1_TrialStatus(ref),
	}
}

func schema_apis_controller_common_v1beta1_AlgorithmSetting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AlgorithmSetting represents key-value pair for HP or NAS algorithm settings.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is setting name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the setting value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_AlgorithmSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AlgorithmSpec is the specification for a HP or NAS algorithm.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"algorithmName": {
						SchemaProps: spec.SchemaProps{
							Description: "HP or NAS algorithm name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"algorithmSettings": {
						SchemaProps: spec.SchemaProps{
							Description: "Key-value pairs representing settings for suggestion algorithms.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSetting"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSetting"},
	}
}

func schema_apis_controller_common_v1beta1_CollectorSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"customCollector": {
						SchemaProps: spec.SchemaProps{
							Description: "When kind is \"customCollector\", this field will be used",
							Ref:         ref("k8s.io/api/core/v1.Container"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Container"},
	}
}

func schema_apis_controller_common_v1beta1_EarlyStoppingRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EarlyStoppingRule represents each rule for early stopping.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name contains metric name for the rule.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value contains metric value for the rule.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"comparison": {
						SchemaProps: spec.SchemaProps{
							Description: "Comparison defines correlation between name and value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startStep": {
						SchemaProps: spec.SchemaProps{
							Description: "StartStep defines quantity of intermediate results that should be received before applying the rule. If start step is empty, rule is applied from the first recorded metric.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_EarlyStoppingSetting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EarlyStoppingSetting represents key-value pair for early stopping algorithm settings.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the setting name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the setting value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_EarlyStoppingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EarlyStoppingSpec is the specification for a early stopping algorithm.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"algorithmName": {
						SchemaProps: spec.SchemaProps{
							Description: "Early stopping algorithm name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"algorithmSettings": {
						SchemaProps: spec.SchemaProps{
							Description: "Key-value pairs representing settings for early stopping algorithm.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSetting"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSetting"},
	}
}

func schema_apis_controller_common_v1beta1_FileSystemPath(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"format": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_FilterSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"metricsFormat": {
						SchemaProps: spec.SchemaProps{
							Description: "When the metrics output follows format as this field specified, metricsCollector collects it and reports to metrics server, it can be \"<metric_name>: <float>\" or else",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_Metric(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"min": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"latest": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_MetricStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_MetricsCollectorSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"source": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.SourceSpec"),
						},
					},
					"collector": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.CollectorSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.CollectorSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.SourceSpec"},
	}
}

func schema_apis_controller_common_v1beta1_ObjectiveSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectiveSpec represents Experiment's objective specification.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type for Experiment optimization.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"goal": {
						SchemaProps: spec.SchemaProps{
							Description: "Goal is the Experiment's objective goal that should be reached. In case of empty goal, Experiment is running until MaxTrialCount = TrialsSucceeded.",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"objectiveMetricName": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectiveMetricName represents primary Experiment's metric to optimize.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"additionalMetricNames": {
						SchemaProps: spec.SchemaProps{
							Description: "AdditionalMetricNames represents metrics that should be collected from Trials. This can be empty if we only care about the objective metric. Note: If we adopt a push instead of pull mechanism, this can be omitted completely.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"metricStrategies": {
						SchemaProps: spec.SchemaProps{
							Description: "MetricStrategies defines various rules (min, max or latest) to extract metrics values. This field is allowed to missing, experiment defaulter (webhook) will fill it.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricStrategy"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricStrategy"},
	}
}

func schema_apis_controller_common_v1beta1_Observation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"metrics": {
						SchemaProps: spec.SchemaProps{
							Description: "Key-value pairs for metric names and values",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Metric"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Metric"},
	}
}

func schema_apis_controller_common_v1beta1_ParameterAssignment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_common_v1beta1_SourceSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "Model-train source code can expose metrics by http, such as HTTP endpoint in prometheus metric format",
							Ref:         ref("k8s.io/api/core/v1.HTTPGetAction"),
						},
					},
					"fileSystemPath": {
						SchemaProps: spec.SchemaProps{
							Description: "During training model, metrics may be persisted into local file in source code, such as tfEvent use case",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FileSystemPath"),
						},
					},
					"filter": {
						SchemaProps: spec.SchemaProps{
							Description: "Default metric output format is {\"metric\": \"<metric_name>\", \"value\": <int_or_float>, \"epoch\": <int>, \"step\": <int>}, but if the output doesn't follow default format, please extend it here",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FilterSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FileSystemPath", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.FilterSpec", "k8s.io/api/core/v1.HTTPGetAction"},
	}
}

func schema_apis_controller_experiments_v1beta1_ConfigMapSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapSource references the config map where trial template is located",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMapName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of config map where trial template is located",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"configMapNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of config map where trial template is located",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"templatePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path in config map where trial template is located",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_experiments_v1beta1_Experiment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Structure of the Experiment custom resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentSpec", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_apis_controller_experiments_v1beta1_ExperimentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExperimentCondition describes the state of the experiment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of experiment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_apis_controller_experiments_v1beta1_ExperimentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExperimentList contains a list of Experiments",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Experiment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Experiment", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_apis_controller_experiments_v1beta1_ExperimentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExperimentSpec is the specification of an Experiment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"parameters": {
						SchemaProps: spec.SchemaProps{
							Description: "List of hyperparameter configurations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ParameterSpec"),
									},
								},
							},
						},
					},
					"objective": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the objective of the experiment.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ObjectiveSpec"),
						},
					},
					"algorithm": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the suggestion algorithm.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSpec"),
						},
					},
					"earlyStopping": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the early stopping algorithm.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSpec"),
						},
					},
					"trialTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "Template for each run of the trial.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialTemplate"),
						},
					},
					"parallelTrialCount": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials can be processed in parallel. Defaults to 3",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxTrialCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Max completed trials to mark experiment as succeeded",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxFailedTrialCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Max failed trials to mark experiment as failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metricsCollectorSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the specification of the metrics collector",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricsCollectorSpec"),
						},
					},
					"nasConfig": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.NasConfig"),
						},
					},
					"resumePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes resuming policy which usually take effect after experiment terminated. Default value is Never.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricsCollectorSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ObjectiveSpec", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.NasConfig", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ParameterSpec", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialTemplate"},
	}
}

func schema_apis_controller_experiments_v1beta1_ExperimentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExperimentStatus is the current status of an Experiment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Experiment was acknowledged by the Experiment controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Experiment was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastReconcileTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents last time when the Experiment was reconciled. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "List of observed runtime conditions for this Experiment.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentCondition"),
									},
								},
							},
						},
					},
					"currentOptimalTrial": {
						SchemaProps: spec.SchemaProps{
							Description: "Current optimal trial parameters and observations.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.OptimalTrial"),
						},
					},
					"runningTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which are running.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"pendingTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which are pending.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"failedTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which have already failed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"succeededTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which have already succeeded.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"killedTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which have been killed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"earlyStoppedTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which have been early stopped.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"metricsUnavailableTrialList": {
						SchemaProps: spec.SchemaProps{
							Description: "List of trial names which have been metrics unavailable",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"trials": {
						SchemaProps: spec.SchemaProps{
							Description: "Trials is the total number of trials owned by the experiment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsSucceeded": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials have succeeded.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsFailed": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials have failed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsKilled": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials have been killed.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsPending": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials are currently pending.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsRunning": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials are currently running.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialsEarlyStopped": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials are currently early stopped.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"trialMetricsUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "How many trials are currently metrics unavailable.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ExperimentCondition", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.OptimalTrial", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_apis_controller_experiments_v1beta1_FeasibleSpace(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"max": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"min": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"list": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"step": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"distribution": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_experiments_v1beta1_GraphConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GraphConfig contains a config of DAG",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"numLayers": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
					"inputSizes": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: 0,
										Type:    []string{"integer"},
										Format:  "int32",
									},
								},
							},
						},
					},
					"outputSizes": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: 0,
										Type:    []string{"integer"},
										Format:  "int32",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_experiments_v1beta1_NasConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NasConfig contains config for NAS job",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"graphConfig": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.GraphConfig"),
						},
					},
					"operations": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Operation"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.GraphConfig", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.Operation"},
	}
}

func schema_apis_controller_experiments_v1beta1_Operation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Operation contains type of operation in DAG",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"operationType": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"parameters": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ParameterSpec"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ParameterSpec"},
	}
}

func schema_apis_controller_experiments_v1beta1_OptimalTrial(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OptimalTrial is the metrics and assignments of the best trial.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bestTrialName": {
						SchemaProps: spec.SchemaProps{
							Description: "BestTrialName is the name of the best trial.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"parameterAssignments": {
						SchemaProps: spec.SchemaProps{
							Description: "Key-value pairs for hyperparameters and assignment values.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment"),
									},
								},
							},
						},
					},
					"observation": {
						SchemaProps: spec.SchemaProps{
							Description: "Observation for this trial",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Observation"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Observation", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment"},
	}
}

func schema_apis_controller_experiments_v1beta1_ParameterSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"parameterType": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"feasibleSpace": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.FeasibleSpace"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.FeasibleSpace"},
	}
}

func schema_apis_controller_experiments_v1beta1_TrialParameterSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialParameterSpec describes parameters that must be replaced in trial template",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the parameter that must be replaced in trial template",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description of the parameter",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reference": {
						SchemaProps: spec.SchemaProps{
							Description: "Reference to the parameter in search space",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_apis_controller_experiments_v1beta1_TrialSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialSource represent the source for trial template Only one source can be specified",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"trialSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "TrialSpec represents trial template in unstructured format",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap spec represents a reference to ConfigMap",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ConfigMapSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ConfigMapSource", "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"},
	}
}

func schema_apis_controller_experiments_v1beta1_TrialTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialTemplate describes structure of trial template",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"retain": {
						SchemaProps: spec.SchemaProps{
							Description: "Retain indicates that trial resources must be not cleanup",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"trialSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "TrialSpec represents trial template in unstructured format",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap spec represents a reference to ConfigMap",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ConfigMapSource"),
						},
					},
					"trialParameters": {
						SchemaProps: spec.SchemaProps{
							Description: "List of parameters that are used in trial template",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialParameterSpec"),
									},
								},
							},
						},
					},
					"primaryPodLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels that determines if pod needs to be injected by Katib sidecar container. If PrimaryPodLabels is omitted, metrics collector wraps all Trial's pods.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"primaryContainerName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of training container where actual model training is running",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"successCondition": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition when trial custom resource is succeeded. Condition must be in GJSON format, ref https://github.com/tidwall/gjson. For example for BatchJob: status.conditions.#(type==\"Complete\")#|#(status==\"True\")#",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureCondition": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition when trial custom resource is failed. Condition must be in GJSON format, ref https://github.com/tidwall/gjson. For example for BatchJob: status.conditions.#(type==\"Failed\")#|#(status==\"True\")#",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.ConfigMapSource", "github.com/kubeflow/katib/pkg/apis/controller/experiments/v1beta1.TrialParameterSpec", "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"},
	}
}

func schema_apis_controller_suggestions_v1beta1_Suggestion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Suggestion represents the structure of a Suggestion resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionSpec", "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_apis_controller_suggestions_v1beta1_SuggestionCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SuggestionCondition describes the state of the Suggestion at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of Suggestion condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_apis_controller_suggestions_v1beta1_SuggestionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SuggestionList contains a list of Suggestion",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.Suggestion"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.Suggestion", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_apis_controller_suggestions_v1beta1_SuggestionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SuggestionSpec is the specification of a Suggestion.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"algorithm": {
						SchemaProps: spec.SchemaProps{
							Description: "Algorithm describes HP or NAS algorithm that suggestion is used.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSpec"),
						},
					},
					"earlyStopping": {
						SchemaProps: spec.SchemaProps{
							Description: "EarlyStopping describes early stopping algorithm that suggestion is used.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSpec"),
						},
					},
					"requests": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of suggestions requested.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"resumePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "ResumePolicy describes resuming policy which usually take effect after experiment terminated. Default value is Never.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingSpec"},
	}
}

func schema_apis_controller_suggestions_v1beta1_SuggestionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SuggestionStatus is the current status of a Suggestion.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"algorithmSettings": {
						SchemaProps: spec.SchemaProps{
							Description: "AlgorithmSettings defines HP or NAS algorithm settings which suggestion gRPC service returns. These settings overwrites Experiment's settings before the gRPC request. It can be empty if settings haven't been changed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSetting"),
									},
								},
							},
						},
					},
					"suggestionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of suggestion results",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"suggestions": {
						SchemaProps: spec.SchemaProps{
							Description: "Suggestion results",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.TrialAssignment"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Suggestion was acknowledged by the Suggestion controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Suggestion was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastReconcileTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents last time when the Suggestion was reconciled. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "List of observed runtime conditions for this Suggestion.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.AlgorithmSetting", "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.SuggestionCondition", "github.com/kubeflow/katib/pkg/apis/controller/suggestions/v1beta1.TrialAssignment", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_apis_controller_suggestions_v1beta1_TrialAssignment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialAssignment is the assignment for one trial.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"parameterAssignments": {
						SchemaProps: spec.SchemaProps{
							Description: "Suggestion results with Trial parameters",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment"),
									},
								},
							},
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the suggestion",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"earlyStoppingRules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules for early stopping techniques Contains rule name, value and comparison type",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingRule"),
									},
								},
							},
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Suggestion label metadata to attach to Trial job",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingRule", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment"},
	}
}

func schema_apis_controller_trials_v1beta1_Trial(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the structure of a Trial resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialSpec", "github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_apis_controller_trials_v1beta1_TrialCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialCondition describes the state of the trial at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of trial condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_apis_controller_trials_v1beta1_TrialList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialList contains a list of Trials",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.Trial"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.Trial", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_apis_controller_trials_v1beta1_TrialSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialSpec is the specification of a Trial.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"objective": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the objective of the experiment.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ObjectiveSpec"),
						},
					},
					"parameterAssignments": {
						SchemaProps: spec.SchemaProps{
							Description: "Key-value pairs for hyperparameters and assignment values.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment"),
									},
								},
							},
						},
					},
					"earlyStoppingRules": {
						SchemaProps: spec.SchemaProps{
							Description: "Rules for early stopping techniques. Each rule should be met to early stop Trial.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingRule"),
									},
								},
							},
						},
					},
					"runSpec": {
						SchemaProps: spec.SchemaProps{
							Description: "Raw text for the trial run spec. This can be any generic Kubernetes runtime object. The trial operator should create the resource as written, and let the corresponding resource controller (e.g. Kubeflow Training Operator) handle the rest.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"),
						},
					},
					"retainRun": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether to retain the trial run object after completed.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"metricsCollector": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes how metrics will be collected",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricsCollectorSpec"),
						},
					},
					"primaryPodLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "Label that determines if pod needs to be injected by Katib sidecar container",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"primaryContainerName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of training container where actual model training is running",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"successCondition": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition when trial custom resource is succeeded. Condition must be in GJSON format, ref https://github.com/tidwall/gjson. For example for BatchJob: status.conditions.#(type==\"Complete\")#|#(status==\"True\")#",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failureCondition": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition when trial custom resource is failed. Condition must be in GJSON format, ref https://github.com/tidwall/gjson. For example for BatchJob: status.conditions.#(type==\"Failed\")#|#(status==\"True\")#",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels that provide additional metadata for services (e.g. Suggestions tracking)",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.EarlyStoppingRule", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.MetricsCollectorSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ObjectiveSpec", "github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.ParameterAssignment", "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured.Unstructured"},
	}
}

func schema_apis_controller_trials_v1beta1_TrialStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TrialStatus is the current status of a Trial.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Trial was acknowledged by the Trial controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the Trial was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastReconcileTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents last time when the Trial was reconciled. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "List of observed runtime conditions for this Trial.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialCondition"),
									},
								},
							},
						},
					},
					"observation": {
						SchemaProps: spec.SchemaProps{
							Description: "Results of the Trial - objectives and other metrics values.",
							Ref:         ref("github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Observation"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/katib/pkg/apis/controller/common/v1beta1.Observation", "github.com/kubeflow/katib/pkg/apis/controller/trials/v1beta1.TrialCondition", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}
