//*
// Katib GRPC API v1beta1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: api.proto

package api_v1_beta1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// *
// Types of value for HyperParameter.
type ParameterType int32

const (
	ParameterType_UNKNOWN_TYPE ParameterType = 0 /// Undefined type and not used.
	ParameterType_DOUBLE       ParameterType = 1 /// Double float type. Use "Max/Min".
	ParameterType_INT          ParameterType = 2 /// Int type. Use "Max/Min".
	ParameterType_DISCRETE     ParameterType = 3 /// Discrete number type. Use "List" as float.
	ParameterType_CATEGORICAL  ParameterType = 4 /// Categorical type. Use "List" as string.
)

// Enum value maps for ParameterType.
var (
	ParameterType_name = map[int32]string{
		0: "UNKNOWN_TYPE",
		1: "DOUBLE",
		2: "INT",
		3: "DISCRETE",
		4: "CATEGORICAL",
	}
	ParameterType_value = map[string]int32{
		"UNKNOWN_TYPE": 0,
		"DOUBLE":       1,
		"INT":          2,
		"DISCRETE":     3,
		"CATEGORICAL":  4,
	}
)

func (x ParameterType) Enum() *ParameterType {
	p := new(ParameterType)
	*p = x
	return p
}

func (x ParameterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[0].Descriptor()
}

func (ParameterType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[0]
}

func (x ParameterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterType.Descriptor instead.
func (ParameterType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{0}
}

// *
// Distribution types for HyperParameter.
type Distribution int32

const (
	Distribution_UNIFORM              Distribution = 0
	Distribution_LOG_UNIFORM          Distribution = 1
	Distribution_NORMAL               Distribution = 2
	Distribution_LOG_NORMAL           Distribution = 3
	Distribution_DISTRIBUTION_UNKNOWN Distribution = 4
)

// Enum value maps for Distribution.
var (
	Distribution_name = map[int32]string{
		0: "UNIFORM",
		1: "LOG_UNIFORM",
		2: "NORMAL",
		3: "LOG_NORMAL",
		4: "DISTRIBUTION_UNKNOWN",
	}
	Distribution_value = map[string]int32{
		"UNIFORM":              0,
		"LOG_UNIFORM":          1,
		"NORMAL":               2,
		"LOG_NORMAL":           3,
		"DISTRIBUTION_UNKNOWN": 4,
	}
)

func (x Distribution) Enum() *Distribution {
	p := new(Distribution)
	*p = x
	return p
}

func (x Distribution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Distribution) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[1].Descriptor()
}

func (Distribution) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[1]
}

func (x Distribution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Distribution.Descriptor instead.
func (Distribution) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1}
}

// *
// Direction of optimization. Minimize or Maximize.
type ObjectiveType int32

const (
	ObjectiveType_UNKNOWN  ObjectiveType = 0 /// Undefined type and not used.
	ObjectiveType_MINIMIZE ObjectiveType = 1 /// Minimize
	ObjectiveType_MAXIMIZE ObjectiveType = 2 /// Maximize
)

// Enum value maps for ObjectiveType.
var (
	ObjectiveType_name = map[int32]string{
		0: "UNKNOWN",
		1: "MINIMIZE",
		2: "MAXIMIZE",
	}
	ObjectiveType_value = map[string]int32{
		"UNKNOWN":  0,
		"MINIMIZE": 1,
		"MAXIMIZE": 2,
	}
)

func (x ObjectiveType) Enum() *ObjectiveType {
	p := new(ObjectiveType)
	*p = x
	return p
}

func (x ObjectiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ObjectiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[2].Descriptor()
}

func (ObjectiveType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[2]
}

func (x ObjectiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ObjectiveType.Descriptor instead.
func (ObjectiveType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{2}
}

type ComparisonType int32

const (
	ComparisonType_UNKNOWN_COMPARISON ComparisonType = 0 // Unknown comparison, not used
	ComparisonType_EQUAL              ComparisonType = 1 // Equal comparison, e.g. accuracy = 0.7
	ComparisonType_LESS               ComparisonType = 2 // Less comparison, e.g. accuracy < 0.7
	ComparisonType_GREATER            ComparisonType = 3 // Greater comparison, e.g. accuracy > 0.7
)

// Enum value maps for ComparisonType.
var (
	ComparisonType_name = map[int32]string{
		0: "UNKNOWN_COMPARISON",
		1: "EQUAL",
		2: "LESS",
		3: "GREATER",
	}
	ComparisonType_value = map[string]int32{
		"UNKNOWN_COMPARISON": 0,
		"EQUAL":              1,
		"LESS":               2,
		"GREATER":            3,
	}
)

func (x ComparisonType) Enum() *ComparisonType {
	p := new(ComparisonType)
	*p = x
	return p
}

func (x ComparisonType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComparisonType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[3].Descriptor()
}

func (ComparisonType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[3]
}

func (x ComparisonType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComparisonType.Descriptor instead.
func (ComparisonType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{3}
}

// Trial can be in one of 8 conditions.
// TODO (andreyvelich): Remove unused conditions.
type TrialStatus_TrialConditionType int32

const (
	TrialStatus_CREATED            TrialStatus_TrialConditionType = 0
	TrialStatus_RUNNING            TrialStatus_TrialConditionType = 1
	TrialStatus_SUCCEEDED          TrialStatus_TrialConditionType = 2
	TrialStatus_KILLED             TrialStatus_TrialConditionType = 3
	TrialStatus_FAILED             TrialStatus_TrialConditionType = 4
	TrialStatus_METRICSUNAVAILABLE TrialStatus_TrialConditionType = 5
	TrialStatus_EARLYSTOPPED       TrialStatus_TrialConditionType = 6
	TrialStatus_UNKNOWN            TrialStatus_TrialConditionType = 7
)

// Enum value maps for TrialStatus_TrialConditionType.
var (
	TrialStatus_TrialConditionType_name = map[int32]string{
		0: "CREATED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "KILLED",
		4: "FAILED",
		5: "METRICSUNAVAILABLE",
		6: "EARLYSTOPPED",
		7: "UNKNOWN",
	}
	TrialStatus_TrialConditionType_value = map[string]int32{
		"CREATED":            0,
		"RUNNING":            1,
		"SUCCEEDED":          2,
		"KILLED":             3,
		"FAILED":             4,
		"METRICSUNAVAILABLE": 5,
		"EARLYSTOPPED":       6,
		"UNKNOWN":            7,
	}
)

func (x TrialStatus_TrialConditionType) Enum() *TrialStatus_TrialConditionType {
	p := new(TrialStatus_TrialConditionType)
	*p = x
	return p
}

func (x TrialStatus_TrialConditionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrialStatus_TrialConditionType) Descriptor() protoreflect.EnumDescriptor {
	return file_api_proto_enumTypes[4].Descriptor()
}

func (TrialStatus_TrialConditionType) Type() protoreflect.EnumType {
	return &file_api_proto_enumTypes[4]
}

func (x TrialStatus_TrialConditionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrialStatus_TrialConditionType.Descriptor instead.
func (TrialStatus_TrialConditionType) EnumDescriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15, 0}
}

// *
// Structure for a single Experiment.
type Experiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"` // Name for the Experiment.
	Spec *ExperimentSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"` // Experiment specification.
}

func (x *Experiment) Reset() {
	*x = Experiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment) ProtoMessage() {}

func (x *Experiment) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment.ProtoReflect.Descriptor instead.
func (*Experiment) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{0}
}

func (x *Experiment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Experiment) GetSpec() *ExperimentSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// *
// Specification of an Experiment. Experiment represents a single optimization run over a feasible space.
// Each Experiment contains a configuration describing the feasible space, as well as a set of Trials.
// It is assumed that objective function f(x) does not change in the course of an Experiment.
type ExperimentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParameterSpecs     *ExperimentSpec_ParameterSpecs `protobuf:"bytes,1,opt,name=parameter_specs,json=parameterSpecs,proto3" json:"parameter_specs,omitempty"`
	Objective          *ObjectiveSpec                 `protobuf:"bytes,2,opt,name=objective,proto3" json:"objective,omitempty"`                                                // Objective specification for the Experiment.
	Algorithm          *AlgorithmSpec                 `protobuf:"bytes,3,opt,name=algorithm,proto3" json:"algorithm,omitempty"`                                                // HP or NAS algorithm specification for the Experiment.
	EarlyStopping      *EarlyStoppingSpec             `protobuf:"bytes,4,opt,name=early_stopping,json=earlyStopping,proto3" json:"early_stopping,omitempty"`                   // Early stopping specification for the Experiment.
	ParallelTrialCount int32                          `protobuf:"varint,5,opt,name=parallel_trial_count,json=parallelTrialCount,proto3" json:"parallel_trial_count,omitempty"` // How many Trials can be processed in parallel.
	MaxTrialCount      int32                          `protobuf:"varint,6,opt,name=max_trial_count,json=maxTrialCount,proto3" json:"max_trial_count,omitempty"`                // Max completed Trials to mark Experiment as succeeded.
	NasConfig          *NasConfig                     `protobuf:"bytes,7,opt,name=nas_config,json=nasConfig,proto3" json:"nas_config,omitempty"`                               // NAS configuration for the Experiment.
}

func (x *ExperimentSpec) Reset() {
	*x = ExperimentSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExperimentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExperimentSpec) ProtoMessage() {}

func (x *ExperimentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExperimentSpec.ProtoReflect.Descriptor instead.
func (*ExperimentSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1}
}

func (x *ExperimentSpec) GetParameterSpecs() *ExperimentSpec_ParameterSpecs {
	if x != nil {
		return x.ParameterSpecs
	}
	return nil
}

func (x *ExperimentSpec) GetObjective() *ObjectiveSpec {
	if x != nil {
		return x.Objective
	}
	return nil
}

func (x *ExperimentSpec) GetAlgorithm() *AlgorithmSpec {
	if x != nil {
		return x.Algorithm
	}
	return nil
}

func (x *ExperimentSpec) GetEarlyStopping() *EarlyStoppingSpec {
	if x != nil {
		return x.EarlyStopping
	}
	return nil
}

func (x *ExperimentSpec) GetParallelTrialCount() int32 {
	if x != nil {
		return x.ParallelTrialCount
	}
	return 0
}

func (x *ExperimentSpec) GetMaxTrialCount() int32 {
	if x != nil {
		return x.MaxTrialCount
	}
	return 0
}

func (x *ExperimentSpec) GetNasConfig() *NasConfig {
	if x != nil {
		return x.NasConfig
	}
	return nil
}

// *
// Config for a hyperparameter.
// Katib will create each Hyper parameter from this config.
type ParameterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name          string         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                                                         /// Name of the parameter.
	ParameterType ParameterType  `protobuf:"varint,2,opt,name=parameter_type,json=parameterType,proto3,enum=api.v1.beta1.ParameterType" json:"parameter_type,omitempty"` /// Type of the parameter.
	FeasibleSpace *FeasibleSpace `protobuf:"bytes,3,opt,name=feasible_space,json=feasibleSpace,proto3" json:"feasible_space,omitempty"`                                  /// FeasibleSpace for the parameter.
}

func (x *ParameterSpec) Reset() {
	*x = ParameterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParameterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterSpec) ProtoMessage() {}

func (x *ParameterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterSpec.ProtoReflect.Descriptor instead.
func (*ParameterSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{2}
}

func (x *ParameterSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParameterSpec) GetParameterType() ParameterType {
	if x != nil {
		return x.ParameterType
	}
	return ParameterType_UNKNOWN_TYPE
}

func (x *ParameterSpec) GetFeasibleSpace() *FeasibleSpace {
	if x != nil {
		return x.FeasibleSpace
	}
	return nil
}

// *
// Feasible space for optimization.
// Int and Double type use Max/Min.
// Discrete and Categorical type use List.
type FeasibleSpace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Max          string       `protobuf:"bytes,1,opt,name=max,proto3" json:"max,omitempty"`                                                   /// Max Value
	Min          string       `protobuf:"bytes,2,opt,name=min,proto3" json:"min,omitempty"`                                                   /// Minimum Value
	List         []string     `protobuf:"bytes,3,rep,name=list,proto3" json:"list,omitempty"`                                                 /// List of Values.
	Step         string       `protobuf:"bytes,4,opt,name=step,proto3" json:"step,omitempty"`                                                 /// Step for double or int parameter
	Distribution Distribution `protobuf:"varint,5,opt,name=distribution,proto3,enum=api.v1.beta1.Distribution" json:"distribution,omitempty"` // Distribution of the parameter.
}

func (x *FeasibleSpace) Reset() {
	*x = FeasibleSpace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeasibleSpace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeasibleSpace) ProtoMessage() {}

func (x *FeasibleSpace) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeasibleSpace.ProtoReflect.Descriptor instead.
func (*FeasibleSpace) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{3}
}

func (x *FeasibleSpace) GetMax() string {
	if x != nil {
		return x.Max
	}
	return ""
}

func (x *FeasibleSpace) GetMin() string {
	if x != nil {
		return x.Min
	}
	return ""
}

func (x *FeasibleSpace) GetList() []string {
	if x != nil {
		return x.List
	}
	return nil
}

func (x *FeasibleSpace) GetStep() string {
	if x != nil {
		return x.Step
	}
	return ""
}

func (x *FeasibleSpace) GetDistribution() Distribution {
	if x != nil {
		return x.Distribution
	}
	return Distribution_UNIFORM
}

// *
// Objective specification.
type ObjectiveSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                ObjectiveType `protobuf:"varint,1,opt,name=type,proto3,enum=api.v1.beta1.ObjectiveType" json:"type,omitempty"`                           // Type of optimization.
	Goal                float64       `protobuf:"fixed64,2,opt,name=goal,proto3" json:"goal,omitempty"`                                                          // Goal of optimization, can be empty.
	ObjectiveMetricName string        `protobuf:"bytes,3,opt,name=objective_metric_name,json=objectiveMetricName,proto3" json:"objective_metric_name,omitempty"` // Primary metric name for the optimization.
	// List of additional metrics to record from Trial.
	// This can be empty if we only care about the objective metric.
	AdditionalMetricNames []string `protobuf:"bytes,4,rep,name=additional_metric_names,json=additionalMetricNames,proto3" json:"additional_metric_names,omitempty"`
}

func (x *ObjectiveSpec) Reset() {
	*x = ObjectiveSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectiveSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectiveSpec) ProtoMessage() {}

func (x *ObjectiveSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectiveSpec.ProtoReflect.Descriptor instead.
func (*ObjectiveSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{4}
}

func (x *ObjectiveSpec) GetType() ObjectiveType {
	if x != nil {
		return x.Type
	}
	return ObjectiveType_UNKNOWN
}

func (x *ObjectiveSpec) GetGoal() float64 {
	if x != nil {
		return x.Goal
	}
	return 0
}

func (x *ObjectiveSpec) GetObjectiveMetricName() string {
	if x != nil {
		return x.ObjectiveMetricName
	}
	return ""
}

func (x *ObjectiveSpec) GetAdditionalMetricNames() []string {
	if x != nil {
		return x.AdditionalMetricNames
	}
	return nil
}

// *
// HP or NAS algorithm specification.
type AlgorithmSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AlgorithmName     string              `protobuf:"bytes,1,opt,name=algorithm_name,json=algorithmName,proto3" json:"algorithm_name,omitempty"`
	AlgorithmSettings []*AlgorithmSetting `protobuf:"bytes,2,rep,name=algorithm_settings,json=algorithmSettings,proto3" json:"algorithm_settings,omitempty"`
}

func (x *AlgorithmSpec) Reset() {
	*x = AlgorithmSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlgorithmSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlgorithmSpec) ProtoMessage() {}

func (x *AlgorithmSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlgorithmSpec.ProtoReflect.Descriptor instead.
func (*AlgorithmSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{5}
}

func (x *AlgorithmSpec) GetAlgorithmName() string {
	if x != nil {
		return x.AlgorithmName
	}
	return ""
}

func (x *AlgorithmSpec) GetAlgorithmSettings() []*AlgorithmSetting {
	if x != nil {
		return x.AlgorithmSettings
	}
	return nil
}

// *
// HP or NAS algorithm settings.
type AlgorithmSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AlgorithmSetting) Reset() {
	*x = AlgorithmSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlgorithmSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlgorithmSetting) ProtoMessage() {}

func (x *AlgorithmSetting) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlgorithmSetting.ProtoReflect.Descriptor instead.
func (*AlgorithmSetting) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{6}
}

func (x *AlgorithmSetting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlgorithmSetting) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// *
// Early stopping algorithm specification.
type EarlyStoppingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AlgorithmName     string                  `protobuf:"bytes,1,opt,name=algorithm_name,json=algorithmName,proto3" json:"algorithm_name,omitempty"`
	AlgorithmSettings []*EarlyStoppingSetting `protobuf:"bytes,2,rep,name=algorithm_settings,json=algorithmSettings,proto3" json:"algorithm_settings,omitempty"`
}

func (x *EarlyStoppingSpec) Reset() {
	*x = EarlyStoppingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EarlyStoppingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EarlyStoppingSpec) ProtoMessage() {}

func (x *EarlyStoppingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EarlyStoppingSpec.ProtoReflect.Descriptor instead.
func (*EarlyStoppingSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{7}
}

func (x *EarlyStoppingSpec) GetAlgorithmName() string {
	if x != nil {
		return x.AlgorithmName
	}
	return ""
}

func (x *EarlyStoppingSpec) GetAlgorithmSettings() []*EarlyStoppingSetting {
	if x != nil {
		return x.AlgorithmSettings
	}
	return nil
}

// *
// Early stopping algorithm settings.
type EarlyStoppingSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *EarlyStoppingSetting) Reset() {
	*x = EarlyStoppingSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EarlyStoppingSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EarlyStoppingSetting) ProtoMessage() {}

func (x *EarlyStoppingSetting) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EarlyStoppingSetting.ProtoReflect.Descriptor instead.
func (*EarlyStoppingSetting) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{8}
}

func (x *EarlyStoppingSetting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EarlyStoppingSetting) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// *
// NasConfig contains a config of NAS job
type NasConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GraphConfig *GraphConfig          `protobuf:"bytes,1,opt,name=graph_config,json=graphConfig,proto3" json:"graph_config,omitempty"` /// Config of DAG
	Operations  *NasConfig_Operations `protobuf:"bytes,2,opt,name=operations,proto3" json:"operations,omitempty"`                      /// List of Operation
}

func (x *NasConfig) Reset() {
	*x = NasConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NasConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasConfig) ProtoMessage() {}

func (x *NasConfig) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasConfig.ProtoReflect.Descriptor instead.
func (*NasConfig) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{9}
}

func (x *NasConfig) GetGraphConfig() *GraphConfig {
	if x != nil {
		return x.GraphConfig
	}
	return nil
}

func (x *NasConfig) GetOperations() *NasConfig_Operations {
	if x != nil {
		return x.Operations
	}
	return nil
}

// *
// GraphConfig contains a config of DAG
type GraphConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NumLayers   int32   `protobuf:"varint,1,opt,name=num_layers,json=numLayers,proto3" json:"num_layers,omitempty"`              /// Number of layers
	InputSizes  []int32 `protobuf:"varint,2,rep,packed,name=input_sizes,json=inputSizes,proto3" json:"input_sizes,omitempty"`    /// Dimensions of input size
	OutputSizes []int32 `protobuf:"varint,3,rep,packed,name=output_sizes,json=outputSizes,proto3" json:"output_sizes,omitempty"` /// Dimensions of output size
}

func (x *GraphConfig) Reset() {
	*x = GraphConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraphConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraphConfig) ProtoMessage() {}

func (x *GraphConfig) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraphConfig.ProtoReflect.Descriptor instead.
func (*GraphConfig) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{10}
}

func (x *GraphConfig) GetNumLayers() int32 {
	if x != nil {
		return x.NumLayers
	}
	return 0
}

func (x *GraphConfig) GetInputSizes() []int32 {
	if x != nil {
		return x.InputSizes
	}
	return nil
}

func (x *GraphConfig) GetOutputSizes() []int32 {
	if x != nil {
		return x.OutputSizes
	}
	return nil
}

// *
// Config for operations in DAG
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OperationType  string                    `protobuf:"bytes,1,opt,name=operation_type,json=operationType,proto3" json:"operation_type,omitempty"` /// Type of operation in DAG
	ParameterSpecs *Operation_ParameterSpecs `protobuf:"bytes,2,opt,name=parameter_specs,json=parameterSpecs,proto3" json:"parameter_specs,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{11}
}

func (x *Operation) GetOperationType() string {
	if x != nil {
		return x.OperationType
	}
	return ""
}

func (x *Operation) GetParameterSpecs() *Operation_ParameterSpecs {
	if x != nil {
		return x.ParameterSpecs
	}
	return nil
}

// *
// Structure for a single Trial.
type Trial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`     // Name for the Trial.
	Spec   *TrialSpec   `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`     // Trial specification.
	Status *TrialStatus `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"` // Trial status.
}

func (x *Trial) Reset() {
	*x = Trial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trial) ProtoMessage() {}

func (x *Trial) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trial.ProtoReflect.Descriptor instead.
func (*Trial) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{12}
}

func (x *Trial) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Trial) GetSpec() *TrialSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Trial) GetStatus() *TrialStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// *
// Specification of a Trial. It represents Trial's parameter assignments and objective.
type TrialSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Objective            *ObjectiveSpec                  `protobuf:"bytes,2,opt,name=objective,proto3" json:"objective,omitempty"`                                                                                   // Objective specification for the Trial.
	ParameterAssignments *TrialSpec_ParameterAssignments `protobuf:"bytes,3,opt,name=parameter_assignments,json=parameterAssignments,proto3" json:"parameter_assignments,omitempty"`                                 // List of assignments generated for the Trial.
	Labels               map[string]string               `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Map of labels assigned to the Trial
}

func (x *TrialSpec) Reset() {
	*x = TrialSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialSpec) ProtoMessage() {}

func (x *TrialSpec) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialSpec.ProtoReflect.Descriptor instead.
func (*TrialSpec) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13}
}

func (x *TrialSpec) GetObjective() *ObjectiveSpec {
	if x != nil {
		return x.Objective
	}
	return nil
}

func (x *TrialSpec) GetParameterAssignments() *TrialSpec_ParameterAssignments {
	if x != nil {
		return x.ParameterAssignments
	}
	return nil
}

func (x *TrialSpec) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type ParameterAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ParameterAssignment) Reset() {
	*x = ParameterAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParameterAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterAssignment) ProtoMessage() {}

func (x *ParameterAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterAssignment.ProtoReflect.Descriptor instead.
func (*ParameterAssignment) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{14}
}

func (x *ParameterAssignment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParameterAssignment) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// *
// Current Trial status. It contains Trial's latest condition, start time, completion time, observation.
type TrialStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartTime      string                         `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`                                  // Trial start time in RFC3339 format
	CompletionTime string                         `protobuf:"bytes,2,opt,name=completion_time,json=completionTime,proto3" json:"completion_time,omitempty"`                   // Trial completion time in RFC3339 format
	Condition      TrialStatus_TrialConditionType `protobuf:"varint,3,opt,name=condition,proto3,enum=api.v1.beta1.TrialStatus_TrialConditionType" json:"condition,omitempty"` // Trial current condition. It is equal to the latest Trial CR condition.
	Observation    *Observation                   `protobuf:"bytes,4,opt,name=observation,proto3" json:"observation,omitempty"`                                               // The best Trial observation in logs.
}

func (x *TrialStatus) Reset() {
	*x = TrialStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialStatus) ProtoMessage() {}

func (x *TrialStatus) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialStatus.ProtoReflect.Descriptor instead.
func (*TrialStatus) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{15}
}

func (x *TrialStatus) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *TrialStatus) GetCompletionTime() string {
	if x != nil {
		return x.CompletionTime
	}
	return ""
}

func (x *TrialStatus) GetCondition() TrialStatus_TrialConditionType {
	if x != nil {
		return x.Condition
	}
	return TrialStatus_CREATED
}

func (x *TrialStatus) GetObservation() *Observation {
	if x != nil {
		return x.Observation
	}
	return nil
}

type Observation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metrics []*Metric `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Observation) Reset() {
	*x = Observation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Observation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Observation) ProtoMessage() {}

func (x *Observation) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Observation.ProtoReflect.Descriptor instead.
func (*Observation) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{16}
}

func (x *Observation) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{17}
}

func (x *Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metric) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type ReportObservationLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrialName      string          `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
	ObservationLog *ObservationLog `protobuf:"bytes,2,opt,name=observation_log,json=observationLog,proto3" json:"observation_log,omitempty"`
}

func (x *ReportObservationLogRequest) Reset() {
	*x = ReportObservationLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportObservationLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportObservationLogRequest) ProtoMessage() {}

func (x *ReportObservationLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportObservationLogRequest.ProtoReflect.Descriptor instead.
func (*ReportObservationLogRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{18}
}

func (x *ReportObservationLogRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

func (x *ReportObservationLogRequest) GetObservationLog() *ObservationLog {
	if x != nil {
		return x.ObservationLog
	}
	return nil
}

type ReportObservationLogReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportObservationLogReply) Reset() {
	*x = ReportObservationLogReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportObservationLogReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportObservationLogReply) ProtoMessage() {}

func (x *ReportObservationLogReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportObservationLogReply.ProtoReflect.Descriptor instead.
func (*ReportObservationLogReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{19}
}

type ObservationLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MetricLogs []*MetricLog `protobuf:"bytes,1,rep,name=metric_logs,json=metricLogs,proto3" json:"metric_logs,omitempty"`
}

func (x *ObservationLog) Reset() {
	*x = ObservationLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObservationLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObservationLog) ProtoMessage() {}

func (x *ObservationLog) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObservationLog.ProtoReflect.Descriptor instead.
func (*ObservationLog) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{20}
}

func (x *ObservationLog) GetMetricLogs() []*MetricLog {
	if x != nil {
		return x.MetricLogs
	}
	return nil
}

type MetricLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimeStamp string  `protobuf:"bytes,1,opt,name=time_stamp,json=timeStamp,proto3" json:"time_stamp,omitempty"` /// RFC3339 format
	Metric    *Metric `protobuf:"bytes,2,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (x *MetricLog) Reset() {
	*x = MetricLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricLog) ProtoMessage() {}

func (x *MetricLog) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricLog.ProtoReflect.Descriptor instead.
func (*MetricLog) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{21}
}

func (x *MetricLog) GetTimeStamp() string {
	if x != nil {
		return x.TimeStamp
	}
	return ""
}

func (x *MetricLog) GetMetric() *Metric {
	if x != nil {
		return x.Metric
	}
	return nil
}

type GetObservationLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrialName  string `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
	MetricName string `protobuf:"bytes,2,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	StartTime  string `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"` ///The start of the time range. RFC3339 format
	EndTime    string `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`       ///The end of the time range. RFC3339 format
}

func (x *GetObservationLogRequest) Reset() {
	*x = GetObservationLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObservationLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObservationLogRequest) ProtoMessage() {}

func (x *GetObservationLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObservationLogRequest.ProtoReflect.Descriptor instead.
func (*GetObservationLogRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{22}
}

func (x *GetObservationLogRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

func (x *GetObservationLogRequest) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *GetObservationLogRequest) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *GetObservationLogRequest) GetEndTime() string {
	if x != nil {
		return x.EndTime
	}
	return ""
}

type GetObservationLogReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ObservationLog *ObservationLog `protobuf:"bytes,1,opt,name=observation_log,json=observationLog,proto3" json:"observation_log,omitempty"`
}

func (x *GetObservationLogReply) Reset() {
	*x = GetObservationLogReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObservationLogReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObservationLogReply) ProtoMessage() {}

func (x *GetObservationLogReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObservationLogReply.ProtoReflect.Descriptor instead.
func (*GetObservationLogReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{23}
}

func (x *GetObservationLogReply) GetObservationLog() *ObservationLog {
	if x != nil {
		return x.ObservationLog
	}
	return nil
}

type DeleteObservationLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrialName string `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
}

func (x *DeleteObservationLogRequest) Reset() {
	*x = DeleteObservationLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObservationLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObservationLogRequest) ProtoMessage() {}

func (x *DeleteObservationLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObservationLogRequest.ProtoReflect.Descriptor instead.
func (*DeleteObservationLogRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteObservationLogRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

type DeleteObservationLogReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteObservationLogReply) Reset() {
	*x = DeleteObservationLogReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObservationLogReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObservationLogReply) ProtoMessage() {}

func (x *DeleteObservationLogReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObservationLogReply.ProtoReflect.Descriptor instead.
func (*DeleteObservationLogReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{25}
}

type GetSuggestionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Experiment *Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	Trials     []*Trial    `protobuf:"bytes,2,rep,name=trials,proto3" json:"trials,omitempty"` // All completed trials owned by the experiment.
	// The number of Suggestions requested at one time.
	// When you set 3 to current_request_number, you get three Suggestions at one time.
	CurrentRequestNumber int32 `protobuf:"varint,4,opt,name=current_request_number,json=currentRequestNumber,proto3" json:"current_request_number,omitempty"`
	TotalRequestNumber   int32 `protobuf:"varint,5,opt,name=total_request_number,json=totalRequestNumber,proto3" json:"total_request_number,omitempty"` // The number of Suggestions requested till now.
}

func (x *GetSuggestionsRequest) Reset() {
	*x = GetSuggestionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSuggestionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSuggestionsRequest) ProtoMessage() {}

func (x *GetSuggestionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSuggestionsRequest.ProtoReflect.Descriptor instead.
func (*GetSuggestionsRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{26}
}

func (x *GetSuggestionsRequest) GetExperiment() *Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *GetSuggestionsRequest) GetTrials() []*Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *GetSuggestionsRequest) GetCurrentRequestNumber() int32 {
	if x != nil {
		return x.CurrentRequestNumber
	}
	return 0
}

func (x *GetSuggestionsRequest) GetTotalRequestNumber() int32 {
	if x != nil {
		return x.TotalRequestNumber
	}
	return 0
}

type GetSuggestionsReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParameterAssignments []*GetSuggestionsReply_ParameterAssignments `protobuf:"bytes,1,rep,name=parameter_assignments,json=parameterAssignments,proto3" json:"parameter_assignments,omitempty"`
	Algorithm            *AlgorithmSpec                              `protobuf:"bytes,2,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
	EarlyStoppingRules   []*EarlyStoppingRule                        `protobuf:"bytes,3,rep,name=early_stopping_rules,json=earlyStoppingRules,proto3" json:"early_stopping_rules,omitempty"`
}

func (x *GetSuggestionsReply) Reset() {
	*x = GetSuggestionsReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSuggestionsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSuggestionsReply) ProtoMessage() {}

func (x *GetSuggestionsReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSuggestionsReply.ProtoReflect.Descriptor instead.
func (*GetSuggestionsReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{27}
}

func (x *GetSuggestionsReply) GetParameterAssignments() []*GetSuggestionsReply_ParameterAssignments {
	if x != nil {
		return x.ParameterAssignments
	}
	return nil
}

func (x *GetSuggestionsReply) GetAlgorithm() *AlgorithmSpec {
	if x != nil {
		return x.Algorithm
	}
	return nil
}

func (x *GetSuggestionsReply) GetEarlyStoppingRules() []*EarlyStoppingRule {
	if x != nil {
		return x.EarlyStoppingRules
	}
	return nil
}

type ValidateAlgorithmSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Experiment *Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
}

func (x *ValidateAlgorithmSettingsRequest) Reset() {
	*x = ValidateAlgorithmSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateAlgorithmSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAlgorithmSettingsRequest) ProtoMessage() {}

func (x *ValidateAlgorithmSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAlgorithmSettingsRequest.ProtoReflect.Descriptor instead.
func (*ValidateAlgorithmSettingsRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{28}
}

func (x *ValidateAlgorithmSettingsRequest) GetExperiment() *Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

// *
// Return INVALID_ARGUMENT Error if Algorithm Settings are not Valid
type ValidateAlgorithmSettingsReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ValidateAlgorithmSettingsReply) Reset() {
	*x = ValidateAlgorithmSettingsReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateAlgorithmSettingsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAlgorithmSettingsReply) ProtoMessage() {}

func (x *ValidateAlgorithmSettingsReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAlgorithmSettingsReply.ProtoReflect.Descriptor instead.
func (*ValidateAlgorithmSettingsReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{29}
}

type GetEarlyStoppingRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Experiment       *Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	Trials           []*Trial    `protobuf:"bytes,2,rep,name=trials,proto3" json:"trials,omitempty"`
	DbManagerAddress string      `protobuf:"bytes,3,opt,name=db_manager_address,json=dbManagerAddress,proto3" json:"db_manager_address,omitempty"`
}

func (x *GetEarlyStoppingRulesRequest) Reset() {
	*x = GetEarlyStoppingRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEarlyStoppingRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEarlyStoppingRulesRequest) ProtoMessage() {}

func (x *GetEarlyStoppingRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEarlyStoppingRulesRequest.ProtoReflect.Descriptor instead.
func (*GetEarlyStoppingRulesRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{30}
}

func (x *GetEarlyStoppingRulesRequest) GetExperiment() *Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *GetEarlyStoppingRulesRequest) GetTrials() []*Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *GetEarlyStoppingRulesRequest) GetDbManagerAddress() string {
	if x != nil {
		return x.DbManagerAddress
	}
	return ""
}

type GetEarlyStoppingRulesReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EarlyStoppingRules []*EarlyStoppingRule `protobuf:"bytes,1,rep,name=early_stopping_rules,json=earlyStoppingRules,proto3" json:"early_stopping_rules,omitempty"`
}

func (x *GetEarlyStoppingRulesReply) Reset() {
	*x = GetEarlyStoppingRulesReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEarlyStoppingRulesReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEarlyStoppingRulesReply) ProtoMessage() {}

func (x *GetEarlyStoppingRulesReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEarlyStoppingRulesReply.ProtoReflect.Descriptor instead.
func (*GetEarlyStoppingRulesReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{31}
}

func (x *GetEarlyStoppingRulesReply) GetEarlyStoppingRules() []*EarlyStoppingRule {
	if x != nil {
		return x.EarlyStoppingRules
	}
	return nil
}

// *
// EarlyStoppingRule represents single early stopping rule.
type EarlyStoppingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name       string         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                               // Name of the rule. Usually, metric name.
	Value      string         `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`                                             // Value of the metric.
	Comparison ComparisonType `protobuf:"varint,3,opt,name=comparison,proto3,enum=api.v1.beta1.ComparisonType" json:"comparison,omitempty"` // Correlation between name and value, one of equal, less or greater
	// Defines quantity of intermediate results that should be received before applying the rule.
	// If start step is empty, rule is applied from the first recorded metric.
	StartStep int32 `protobuf:"varint,4,opt,name=start_step,json=startStep,proto3" json:"start_step,omitempty"`
}

func (x *EarlyStoppingRule) Reset() {
	*x = EarlyStoppingRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EarlyStoppingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EarlyStoppingRule) ProtoMessage() {}

func (x *EarlyStoppingRule) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EarlyStoppingRule.ProtoReflect.Descriptor instead.
func (*EarlyStoppingRule) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{32}
}

func (x *EarlyStoppingRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EarlyStoppingRule) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *EarlyStoppingRule) GetComparison() ComparisonType {
	if x != nil {
		return x.Comparison
	}
	return ComparisonType_UNKNOWN_COMPARISON
}

func (x *EarlyStoppingRule) GetStartStep() int32 {
	if x != nil {
		return x.StartStep
	}
	return 0
}

type ValidateEarlyStoppingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EarlyStopping *EarlyStoppingSpec `protobuf:"bytes,1,opt,name=early_stopping,json=earlyStopping,proto3" json:"early_stopping,omitempty"`
}

func (x *ValidateEarlyStoppingSettingsRequest) Reset() {
	*x = ValidateEarlyStoppingSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEarlyStoppingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEarlyStoppingSettingsRequest) ProtoMessage() {}

func (x *ValidateEarlyStoppingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEarlyStoppingSettingsRequest.ProtoReflect.Descriptor instead.
func (*ValidateEarlyStoppingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{33}
}

func (x *ValidateEarlyStoppingSettingsRequest) GetEarlyStopping() *EarlyStoppingSpec {
	if x != nil {
		return x.EarlyStopping
	}
	return nil
}

// *
// Return INVALID_ARGUMENT Error if Early Stopping Settings are not Valid
type ValidateEarlyStoppingSettingsReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ValidateEarlyStoppingSettingsReply) Reset() {
	*x = ValidateEarlyStoppingSettingsReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEarlyStoppingSettingsReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEarlyStoppingSettingsReply) ProtoMessage() {}

func (x *ValidateEarlyStoppingSettingsReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEarlyStoppingSettingsReply.ProtoReflect.Descriptor instead.
func (*ValidateEarlyStoppingSettingsReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{34}
}

type SetTrialStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrialName string `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
}

func (x *SetTrialStatusRequest) Reset() {
	*x = SetTrialStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetTrialStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTrialStatusRequest) ProtoMessage() {}

func (x *SetTrialStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTrialStatusRequest.ProtoReflect.Descriptor instead.
func (*SetTrialStatusRequest) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{35}
}

func (x *SetTrialStatusRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

type SetTrialStatusReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetTrialStatusReply) Reset() {
	*x = SetTrialStatusReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetTrialStatusReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTrialStatusReply) ProtoMessage() {}

func (x *SetTrialStatusReply) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTrialStatusReply.ProtoReflect.Descriptor instead.
func (*SetTrialStatusReply) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{36}
}

// *
// List of ParameterSpec.
type ExperimentSpec_ParameterSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Parameters []*ParameterSpec `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *ExperimentSpec_ParameterSpecs) Reset() {
	*x = ExperimentSpec_ParameterSpecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExperimentSpec_ParameterSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExperimentSpec_ParameterSpecs) ProtoMessage() {}

func (x *ExperimentSpec_ParameterSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExperimentSpec_ParameterSpecs.ProtoReflect.Descriptor instead.
func (*ExperimentSpec_ParameterSpecs) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ExperimentSpec_ParameterSpecs) GetParameters() []*ParameterSpec {
	if x != nil {
		return x.Parameters
	}
	return nil
}

type NasConfig_Operations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Operation []*Operation `protobuf:"bytes,1,rep,name=operation,proto3" json:"operation,omitempty"`
}

func (x *NasConfig_Operations) Reset() {
	*x = NasConfig_Operations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NasConfig_Operations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasConfig_Operations) ProtoMessage() {}

func (x *NasConfig_Operations) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasConfig_Operations.ProtoReflect.Descriptor instead.
func (*NasConfig_Operations) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{9, 0}
}

func (x *NasConfig_Operations) GetOperation() []*Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

// *
// List of ParameterSpec
type Operation_ParameterSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Parameters []*ParameterSpec `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *Operation_ParameterSpecs) Reset() {
	*x = Operation_ParameterSpecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation_ParameterSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation_ParameterSpecs) ProtoMessage() {}

func (x *Operation_ParameterSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation_ParameterSpecs.ProtoReflect.Descriptor instead.
func (*Operation_ParameterSpecs) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Operation_ParameterSpecs) GetParameters() []*ParameterSpec {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// *
// List of ParameterAssignment
type TrialSpec_ParameterAssignments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Assignments []*ParameterAssignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
}

func (x *TrialSpec_ParameterAssignments) Reset() {
	*x = TrialSpec_ParameterAssignments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialSpec_ParameterAssignments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialSpec_ParameterAssignments) ProtoMessage() {}

func (x *TrialSpec_ParameterAssignments) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialSpec_ParameterAssignments.ProtoReflect.Descriptor instead.
func (*TrialSpec_ParameterAssignments) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{13, 0}
}

func (x *TrialSpec_ParameterAssignments) GetAssignments() []*ParameterAssignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

type GetSuggestionsReply_ParameterAssignments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Assignments []*ParameterAssignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Optional field to override the trial name
	TrialName string `protobuf:"bytes,2,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
	// Optional field to add labels to the generated Trials
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GetSuggestionsReply_ParameterAssignments) Reset() {
	*x = GetSuggestionsReply_ParameterAssignments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_api_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSuggestionsReply_ParameterAssignments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSuggestionsReply_ParameterAssignments) ProtoMessage() {}

func (x *GetSuggestionsReply_ParameterAssignments) ProtoReflect() protoreflect.Message {
	mi := &file_api_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSuggestionsReply_ParameterAssignments.ProtoReflect.Descriptor instead.
func (*GetSuggestionsReply_ParameterAssignments) Descriptor() ([]byte, []int) {
	return file_api_proto_rawDescGZIP(), []int{27, 0}
}

func (x *GetSuggestionsReply_ParameterAssignments) GetAssignments() []*ParameterAssignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *GetSuggestionsReply_ParameterAssignments) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

func (x *GetSuggestionsReply_ParameterAssignments) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

var File_api_proto protoreflect.FileDescriptor

var file_api_proto_rawDesc = []byte{
	0x0a, 0x09, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x22, 0x52, 0x0a, 0x0a, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x85, 0x04,
	0x0a, 0x0e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x54, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x12, 0x39, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x46, 0x0a, 0x0e,
	0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c,
	0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x12, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6d, 0x61, 0x78, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36,
	0x0a, 0x0a, 0x6e, 0x61, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4e, 0x61, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6e, 0x61, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x4d, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xab, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x42, 0x0a, 0x0e, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x0d, 0x46, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x73, 0x74, 0x65, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x73, 0x74, 0x65,
	0x70, 0x12, 0x3e, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xc0, 0x01, 0x0a, 0x0d, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x2f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x12, 0x32, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x17,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x22, 0x85, 0x01, 0x0a, 0x0d, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a,
	0x12, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x11, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x3c, 0x0a, 0x10,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x11, 0x45,
	0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x12, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x11, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x40, 0x0a, 0x14, 0x45, 0x61,
	0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd2, 0x01, 0x0a,
	0x09, 0x4e, 0x61, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x0c, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x72, 0x61, 0x70, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x43, 0x0a, 0x0a,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x09, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x70, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x70, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x73, 0x22, 0xd2, 0x01, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x4d, 0x0a, 0x0e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x7b, 0x0a, 0x05, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x12, 0x31, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xfe, 0x02, 0x0a, 0x09, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x39, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x61,
	0x0a, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x14, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x3b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x5b,
	0x0a, 0x14, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3f, 0x0a, 0x13, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xed, 0x02, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4a, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x6f,
	0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x12, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x49, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x53, 0x55, 0x4e, 0x41, 0x56, 0x41,
	0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x41, 0x52, 0x4c,
	0x59, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x07, 0x22, 0x3d, 0x0a, 0x0b, 0x4f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x32, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1b, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67,
	0x52, 0x0e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67,
	0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x22, 0x4a, 0x0a,
	0x0e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x12,
	0x38, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x6f, 0x67, 0x52, 0x0a, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x6f, 0x67, 0x73, 0x22, 0x58, 0x0a, 0x09, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x4c, 0x6f, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2c, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x45, 0x0a, 0x0f, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x0e, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x22, 0x3c, 0x0a, 0x1b, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f,
	0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x22, 0xe6, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x38, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52,
	0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x30, 0x0a,
	0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22,
	0xa4, 0x04, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x6b, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x14,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12,
	0x51, 0x0a, 0x14, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x61, 0x72,
	0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x12,
	0x65, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x1a, 0x91, 0x02, 0x0a, 0x14, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x5a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5c, 0x0a, 0x20, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0x20, 0x0a, 0x1e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x22, 0xb3, 0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x45, 0x61,
	0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x2b, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x64, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x62, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x6f, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x51, 0x0a, 0x14, 0x65, 0x61,
	0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x12, 0x65, 0x61, 0x72, 0x6c, 0x79,
	0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x9a, 0x01,
	0x0a, 0x11, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3c, 0x0a,
	0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x53, 0x74, 0x65, 0x70, 0x22, 0x6e, 0x0a, 0x24, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x0e, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53,
	0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x65, 0x61, 0x72,
	0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x22, 0x24, 0x0a, 0x22, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x22, 0x36, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x2a,
	0x55, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x07,
	0x0a, 0x03, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x43, 0x52,
	0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52,
	0x49, 0x43, 0x41, 0x4c, 0x10, 0x04, 0x2a, 0x62, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x49, 0x46, 0x4f, 0x52,
	0x4d, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x4f, 0x47, 0x5f, 0x55, 0x4e, 0x49, 0x46, 0x4f,
	0x52, 0x4d, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x4f, 0x47, 0x5f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x03,
	0x12, 0x18, 0x0a, 0x14, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x04, 0x2a, 0x38, 0x0a, 0x0d, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x49, 0x4e, 0x49,
	0x4d, 0x49, 0x5a, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x49,
	0x5a, 0x45, 0x10, 0x02, 0x2a, 0x4a, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x45, 0x53,
	0x53, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x10, 0x03,
	0x32, 0xc6, 0x02, 0x0a, 0x09, 0x44, 0x42, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0x6a,
	0x0a, 0x14, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x12, 0x29, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x62, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x27, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x61, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x12,
	0x26, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x6a, 0x0a,
	0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x12, 0x29, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x32, 0xe1, 0x01, 0x0a, 0x0a, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x79, 0x0a, 0x19, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x2e, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x32, 0xe0, 0x02,
	0x0a, 0x0d, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12,
	0x6d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x2a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x61, 0x72, 0x6c, 0x79,
	0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x58,
	0x0a, 0x0e, 0x53, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x23, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x85, 0x01, 0x0a, 0x1d, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x42, 0x41, 0x5a, 0x3f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6b,
	0x75, 0x62, 0x65, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x6b, 0x61, 0x74, 0x69, 0x62, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x31, 0x5f, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_api_proto_rawDescOnce sync.Once
	file_api_proto_rawDescData = file_api_proto_rawDesc
)

func file_api_proto_rawDescGZIP() []byte {
	file_api_proto_rawDescOnce.Do(func() {
		file_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_api_proto_rawDescData)
	})
	return file_api_proto_rawDescData
}

var file_api_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_api_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_api_proto_goTypes = []interface{}{
	(ParameterType)(0),                               // 0: api.v1.beta1.ParameterType
	(Distribution)(0),                                // 1: api.v1.beta1.Distribution
	(ObjectiveType)(0),                               // 2: api.v1.beta1.ObjectiveType
	(ComparisonType)(0),                              // 3: api.v1.beta1.ComparisonType
	(TrialStatus_TrialConditionType)(0),              // 4: api.v1.beta1.TrialStatus.TrialConditionType
	(*Experiment)(nil),                               // 5: api.v1.beta1.Experiment
	(*ExperimentSpec)(nil),                           // 6: api.v1.beta1.ExperimentSpec
	(*ParameterSpec)(nil),                            // 7: api.v1.beta1.ParameterSpec
	(*FeasibleSpace)(nil),                            // 8: api.v1.beta1.FeasibleSpace
	(*ObjectiveSpec)(nil),                            // 9: api.v1.beta1.ObjectiveSpec
	(*AlgorithmSpec)(nil),                            // 10: api.v1.beta1.AlgorithmSpec
	(*AlgorithmSetting)(nil),                         // 11: api.v1.beta1.AlgorithmSetting
	(*EarlyStoppingSpec)(nil),                        // 12: api.v1.beta1.EarlyStoppingSpec
	(*EarlyStoppingSetting)(nil),                     // 13: api.v1.beta1.EarlyStoppingSetting
	(*NasConfig)(nil),                                // 14: api.v1.beta1.NasConfig
	(*GraphConfig)(nil),                              // 15: api.v1.beta1.GraphConfig
	(*Operation)(nil),                                // 16: api.v1.beta1.Operation
	(*Trial)(nil),                                    // 17: api.v1.beta1.Trial
	(*TrialSpec)(nil),                                // 18: api.v1.beta1.TrialSpec
	(*ParameterAssignment)(nil),                      // 19: api.v1.beta1.ParameterAssignment
	(*TrialStatus)(nil),                              // 20: api.v1.beta1.TrialStatus
	(*Observation)(nil),                              // 21: api.v1.beta1.Observation
	(*Metric)(nil),                                   // 22: api.v1.beta1.Metric
	(*ReportObservationLogRequest)(nil),              // 23: api.v1.beta1.ReportObservationLogRequest
	(*ReportObservationLogReply)(nil),                // 24: api.v1.beta1.ReportObservationLogReply
	(*ObservationLog)(nil),                           // 25: api.v1.beta1.ObservationLog
	(*MetricLog)(nil),                                // 26: api.v1.beta1.MetricLog
	(*GetObservationLogRequest)(nil),                 // 27: api.v1.beta1.GetObservationLogRequest
	(*GetObservationLogReply)(nil),                   // 28: api.v1.beta1.GetObservationLogReply
	(*DeleteObservationLogRequest)(nil),              // 29: api.v1.beta1.DeleteObservationLogRequest
	(*DeleteObservationLogReply)(nil),                // 30: api.v1.beta1.DeleteObservationLogReply
	(*GetSuggestionsRequest)(nil),                    // 31: api.v1.beta1.GetSuggestionsRequest
	(*GetSuggestionsReply)(nil),                      // 32: api.v1.beta1.GetSuggestionsReply
	(*ValidateAlgorithmSettingsRequest)(nil),         // 33: api.v1.beta1.ValidateAlgorithmSettingsRequest
	(*ValidateAlgorithmSettingsReply)(nil),           // 34: api.v1.beta1.ValidateAlgorithmSettingsReply
	(*GetEarlyStoppingRulesRequest)(nil),             // 35: api.v1.beta1.GetEarlyStoppingRulesRequest
	(*GetEarlyStoppingRulesReply)(nil),               // 36: api.v1.beta1.GetEarlyStoppingRulesReply
	(*EarlyStoppingRule)(nil),                        // 37: api.v1.beta1.EarlyStoppingRule
	(*ValidateEarlyStoppingSettingsRequest)(nil),     // 38: api.v1.beta1.ValidateEarlyStoppingSettingsRequest
	(*ValidateEarlyStoppingSettingsReply)(nil),       // 39: api.v1.beta1.ValidateEarlyStoppingSettingsReply
	(*SetTrialStatusRequest)(nil),                    // 40: api.v1.beta1.SetTrialStatusRequest
	(*SetTrialStatusReply)(nil),                      // 41: api.v1.beta1.SetTrialStatusReply
	(*ExperimentSpec_ParameterSpecs)(nil),            // 42: api.v1.beta1.ExperimentSpec.ParameterSpecs
	(*NasConfig_Operations)(nil),                     // 43: api.v1.beta1.NasConfig.Operations
	(*Operation_ParameterSpecs)(nil),                 // 44: api.v1.beta1.Operation.ParameterSpecs
	(*TrialSpec_ParameterAssignments)(nil),           // 45: api.v1.beta1.TrialSpec.ParameterAssignments
	nil,                                              // 46: api.v1.beta1.TrialSpec.LabelsEntry
	(*GetSuggestionsReply_ParameterAssignments)(nil), // 47: api.v1.beta1.GetSuggestionsReply.ParameterAssignments
	nil, // 48: api.v1.beta1.GetSuggestionsReply.ParameterAssignments.LabelsEntry
}
var file_api_proto_depIdxs = []int32{
	6,  // 0: api.v1.beta1.Experiment.spec:type_name -> api.v1.beta1.ExperimentSpec
	42, // 1: api.v1.beta1.ExperimentSpec.parameter_specs:type_name -> api.v1.beta1.ExperimentSpec.ParameterSpecs
	9,  // 2: api.v1.beta1.ExperimentSpec.objective:type_name -> api.v1.beta1.ObjectiveSpec
	10, // 3: api.v1.beta1.ExperimentSpec.algorithm:type_name -> api.v1.beta1.AlgorithmSpec
	12, // 4: api.v1.beta1.ExperimentSpec.early_stopping:type_name -> api.v1.beta1.EarlyStoppingSpec
	14, // 5: api.v1.beta1.ExperimentSpec.nas_config:type_name -> api.v1.beta1.NasConfig
	0,  // 6: api.v1.beta1.ParameterSpec.parameter_type:type_name -> api.v1.beta1.ParameterType
	8,  // 7: api.v1.beta1.ParameterSpec.feasible_space:type_name -> api.v1.beta1.FeasibleSpace
	1,  // 8: api.v1.beta1.FeasibleSpace.distribution:type_name -> api.v1.beta1.Distribution
	2,  // 9: api.v1.beta1.ObjectiveSpec.type:type_name -> api.v1.beta1.ObjectiveType
	11, // 10: api.v1.beta1.AlgorithmSpec.algorithm_settings:type_name -> api.v1.beta1.AlgorithmSetting
	13, // 11: api.v1.beta1.EarlyStoppingSpec.algorithm_settings:type_name -> api.v1.beta1.EarlyStoppingSetting
	15, // 12: api.v1.beta1.NasConfig.graph_config:type_name -> api.v1.beta1.GraphConfig
	43, // 13: api.v1.beta1.NasConfig.operations:type_name -> api.v1.beta1.NasConfig.Operations
	44, // 14: api.v1.beta1.Operation.parameter_specs:type_name -> api.v1.beta1.Operation.ParameterSpecs
	18, // 15: api.v1.beta1.Trial.spec:type_name -> api.v1.beta1.TrialSpec
	20, // 16: api.v1.beta1.Trial.status:type_name -> api.v1.beta1.TrialStatus
	9,  // 17: api.v1.beta1.TrialSpec.objective:type_name -> api.v1.beta1.ObjectiveSpec
	45, // 18: api.v1.beta1.TrialSpec.parameter_assignments:type_name -> api.v1.beta1.TrialSpec.ParameterAssignments
	46, // 19: api.v1.beta1.TrialSpec.labels:type_name -> api.v1.beta1.TrialSpec.LabelsEntry
	4,  // 20: api.v1.beta1.TrialStatus.condition:type_name -> api.v1.beta1.TrialStatus.TrialConditionType
	21, // 21: api.v1.beta1.TrialStatus.observation:type_name -> api.v1.beta1.Observation
	22, // 22: api.v1.beta1.Observation.metrics:type_name -> api.v1.beta1.Metric
	25, // 23: api.v1.beta1.ReportObservationLogRequest.observation_log:type_name -> api.v1.beta1.ObservationLog
	26, // 24: api.v1.beta1.ObservationLog.metric_logs:type_name -> api.v1.beta1.MetricLog
	22, // 25: api.v1.beta1.MetricLog.metric:type_name -> api.v1.beta1.Metric
	25, // 26: api.v1.beta1.GetObservationLogReply.observation_log:type_name -> api.v1.beta1.ObservationLog
	5,  // 27: api.v1.beta1.GetSuggestionsRequest.experiment:type_name -> api.v1.beta1.Experiment
	17, // 28: api.v1.beta1.GetSuggestionsRequest.trials:type_name -> api.v1.beta1.Trial
	47, // 29: api.v1.beta1.GetSuggestionsReply.parameter_assignments:type_name -> api.v1.beta1.GetSuggestionsReply.ParameterAssignments
	10, // 30: api.v1.beta1.GetSuggestionsReply.algorithm:type_name -> api.v1.beta1.AlgorithmSpec
	37, // 31: api.v1.beta1.GetSuggestionsReply.early_stopping_rules:type_name -> api.v1.beta1.EarlyStoppingRule
	5,  // 32: api.v1.beta1.ValidateAlgorithmSettingsRequest.experiment:type_name -> api.v1.beta1.Experiment
	5,  // 33: api.v1.beta1.GetEarlyStoppingRulesRequest.experiment:type_name -> api.v1.beta1.Experiment
	17, // 34: api.v1.beta1.GetEarlyStoppingRulesRequest.trials:type_name -> api.v1.beta1.Trial
	37, // 35: api.v1.beta1.GetEarlyStoppingRulesReply.early_stopping_rules:type_name -> api.v1.beta1.EarlyStoppingRule
	3,  // 36: api.v1.beta1.EarlyStoppingRule.comparison:type_name -> api.v1.beta1.ComparisonType
	12, // 37: api.v1.beta1.ValidateEarlyStoppingSettingsRequest.early_stopping:type_name -> api.v1.beta1.EarlyStoppingSpec
	7,  // 38: api.v1.beta1.ExperimentSpec.ParameterSpecs.parameters:type_name -> api.v1.beta1.ParameterSpec
	16, // 39: api.v1.beta1.NasConfig.Operations.operation:type_name -> api.v1.beta1.Operation
	7,  // 40: api.v1.beta1.Operation.ParameterSpecs.parameters:type_name -> api.v1.beta1.ParameterSpec
	19, // 41: api.v1.beta1.TrialSpec.ParameterAssignments.assignments:type_name -> api.v1.beta1.ParameterAssignment
	19, // 42: api.v1.beta1.GetSuggestionsReply.ParameterAssignments.assignments:type_name -> api.v1.beta1.ParameterAssignment
	48, // 43: api.v1.beta1.GetSuggestionsReply.ParameterAssignments.labels:type_name -> api.v1.beta1.GetSuggestionsReply.ParameterAssignments.LabelsEntry
	23, // 44: api.v1.beta1.DBManager.ReportObservationLog:input_type -> api.v1.beta1.ReportObservationLogRequest
	27, // 45: api.v1.beta1.DBManager.GetObservationLog:input_type -> api.v1.beta1.GetObservationLogRequest
	29, // 46: api.v1.beta1.DBManager.DeleteObservationLog:input_type -> api.v1.beta1.DeleteObservationLogRequest
	31, // 47: api.v1.beta1.Suggestion.GetSuggestions:input_type -> api.v1.beta1.GetSuggestionsRequest
	33, // 48: api.v1.beta1.Suggestion.ValidateAlgorithmSettings:input_type -> api.v1.beta1.ValidateAlgorithmSettingsRequest
	35, // 49: api.v1.beta1.EarlyStopping.GetEarlyStoppingRules:input_type -> api.v1.beta1.GetEarlyStoppingRulesRequest
	40, // 50: api.v1.beta1.EarlyStopping.SetTrialStatus:input_type -> api.v1.beta1.SetTrialStatusRequest
	38, // 51: api.v1.beta1.EarlyStopping.ValidateEarlyStoppingSettings:input_type -> api.v1.beta1.ValidateEarlyStoppingSettingsRequest
	24, // 52: api.v1.beta1.DBManager.ReportObservationLog:output_type -> api.v1.beta1.ReportObservationLogReply
	28, // 53: api.v1.beta1.DBManager.GetObservationLog:output_type -> api.v1.beta1.GetObservationLogReply
	30, // 54: api.v1.beta1.DBManager.DeleteObservationLog:output_type -> api.v1.beta1.DeleteObservationLogReply
	32, // 55: api.v1.beta1.Suggestion.GetSuggestions:output_type -> api.v1.beta1.GetSuggestionsReply
	34, // 56: api.v1.beta1.Suggestion.ValidateAlgorithmSettings:output_type -> api.v1.beta1.ValidateAlgorithmSettingsReply
	36, // 57: api.v1.beta1.EarlyStopping.GetEarlyStoppingRules:output_type -> api.v1.beta1.GetEarlyStoppingRulesReply
	41, // 58: api.v1.beta1.EarlyStopping.SetTrialStatus:output_type -> api.v1.beta1.SetTrialStatusReply
	39, // 59: api.v1.beta1.EarlyStopping.ValidateEarlyStoppingSettings:output_type -> api.v1.beta1.ValidateEarlyStoppingSettingsReply
	52, // [52:60] is the sub-list for method output_type
	44, // [44:52] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_api_proto_init() }
func file_api_proto_init() {
	if File_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Experiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExperimentSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParameterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeasibleSpace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectiveSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlgorithmSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlgorithmSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EarlyStoppingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EarlyStoppingSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NasConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraphConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParameterAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Observation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportObservationLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportObservationLogReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObservationLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObservationLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObservationLogReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteObservationLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteObservationLogReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSuggestionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSuggestionsReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateAlgorithmSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateAlgorithmSettingsReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEarlyStoppingRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEarlyStoppingRulesReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EarlyStoppingRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEarlyStoppingSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEarlyStoppingSettingsReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetTrialStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetTrialStatusReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExperimentSpec_ParameterSpecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NasConfig_Operations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation_ParameterSpecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialSpec_ParameterAssignments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_api_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSuggestionsReply_ParameterAssignments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_api_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_api_proto_goTypes,
		DependencyIndexes: file_api_proto_depIdxs,
		EnumInfos:         file_api_proto_enumTypes,
		MessageInfos:      file_api_proto_msgTypes,
	}.Build()
	File_api_proto = out.File
	file_api_proto_rawDesc = nil
	file_api_proto_goTypes = nil
	file_api_proto_depIdxs = nil
}
