# 🎯 [Improving Accuracy of LLM Applications](https://www.deeplearning.ai/short-courses/improving-accuracy-of-llm-applications/)

Welcome to the "Improving Accuracy of LLM Applications" course! 🚀 The course provides a systematic approach to enhance the accuracy and reliability of your LLM applications.

<p align="center">
<img src="images/l1_1.png" height="450"> 
</p>

## 📘 Course Summary
Many developers struggle with inconsistent results in LLM applications. 😓 This course is designed to address these challenges by offering hands-on experience in improving accuracy through evaluation, prompt engineering, self-reflection, and fine-tuning techniques.

**What You’ll Do:**
1. 🧠 **SQL Agent Development**: Build a text-to-SQL agent and simulate situations where it hallucinates to begin the evaluation process.
<p align="center">
<img src="images/l1_3.png" height="330"> 
<img src="images/l1_4.png" height="330"> 
</p>

2. 📊 **Evaluation Framework**: Create a robust framework to systematically measure performance, including criteria for good evaluations, best practices, and developing an evaluation score.
<p align="center">
<img src="images/l3_1.png" height="500"> 
</p>

3. 🎯 **Instruction Fine-tuning**: Learn how instruction fine-tuning helps LLMs follow instructions more accurately and how memory fine-tuning embeds facts to reduce hallucinations.
4. 🚀 **Performance-Efficient Fine-tuning (PEFT)**: Discover advanced techniques like Low-Rank Adaptation (LoRA) and Mixture of Memory Experts (MoME) to reduce training time while improving model performance.
5. 🔄 **Iterative Fine-tuning**: Go through an iterative process of generating training data, fine-tuning, and applying practical tips to increase model accuracy.

## 🔑 Key Points
- 🛠️ **Systematic Improvement**: Learn development steps, from evaluation, prompting, self-reflection, and fine-tuning, to improve your model’s reliability and accuracy.
- 🧠 **Memory Tuning**: Enhance your model's performance by embedding facts to reduce hallucinations.
- 🐑 **Llama Models**: Use the Llama 3-8b model to build an LLM application that converts text to SQL with a custom schema.

## 👩‍🏫 About the Instructors
- 👩‍💼 **Sharon Zhou**: Co-Founder and CEO of Lamini, Sharon brings her expertise in LLM development and fine-tuning.
- 👨‍💼 **Amit Sangani**: Senior Director of Partner Engineering at Meta, Amit shares valuable insights on engineering reliable LLM applications.

🔗 To enroll in the course or for further information, visit 📚 [deeplearning.ai](https://www.deeplearning.ai/short-courses/).
