---
id: simple_extensions
title: Simple Extensions
slug: simple-extensions.html
sidebar_label: Simple Extensions
---

This table lists the most basic extensions, that cover test and spec lifecycle events, and are mostly equivalent to lifecycle hooks. For more advanced extensions that can be used to modify the way the Engine runs, see [advanced extensions](advanced.md).

| Extension                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|--------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| BeforeContainerListener  | Invoked directly before each test with type `TestType.Container` is executed. If the test is marked as ignored / disabled / inactive, then this callback won't be invoked.                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| AfterContainerListener   | Invoked immediately after a `TestCase` with type `TestType.Container` has finished. If a test case was skipped (ignored / disabled / inactive) then this callback will not be invoked for that particular test case.<br/><br/>The callback will execute even if the test fails.                                                                                                                                                                                                                                                                                                                             |
| BeforeEachListener       | Invoked directly before each test with type `TestType.Test` is executed. If the test is marked as ignored / disabled / inactive, then this callback won't be invoked.                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| AfterEachListener        | Invoked immediately after a `TestCase` with type `TestType.Test` has finished, with the `TestResult` of that test. If a test case was skipped (ignored / disabled / inactive) then this callback will not be invoked for that particular test case.<br/><br/>The callback will execute even if the test fails.                                                                                                                                                                                                                                                                                              |
| BeforeTestListener       | Invoked directly before each test is executed with the `TestCase` instance as a parameter. If the test is marked as ignored / disabled / inactive, then this callback won't be invoked.                                                                                                                                                                                                                                                                                                                                                                                                                     |
| AfterTestListener        | Invoked immediately after a `TestCase` has finished with the `TestResult` of that test. If a test case was skipped (ignored / disabled / inactive) then this callback will not be invoked for that particular test case.<br/><br/>The callback will execute even if the test fails.                                                                                                                                                                                                                                                                                                                         |
| BeforeInvocationListener | Invoked before each 'run' of a test, with a flag indicating the iteration number. If you are running a test with the default single invocation then this callback is effectively the same as `beforeTest`.<br/><br/>_Note: If you have multiple invocations and multiple threads, then this callback will be invoked concurrently._                                                                                                                                                                                                                                                                         |
| AfterInvocationListener  | Invoked after each 'run' of a test, with a flag indicating the iteration number. If you are running a test with the default single invocation then this callback is effectively the same as `afterTest`.<br/><br/>_Note: If you have multiple invocations and multiple threads, then this callback will be invoked concurrently._                                                                                                                                                                                                                                                                           |
| BeforeSpecListener       | Invoked after the Engine instantiates a spec to be used as part of a test execution. If a spec is instantiated multiple times - for example, if `InstancePerTest` or `InstancePerLeaf` isolation modes are used, then this callback will be invoked for each instance created.<br/><br/>This callback can be used to perform setup each time a new spec instance is created. To perform setup once per class, then use `PrepareSpecListener`.<br/><br/>This listener is invoked before any test lifecycle events.                                                                                           |
| AfterSpecListener        | Is invoked after the `TestCase`s that are part of a particular spec instance have completed.<br/><br/>If a spec is instantiated multiple times - for example, if `InstancePerTest` or `InstancePerLeaf` isolation modes are used, then this callback will be invoked for each instantiated spec, after the tests that are applicable to that spec instance have returned.<br/><br/>This callback can be used to perform cleanup after each individual spec instance. To perform cleanup once per class, then use `FinalizeSpecListener.`<br/><br/>This listener is invoked after all test lifecycle events. |
| PrepareSpecListener      | Called once per spec, when the engine is preparing to execute the tests for that spec.<br/><br/>Regardless of how many times the spec is instantiated, for example, if `InstancePerTest` or `InstancePerLeaf` isolation modes are used, this callback will only be invoked once. If the spec is skipped then this callback will **not** be invoked.                                                                                                                                                                                                                                                         |
| FinalizeSpecListener     | Called once per `Spec`, after all tests have completed for that spec.<br/><br/>Regardless of how many times the spec is instantiated, for example, if `InstancePerTest` or `InstancePerLeaf` isolation modes are used, this callback will only be invoked once. If the spec is skipped then this callback will **not** be invoked.                                                                                                                                                                                                                                                                          |
| BeforeProjectListener    | Is invoked before any specs are created.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| AfterProjectListener     | Is invoked once all tests and specs have completed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |

