---
id: index
title: Extensions
slug: extensions.html
sidebar_label: Introduction
---

Kotest integrates with many other libraries and frameworks. Some are provided by the Kotest team, and others are
maintained and hosted by third parties.

### Kotest Team Extensions

| Project | Description |
| ------- | ----------- |
| [Spring](spring.md) | Adds support for spring beans in tests and spring test annotations |
| [Ktor](ktor.md) | Provides matchers for Ktor endpoints |
| [Koin](koin.md) | Kotlin DI framework |
| [Mockserver](mockserver.md) | Integrate mockserver HTTP servers with the test lifecycle |
| [System](system.md) | Provides utilities for integrating with System.* functions |
| [Instant](instant.md) | Override the 'now' context in java.time |
| [Testcontainers](test_containers.md) | Run docker images as part of a test lifecycle |
| [Wiremock](wiremock.md) | Provides a mock HTTP server. Project homepage [here](http://wiremock.org/). |
| [Roboelectric](roboelectric.md) | Integrate roboelectric with the test lifecycle |
| [Allure](allure.md) | Provides output for the allure framework |
| [JUnit XML](junit_xml.md) | Provides output in the JUnit XML format for integration with reporting tools |
| [HTML Reporter](html_reporter.md) | Generates HTML reports of test results based on [JUnit XML](junit_xml.md) |

### Third Party Extensions

| Project | Description |
| ------- | ----------- |
| [Http4k](https://www.http4k.org/guide/reference/kotest/) | Functional toolkit for Kotlin HTTP applications |
| [Micronaut](https://github.com/micronaut-projects/micronaut-test) | JVM-based, full-stack framework for building modular, easily testable microservice |
| [Sniffy](https://www.sniffy.io/docs/latest/#_integration_with_kotest) | Network connectivity testing |
| [TestFiles](https://github.com/jGleitz/testfiles) | Creates organized files and directories for testing |
| [Result4s](https://github.com/MrBergin/result4k-kotest-matchers) | Result4s matchers|
| [Kotless](https://github.com/LeoColman/kotest-kotless) | Utilties for kotless and kotest |
| [LogCapture](https://github.com/jsalinaspolo/logcapture) | LogCapture is a testing library for asserting logging messages |
| [KotlinFixture](https://github.com/appmattus/kotlinfixture/blob/main/fixture-kotest/README.adoc) | generate well-defined, but essentially random, input |
| [Fluentlenium](https://fluentlenium.io/docs/test-runners/#kotest) | FluentLenium integration with Kotest |
