module.exports = {
  "docs": [
    "quickstart",
    "blogs"
  ],
  "proptest": [
    "proptest/index",
    "proptest/testfunctions",
    "proptest/gens",
    "proptest/genslist",
    "proptest/genops",
    "proptest/assumptions",
    "proptest/seeds",
    "proptest/proptestconfig",
    "proptest/customgens",
    "proptest/shrinking",
    "proptest/statistics",
    "proptest/globalconfig",
    "proptest/arrow",
    "proptest/date_gens",
    "proptest/extra_arbs",
    "proptest/reflective_arbs"
  ],
  "intellij": [
    "intellij/index",
    "intellij/test_explorer",
    "intellij/props"
  ],
  "extensions": [
    "extensions/index",
    "extensions/spring",
    "extensions/ktor",
    "extensions/system_extensions",
    "extensions/test_containers",
    "extensions/kafka",
    "extensions/mockserver",
    "extensions/junit_xml",
    "extensions/html_reporter",
    "extensions/allure",
    "extensions/instant",
    "extensions/koin",
    "extensions/wiremock",
    "extensions/clock",
    "extensions/pitest",
    "extensions/blockhound"
  ],
  "assertions": [
    "assertions/index",
    "assertions/matchers",
    "assertions/custom_matchers",
    "assertions/composed_matchers",
    "assertions/exceptions",
    "assertions/similarity",
    "assertions/clues",
    "assertions/soft_assertions",
    {
      "type": "category",
      "label": "Non-deterministic Testing",
      "collapsed": false,
      "items": [
        "assertions/eventually",
        "assertions/continually",
        "assertions/until",
        "assertions/retry"
      ]
    },
    "assertions/inspectors",
    "assertions/assertion_mode",
    {
      "type": "category",
      "label": "Matcher Modules",
      "collapsed": false,
      "items": [
        "assertions/core",
        {
          "type": "category",
          "label": "JSON",
          "collapsed": true,
          "link": {
            "type": "doc",
            "id": "assertions/json/overview"
          },
          "items": [
            "assertions/json/overview",
            "assertions/json/content",
            "assertions/json/schema"
          ]
        },
        "assertions/ktor",
        "assertions/kotlinx_datetime",
        "assertions/arrow",
        "assertions/sql-matchers",
        "assertions/konform",
        "assertions/klock",
        "assertions/compiler",
        "assertions/field-matching",
        "assertions/jsoup",
        "assertions/ranges",
        "assertions/yaml"
      ]
    }
  ],
  "framework": [
    "framework/index",
    "framework/setup",
    "framework/writing_tests",
    "framework/styles",
    {
      "type": "category",
      "label": "Conditional Evaluation",
      "collapsed": true,
      "items": [
        "framework/conditional/enabled_config_flags",
        "framework/conditional/focus_and_bang",
        "framework/conditional/xmethods",
        "framework/conditional/annotations",
        "framework/conditional/gradle"
      ]
    },
    "framework/isolation_mode",
    "framework/lifecycle_hooks",
    {
      "type": "category",
      "label": "Extensions",
      "collapsed": true,
      "items": [
        "framework/extensions/extensions_introduction",
        "framework/extensions/simple_extensions",
        "framework/extensions/advanced_extensions",
        "framework/extensions/extension_examples"
      ]
    },
    {
      "type": "category",
      "label": "Coroutines",
      "collapsed": true,
      "items": [
        "framework/coroutines/test_coroutine_dispatcher",
        "framework/coroutines/coroutine_debugging"
      ]
    },
    "framework/exceptions",
    {
      "type": "category",
      "label": "Data Driven Testing",
      "collapsed": true,
      "items": [
        "framework/datatesting/introduction",
        "framework/datatesting/test_names",
        "framework/datatesting/nested"
      ]
    },
    {
      "type": "category",
      "label": "Non-deterministic Testing",
      "collapsed": true,
      "items": [
        "assertions/eventually",
        "assertions/continually",
        "assertions/until",
        "assertions/retry"
      ]
    },
    {
      "type": "category",
      "label": "Integrations",
      "collapsed": true,
      "items": [
        "framework/integrations/mocks",
        "framework/integrations/jacoco"
      ]
    },
    {
      "type": "category",
      "label": "Ordering",
      "collapsed": true,
      "items": [
        "framework/spec_ordering",
        "framework/test_ordering"
      ]
    },
    "framework/tags",
    {
      "type": "category",
      "label": "Resources",
      "collapsed": true,
      "items": [
        "framework/autoclose",
        "framework/tempfile"
      ]
    },
    {
      "type": "category",
      "label": "Configuration",
      "collapsed": true,
      "items": [
        "framework/test_case_config",
        "framework/project_config",
        "framework/framework_config_props"
      ]
    },
    "framework/test_factories",
    "framework/fake_functions",
    "framework/test_output",
    {
      "type": "category",
      "label": "Timeouts",
      "collapsed": true,
      "items": [
        "framework/timeouts/test_timeouts",
        "framework/timeouts/project_timeout",
        "framework/timeouts/blocking_tests"
      ]
    },
    {
      "type": "category",
      "label": "Other settings",
      "collapsed": true,
      "items": [
        "framework/fail_fast",
        "framework/fail_on_empty",
        "framework/config_dump"
      ]
    }
  ]
};
