module.exports = {
   title: 'Kotest',
   tagline: 'Flexible and elegant multiplatform test framework, assertions, and property test library for Kotlin',
   url: 'https://kotest.io',
   baseUrl: '/',
   onBrokenLinks: 'throw',
   onBrokenMarkdownLinks: 'throw',
   favicon: 'img/favicon.ico',
   organizationName: 'kotest', // Usually your GitHub org/user name.
   projectName: 'kotest.io', // Usually your repo name.
   themeConfig: {
      algolia: {
         // The application ID provided by Algolia
         appId: 'UGZ6V0USY6',

         // Public API key: it is safe to commit it
         apiKey: 'f170b39d801f28d7bf2deb2a4a731908',

         indexName: 'kotest',

         // Contextual search is enabled by default.
         // It ensures that search results are relevant to the current language and version.
         // contextualSearch: true,

         // Optional: Specify domains where the navigation should occur through window.location instead on history.push. Useful when our Algolia config crawls multiple documentation sites and we want to navigate with window.location.href to them.
         // externalUrlRegex: 'external\\.com|domain\\.com',

         // Optional: Algolia search parameters
         searchParameters: {},

         // Optional: path for search page that enabled by default (`false` to disable it)
         searchPagePath: 'search',

         //... other Algolia params
      },
      navbar: {
         title: 'Kotest',
         logo: {
            alt: 'Kotest',
            src: 'img/logo.png',
         },
         items: [
            {
               type: 'doc',
               docId: 'quickstart',
               label: 'Overview',
               position: 'left'
            },
            {
               type: 'doc',
               docId: 'framework/index',
               label: 'Framework',
               position: 'left'
            },
            {
               type: 'doc',
               docId: 'extensions/index',
               label: 'Extensions',
               position: 'left'
            },
            {
               type: 'doc',
               docId: 'assertions/index',
               label: 'Assertions',
               position: 'left'
            },
            {
               type: 'doc',
               docId: 'proptest/index',
               label: 'Property Testing',
               position: 'left'
            },
            {
               type: 'doc',
               docId: 'intellij/index',
               label: 'Intellij Plugin',
               position: 'left'
            },
            {
               type:'search',
               position: 'right'
            },
            {
               type: 'docsVersionDropdown',
               position: 'right',
               dropdownActiveClassDisabled: true,
            },
            {
               href: 'https://github.com/kotest/kotest',
               className: 'header-github-link',
               'aria-label': 'GitHub repository',
               position: 'right',
            },
         ],
      },
      footer: {
         style: 'dark',
         links: [
            {
               title: 'Community',
               items: [
                  {
                     label: 'Slack',
                     href: 'https://kotlinlang.slack.com/archives/CT0G9SD7Z',
                  },
                  {
                     label: 'Github',
                     href: 'https://github.com/kotest/kotest',
                  },
                  {
                     label: 'Stack Overflow',
                     href: 'https://stackoverflow.com/questions/tagged/kotest',
                  },
               ],
            },
            {
               title: 'Updates',
               items: [
                  {
                     label: 'Changelog',
                     href: 'https://github.com/kotest/kotest/releases',
                  },
                  {
                     label: 'Releases',
                     href: 'https://github.com/kotest/kotest/releases',
                  },
                  {
                     label: 'Blogs and articles',
                     href: 'https://kotest.io/docs/next/blogs',
                  },
               ],
            },
         ],
         copyright: `Copyright © ${new Date().getFullYear()} Kotest Team. Built with Docusaurus.`,
      },
      prism: {
         additionalLanguages: ['kotlin', 'groovy'],
         theme: require('prism-react-renderer/themes/github'),
         darkTheme: require('prism-react-renderer/themes/dracula'),
      },
   },
   presets: [
      [
         '@docusaurus/preset-classic',
         {
            theme: {
               customCss: [require.resolve('./src/css/custom.css')],
            },
            googleAnalytics: {
               trackingID: 'UA-177425497-1',
               // Optional fields.
               anonymizeIP: true, // Should IPs be anonymized?
            },
            docs: {
               versions: {
                  current: {
                     label: `5.9 🚧`,
                  },
               },
               sidebarPath: require.resolve('./sidebars.js'),
               editUrl: 'https://github.com/kotest/kotest/blob/master/documentation',
            }
         },
      ],
   ],
   plugins: [
      [
         '@docusaurus/plugin-client-redirects',
         {
            redirects: [
               {
                  to: '/docs/quickstart',
                  from: ['/quick_start'],
               },
               {
                  to: '/docs/assertions/clues.html',
                  from: ['/clues'],
               },
               {
                  to: '/docs/framework/testing-styles.html',
                  from: ['/styles'],
               },
            ],
         },
      ],
   ]
};
