<?php

namespace demo\apexcharts;

use \koolreport\dashboard\widgets\apexcharts\CandleStickChart;
use \koolreport\dashboard\fields\Text;
use \koolreport\dashboard\fields\Currency;
use \koolreport\dashboard\ColorList;

use  \demo\AutoMaker;

class CandleStickChartDemo extends CandleStickChart
{
    protected function onInit()
    {
        $this
        ->settings([
            "title" => "CandleStick Chart",
            "columns" => array(
                'datetime' => [
                    "categoryType" => "datetime",
                ],
                'candlestick' => [
                    'combination' => [
                        'open',
                        'high',
                        'low',
                        'close',
                    ]
                ]
            ),
            "options" => [
                'yaxis | tooltip | enabled' => true,
            ],
            "showLegend" => false,
        ])
        ->colorScheme(ColorList::random())
        ;
    }

    protected function dataSource()
    {
        return [
            [
                'datetime',
                'open',
                'high',
                'low',
                'close',
            ],
            [
                "2018/10/6 05:30:00",
                6629.81,
                6650.5,
                6623.04,
                6633.33
            ],
            [
                "2018/10/6 06:00:00",
                6632.01,
                6643.59,
                6620,
                6630.11
            ],
            [
                "2018/10/6 06:30:00",
                6630.71,
                6648.95,
                6623.34,
                6635.65
            ],
            [
                "2018/10/6 07:00:00",
                6635.65,
                6651,
                6629.67,
                6638.24
            ],
            [
                "2018/10/6 07:30:00",
                6638.24,
                6640,
                6620,
                6624.47
            ],
            [
                "2018/10/6 08:00:00",
                6624.53,
                6636.03,
                6621.68,
                6624.31
            ],
            [
                "2018/10/6 08:30:00",
                6624.61,
                6632.2,
                6617,
                6626.02
            ],
            [
                "2018/10/6 09:00:00",
                6627,
                6627.62,
                6584.22,
                6603.02
            ],
            [
                "2018/10/6 09:30:00",
                6605,
                6608.03,
                6598.95,
                6604.01
            ],
            [
                "2018/10/6 10:00:00",
                6604.5,
                6614.4,
                6602.26,
                6608.02
            ],
            [
                "2018/10/6 10:30:00",
                6608.02,
                6610.68,
                6601.99,
                6608.91
            ],
            [
                "2018/10/6 11:00:00",
                6608.91,
                6618.99,
                6608.01,
                6612
            ],
            [
                "2018/10/6 11:30:00",
                6612,
                6615.13,
                6605.09,
                6612
            ],
            [
                "2018/10/6 12:00:00",
                6612,
                6624.12,
                6608.43,
                6622.95
            ],
            [
                "2018/10/6 12:30:00",
                6623.91,
                6623.91,
                6615,
                6615.67
            ],
            [
                "2018/10/6 13:00:00",
                6618.69,
                6618.74,
                6610,
                6610.4
            ],
            [
                "2018/10/6 13:30:00",
                6611,
                6622.78,
                6610.4,
                6614.9
            ],
            [
                "2018/10/6 14:00:00",
                6614.9,
                6626.2,
                6613.33,
                6623.45
            ],
            [
                "2018/10/6 14:30:00",
                6623.48,
                6627,
                6618.38,
                6620.35
            ],
            [
                "2018/10/6 15:00:00",
                6619.43,
                6620.35,
                6610.05,
                6615.53
            ],
            [
                "2018/10/6 15:30:00",
                6615.53,
                6617.93,
                6610,
                6615.19
            ],
            [
                "2018/10/6 16:00:00",
                6615.19,
                6621.6,
                6608.2,
                6620
            ],
            [
                "2018/10/6 16:30:00",
                6619.54,
                6625.17,
                6614.15,
                6620
            ],
            [
                "2018/10/6 17:00:00",
                6620.33,
                6634.15,
                6617.24,
                6624.61
            ],
            [
                "2018/10/6 17:30:00",
                6625.95,
                6626,
                6611.66,
                6617.58
            ],
            [
                "2018/10/6 18:00:00",
                6619,
                6625.97,
                6595.27,
                6598.86
            ],
            [
                "2018/10/6 18:30:00",
                6598.86,
                6598.88,
                6570,
                6587.16
            ],
            [
                "2018/10/6 19:00:00",
                6588.86,
                6600,
                6580,
                6593.4
            ],
            [
                "2018/10/6 19:30:00",
                6593.99,
                6598.89,
                6585,
                6587.81
            ],
            [
                "2018/10/6 20:00:00",
                6587.81,
                6592.73,
                6567.14,
                6578
            ],
            [
                "2018/10/6 20:30:00",
                6578.35,
                6581.72,
                6567.39,
                6579
            ],
            [
                "2018/10/6 21:00:00",
                6579.38,
                6580.92,
                6566.77,
                6575.96
            ],
            [
                "2018/10/6 21:30:00",
                6575.96,
                6589,
                6571.77,
                6588.92
            ],
            [
                "2018/10/6 22:00:00",
                6588.92,
                6594,
                6577.55,
                6589.22
            ],
            [
                "2018/10/6 22:30:00",
                6589.3,
                6598.89,
                6589.1,
                6596.08
            ],
            [
                "2018/10/6 23:00:00",
                6597.5,
                6600,
                6588.39,
                6596.25
            ],
            [
                "2018/10/6 23:30:00",
                6598.03,
                6600,
                6588.73,
                6595.97
            ],
            [
                "2018/10/7 00:00:00",
                6595.97,
                6602.01,
                6588.17,
                6602
            ],
            [
                "2018/10/7 00:30:00",
                6602,
                6607,
                6596.51,
                6599.95
            ],
            [
                "2018/10/7 01:00:00",
                6600.63,
                6601.21,
                6590.39,
                6591.02
            ],
            [
                "2018/10/7 01:30:00",
                6591.02,
                6603.08,
                6591,
                6591
            ],
            [
                "2018/10/7 02:00:00",
                6591,
                6601.32,
                6585,
                6592
            ],
            [
                "2018/10/7 02:30:00",
                6593.13,
                6596.01,
                6590,
                6593.34
            ],
            [
                "2018/10/7 03:00:00",
                6593.34,
                6604.76,
                6582.63,
                6593.86
            ],
            [
                "2018/10/7 03:30:00",
                6593.86,
                6604.28,
                6586.57,
                6600.01
            ],
            [
                "2018/10/7 04:00:00",
                6601.81,
                6603.21,
                6592.78,
                6596.25
            ],
            [
                "2018/10/7 04:30:00",
                6596.25,
                6604.2,
                6590,
                6602.99
            ],
            [
                "2018/10/7 05:00:00",
                6602.99,
                6606,
                6584.99,
                6587.81
            ],
            [
                "2018/10/7 05:30:00",
                6587.81,
                6595,
                6583.27,
                6591.96
            ],
            [
                "2018/10/7 06:00:00",
                6591.97,
                6596.07,
                6585,
                6588.39
            ],
            [
                "2018/10/7 06:30:00",
                6587.6,
                6598.21,
                6587.6,
                6594.27
            ],
            [
                "2018/10/7 07:00:00",
                6596.44,
                6601,
                6590,
                6596.55
            ],
            [
                "2018/10/7 07:30:00",
                6598.91,
                6605,
                6596.61,
                6600.02
            ],
            [
                "2018/10/7 08:00:00",
                6600.55,
                6605,
                6589.14,
                6593.01
            ],
            [
                "2018/10/7 08:30:00",
                6593.15,
                6605,
                6592,
                6603.06
            ],
            [
                "2018/10/7 09:00:00",
                6603.07,
                6604.5,
                6599.09,
                6603.89
            ],
            [
                "2018/10/7 09:30:00",
                6604.44,
                6604.44,
                6600,
                6603.5
            ],
            [
                "2018/10/7 10:00:00",
                6603.5,
                6603.99,
                6597.5,
                6603.86
            ],
            [
                "2018/10/7 10:30:00",
                6603.85,
                6605,
                6600,
                6604.07
            ],
            [
                "2018/10/7 11:00:00",
                6604.98,
                6606,
                6604.07,
                6606
            ]
        ];
    }

    protected function fields()
    {
        return [
            Text::create('datetime'),
            Text::create('open'),
            Text::create('high'),
            Text::create('low'),
            Text::create('close'),
        ];
    }
}