/**
 ******************************************************************************
 * DO NOT MANUALLY EDIT THIS FILE. THIS FILE IS AUTOMATICALLY GENERATED.
 ******************************************************************************
 */

export interface LiveExample {
  /** Title of the example. */
  title: string;
  /** Name of the example component. */
  componentName: string;
  /** Selector to match the component of this example. */
  selector: string;
  /** Name of the primary file of this example. */
  primaryFile: string;
  /** List of files which are part of the example. */
  files: string[];
  /** Path to the directory containing the example. */
  packagePath: string;
  /** List of additional components which are part of the example. */
  additionalComponents: string[];
  /** Path from which to import the example. */
  importPath: string;
}

export const EXAMPLE_COMPONENTS: {[id: string]: LiveExample} = {
  "accordion-content": {
    "packagePath": "components/accordion/accordion-content",
    "title": "Accordion content",
    "componentName": "AccordionContentExample",
    "files": [
      "accordion-content-example.ts",
      "accordion-content-example.html",
      "accordion-content-example.css"
    ],
    "selector": "accordion-content-example",
    "additionalComponents": [],
    "primaryFile": "accordion-content-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-header": {
    "packagePath": "components/accordion/accordion-header",
    "title": "Accordion header",
    "componentName": "AccordionHeaderExample",
    "files": [
      "accordion-header-example.ts",
      "accordion-header-example.html"
    ],
    "selector": "accordion-header-example",
    "additionalComponents": [],
    "primaryFile": "accordion-header-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-in-panel": {
    "packagePath": "components/accordion/accordion-in-panel",
    "title": "Accordion in panel",
    "componentName": "AccordionInPanelExample",
    "files": [
      "accordion-in-panel-example.ts",
      "accordion-in-panel-example.html"
    ],
    "selector": "accordion-in-panel-example",
    "additionalComponents": [],
    "primaryFile": "accordion-in-panel-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-in-section": {
    "packagePath": "components/accordion/accordion-in-section",
    "title": "Accordion in section",
    "componentName": "AccordionInSectionExample",
    "files": [
      "accordion-in-section-example.ts",
      "accordion-in-section-example.html",
      "accordion-in-section-example.css"
    ],
    "selector": "accordion-in-section-example",
    "additionalComponents": [],
    "primaryFile": "accordion-in-section-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-inactive-section": {
    "packagePath": "components/accordion/accordion-inactive-section",
    "title": "Accordion inactive section",
    "componentName": "AccordionInactiveSectionExample",
    "files": [
      "accordion-inactive-section-example.ts",
      "accordion-inactive-section-example.html"
    ],
    "selector": "accordion-inactive-section-example",
    "additionalComponents": [],
    "primaryFile": "accordion-inactive-section-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-overview": {
    "packagePath": "components/accordion/accordion-overview",
    "title": "Accordion",
    "componentName": "AccordionOverviewExample",
    "files": [
      "accordion-overview-example.ts",
      "accordion-overview-example.html"
    ],
    "selector": "accordion-overview-example",
    "additionalComponents": [],
    "primaryFile": "accordion-overview-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-sections": {
    "packagePath": "components/accordion/accordion-sections",
    "title": "Accordion sections",
    "componentName": "AccordionSectionsExample",
    "files": [
      "accordion-sections-example.ts",
      "accordion-sections-example.html"
    ],
    "selector": "accordion-sections-example",
    "additionalComponents": [],
    "primaryFile": "accordion-sections-example.ts",
    "importPath": "components/accordion"
  },
  "accordion-states": {
    "packagePath": "components/accordion/accordion-states",
    "title": "Accordion states",
    "componentName": "AccordionStatesExample",
    "files": [
      "accordion-states-example.ts",
      "accordion-states-example.html"
    ],
    "selector": "accordion-states-example",
    "additionalComponents": [],
    "primaryFile": "accordion-states-example.ts",
    "importPath": "components/accordion"
  },
  "alert-close": {
    "packagePath": "components/alert/alert-close",
    "title": "Alert close",
    "componentName": "AlertCloseExample",
    "files": [
      "alert-close-example.ts"
    ],
    "selector": "alert-close-example",
    "additionalComponents": [],
    "primaryFile": "alert-close-example.ts",
    "importPath": "components/alert"
  },
  "alert-content": {
    "packagePath": "components/alert/alert-content",
    "title": "Alert content",
    "componentName": "AlertContentExample",
    "files": [
      "alert-content-example.ts",
      "alert-content-example.html",
      "alert-content-example.css"
    ],
    "selector": "alert-content-example",
    "additionalComponents": [],
    "primaryFile": "alert-content-example.ts",
    "importPath": "components/alert"
  },
  "alert-size": {
    "packagePath": "components/alert/alert-size",
    "title": "Alert size",
    "componentName": "AlertSizeExample",
    "files": [
      "alert-size-example.ts",
      "alert-size-example.html",
      "alert-size-example.css"
    ],
    "selector": "alert-size-example",
    "additionalComponents": [],
    "primaryFile": "alert-size-example.ts",
    "importPath": "components/alert"
  },
  "alert-status": {
    "packagePath": "components/alert/alert-status",
    "title": "Alert status",
    "componentName": "AlertStatusExample",
    "files": [
      "alert-status-example.ts",
      "alert-status-example.html",
      "alert-status-example.css"
    ],
    "selector": "alert-status-example",
    "additionalComponents": [],
    "primaryFile": "alert-status-example.ts",
    "importPath": "components/alert"
  },
  "alert-variants": {
    "packagePath": "components/alert/alert-variants",
    "title": "Alert variants",
    "componentName": "AlertVariantsExample",
    "files": [
      "alert-variants-example.ts",
      "alert-variants-example.css"
    ],
    "selector": "alert-variants-example",
    "additionalComponents": [],
    "primaryFile": "alert-variants-example.ts",
    "importPath": "components/alert"
  },
  "autocomplete-overview": {
    "packagePath": "components/autocomplete/autocomplete-overview",
    "title": "Autocomplete",
    "componentName": "AutocompleteOverviewExample",
    "files": [
      "autocomplete-overview-example.ts"
    ],
    "selector": "autocomplete-overview-example",
    "additionalComponents": [],
    "primaryFile": "autocomplete-overview-example.ts",
    "importPath": "components/autocomplete"
  },
  "badge-content": {
    "packagePath": "components/badge/badge-content",
    "title": "Badge content",
    "componentName": "BadgeContentExample",
    "files": [
      "badge-content-example.ts"
    ],
    "selector": "badge-content-example",
    "additionalComponents": [],
    "primaryFile": "badge-content-example.ts",
    "importPath": "components/badge"
  },
  "badge-fill-and-style": {
    "packagePath": "components/badge/badge-fill-and-style",
    "title": "Badge fill and style",
    "componentName": "BadgeFillAndStyleExample",
    "files": [
      "badge-fill-and-style-example.ts",
      "badge-fill-and-style-example.html",
      "badge-fill-and-style-example.css"
    ],
    "selector": "badge-fill-and-style-example",
    "additionalComponents": [],
    "primaryFile": "badge-fill-and-style-example.ts",
    "importPath": "components/badge"
  },
  "badge-list": {
    "packagePath": "components/badge/badge-list",
    "title": "Badge list",
    "componentName": "BadgeListExample",
    "files": [
      "badge-list-example.ts",
      "badge-list-example.css"
    ],
    "selector": "badge-list-example",
    "additionalComponents": [],
    "primaryFile": "badge-list-example.ts",
    "importPath": "components/badge"
  },
  "badge-size": {
    "packagePath": "components/badge/badge-size",
    "title": "Badge size",
    "componentName": "BadgeSizeExample",
    "files": [
      "badge-size-example.ts"
    ],
    "selector": "badge-size-example",
    "additionalComponents": [],
    "primaryFile": "badge-size-example.ts",
    "importPath": "components/badge"
  },
  "badge-table": {
    "packagePath": "components/badge/badge-table",
    "title": "Badge table",
    "componentName": "BadgeTableExample",
    "files": [
      "badge-table-example.ts",
      "badge-table-example.html"
    ],
    "selector": "badge-table-example",
    "additionalComponents": [],
    "primaryFile": "badge-table-example.ts",
    "importPath": "components/badge"
  },
  "badge-tooltip": {
    "packagePath": "components/badge/badge-tooltip",
    "title": "Badge tooltip",
    "componentName": "BadgeTooltipExample",
    "files": [
      "badge-tooltip-example.ts",
      "badge-tooltip-example.css"
    ],
    "selector": "badge-tooltip-example",
    "additionalComponents": [],
    "primaryFile": "badge-tooltip-example.ts",
    "importPath": "components/badge"
  },
  "button-toggle-alignment-overview": {
    "packagePath": "components/button-toggle/button-toggle-alignment-overview",
    "title": "Button toggle alignment",
    "componentName": "ButtonToggleAlignmentOverviewExample",
    "files": [
      "button-toggle-alignment-overview-example.ts",
      "button-toggle-alignment-overview-example.html",
      "button-toggle-alignment-overview-example.css"
    ],
    "selector": "button-toggle-alignment-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-toggle-alignment-overview-example.ts",
    "importPath": "components/button-toggle"
  },
  "button-toggle-disabled-all-overview": {
    "packagePath": "components/button-toggle/button-toggle-disabled-all-overview",
    "title": "Button toggle disabled all",
    "componentName": "ButtonToggleDisabledAllOverviewExample",
    "files": [
      "button-toggle-disabled-all-overview-example.ts",
      "button-toggle-disabled-all-overview-example.html"
    ],
    "selector": "button-toggle-disabled-all-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-toggle-disabled-all-overview-example.ts",
    "importPath": "components/button-toggle"
  },
  "button-toggle-disabled-partial-overview": {
    "packagePath": "components/button-toggle/button-toggle-disabled-partial-overview",
    "title": "Button toggle disabled partial",
    "componentName": "ButtonToggleDisabledPartialOverviewExample",
    "files": [
      "button-toggle-disabled-partial-overview-example.ts",
      "button-toggle-disabled-partial-overview-example.html"
    ],
    "selector": "button-toggle-disabled-partial-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-toggle-disabled-partial-overview-example.ts",
    "importPath": "components/button-toggle"
  },
  "button-toggle-overview": {
    "packagePath": "components/button-toggle/button-toggle-overview",
    "title": "Button toggle",
    "componentName": "ButtonToggleOverviewExample",
    "files": [
      "button-toggle-overview-example.ts",
      "button-toggle-overview-example.html"
    ],
    "selector": "button-toggle-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-toggle-overview-example.ts",
    "importPath": "components/button-toggle"
  },
  "button-toggle-tooltip-overview": {
    "packagePath": "components/button-toggle/button-toggle-tooltip-overview",
    "title": "Button toggle tooltip",
    "componentName": "ButtonToggleTooltipOverviewExample",
    "files": [
      "button-toggle-tooltip-overview-example.ts",
      "button-toggle-tooltip-overview-example.css"
    ],
    "selector": "button-toggle-tooltip-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-toggle-tooltip-overview-example.ts",
    "importPath": "components/button-toggle"
  },
  "button-content": {
    "packagePath": "components/button/button-content",
    "title": "Button content",
    "componentName": "ButtonContentExample",
    "files": [
      "button-content-example.ts",
      "button-content-example.css"
    ],
    "selector": "button-content-example",
    "additionalComponents": [],
    "primaryFile": "button-content-example.ts",
    "importPath": "components/button"
  },
  "button-fill-and-style": {
    "packagePath": "components/button/button-fill-and-style",
    "title": "Button fill and style",
    "componentName": "ButtonFillAndStyleExample",
    "files": [
      "button-fill-and-style-example.ts",
      "button-fill-and-style-example.html",
      "button-fill-and-style-example.css"
    ],
    "selector": "button-fill-and-style-example",
    "additionalComponents": [],
    "primaryFile": "button-fill-and-style-example.ts",
    "importPath": "components/button"
  },
  "button-fill-content": {
    "packagePath": "components/button/button-fill-content",
    "title": "Button fill content",
    "componentName": "ButtonFillContentExample",
    "files": [
      "button-fill-content-example.ts",
      "button-fill-content-example.css"
    ],
    "selector": "button-fill-content-example",
    "additionalComponents": [],
    "primaryFile": "button-fill-content-example.ts",
    "importPath": "components/button"
  },
  "button-fixed-content": {
    "packagePath": "components/button/button-fixed-content",
    "title": "Button fixed content",
    "componentName": "ButtonFixedContentExample",
    "files": [
      "button-fixed-content-example.ts",
      "button-fixed-content-example.css"
    ],
    "selector": "button-fixed-content-example",
    "additionalComponents": [],
    "primaryFile": "button-fixed-content-example.ts",
    "importPath": "components/button"
  },
  "button-hug-content": {
    "packagePath": "components/button/button-hug-content",
    "title": "Button hug content",
    "componentName": "ButtonHugContentExample",
    "files": [
      "button-hug-content-example.ts",
      "button-hug-content-example.css"
    ],
    "selector": "button-hug-content-example",
    "additionalComponents": [],
    "primaryFile": "button-hug-content-example.ts",
    "importPath": "components/button"
  },
  "button-loading-state": {
    "packagePath": "components/button/button-loading-state",
    "title": "Button loading state",
    "componentName": "ButtonLoadingStateExample",
    "files": [
      "button-loading-state-example.ts"
    ],
    "selector": "button-loading-state-example",
    "additionalComponents": [],
    "primaryFile": "button-loading-state-example.ts",
    "importPath": "components/button"
  },
  "button-overview": {
    "packagePath": "components/button/button-overview",
    "title": "Button overview",
    "componentName": "ButtonOverviewExample",
    "files": [
      "button-overview-example.ts",
      "button-overview-example.css"
    ],
    "selector": "button-overview-example",
    "additionalComponents": [],
    "primaryFile": "button-overview-example.ts",
    "importPath": "components/button"
  },
  "checkbox-indeterminate": {
    "packagePath": "components/checkbox/checkbox-indeterminate",
    "title": "Checkbox indeterminate",
    "componentName": "CheckboxIndeterminateExample",
    "files": [
      "checkbox-indeterminate-example.ts"
    ],
    "selector": "checkbox-indeterminate-example",
    "additionalComponents": [],
    "primaryFile": "checkbox-indeterminate-example.ts",
    "importPath": "components/checkbox"
  },
  "checkbox-overview": {
    "packagePath": "components/checkbox/checkbox-overview",
    "title": "Checkbox",
    "componentName": "CheckboxOverviewExample",
    "files": [
      "checkbox-overview-example.ts",
      "checkbox-overview-example.html"
    ],
    "selector": "checkbox-overview-example",
    "additionalComponents": [],
    "primaryFile": "checkbox-overview-example.ts",
    "importPath": "components/checkbox"
  },
  "pseudo-checkbox": {
    "packagePath": "components/checkbox/pseudo-checkbox",
    "title": "Pseudo checkbox",
    "componentName": "PseudoCheckboxExample",
    "files": [
      "pseudo-checkbox-example.ts"
    ],
    "selector": "pseudo-checkbox-example",
    "additionalComponents": [],
    "primaryFile": "pseudo-checkbox-example.ts",
    "importPath": "components/checkbox"
  },
  "code-block-with-custom-locale-configuration": {
    "packagePath": "components/code-block/code-block-with-custom-locale-configuration",
    "title": "Code-block with custom locale configuration, without KBQ_LOCALE_SERVICE",
    "componentName": "CodeBlockWithCustomLocaleConfigurationExample",
    "files": [
      "code-block-with-custom-locale-configuration-example.ts"
    ],
    "selector": "code-block-with-custom-locale-configuration-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-custom-locale-configuration-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-filled": {
    "packagePath": "components/code-block/code-block-with-filled",
    "title": "Code-block with filled attribute",
    "componentName": "CodeBlockWithFilledExample",
    "files": [
      "code-block-with-filled-example.ts"
    ],
    "selector": "code-block-with-filled-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-filled-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-line-numbers": {
    "packagePath": "components/code-block/code-block-with-line-numbers",
    "title": "Code-block with lineNumbers attribute",
    "componentName": "CodeBlockWithLineNumbersExample",
    "files": [
      "code-block-with-line-numbers-example.ts"
    ],
    "selector": "code-block-with-line-numbers-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-line-numbers-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-link": {
    "packagePath": "components/code-block/code-block-with-link",
    "title": "Code-block with link",
    "componentName": "CodeBlockWithLinkExample",
    "files": [
      "code-block-with-link-example.ts"
    ],
    "selector": "code-block-with-link-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-link-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-max-height": {
    "packagePath": "components/code-block/code-block-with-max-height",
    "title": "Code-block with maxHeight attribute",
    "componentName": "CodeBlockWithMaxHeightExample",
    "files": [
      "code-block-with-max-height-example.ts"
    ],
    "selector": "code-block-with-max-height-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-max-height-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-no-border": {
    "packagePath": "components/code-block/code-block-with-no-border",
    "title": "Code-block with noBorder attribute",
    "componentName": "CodeBlockWithNoBorderExample",
    "files": [
      "code-block-with-no-border-example.ts"
    ],
    "selector": "code-block-with-no-border-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-no-border-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-soft-wrap": {
    "packagePath": "components/code-block/code-block-with-soft-wrap",
    "title": "Code-block with softWrap attribute",
    "componentName": "CodeBlockWithSoftWrapExample",
    "files": [
      "code-block-with-soft-wrap-example.ts"
    ],
    "selector": "code-block-with-soft-wrap-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-soft-wrap-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-tabs-and-shadow": {
    "packagePath": "components/code-block/code-block-with-tabs-and-shadow",
    "title": "Code-block with tabs and shadow",
    "componentName": "CodeBlockWithTabsAndShadowExample",
    "files": [
      "code-block-with-tabs-and-shadow-example.ts"
    ],
    "selector": "code-block-with-tabs-and-shadow-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-tabs-and-shadow-example.ts",
    "importPath": "components/code-block"
  },
  "code-block-with-tabs": {
    "packagePath": "components/code-block/code-block-with-tabs",
    "title": "Code-block with tabs",
    "componentName": "CodeBlockWithTabsExample",
    "files": [
      "code-block-with-tabs-example.ts"
    ],
    "selector": "code-block-with-tabs-example",
    "additionalComponents": [],
    "primaryFile": "code-block-with-tabs-example.ts",
    "importPath": "components/code-block"
  },
  "absolute-date-formatter": {
    "packagePath": "components/date-formatter/absolute-date-formatter",
    "title": "Absolute date-formatter",
    "componentName": "AbsoluteDateFormatterExample",
    "files": [
      "absolute-date-formatter-example.ts",
      "absolute-date-formatter-example.html",
      "absolute-date-formatter-example.css"
    ],
    "selector": "absolute-date-formatter-example",
    "additionalComponents": [],
    "primaryFile": "absolute-date-formatter-example.ts",
    "importPath": "components/date-formatter"
  },
  "duration-date-formatter": {
    "packagePath": "components/date-formatter/duration-date-formatter",
    "title": "Duration date-formatter",
    "componentName": "DurationDateFormatterExample",
    "files": [
      "duration-date-formatter-example.ts",
      "duration-date-formatter-example.html",
      "duration-date-formatter-example.css"
    ],
    "selector": "duration-date-formatter-example",
    "additionalComponents": [],
    "primaryFile": "duration-date-formatter-example.ts",
    "importPath": "components/date-formatter"
  },
  "range-date-formatter": {
    "packagePath": "components/date-formatter/range-date-formatter",
    "title": "Range date-formatter",
    "componentName": "RangeDateFormatterExample",
    "files": [
      "range-date-formatter-example.ts",
      "range-date-formatter-example.html",
      "range-date-formatter-example.css"
    ],
    "selector": "range-date-formatter-example",
    "additionalComponents": [],
    "primaryFile": "range-date-formatter-example.ts",
    "importPath": "components/date-formatter"
  },
  "relative-date-formatter": {
    "packagePath": "components/date-formatter/relative-date-formatter",
    "title": "Relative date-formatter",
    "componentName": "RelativeDateFormatterExample",
    "files": [
      "relative-date-formatter-example.ts",
      "relative-date-formatter-example.html",
      "relative-date-formatter-example.css"
    ],
    "selector": "relative-date-formatter-example",
    "additionalComponents": [],
    "primaryFile": "relative-date-formatter-example.ts",
    "importPath": "components/date-formatter"
  },
  "datepicker-and-timepicker": {
    "packagePath": "components/datepicker/datepicker-and-timepicker",
    "title": "Datepicker and timepicker",
    "componentName": "DatepickerAndTimepickerExample",
    "files": [
      "datepicker-and-timepicker-example.ts"
    ],
    "selector": "datepicker-and-timepicker-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-and-timepicker-example.ts",
    "importPath": "components/datepicker"
  },
  "datepicker-inactive": {
    "packagePath": "components/datepicker/datepicker-inactive",
    "title": "Datepicker inactive",
    "componentName": "DatepickerInactiveExample",
    "files": [
      "datepicker-inactive-example.ts"
    ],
    "selector": "datepicker-inactive-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-inactive-example.ts",
    "importPath": "components/datepicker"
  },
  "datepicker-minimax": {
    "packagePath": "components/datepicker/datepicker-minimax",
    "title": "Datepicker minimax",
    "componentName": "DatepickerMinimaxExample",
    "files": [
      "datepicker-minimax-example.ts"
    ],
    "selector": "datepicker-minimax-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-minimax-example.ts",
    "importPath": "components/datepicker"
  },
  "datepicker-overview": {
    "packagePath": "components/datepicker/datepicker-overview",
    "title": "Datepicker",
    "componentName": "DatepickerOverviewExample",
    "files": [
      "datepicker-overview-example.ts"
    ],
    "selector": "datepicker-overview-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-overview-example.ts",
    "importPath": "components/datepicker"
  },
  "datepicker-range": {
    "packagePath": "components/datepicker/datepicker-range",
    "title": "Datepicker range",
    "componentName": "DatepickerRangeExample",
    "files": [
      "datepicker-range-example.ts"
    ],
    "selector": "datepicker-range-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-range-example.ts",
    "importPath": "components/datepicker"
  },
  "datepicker-required": {
    "packagePath": "components/datepicker/datepicker-required",
    "title": "Datepicker required",
    "componentName": "DatepickerRequiredExample",
    "files": [
      "datepicker-required-example.ts"
    ],
    "selector": "datepicker-required-example",
    "additionalComponents": [],
    "primaryFile": "datepicker-required-example.ts",
    "importPath": "components/datepicker"
  },
  "divider-overview": {
    "packagePath": "components/divider/divider-overview",
    "title": "Divider",
    "componentName": "DividerOverviewExample",
    "files": [
      "divider-overview-example.ts"
    ],
    "selector": "divider-overview-example",
    "additionalComponents": [],
    "primaryFile": "divider-overview-example.ts",
    "importPath": "components/divider"
  },
  "divider-vertical": {
    "packagePath": "components/divider/divider-vertical",
    "title": "Divider vertical",
    "componentName": "DividerVerticalExample",
    "files": [
      "divider-vertical-example.ts"
    ],
    "selector": "divider-vertical-example",
    "additionalComponents": [],
    "primaryFile": "divider-vertical-example.ts",
    "importPath": "components/divider"
  },
  "dl-horizontal-overview": {
    "packagePath": "components/dl/dl-horizontal-overview",
    "title": "Description list horizontal",
    "componentName": "DlHorizontalOverviewExample",
    "files": [
      "dl-horizontal-overview-example.ts"
    ],
    "selector": "dl-horizontal-overview-example",
    "additionalComponents": [],
    "primaryFile": "dl-horizontal-overview-example.ts",
    "importPath": "components/dl"
  },
  "dl-overview": {
    "packagePath": "components/dl/dl-overview",
    "title": "Description list",
    "componentName": "DlOverviewExample",
    "files": [
      "dl-overview-example.ts"
    ],
    "selector": "dl-overview-example",
    "additionalComponents": [],
    "primaryFile": "dl-overview-example.ts",
    "importPath": "components/dl"
  },
  "dl-small": {
    "packagePath": "components/dl/dl-small",
    "title": "Description list small",
    "componentName": "DlSmallExample",
    "files": [
      "dl-small-example.ts"
    ],
    "selector": "dl-small-example",
    "additionalComponents": [],
    "primaryFile": "dl-small-example.ts",
    "importPath": "components/dl"
  },
  "dl-vertical-overview": {
    "packagePath": "components/dl/dl-vertical-overview",
    "title": "Description list vertical",
    "componentName": "DlVerticalOverviewExample",
    "files": [
      "dl-vertical-overview-example.ts"
    ],
    "selector": "dl-vertical-overview-example",
    "additionalComponents": [],
    "primaryFile": "dl-vertical-overview-example.ts",
    "importPath": "components/dl"
  },
  "dropdown-disabled": {
    "packagePath": "components/dropdown/dropdown-disabled",
    "title": "Dropdown disabled",
    "componentName": "DropdownDisabledExample",
    "files": [
      "dropdown-disabled-example.ts",
      "dropdown-disabled-example.html"
    ],
    "selector": "dropdown-disabled-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-disabled-example.ts",
    "importPath": "components/dropdown"
  },
  "dropdown-lazyload-data": {
    "packagePath": "components/dropdown/dropdown-lazyload-data",
    "title": "Dropdown lazy load data",
    "componentName": "DropdownLazyloadDataExample",
    "files": [
      "dropdown-lazyload-data-example.ts",
      "dropdown-lazyload-data-example.html"
    ],
    "selector": "dropdown-lazyload-data-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-lazyload-data-example.ts",
    "importPath": "components/dropdown"
  },
  "dropdown-navigation-wrap": {
    "packagePath": "components/dropdown/dropdown-navigation-wrap",
    "title": "Dropdown navigation wrap",
    "componentName": "DropdownNavigationWrapExample",
    "files": [
      "dropdown-navigation-wrap-example.ts",
      "dropdown-navigation-wrap-example.html"
    ],
    "selector": "dropdown-navigation-wrap-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-navigation-wrap-example.ts",
    "importPath": "components/dropdown"
  },
  "dropdown-nested": {
    "packagePath": "components/dropdown/dropdown-nested",
    "title": "Dropdown nested",
    "componentName": "DropdownNestedExample",
    "files": [
      "dropdown-nested-example.ts",
      "dropdown-nested-example.html"
    ],
    "selector": "dropdown-nested-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-nested-example.ts",
    "importPath": "components/dropdown"
  },
  "dropdown-open-by-arrow-down": {
    "packagePath": "components/dropdown/dropdown-open-by-arrowdown",
    "title": "Dropdown open by arrow down",
    "componentName": "DropdownOpenByArrowDownExample",
    "files": [
      "dropdown-open-by-arrow-down-example.ts",
      "dropdown-open-by-arrow-down-example.html"
    ],
    "selector": "dropdown-open-by-arrow-down-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-open-by-arrow-down-example.ts",
    "importPath": "components/dropdown"
  },
  "dropdown-overview": {
    "packagePath": "components/dropdown/dropdown-overview",
    "title": "Dropdown",
    "componentName": "DropdownOverviewExample",
    "files": [
      "dropdown-overview-example.ts",
      "dropdown-overview-example.html"
    ],
    "selector": "dropdown-overview-example",
    "additionalComponents": [],
    "primaryFile": "dropdown-overview-example.ts",
    "importPath": "components/dropdown"
  },
  "empty-state-actions": {
    "packagePath": "components/empty-state/empty-state-actions",
    "title": "Empty-state actions",
    "componentName": "EmptyStateActionsExample",
    "files": [
      "empty-state-actions-example.ts"
    ],
    "selector": "empty-state-actions-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-actions-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-actions2": {
    "packagePath": "components/empty-state/empty-state-actions2",
    "title": "Empty-state actions more",
    "componentName": "EmptyStateActions2Example",
    "files": [
      "empty-state-actions2-example.ts"
    ],
    "selector": "empty-state-actions2-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-actions2-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-align": {
    "packagePath": "components/empty-state/empty-state-align",
    "title": "Empty-state align",
    "componentName": "EmptyStateAlignExample",
    "files": [
      "empty-state-align-example.ts"
    ],
    "selector": "empty-state-align-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-align-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-big": {
    "packagePath": "components/empty-state/empty-state-big",
    "title": "Empty-state big",
    "componentName": "EmptyStateBigExample",
    "files": [
      "empty-state-big-example.ts"
    ],
    "selector": "empty-state-big-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-big-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-content": {
    "packagePath": "components/empty-state/empty-state-content",
    "title": "Empty-state content",
    "componentName": "EmptyStateContentExample",
    "files": [
      "empty-state-content-example.ts"
    ],
    "selector": "empty-state-content-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-content-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-default": {
    "packagePath": "components/empty-state/empty-state-default",
    "title": "Empty-state default",
    "componentName": "EmptyStateDefaultExample",
    "files": [
      "empty-state-default-example.ts"
    ],
    "selector": "empty-state-default-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-default-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-error": {
    "packagePath": "components/empty-state/empty-state-error",
    "title": "Empty-state error",
    "componentName": "EmptyStateErrorExample",
    "files": [
      "empty-state-error-example.ts"
    ],
    "selector": "empty-state-error-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-error-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-icon": {
    "packagePath": "components/empty-state/empty-state-icon",
    "title": "Empty-state icon",
    "componentName": "EmptyStateIconExample",
    "files": [
      "empty-state-icon-example.ts"
    ],
    "selector": "empty-state-icon-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-icon-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-text-only": {
    "packagePath": "components/empty-state/empty-state-text-only",
    "title": "Empty-state text only",
    "componentName": "EmptyStateTextOnlyExample",
    "files": [
      "empty-state-text-only-example.ts"
    ],
    "selector": "empty-state-text-only-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-text-only-example.ts",
    "importPath": "components/empty-state"
  },
  "empty-state-title": {
    "packagePath": "components/empty-state/empty-state-title",
    "title": "Empty-state title",
    "componentName": "EmptyStateTitleExample",
    "files": [
      "empty-state-title-example.ts"
    ],
    "selector": "empty-state-title-example",
    "additionalComponents": [],
    "primaryFile": "empty-state-title-example.ts",
    "importPath": "components/empty-state"
  },
  "file-upload-cva-overview": {
    "packagePath": "components/file-upload/file-upload-cva-overview",
    "title": "File-upload with control value accessor",
    "componentName": "FileUploadCvaOverviewExample",
    "files": [
      "file-upload-cva-overview-example.ts"
    ],
    "selector": "file-upload-cva-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-cva-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-indeterminate-loading-overview": {
    "packagePath": "components/file-upload/file-upload-indeterminate-loading-overview",
    "title": "File-upload indeterminate loading",
    "componentName": "FileUploadIndeterminateLoadingOverviewExample",
    "files": [
      "file-upload-indeterminate-loading-overview-example.ts"
    ],
    "selector": "file-upload-indeterminate-loading-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-indeterminate-loading-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-multiple-compact-overview": {
    "packagePath": "components/file-upload/file-upload-multiple-compact-overview",
    "title": "File-upload multiple compact",
    "componentName": "FileUploadMultipleCompactOverviewExample",
    "files": [
      "file-upload-multiple-compact-overview-example.ts"
    ],
    "selector": "file-upload-multiple-compact-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-multiple-compact-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-multiple-custom-text-overview": {
    "packagePath": "components/file-upload/file-upload-multiple-custom-text-overview",
    "title": "File-upload multiple custom text",
    "componentName": "FileUploadMultipleCustomTextOverviewExample",
    "files": [
      "file-upload-multiple-custom-text-overview-example.ts"
    ],
    "selector": "file-upload-multiple-custom-text-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-multiple-custom-text-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-multiple-default-overview": {
    "packagePath": "components/file-upload/file-upload-multiple-default-overview",
    "title": "File-upload multiple default",
    "componentName": "FileUploadMultipleDefaultOverviewExample",
    "files": [
      "file-upload-multiple-default-overview-example.ts"
    ],
    "selector": "file-upload-multiple-default-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-multiple-default-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-multiple-default-validation-reactive-forms-overview": {
    "packagePath": "components/file-upload/file-upload-multiple-default-validation-reactive-forms-overview",
    "title": "File-upload multiple default validation reactive forms",
    "componentName": "FileUploadMultipleDefaultValidationReactiveFormsOverviewExample",
    "files": [
      "file-upload-multiple-default-validation-reactive-forms-overview-example.ts"
    ],
    "selector": "file-upload-multiple-default-validation-reactive-forms-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-multiple-default-validation-reactive-forms-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-multiple-error-overview": {
    "packagePath": "components/file-upload/file-upload-multiple-error-overview",
    "title": "File-upload multiple error",
    "componentName": "FileUploadMultipleErrorOverviewExample",
    "files": [
      "file-upload-multiple-error-overview-example.ts"
    ],
    "selector": "file-upload-multiple-error-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-multiple-error-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-single-error-overview": {
    "packagePath": "components/file-upload/file-upload-single-error-overview",
    "title": "File-upload single error",
    "componentName": "FileUploadSingleErrorOverviewExample",
    "files": [
      "file-upload-single-error-overview-example.ts"
    ],
    "selector": "file-upload-single-error-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-single-error-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-single-overview": {
    "packagePath": "components/file-upload/file-upload-single-overview",
    "title": "File-upload single",
    "componentName": "FileUploadSingleOverviewExample",
    "files": [
      "file-upload-single-overview-example.ts"
    ],
    "selector": "file-upload-single-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-single-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "file-upload-single-validation-reactive-forms-overview": {
    "packagePath": "components/file-upload/file-upload-single-validation-reactive-forms-overview",
    "title": "File-upload single validation reactive forms",
    "componentName": "FileUploadSingleValidationReactiveFormsOverviewExample",
    "files": [
      "file-upload-single-validation-reactive-forms-overview-example.ts"
    ],
    "selector": "file-upload-single-validation-reactive-forms-overview-example",
    "additionalComponents": [],
    "primaryFile": "file-upload-single-validation-reactive-forms-overview-example.ts",
    "importPath": "components/file-upload"
  },
  "form-field-password-overview": {
    "packagePath": "components/form-field/form-field-password-overview",
    "title": "Form field password overview",
    "componentName": "FormFieldPasswordOverviewExample",
    "files": [
      "form-field-password-overview-example.ts"
    ],
    "selector": "form-field-password-overview-example",
    "additionalComponents": [],
    "primaryFile": "form-field-password-overview-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-cleaner": {
    "packagePath": "components/form-field/form-field-with-cleaner",
    "title": "Form field with kbq-cleaner",
    "componentName": "FormFieldWithCleanerExample",
    "files": [
      "form-field-with-cleaner-example.ts"
    ],
    "selector": "form-field-with-cleaner-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-cleaner-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-custom-error-state-matcher-set-by-attribute": {
    "packagePath": "components/form-field/form-field-with-custom-error-state-matcher-set-by-attribute",
    "title": "Form field with CustomErrorStateMatcher which set by `errorStateMatcher` attribute",
    "componentName": "FormFieldWithCustomErrorStateMatcherSetByAttributeExample",
    "files": [
      "form-field-with-custom-error-state-matcher-set-by-attribute-example.ts"
    ],
    "selector": "form-field-with-custom-error-state-matcher-set-by-attribute-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-custom-error-state-matcher-set-by-attribute-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider": {
    "packagePath": "components/form-field/form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider",
    "title": "Form field with CustomErrorStateMatcher which set by DI provider",
    "componentName": "FormFieldWithCustomErrorStateMatcherSetByDependencyInjectionProviderExample",
    "files": [
      "form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider-example.ts"
    ],
    "selector": "form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-error": {
    "packagePath": "components/form-field/form-field-with-error",
    "title": "Form field with kbq-error",
    "componentName": "FormFieldWithErrorExample",
    "files": [
      "form-field-with-error-example.ts"
    ],
    "selector": "form-field-with-error-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-error-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-hint": {
    "packagePath": "components/form-field/form-field-with-hint",
    "title": "Form field with kbq-hint",
    "componentName": "FormFieldWithHintExample",
    "files": [
      "form-field-with-hint-example.ts"
    ],
    "selector": "form-field-with-hint-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-hint-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-label": {
    "packagePath": "components/form-field/form-field-with-label",
    "title": "Form field with kbq-label",
    "componentName": "FormFieldWithLabelExample",
    "files": [
      "form-field-with-label-example.ts"
    ],
    "selector": "form-field-with-label-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-label-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-with-prefix-and-suffix": {
    "packagePath": "components/form-field/form-field-with-prefix-and-suffix",
    "title": "Form field with kbqPrefix and kbqSuffix",
    "componentName": "FormFieldWithPrefixAndSuffixExample",
    "files": [
      "form-field-with-prefix-and-suffix-example.ts"
    ],
    "selector": "form-field-with-prefix-and-suffix-example",
    "additionalComponents": [],
    "primaryFile": "form-field-with-prefix-and-suffix-example.ts",
    "importPath": "components/form-field"
  },
  "form-field-without-borders": {
    "packagePath": "components/form-field/form-field-without-borders",
    "title": "Form field without borders",
    "componentName": "FormFieldWithoutBordersExample",
    "files": [
      "form-field-without-borders-example.ts"
    ],
    "selector": "form-field-without-borders-example",
    "additionalComponents": [],
    "primaryFile": "form-field-without-borders-example.ts",
    "importPath": "components/form-field"
  },
  "horizontal-form-labels": {
    "packagePath": "components/forms/horizontal-form-labels",
    "title": "Horizontal form labels",
    "componentName": "HorizontalFormLabelsExample",
    "files": [
      "horizontal-form-labels-example.ts",
      "horizontal-form-labels-example.html",
      "horizontal-form-labels-example.css"
    ],
    "selector": "horizontal-form-labels-example",
    "additionalComponents": [],
    "primaryFile": "horizontal-form-labels-example.ts",
    "importPath": "components/forms"
  },
  "horizontal-form": {
    "packagePath": "components/forms/horizontal-form",
    "title": "Horizontal form",
    "componentName": "HorizontalFormExample",
    "files": [
      "horizontal-form-example.ts",
      "horizontal-form-example.html"
    ],
    "selector": "horizontal-form-example",
    "additionalComponents": [],
    "primaryFile": "horizontal-form-example.ts",
    "importPath": "components/forms"
  },
  "vertical-form": {
    "packagePath": "components/forms/vertical-form",
    "title": "Vertical form",
    "componentName": "VerticalFormExample",
    "files": [
      "vertical-form-example.ts",
      "vertical-form-example.html"
    ],
    "selector": "vertical-form-example",
    "additionalComponents": [],
    "primaryFile": "vertical-form-example.ts",
    "importPath": "components/forms"
  },
  "icon-item-color": {
    "packagePath": "components/icon-item/icon-item-color",
    "title": "Icon-item color",
    "componentName": "IconItemColorExample",
    "files": [
      "icon-item-color-example.ts",
      "icon-item-color-example.css"
    ],
    "selector": "icon-item-color-example",
    "additionalComponents": [],
    "primaryFile": "icon-item-color-example.ts",
    "importPath": "components/icon-item"
  },
  "icon-item-default": {
    "packagePath": "components/icon-item/icon-item-default",
    "title": "Icon-item",
    "componentName": "IconItemDefaultExample",
    "files": [
      "icon-item-default-example.ts",
      "icon-item-default-example.css"
    ],
    "selector": "icon-item-default-example",
    "additionalComponents": [],
    "primaryFile": "icon-item-default-example.ts",
    "importPath": "components/icon-item"
  },
  "icon-item-size": {
    "packagePath": "components/icon-item/icon-item-size",
    "title": "Icon-item size",
    "componentName": "IconItemSizeExample",
    "files": [
      "icon-item-size-example.ts",
      "icon-item-size-example.css"
    ],
    "selector": "icon-item-size-example",
    "additionalComponents": [],
    "primaryFile": "icon-item-size-example.ts",
    "importPath": "components/icon-item"
  },
  "icon-item-variant": {
    "packagePath": "components/icon-item/icon-item-variant",
    "title": "Icon Item Variant",
    "componentName": "IconItemVariantExample",
    "files": [
      "icon-item-variant-example.ts",
      "icon-item-variant-example.css"
    ],
    "selector": "icon-item-variant-example",
    "additionalComponents": [],
    "primaryFile": "icon-item-variant-example.ts",
    "importPath": "components/icon-item"
  },
  "input-number-overview": {
    "packagePath": "components/input/input-number-overview",
    "title": "Input number",
    "componentName": "InputNumberOverviewExample",
    "files": [
      "input-number-overview-example.ts"
    ],
    "selector": "input-number-overview-example",
    "additionalComponents": [],
    "primaryFile": "input-number-overview-example.ts",
    "importPath": "components/input"
  },
  "input-overview": {
    "packagePath": "components/input/input-overview",
    "title": "Input",
    "componentName": "InputOverviewExample",
    "files": [
      "input-overview-example.ts"
    ],
    "selector": "input-overview-example",
    "additionalComponents": [],
    "primaryFile": "input-overview-example.ts",
    "importPath": "components/input"
  },
  "input-password-overview": {
    "packagePath": "components/input/input-password-overview",
    "title": "Input password",
    "componentName": "InputPasswordOverviewExample",
    "files": [
      "input-password-overview-example.ts"
    ],
    "selector": "input-password-overview-example",
    "additionalComponents": [],
    "primaryFile": "input-password-overview-example.ts",
    "importPath": "components/input"
  },
  "layout-flex-alignment": {
    "packagePath": "components/layout-flex/layout-flex-alignment",
    "title": "Layout-flex alignment",
    "componentName": "LayoutFlexAlignmentExample",
    "files": [
      "layout-flex-alignment-example.ts",
      "layout-flex-alignment-example.css"
    ],
    "selector": "layout-flex-alignment-example",
    "additionalComponents": [],
    "primaryFile": "layout-flex-alignment-example.ts",
    "importPath": "components/layout-flex"
  },
  "layout-flex-behaviour-modifiers": {
    "packagePath": "components/layout-flex/layout-flex-behaviour-modifiers",
    "title": "Layout-flex behaviour modifiers",
    "componentName": "LayoutFlexBehaviourModifiersExample",
    "files": [
      "layout-flex-behaviour-modifiers-example.ts",
      "layout-flex-behaviour-modifiers-example.css"
    ],
    "selector": "layout-flex-behaviour-modifiers-example",
    "additionalComponents": [],
    "primaryFile": "layout-flex-behaviour-modifiers-example.ts",
    "importPath": "components/layout-flex"
  },
  "layout-flex-offsets": {
    "packagePath": "components/layout-flex/layout-flex-offsets",
    "title": "Layout-flex offsets",
    "componentName": "LayoutFlexOffsetsExample",
    "files": [
      "layout-flex-offsets-example.ts",
      "layout-flex-offsets-example.css"
    ],
    "selector": "layout-flex-offsets-example",
    "additionalComponents": [],
    "primaryFile": "layout-flex-offsets-example.ts",
    "importPath": "components/layout-flex"
  },
  "layout-flex-order": {
    "packagePath": "components/layout-flex/layout-flex-order",
    "title": "Layout-flex order",
    "componentName": "LayoutFlexOrderExample",
    "files": [
      "layout-flex-order-example.ts",
      "layout-flex-order-example.css"
    ],
    "selector": "layout-flex-order-example",
    "additionalComponents": [],
    "primaryFile": "layout-flex-order-example.ts",
    "importPath": "components/layout-flex"
  },
  "layout-flex-overview": {
    "packagePath": "components/layout-flex/layout-flex-overview",
    "title": "Layout-flex",
    "componentName": "LayoutFlexOverviewExample",
    "files": [
      "layout-flex-overview-example.ts",
      "layout-flex-overview-example.css"
    ],
    "selector": "layout-flex-overview-example",
    "additionalComponents": [],
    "primaryFile": "layout-flex-overview-example.ts",
    "importPath": "components/layout-flex"
  },
  "link-application": {
    "packagePath": "components/link/link-application",
    "title": "Link application",
    "componentName": "LinkApplicationExample",
    "files": [
      "link-application-example.ts"
    ],
    "selector": "link-application-example",
    "additionalComponents": [],
    "primaryFile": "link-application-example.ts",
    "importPath": "components/link"
  },
  "link-caption": {
    "packagePath": "components/link/link-caption",
    "title": "Link caption",
    "componentName": "LinkCaptionExample",
    "files": [
      "link-caption-example.ts"
    ],
    "selector": "link-caption-example",
    "additionalComponents": [],
    "primaryFile": "link-caption-example.ts",
    "importPath": "components/link"
  },
  "link-color": {
    "packagePath": "components/link/link-color",
    "title": "Link color",
    "componentName": "LinkColorExample",
    "files": [
      "link-color-example.ts",
      "link-color-example.css"
    ],
    "selector": "link-color-example",
    "additionalComponents": [],
    "primaryFile": "link-color-example.ts",
    "importPath": "components/link"
  },
  "link-disabled": {
    "packagePath": "components/link/link-disabled",
    "title": "Link disabled",
    "componentName": "LinkDisabledExample",
    "files": [
      "link-disabled-example.ts"
    ],
    "selector": "link-disabled-example",
    "additionalComponents": [],
    "primaryFile": "link-disabled-example.ts",
    "importPath": "components/link"
  },
  "link-external": {
    "packagePath": "components/link/link-external",
    "title": "Link external",
    "componentName": "LinkExternalExample",
    "files": [
      "link-external-example.ts"
    ],
    "selector": "link-external-example",
    "additionalComponents": [],
    "primaryFile": "link-external-example.ts",
    "importPath": "components/link"
  },
  "link-general": {
    "packagePath": "components/link/link-general",
    "title": "Link general",
    "componentName": "LinkGeneralExample",
    "files": [
      "link-general-example.ts"
    ],
    "selector": "link-general-example",
    "additionalComponents": [],
    "primaryFile": "link-general-example.ts",
    "importPath": "components/link"
  },
  "link-icons": {
    "packagePath": "components/link/link-icons",
    "title": "Link icons",
    "componentName": "LinkIconsExample",
    "files": [
      "link-icons-example.ts"
    ],
    "selector": "link-icons-example",
    "additionalComponents": [],
    "primaryFile": "link-icons-example.ts",
    "importPath": "components/link"
  },
  "link-multi-line": {
    "packagePath": "components/link/link-multi-line",
    "title": "Link multi-line",
    "componentName": "LinkMultiLineExample",
    "files": [
      "link-multi-line-example.ts"
    ],
    "selector": "link-multi-line-example",
    "additionalComponents": [],
    "primaryFile": "link-multi-line-example.ts",
    "importPath": "components/link"
  },
  "link-overview": {
    "packagePath": "components/link/link-overview",
    "title": "Link",
    "componentName": "LinkOverviewExample",
    "files": [
      "link-overview-example.ts"
    ],
    "selector": "link-overview-example",
    "additionalComponents": [],
    "primaryFile": "link-overview-example.ts",
    "importPath": "components/link"
  },
  "link-prepositions": {
    "packagePath": "components/link/link-prepositions",
    "title": "Link preposition",
    "componentName": "LinkPrepositionsExample",
    "files": [
      "link-prepositions-example.ts"
    ],
    "selector": "link-prepositions-example",
    "additionalComponents": [],
    "primaryFile": "link-prepositions-example.ts",
    "importPath": "components/link"
  },
  "link-print": {
    "packagePath": "components/link/link-print",
    "title": "Link print",
    "componentName": "LinkPrintExample",
    "files": [
      "link-print-example.ts"
    ],
    "selector": "link-print-example",
    "additionalComponents": [],
    "primaryFile": "link-print-example.ts",
    "importPath": "components/link"
  },
  "link-pseudo": {
    "packagePath": "components/link/link-pseudo",
    "title": "Link pseudo",
    "componentName": "LinkPseudoExample",
    "files": [
      "link-pseudo-example.ts"
    ],
    "selector": "link-pseudo-example",
    "additionalComponents": [],
    "primaryFile": "link-pseudo-example.ts",
    "importPath": "components/link"
  },
  "link-target-blank": {
    "packagePath": "components/link/link-target-blank",
    "title": "Link target blank",
    "componentName": "LinkTargetBlankExample",
    "files": [
      "link-target-blank-example.ts"
    ],
    "selector": "link-target-blank-example",
    "additionalComponents": [],
    "primaryFile": "link-target-blank-example.ts",
    "importPath": "components/link"
  },
  "link-visited": {
    "packagePath": "components/link/link-visited",
    "title": "Link visited",
    "componentName": "LinkVisitedExample",
    "files": [
      "link-visited-example.ts"
    ],
    "selector": "link-visited-example",
    "additionalComponents": [],
    "primaryFile": "link-visited-example.ts",
    "importPath": "components/link"
  },
  "list-action-button": {
    "packagePath": "components/list/list-action-button",
    "title": "List action button",
    "componentName": "ListActionButtonExample",
    "files": [
      "list-action-button-example.ts"
    ],
    "selector": "list-action-button-example",
    "additionalComponents": [],
    "primaryFile": "list-action-button-example.ts",
    "importPath": "components/list"
  },
  "list-groups": {
    "packagePath": "components/list/list-groups",
    "title": "List groups",
    "componentName": "ListGroupsExample",
    "files": [
      "list-groups-example.ts"
    ],
    "selector": "list-groups-example",
    "additionalComponents": [],
    "primaryFile": "list-groups-example.ts",
    "importPath": "components/list"
  },
  "list-multiple-checkbox": {
    "packagePath": "components/list/list-multiple-checkbox",
    "title": "List multiple checkbox",
    "componentName": "ListMultipleCheckboxExample",
    "files": [
      "list-multiple-checkbox-example.ts"
    ],
    "selector": "list-multiple-checkbox-example",
    "additionalComponents": [],
    "primaryFile": "list-multiple-checkbox-example.ts",
    "importPath": "components/list"
  },
  "list-multiple-keyboard": {
    "packagePath": "components/list/list-multiple-keyboard",
    "title": "List multiple keyboard",
    "componentName": "ListMultipleKeyboardExample",
    "files": [
      "list-multiple-keyboard-example.ts"
    ],
    "selector": "list-multiple-keyboard-example",
    "additionalComponents": [],
    "primaryFile": "list-multiple-keyboard-example.ts",
    "importPath": "components/list"
  },
  "list-overview": {
    "packagePath": "components/list/list-overview",
    "title": "List",
    "componentName": "ListOverviewExample",
    "files": [
      "list-overview-example.ts"
    ],
    "selector": "list-overview-example",
    "additionalComponents": [],
    "primaryFile": "list-overview-example.ts",
    "importPath": "components/list"
  },
  "loader-overlay-default": {
    "packagePath": "components/loader-overlay/loader-overlay-default",
    "title": "Loader-overlay default",
    "componentName": "LoaderOverlayDefaultExample",
    "files": [
      "loader-overlay-default-example.ts"
    ],
    "selector": "loader-overlay-default-example",
    "additionalComponents": [],
    "primaryFile": "loader-overlay-default-example.ts",
    "importPath": "components/loader-overlay"
  },
  "loader-overlay-fixed-top": {
    "packagePath": "components/loader-overlay/loader-overlay-fixed-top",
    "title": "Loader-overlay fixed-top",
    "componentName": "LoaderOverlayFixedTopExample",
    "files": [
      "loader-overlay-fixed-top-example.ts"
    ],
    "selector": "loader-overlay-fixed-top-example",
    "additionalComponents": [],
    "primaryFile": "loader-overlay-fixed-top-example.ts",
    "importPath": "components/loader-overlay"
  },
  "loader-overlay-large": {
    "packagePath": "components/loader-overlay/loader-overlay-large",
    "title": "Loader-overlay large",
    "componentName": "LoaderOverlayLargeExample",
    "files": [
      "loader-overlay-large-example.ts"
    ],
    "selector": "loader-overlay-large-example",
    "additionalComponents": [],
    "primaryFile": "loader-overlay-large-example.ts",
    "importPath": "components/loader-overlay"
  },
  "loader-overlay-overview": {
    "packagePath": "components/loader-overlay/loader-overlay-overview",
    "title": "Loader-overlay",
    "componentName": "LoaderOverlayOverviewExample",
    "files": [
      "loader-overlay-overview-example.ts"
    ],
    "selector": "loader-overlay-overview-example",
    "additionalComponents": [],
    "primaryFile": "loader-overlay-overview-example.ts",
    "importPath": "components/loader-overlay"
  },
  "markdown-article": {
    "packagePath": "components/markdown/markdown-article",
    "title": "Markdown article",
    "componentName": "MarkdownArticleExample",
    "files": [
      "markdown-article-example.ts",
      "./markdown-article-example.html",
      "./markdown-article-example.css"
    ],
    "selector": "markdown-article-example",
    "additionalComponents": [],
    "primaryFile": "markdown-article-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-code-block": {
    "packagePath": "components/markdown/markdown-code-block",
    "title": "Markdown code block",
    "componentName": "MarkdownCodeBlockExample",
    "files": [
      "markdown-code-block-example.ts",
      "./markdown-code-block-example.html"
    ],
    "selector": "markdown-code-block-example",
    "additionalComponents": [],
    "primaryFile": "markdown-code-block-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-code": {
    "packagePath": "components/markdown/markdown-code",
    "title": "Markdown code",
    "componentName": "MarkdownCodeExample",
    "files": [
      "markdown-code-example.ts",
      "./markdown-code-example.html"
    ],
    "selector": "markdown-code-example",
    "additionalComponents": [],
    "primaryFile": "markdown-code-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-divider": {
    "packagePath": "components/markdown/markdown-divider",
    "title": "Markdown divider",
    "componentName": "MarkdownDividerExample",
    "files": [
      "markdown-divider-example.ts",
      "./markdown-divider-example.html"
    ],
    "selector": "markdown-divider-example",
    "additionalComponents": [],
    "primaryFile": "markdown-divider-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-headers-combinations": {
    "packagePath": "components/markdown/markdown-headers-combinations",
    "title": "Markdown headers combinations",
    "componentName": "MarkdownHeadersCombinationsExample",
    "files": [
      "markdown-headers-combinations-example.ts",
      "./markdown-headers-combinations-example.html"
    ],
    "selector": "markdown-headers-combinations-example",
    "additionalComponents": [],
    "primaryFile": "markdown-headers-combinations-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-headers": {
    "packagePath": "components/markdown/markdown-headers",
    "title": "Markdown headers",
    "componentName": "MarkdownHeadersExample",
    "files": [
      "markdown-headers-example.ts",
      "./markdown-headers-example.html"
    ],
    "selector": "markdown-headers-example",
    "additionalComponents": [],
    "primaryFile": "markdown-headers-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-image": {
    "packagePath": "components/markdown/markdown-image",
    "title": "Markdown image",
    "componentName": "MarkdownImageExample",
    "files": [
      "markdown-image-example.ts",
      "./markdown-image-example.html"
    ],
    "selector": "markdown-image-example",
    "additionalComponents": [],
    "primaryFile": "markdown-image-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-line-break": {
    "packagePath": "components/markdown/markdown-line-break",
    "title": "Markdown line break",
    "componentName": "MarkdownLineBreakExample",
    "files": [
      "markdown-line-break-example.ts",
      "./markdown-line-break-example.html"
    ],
    "selector": "markdown-line-break-example",
    "additionalComponents": [],
    "primaryFile": "markdown-line-break-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-link": {
    "packagePath": "components/markdown/markdown-link",
    "title": "Markdown link",
    "componentName": "MarkdownLinkExample",
    "files": [
      "markdown-link-example.ts",
      "./markdown-link-example.html"
    ],
    "selector": "markdown-link-example",
    "additionalComponents": [],
    "primaryFile": "markdown-link-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-list": {
    "packagePath": "components/markdown/markdown-list",
    "title": "Markdown list",
    "componentName": "MarkdownListExample",
    "files": [
      "markdown-list-example.ts",
      "./markdown-list-example.html"
    ],
    "selector": "markdown-list-example",
    "additionalComponents": [],
    "primaryFile": "markdown-list-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-paragraph": {
    "packagePath": "components/markdown/markdown-paragraph",
    "title": "Markdown paragraph",
    "componentName": "MarkdownParagraphExample",
    "files": [
      "markdown-paragraph-example.ts",
      "./markdown-paragraph-example.html"
    ],
    "selector": "markdown-paragraph-example",
    "additionalComponents": [],
    "primaryFile": "markdown-paragraph-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-quote": {
    "packagePath": "components/markdown/markdown-quote",
    "title": "Markdown quote",
    "componentName": "MarkdownQuoteExample",
    "files": [
      "markdown-quote-example.ts",
      "./markdown-quote-example.html"
    ],
    "selector": "markdown-quote-example",
    "additionalComponents": [],
    "primaryFile": "markdown-quote-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-selection": {
    "packagePath": "components/markdown/markdown-selection",
    "title": "Markdown selection",
    "componentName": "MarkdownSelectionExample",
    "files": [
      "markdown-selection-example.ts",
      "markdown-selection-example.html"
    ],
    "selector": "markdown-selection-example",
    "additionalComponents": [],
    "primaryFile": "markdown-selection-example.ts",
    "importPath": "components/markdown"
  },
  "markdown-table": {
    "packagePath": "components/markdown/markdown-table",
    "title": "Markdown table",
    "componentName": "MarkdownTableExample",
    "files": [
      "markdown-table-example.ts",
      "./markdown-table-example.html"
    ],
    "selector": "markdown-table-example",
    "additionalComponents": [],
    "primaryFile": "markdown-table-example.ts",
    "importPath": "components/markdown"
  },
  "modal-component": {
    "packagePath": "components/modal/modal-component",
    "title": "Modal component",
    "componentName": "ModalComponentExample",
    "files": [
      "modal-component-example.ts"
    ],
    "selector": "modal-component-example",
    "additionalComponents": [
      "CustomModalComponent"
    ],
    "primaryFile": "modal-component-example.ts",
    "importPath": "components/modal"
  },
  "modal-multiple": {
    "packagePath": "components/modal/modal-multiple",
    "title": "Modal multiple",
    "componentName": "ModalMultipleExample",
    "files": [
      "modal-multiple-example.ts"
    ],
    "selector": "modal-multiple-example",
    "additionalComponents": [],
    "primaryFile": "modal-multiple-example.ts",
    "importPath": "components/modal"
  },
  "modal-overview": {
    "packagePath": "components/modal/modal-overview",
    "title": "Modal",
    "componentName": "ModalOverviewExample",
    "files": [
      "modal-overview-example.ts"
    ],
    "selector": "modal-overview-example",
    "additionalComponents": [],
    "primaryFile": "modal-overview-example.ts",
    "importPath": "components/modal"
  },
  "modal-scroll": {
    "packagePath": "components/modal/modal-scroll",
    "title": "Modal scroll",
    "componentName": "ModalScrollExample",
    "files": [
      "modal-scroll-example.ts"
    ],
    "selector": "modal-scroll-example",
    "additionalComponents": [
      "CustomModalComponent"
    ],
    "primaryFile": "modal-scroll-example.ts",
    "importPath": "components/modal"
  },
  "modal-sizes": {
    "packagePath": "components/modal/modal-sizes",
    "title": "Modal sizes",
    "componentName": "ModalSizesExample",
    "files": [
      "modal-sizes-example.ts"
    ],
    "selector": "modal-sizes-example",
    "additionalComponents": [],
    "primaryFile": "modal-sizes-example.ts",
    "importPath": "components/modal"
  },
  "modal-template": {
    "packagePath": "components/modal/modal-template",
    "title": "Modal template",
    "componentName": "ModalTemplateExample",
    "files": [
      "modal-template-example.ts"
    ],
    "selector": "modal-template-example",
    "additionalComponents": [],
    "primaryFile": "modal-template-example.ts",
    "importPath": "components/modal"
  },
  "navbar-overview": {
    "packagePath": "components/navbar/navbar-overview",
    "title": "Navbar",
    "componentName": "NavbarOverviewExample",
    "files": [
      "navbar-overview-example.ts",
      "navbar-overview-example.html"
    ],
    "selector": "navbar-overview-example",
    "additionalComponents": [],
    "primaryFile": "navbar-overview-example.ts",
    "importPath": "components/navbar"
  },
  "navbar-vertical-open-over": {
    "packagePath": "components/navbar/navbar-vertical-open-over",
    "title": "Navbar vertical open over",
    "componentName": "NavbarVerticalOpenOverExample",
    "files": [
      "navbar-vertical-open-over-example.ts",
      "navbar-vertical-open-over-example.html"
    ],
    "selector": "navbar-vertical-open-over-example",
    "additionalComponents": [],
    "primaryFile": "navbar-vertical-open-over-example.ts",
    "importPath": "components/navbar"
  },
  "navbar-vertical": {
    "packagePath": "components/navbar/navbar-vertical",
    "title": "Navbar vertical",
    "componentName": "NavbarVerticalExample",
    "files": [
      "navbar-vertical-example.ts",
      "navbar-vertical-example.html"
    ],
    "selector": "navbar-vertical-example",
    "additionalComponents": [],
    "primaryFile": "navbar-vertical-example.ts",
    "importPath": "components/navbar"
  },
  "number-formatter-overview": {
    "packagePath": "components/number-formatter/number-formatter-overview",
    "title": "Number-formatter",
    "componentName": "NumberFormatterOverviewExample",
    "files": [
      "number-formatter-overview-example.ts",
      "number-formatter-overview-example.html"
    ],
    "selector": "number-formatter-overview-example",
    "additionalComponents": [],
    "primaryFile": "number-formatter-overview-example.ts",
    "importPath": "components/number-formatter"
  },
  "popover-close": {
    "packagePath": "components/popover/popover-close",
    "title": "Popover close",
    "componentName": "PopoverCloseExample",
    "files": [
      "popover-close-example.ts",
      "popover-close-example.html",
      "popover-close-example.css"
    ],
    "selector": "popover-close-example",
    "additionalComponents": [],
    "primaryFile": "popover-close-example.ts",
    "importPath": "components/popover"
  },
  "popover-common": {
    "packagePath": "components/popover/popover-common",
    "title": "Popover common",
    "componentName": "PopoverCommonExample",
    "files": [
      "popover-common-example.ts"
    ],
    "selector": "popover-common-example",
    "additionalComponents": [],
    "primaryFile": "popover-common-example.ts",
    "importPath": "components/popover"
  },
  "popover-content": {
    "packagePath": "components/popover/popover-content",
    "title": "Popover content",
    "componentName": "PopoverContentExample",
    "files": [
      "popover-content-example.ts",
      "popover-content-example.html",
      "popover-content-example.css"
    ],
    "selector": "popover-content-example",
    "additionalComponents": [],
    "primaryFile": "popover-content-example.ts",
    "importPath": "components/popover"
  },
  "popover-header": {
    "packagePath": "components/popover/popover-header",
    "title": "Popover Header",
    "componentName": "PopoverHeaderExample",
    "files": [
      "popover-header-example.ts",
      "popover-header-example.html"
    ],
    "selector": "popover-header-example",
    "additionalComponents": [],
    "primaryFile": "popover-header-example.ts",
    "importPath": "components/popover"
  },
  "popover-height": {
    "packagePath": "components/popover/popover-height",
    "title": "Popover height",
    "componentName": "PopoverHeightExample",
    "files": [
      "popover-height-example.ts",
      "popover-height-example.html"
    ],
    "selector": "popover-height-example",
    "additionalComponents": [],
    "primaryFile": "popover-height-example.ts",
    "importPath": "components/popover"
  },
  "popover-placement-center": {
    "packagePath": "components/popover/popover-placement-center",
    "title": "Popover placement center",
    "componentName": "PopoverPlacementCenterExample",
    "files": [
      "popover-placement-center-example.ts",
      "popover-placement-center-example.html"
    ],
    "selector": "popover-placement-center-example",
    "additionalComponents": [],
    "primaryFile": "popover-placement-center-example.ts",
    "importPath": "components/popover"
  },
  "popover-placement-edges": {
    "packagePath": "components/popover/popover-placement-edges",
    "title": "Popover placement edges",
    "componentName": "PopoverPlacementEdgesExample",
    "files": [
      "popover-placement-edges-example.ts",
      "popover-placement-edges-example.html"
    ],
    "selector": "popover-placement-edges-example",
    "additionalComponents": [],
    "primaryFile": "popover-placement-edges-example.ts",
    "importPath": "components/popover"
  },
  "popover-scroll": {
    "packagePath": "components/popover/popover-scroll",
    "title": "popover-scroll",
    "componentName": "PopoverScrollExample",
    "files": [
      "popover-scroll-example.ts"
    ],
    "selector": "popover-scroll-example",
    "additionalComponents": [],
    "primaryFile": "popover-scroll-example.ts",
    "importPath": "components/popover"
  },
  "popover-width": {
    "packagePath": "components/popover/popover-width",
    "title": "Popover width",
    "componentName": "PopoverWidthExample",
    "files": [
      "popover-width-example.ts",
      "popover-width-example.html"
    ],
    "selector": "popover-width-example",
    "additionalComponents": [],
    "primaryFile": "popover-width-example.ts",
    "importPath": "components/popover"
  },
  "progress-bar-indeterminate": {
    "packagePath": "components/progress-bar/progress-bar-indeterminate",
    "title": "Progress bar indeterminate",
    "componentName": "ProgressBarIndeterminateExample",
    "files": [
      "progress-bar-indeterminate-example.ts"
    ],
    "selector": "progress-bar-indeterminate-example",
    "additionalComponents": [],
    "primaryFile": "progress-bar-indeterminate-example.ts",
    "importPath": "components/progress-bar"
  },
  "progress-bar-overview": {
    "packagePath": "components/progress-bar/progress-bar-overview",
    "title": "Progress bar",
    "componentName": "ProgressBarOverviewExample",
    "files": [
      "progress-bar-overview-example.ts"
    ],
    "selector": "progress-bar-overview-example",
    "additionalComponents": [],
    "primaryFile": "progress-bar-overview-example.ts",
    "importPath": "components/progress-bar"
  },
  "progress-spinner-indeterminate": {
    "packagePath": "components/progress-spinner/progress-spinner-indeterminate",
    "title": "Progress spinner indeterminate",
    "componentName": "ProgressSpinnerIndeterminateExample",
    "files": [
      "progress-spinner-indeterminate-example.ts"
    ],
    "selector": "progress-spinner-indeterminate-example",
    "additionalComponents": [],
    "primaryFile": "progress-spinner-indeterminate-example.ts",
    "importPath": "components/progress-spinner"
  },
  "progress-spinner-overview": {
    "packagePath": "components/progress-spinner/progress-spinner-overview",
    "title": "Basic progress spinner",
    "componentName": "ProgressSpinnerOverviewExample",
    "files": [
      "progress-spinner-overview-example.ts"
    ],
    "selector": "progress-spinner-overview-example",
    "additionalComponents": [],
    "primaryFile": "progress-spinner-overview-example.ts",
    "importPath": "components/progress-spinner"
  },
  "radio-content": {
    "packagePath": "components/radio/radio-content",
    "title": "Radio content",
    "componentName": "RadioContentExample",
    "files": [
      "radio-content-example.ts",
      "radio-content-example.html"
    ],
    "selector": "radio-content-example",
    "additionalComponents": [],
    "primaryFile": "radio-content-example.ts",
    "importPath": "components/radio"
  },
  "radio-group": {
    "packagePath": "components/radio/radio-group",
    "title": "Radio group",
    "componentName": "RadioGroupExample",
    "files": [
      "radio-group-example.ts"
    ],
    "selector": "radio-group-example",
    "additionalComponents": [],
    "primaryFile": "radio-group-example.ts",
    "importPath": "components/radio"
  },
  "radio-size": {
    "packagePath": "components/radio/radio-size",
    "title": "Radio size",
    "componentName": "RadioSizeExample",
    "files": [
      "radio-size-example.ts"
    ],
    "selector": "radio-size-example",
    "additionalComponents": [],
    "primaryFile": "radio-size-example.ts",
    "importPath": "components/radio"
  },
  "radio-style": {
    "packagePath": "components/radio/radio-style",
    "title": "Radio style",
    "componentName": "RadioStyleExample",
    "files": [
      "radio-style-example.ts"
    ],
    "selector": "radio-style-example",
    "additionalComponents": [],
    "primaryFile": "radio-style-example.ts",
    "importPath": "components/radio"
  },
  "scrollbar-scroll-to-top": {
    "packagePath": "components/scrollbar/scrollbar-scroll-to-top",
    "title": "Scrollbar scroll to top",
    "componentName": "ScrollbarScrollToTopExample",
    "files": [
      "scrollbar-scroll-to-top-example.ts"
    ],
    "selector": "scrollbar-scroll-to-top-example",
    "additionalComponents": [],
    "primaryFile": "scrollbar-scroll-to-top-example.ts",
    "importPath": "components/scrollbar"
  },
  "scrollbar-with-custom-config": {
    "packagePath": "components/scrollbar/scrollbar-with-custom-config",
    "title": "Scrollbar with custom KBQ_SCROLLBAR_CONFIG",
    "componentName": "ScrollbarWithCustomConfigExample",
    "files": [
      "scrollbar-with-custom-config-example.ts"
    ],
    "selector": "scrollbar-with-custom-config-example",
    "additionalComponents": [],
    "primaryFile": "scrollbar-with-custom-config-example.ts",
    "importPath": "components/scrollbar"
  },
  "scrollbar-with-options": {
    "packagePath": "components/scrollbar/scrollbar-with-options",
    "title": "Scrollbar with options",
    "componentName": "ScrollbarWithOptionsExample",
    "files": [
      "scrollbar-with-options-example.ts"
    ],
    "selector": "scrollbar-with-options-example",
    "additionalComponents": [],
    "primaryFile": "scrollbar-with-options-example.ts",
    "importPath": "components/scrollbar"
  },
  "select-cleaner": {
    "packagePath": "components/select/select-cleaner",
    "title": "Select cleaner",
    "componentName": "SelectCleanerExample",
    "files": [
      "select-cleaner-example.ts"
    ],
    "selector": "select-cleaner-example",
    "additionalComponents": [],
    "primaryFile": "select-cleaner-example.ts",
    "importPath": "components/select"
  },
  "select-disabled": {
    "packagePath": "components/select/select-disabled",
    "title": "Select disabled",
    "componentName": "SelectDisabledExample",
    "files": [
      "select-disabled-example.ts",
      "select-disabled-example.html"
    ],
    "selector": "select-disabled-example",
    "additionalComponents": [],
    "primaryFile": "select-disabled-example.ts",
    "importPath": "components/select"
  },
  "select-footer": {
    "packagePath": "components/select/select-footer",
    "title": "Select footer",
    "componentName": "SelectFooterExample",
    "files": [
      "select-footer-example.ts",
      "select-footer-example.html"
    ],
    "selector": "select-footer-example",
    "additionalComponents": [],
    "primaryFile": "select-footer-example.ts",
    "importPath": "components/select"
  },
  "select-groups": {
    "packagePath": "components/select/select-groups",
    "title": "Select groups",
    "componentName": "SelectGroupsExample",
    "files": [
      "select-groups-example.ts"
    ],
    "selector": "select-groups-example",
    "additionalComponents": [],
    "primaryFile": "select-groups-example.ts",
    "importPath": "components/select"
  },
  "select-height": {
    "packagePath": "components/select/select-height",
    "title": "Select height",
    "componentName": "SelectHeightExample",
    "files": [
      "select-height-example.ts"
    ],
    "selector": "select-height-example",
    "additionalComponents": [],
    "primaryFile": "select-height-example.ts",
    "importPath": "components/select"
  },
  "select-icon": {
    "packagePath": "components/select/select-icon",
    "title": "Select icon",
    "componentName": "SelectIconExample",
    "files": [
      "select-icon-example.ts"
    ],
    "selector": "select-icon-example",
    "additionalComponents": [],
    "primaryFile": "select-icon-example.ts",
    "importPath": "components/select"
  },
  "select-multiple": {
    "packagePath": "components/select/select-multiple",
    "title": "Select multiple",
    "componentName": "SelectMultipleExample",
    "files": [
      "select-multiple-example.ts"
    ],
    "selector": "select-multiple-example",
    "additionalComponents": [],
    "primaryFile": "select-multiple-example.ts",
    "importPath": "components/select"
  },
  "select-overview": {
    "packagePath": "components/select/select-overview",
    "title": "Select",
    "componentName": "SelectOverviewExample",
    "files": [
      "select-overview-example.ts"
    ],
    "selector": "select-overview-example",
    "additionalComponents": [],
    "primaryFile": "select-overview-example.ts",
    "importPath": "components/select"
  },
  "select-prioritized-selected": {
    "packagePath": "components/select/select-prioritized-selected",
    "title": "Selected prioritized selected",
    "componentName": "SelectPrioritizedSelectedExample",
    "files": [
      "select-prioritized-selected-example.ts"
    ],
    "selector": "select-prioritized-selected-example",
    "additionalComponents": [],
    "primaryFile": "select-prioritized-selected-example.ts",
    "importPath": "components/select"
  },
  "select-search": {
    "packagePath": "components/select/select-search",
    "title": "Select search",
    "componentName": "SelectSearchExample",
    "files": [
      "select-search-example.ts"
    ],
    "selector": "select-search-example",
    "additionalComponents": [],
    "primaryFile": "select-search-example.ts",
    "importPath": "components/select"
  },
  "select-validation": {
    "packagePath": "components/select/select-validation",
    "title": "Select validation",
    "componentName": "SelectValidationExample",
    "files": [
      "select-validation-example.ts"
    ],
    "selector": "select-validation-example",
    "additionalComponents": [],
    "primaryFile": "select-validation-example.ts",
    "importPath": "components/select"
  },
  "select-virtual-scroll": {
    "packagePath": "components/select/select-virtual-scroll",
    "title": "Select virtual scroll",
    "componentName": "SelectVirtualScrollExample",
    "files": [
      "select-virtual-scroll-example.ts"
    ],
    "selector": "select-virtual-scroll-example",
    "additionalComponents": [],
    "primaryFile": "select-virtual-scroll-example.ts",
    "importPath": "components/select"
  },
  "select-with-panel-width-attribute": {
    "packagePath": "components/select/select-with-panel-width-attribute",
    "title": "Select with panelWidth attribute",
    "componentName": "SelectWithPanelWidthAttributeExample",
    "files": [
      "select-with-panel-width-attribute-example.ts"
    ],
    "selector": "select-with-panel-width-attribute-example",
    "additionalComponents": [],
    "primaryFile": "select-with-panel-width-attribute-example.ts",
    "importPath": "components/select"
  },
  "sidepanel-modal-mode": {
    "packagePath": "components/sidepanel/sidepanel-modal-mode",
    "title": "Sidepanel modal mode",
    "componentName": "SidepanelModalModeExample",
    "files": [
      "sidepanel-modal-mode-example.ts",
      "sidepanel-modal-mode-example.html"
    ],
    "selector": "sidepanel-modal-mode-example",
    "additionalComponents": [],
    "primaryFile": "sidepanel-modal-mode-example.ts",
    "importPath": "components/sidepanel"
  },
  "sidepanel-normal-mode": {
    "packagePath": "components/sidepanel/sidepanel-normal-mode",
    "title": "Sidepanel normal mode",
    "componentName": "SidepanelNormalModeExample",
    "files": [
      "sidepanel-normal-mode-example.ts",
      "sidepanel-normal-mode-example.html"
    ],
    "selector": "sidepanel-normal-mode-example",
    "additionalComponents": [],
    "primaryFile": "sidepanel-normal-mode-example.ts",
    "importPath": "components/sidepanel"
  },
  "sidepanel-overlayed": {
    "packagePath": "components/sidepanel/sidepanel-overlayed",
    "title": "Sidepanel overlayed",
    "componentName": "SidepanelOverlayedExample",
    "files": [
      "sidepanel-overlayed-example.ts",
      "./sidepanel-overlayed-example.html"
    ],
    "selector": "sidepanel-overlayed-example",
    "additionalComponents": [],
    "primaryFile": "sidepanel-overlayed-example.ts",
    "importPath": "components/sidepanel"
  },
  "sidepanel-sizes": {
    "packagePath": "components/sidepanel/sidepanel-sizes",
    "title": "Sidepanel sizes",
    "componentName": "SidepanelSizesExample",
    "files": [
      "sidepanel-sizes-example.ts",
      "sidepanel-sizes-example.html"
    ],
    "selector": "sidepanel-sizes-example",
    "additionalComponents": [],
    "primaryFile": "sidepanel-sizes-example.ts",
    "importPath": "components/sidepanel"
  },
  "splitter-dynamic-data": {
    "packagePath": "components/splitter/splitter-dynamic-data",
    "title": "Splitter dynamic data",
    "componentName": "SplitterDynamicDataExample",
    "files": [
      "splitter-dynamic-data-example.ts"
    ],
    "selector": "splitter-dynamic-data-example",
    "additionalComponents": [],
    "primaryFile": "splitter-dynamic-data-example.ts",
    "importPath": "components/splitter"
  },
  "splitter-fixed": {
    "packagePath": "components/splitter/splitter-fixed",
    "title": "Splitter fixed",
    "componentName": "SplitterFixedExample",
    "files": [
      "splitter-fixed-example.ts"
    ],
    "selector": "splitter-fixed-example",
    "additionalComponents": [],
    "primaryFile": "splitter-fixed-example.ts",
    "importPath": "components/splitter"
  },
  "splitter-nested": {
    "packagePath": "components/splitter/splitter-nested",
    "title": "Splitter nested",
    "componentName": "SplitterNestedExample",
    "files": [
      "splitter-nested-example.ts"
    ],
    "selector": "splitter-nested-example",
    "additionalComponents": [],
    "primaryFile": "splitter-nested-example.ts",
    "importPath": "components/splitter"
  },
  "splitter-overview": {
    "packagePath": "components/splitter/splitter-overview",
    "title": "Splitter",
    "componentName": "SplitterOverviewExample",
    "files": [
      "splitter-overview-example.ts"
    ],
    "selector": "splitter-overview-example",
    "additionalComponents": [],
    "primaryFile": "splitter-overview-example.ts",
    "importPath": "components/splitter"
  },
  "splitter-vertical": {
    "packagePath": "components/splitter/splitter-vertical",
    "title": "Basic Splitter",
    "componentName": "SplitterVerticalExample",
    "files": [
      "splitter-vertical-example.ts"
    ],
    "selector": "splitter-vertical-example",
    "additionalComponents": [],
    "primaryFile": "splitter-vertical-example.ts",
    "importPath": "components/splitter"
  },
  "table-full-width": {
    "packagePath": "components/table/table-full-width",
    "title": "Table full width",
    "componentName": "TableFullWidthExample",
    "files": [
      "table-full-width-example.ts",
      "table-full-width-example.html"
    ],
    "selector": "table-full-width-example",
    "additionalComponents": [],
    "primaryFile": "table-full-width-example.ts",
    "importPath": "components/table"
  },
  "table-overview": {
    "packagePath": "components/table/table-overview",
    "title": "Table",
    "componentName": "TableOverviewExample",
    "files": [
      "table-overview-example.ts"
    ],
    "selector": "table-overview-example",
    "additionalComponents": [],
    "primaryFile": "table-overview-example.ts",
    "importPath": "components/table"
  },
  "table-with-borders": {
    "packagePath": "components/table/table-with-borders",
    "title": "Table with borders",
    "componentName": "TableWithBordersExample",
    "files": [
      "table-with-borders-example.ts"
    ],
    "selector": "table-with-borders-example",
    "additionalComponents": [],
    "primaryFile": "table-with-borders-example.ts",
    "importPath": "components/table"
  },
  "tabs-actionbar": {
    "packagePath": "components/tabs/tabs-actionbar",
    "title": "Tabs actionbar",
    "componentName": "TabsActionbarExample",
    "files": [
      "tabs-actionbar-example.ts",
      "tabs-actionbar-example.css"
    ],
    "selector": "tabs-actionbar-example",
    "additionalComponents": [],
    "primaryFile": "tabs-actionbar-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-active-tab-id": {
    "packagePath": "components/tabs/tabs-active-tab-id",
    "title": "Tab list with selection by tab id",
    "componentName": "TabsActiveTabIdExample",
    "files": [
      "tabs-active-tab-id-example.ts"
    ],
    "selector": "tabs-active-tab-id-example",
    "additionalComponents": [],
    "primaryFile": "tabs-active-tab-id-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-active-tab-index": {
    "packagePath": "components/tabs/tabs-active-tab-index",
    "title": "Tab list with selection by index",
    "componentName": "TabsActiveTabIndexExample",
    "files": [
      "tabs-active-tab-index-example.ts"
    ],
    "selector": "tabs-active-tab-index-example",
    "additionalComponents": [],
    "primaryFile": "tabs-active-tab-index-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-custom-label": {
    "packagePath": "components/tabs/tabs-custom-label",
    "title": "Tabs custom label",
    "componentName": "TabsCustomLabelExample",
    "files": [
      "tabs-custom-label-example.ts",
      "tabs-custom-label-example.css"
    ],
    "selector": "tabs-custom-label-example",
    "additionalComponents": [],
    "primaryFile": "tabs-custom-label-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-disabled": {
    "packagePath": "components/tabs/tabs-disabled",
    "title": "Tabs disabled",
    "componentName": "TabsDisabledExample",
    "files": [
      "tabs-disabled-example.ts"
    ],
    "selector": "tabs-disabled-example",
    "additionalComponents": [],
    "primaryFile": "tabs-disabled-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-empty-label": {
    "packagePath": "components/tabs/tabs-empty-label",
    "title": "Tabs empty label",
    "componentName": "TabsEmptyLabelExample",
    "files": [
      "tabs-empty-label-example.ts",
      "tabs-empty-label-example.css"
    ],
    "selector": "tabs-empty-label-example",
    "additionalComponents": [],
    "primaryFile": "tabs-empty-label-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-nav-bar-overview": {
    "packagePath": "components/tabs/tabs-nav-bar-overview",
    "title": "Tabs nav bar overview",
    "componentName": "TabsNavBarOverviewExample",
    "files": [
      "tabs-nav-bar-overview-example.ts"
    ],
    "selector": "tabs-nav-bar-overview-example",
    "additionalComponents": [],
    "primaryFile": "tabs-nav-bar-overview-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-overview": {
    "packagePath": "components/tabs/tabs-overview",
    "title": "Tabs overview",
    "componentName": "TabsOverviewExample",
    "files": [
      "tabs-overview-example.ts"
    ],
    "selector": "tabs-overview-example",
    "additionalComponents": [],
    "primaryFile": "tabs-overview-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-stretch": {
    "packagePath": "components/tabs/tabs-stretch",
    "title": "Tabs stretch",
    "componentName": "TabsStretchExample",
    "files": [
      "tabs-stretch-example.ts"
    ],
    "selector": "tabs-stretch-example",
    "additionalComponents": [],
    "primaryFile": "tabs-stretch-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-underlined": {
    "packagePath": "components/tabs/tabs-underlined",
    "title": "Tabs underlined",
    "componentName": "TabsUnderlinedExample",
    "files": [
      "tabs-underlined-example.ts"
    ],
    "selector": "tabs-underlined-example",
    "additionalComponents": [],
    "primaryFile": "tabs-underlined-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-vertical-icons": {
    "packagePath": "components/tabs/tabs-vertical-icons",
    "title": "Tabs vertical icons",
    "componentName": "TabsVerticalIconsExample",
    "files": [
      "tabs-vertical-icons-example.ts",
      "tabs-vertical-icons-example.css"
    ],
    "selector": "tabs-vertical-icons-example",
    "additionalComponents": [],
    "primaryFile": "tabs-vertical-icons-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-vertical": {
    "packagePath": "components/tabs/tabs-vertical",
    "title": "Tabs vertical",
    "componentName": "TabsVerticalExample",
    "files": [
      "tabs-vertical-example.ts",
      "tabs-vertical-example.css"
    ],
    "selector": "tabs-vertical-example",
    "additionalComponents": [],
    "primaryFile": "tabs-vertical-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-with-scroll-vertical": {
    "packagePath": "components/tabs/tabs-with-scroll-vertical",
    "title": "Tabs with scroll vertical",
    "componentName": "TabsWithScrollVerticalExample",
    "files": [
      "tabs-with-scroll-vertical-example.ts",
      "tabs-with-scroll-vertical-example.css"
    ],
    "selector": "tabs-with-scroll-vertical-example",
    "additionalComponents": [],
    "primaryFile": "tabs-with-scroll-vertical-example.ts",
    "importPath": "components/tabs"
  },
  "tabs-with-scroll": {
    "packagePath": "components/tabs/tabs-with-scroll",
    "title": "Tabs with scroll",
    "componentName": "TabsWithScrollExample",
    "files": [
      "tabs-with-scroll-example.ts"
    ],
    "selector": "tabs-with-scroll-example",
    "additionalComponents": [],
    "primaryFile": "tabs-with-scroll-example.ts",
    "importPath": "components/tabs"
  },
  "tag-autocomplete-option-operations": {
    "packagePath": "components/tag/tag-autocomplete-option-operations",
    "title": "Tag autocomplete option operations",
    "componentName": "TagAutocompleteOptionOperationsExample",
    "files": [
      "tag-autocomplete-option-operations-example.ts"
    ],
    "selector": "tag-autocomplete-option-operations-example",
    "additionalComponents": [],
    "primaryFile": "tag-autocomplete-option-operations-example.ts",
    "importPath": "components/tag"
  },
  "tag-autocomplete": {
    "packagePath": "components/tag/tag-autocomplete",
    "title": "Tag autocomplete",
    "componentName": "TagAutocompleteExample",
    "files": [
      "tag-autocomplete-example.ts"
    ],
    "selector": "tag-autocomplete-example",
    "additionalComponents": [],
    "primaryFile": "tag-autocomplete-example.ts",
    "importPath": "components/tag"
  },
  "tag-content": {
    "packagePath": "components/tag/tag-content",
    "title": "Tag content",
    "componentName": "TagContentExample",
    "files": [
      "tag-content-example.ts"
    ],
    "selector": "tag-content-example",
    "additionalComponents": [],
    "primaryFile": "tag-content-example.ts",
    "importPath": "components/tag"
  },
  "tag-fill-and-style": {
    "packagePath": "components/tag/tag-fill-and-style",
    "title": "Tag fill and style",
    "componentName": "TagFillAndStyleExample",
    "files": [
      "tag-fill-and-style-example.ts"
    ],
    "selector": "tag-fill-and-style-example",
    "additionalComponents": [],
    "primaryFile": "tag-fill-and-style-example.ts",
    "importPath": "components/tag"
  },
  "tag-hug-content": {
    "packagePath": "components/tag/tag-hug-content",
    "title": "Tag hug content",
    "componentName": "TagHugContentExample",
    "files": [
      "tag-hug-content-example.ts"
    ],
    "selector": "tag-hug-content-example",
    "additionalComponents": [],
    "primaryFile": "tag-hug-content-example.ts",
    "importPath": "components/tag"
  },
  "tag-input-with-form-control-validators": {
    "packagePath": "components/tag/tag-input-with-form-control-validators",
    "title": "Tag input with form control validators.",
    "componentName": "TagInputWithFormControlValidatorsExample",
    "files": [
      "tag-input-with-form-control-validators-example.ts"
    ],
    "selector": "tag-input-with-form-control-validators-example",
    "additionalComponents": [],
    "primaryFile": "tag-input-with-form-control-validators-example.ts",
    "importPath": "components/tag"
  },
  "tag-input": {
    "packagePath": "components/tag/tag-input",
    "title": "Tag input",
    "componentName": "TagInputExample",
    "files": [
      "tag-input-example.ts"
    ],
    "selector": "tag-input-example",
    "additionalComponents": [],
    "primaryFile": "tag-input-example.ts",
    "importPath": "components/tag"
  },
  "tag-list": {
    "packagePath": "components/tag/tag-list",
    "title": "Tag list",
    "componentName": "TagListExample",
    "files": [
      "tag-list-example.ts"
    ],
    "selector": "tag-list-example",
    "additionalComponents": [],
    "primaryFile": "tag-list-example.ts",
    "importPath": "components/tag"
  },
  "tag-overview": {
    "packagePath": "components/tag/tag-overview",
    "title": "Tag",
    "componentName": "TagOverviewExample",
    "files": [
      "tag-overview-example.ts"
    ],
    "selector": "tag-overview-example",
    "additionalComponents": [],
    "primaryFile": "tag-overview-example.ts",
    "importPath": "components/tag"
  },
  "tags-autocomplete-onpaste-off": {
    "packagePath": "components/tag/tags-autocomplete-onpaste-off",
    "title": "Tags autocomplete onpaste off",
    "componentName": "TagsAutocompleteOnpasteOffExample",
    "files": [
      "tags-autocomplete-onpaste-off-example.ts",
      "tags-autocomplete-onpaste-off-example.html"
    ],
    "selector": "tags-autocomplete-onpaste-off-example",
    "additionalComponents": [],
    "primaryFile": "tags-autocomplete-onpaste-off-example.ts",
    "importPath": "components/tag"
  },
  "tags-input-onpaste-off": {
    "packagePath": "components/tag/tags-input-onpaste-off",
    "title": "Tags input onpaste off",
    "componentName": "TagsInputOnpasteOffExample",
    "files": [
      "tags-input-onpaste-off-example.ts",
      "tags-input-onpaste-off-example.html"
    ],
    "selector": "tags-input-onpaste-off-example",
    "additionalComponents": [],
    "primaryFile": "tags-input-onpaste-off-example.ts",
    "importPath": "components/tag"
  },
  "text-area-overview": {
    "packagePath": "components/textarea/text-area-overview",
    "title": "Textarea",
    "componentName": "TextAreaOverviewExample",
    "files": [
      "text-area-overview-example.ts"
    ],
    "selector": "text-area-overview-example",
    "additionalComponents": [],
    "primaryFile": "text-area-overview-example.ts",
    "importPath": "components/textarea"
  },
  "timepicker-validation-symbols": {
    "packagePath": "components/timepicker/timepicker-validation-symbols",
    "title": "Timepicker validation symbols",
    "componentName": "TimepickerValidationSymbolsExample",
    "files": [
      "timepicker-validation-symbols-example.ts"
    ],
    "selector": "timepicker-validation-symbols-example",
    "additionalComponents": [],
    "primaryFile": "timepicker-validation-symbols-example.ts",
    "importPath": "components/timepicker"
  },
  "timepicker-variations": {
    "packagePath": "components/timepicker/timepicker-variations",
    "title": "Timepicker variations",
    "componentName": "TimepickerVariationsExample",
    "files": [
      "timepicker-variations-example.ts",
      "timepicker-variations-example.html",
      "timepicker-variations-example.css"
    ],
    "selector": "timepicker-variations-example",
    "additionalComponents": [],
    "primaryFile": "timepicker-variations-example.ts",
    "importPath": "components/timepicker"
  },
  "timezone-overview": {
    "packagePath": "components/timezone/timezone-overview",
    "title": "Timezone",
    "componentName": "TimezoneOverviewExample",
    "files": [
      "timezone-overview-example.ts"
    ],
    "selector": "timezone-overview-example",
    "additionalComponents": [],
    "primaryFile": "timezone-overview-example.ts",
    "importPath": "components/timezone"
  },
  "timezone-search-overview": {
    "packagePath": "components/timezone/timezone-search-overview",
    "title": "Timezone search",
    "componentName": "TimezoneSearchOverviewExample",
    "files": [
      "timezone-search-overview-example.ts"
    ],
    "selector": "timezone-search-overview-example",
    "additionalComponents": [],
    "primaryFile": "timezone-search-overview-example.ts",
    "importPath": "components/timezone"
  },
  "timezone-trigger-overview": {
    "packagePath": "components/timezone/timezone-trigger-overview",
    "title": "Timezone trigger",
    "componentName": "TimezoneTriggerOverviewExample",
    "files": [
      "timezone-trigger-overview-example.ts"
    ],
    "selector": "timezone-trigger-overview-example",
    "additionalComponents": [],
    "primaryFile": "timezone-trigger-overview-example.ts",
    "importPath": "components/timezone"
  },
  "toast-actions-overview": {
    "packagePath": "components/toast/toast-actions-overview",
    "title": "Toast actions",
    "componentName": "ToastActionsOverviewExample",
    "files": [
      "toast-actions-overview-example.ts",
      "toast-actions-overview-example.html"
    ],
    "selector": "toast-actions-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-actions-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-hide-overview": {
    "packagePath": "components/toast/toast-hide-overview",
    "title": "Toast hide",
    "componentName": "ToastHideOverviewExample",
    "files": [
      "toast-hide-overview-example.ts",
      "toast-hide-overview-example.html"
    ],
    "selector": "toast-hide-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-hide-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-link-overview": {
    "packagePath": "components/toast/toast-link-overview",
    "title": "Toast link",
    "componentName": "ToastLinkOverviewExample",
    "files": [
      "toast-link-overview-example.ts",
      "toast-link-overview-example.html"
    ],
    "selector": "toast-link-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-link-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-overview": {
    "packagePath": "components/toast/toast-overview",
    "title": "Basic Toast",
    "componentName": "ToastOverviewExample",
    "files": [
      "toast-overview-example.ts"
    ],
    "selector": "toast-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-progress-bar-overview": {
    "packagePath": "components/toast/toast-progress-bar-overview",
    "title": "Toast progress bar",
    "componentName": "ToastProgressBarOverviewExample",
    "files": [
      "toast-progress-bar-overview-example.ts"
    ],
    "selector": "toast-progress-bar-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-progress-bar-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-report-overview": {
    "packagePath": "components/toast/toast-report-overview",
    "title": "Toast report",
    "componentName": "ToastReportOverviewExample",
    "files": [
      "toast-report-overview-example.ts"
    ],
    "selector": "toast-report-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-report-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-types-overview": {
    "packagePath": "components/toast/toast-types-overview",
    "title": "Toast types",
    "componentName": "ToastTypesOverviewExample",
    "files": [
      "toast-types-overview-example.ts",
      "toast-types-overview-example.html"
    ],
    "selector": "toast-types-overview-example",
    "additionalComponents": [],
    "primaryFile": "toast-types-overview-example.ts",
    "importPath": "components/toast"
  },
  "toast-user-data": {
    "packagePath": "components/toast/toast-user-data",
    "title": "Toast user data",
    "componentName": "ToastUserDataExample",
    "files": [
      "toast-user-data-example.ts",
      "toast-user-data-example.html"
    ],
    "selector": "toast-user-data-example",
    "additionalComponents": [],
    "primaryFile": "toast-user-data-example.ts",
    "importPath": "components/toast"
  },
  "toggle-overview": {
    "packagePath": "components/toggle/toggle-overview",
    "title": "Toggle",
    "componentName": "ToggleOverviewExample",
    "files": [
      "toggle-overview-example.ts",
      "toggle-overview-example.html"
    ],
    "selector": "toggle-overview-example",
    "additionalComponents": [],
    "primaryFile": "toggle-overview-example.ts",
    "importPath": "components/toggle"
  },
  "tooltip-arrow-and-offset": {
    "packagePath": "components/tooltip/tooltip-arrow-and-offset",
    "title": "Tooltip arrow and offset example",
    "componentName": "TooltipArrowAndOffsetExample",
    "files": [
      "tooltip-arrow-and-offset-example.ts"
    ],
    "selector": "tooltip-arrow-and-offset-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-arrow-and-offset-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-extended": {
    "packagePath": "components/tooltip/tooltip-extended",
    "title": "Tooltip extended",
    "componentName": "TooltipExtendedExample",
    "files": [
      "tooltip-extended-example.ts"
    ],
    "selector": "tooltip-extended-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-extended-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-long": {
    "packagePath": "components/tooltip/tooltip-long",
    "title": "Tooltip long",
    "componentName": "TooltipLongExample",
    "files": [
      "tooltip-long-example.ts"
    ],
    "selector": "tooltip-long-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-long-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-multiple-lines": {
    "packagePath": "components/tooltip/tooltip-multiple-lines",
    "title": "Tooltip multiple lines",
    "componentName": "TooltipMultipleLinesExample",
    "files": [
      "tooltip-multiple-lines-example.ts"
    ],
    "selector": "tooltip-multiple-lines-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-multiple-lines-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-overview": {
    "packagePath": "components/tooltip/tooltip-overview",
    "title": "Tooltip",
    "componentName": "TooltipOverviewExample",
    "files": [
      "tooltip-overview-example.ts"
    ],
    "selector": "tooltip-overview-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-overview-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-placement-center": {
    "packagePath": "components/tooltip/tooltip-placement-center",
    "title": "Tooltip placement center",
    "componentName": "TooltipPlacementCenterExample",
    "files": [
      "tooltip-placement-center-example.ts",
      "tooltip-placement-center-example.css"
    ],
    "selector": "tooltip-placement-center-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-placement-center-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-placement-edges": {
    "packagePath": "components/tooltip/tooltip-placement-edges",
    "title": "Tooltip placement edges",
    "componentName": "TooltipPlacementEdgesExample",
    "files": [
      "tooltip-placement-edges-example.ts",
      "tooltip-placement-edges-example.css"
    ],
    "selector": "tooltip-placement-edges-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-placement-edges-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-relative-to-pointer": {
    "packagePath": "components/tooltip/tooltip-relative-to-pointer",
    "title": "Tooltip relative to pointer",
    "componentName": "TooltipRelativeToPointerExample",
    "files": [
      "tooltip-relative-to-pointer-example.ts"
    ],
    "selector": "tooltip-relative-to-pointer-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-relative-to-pointer-example.ts",
    "importPath": "components/tooltip"
  },
  "tooltip-style": {
    "packagePath": "components/tooltip/tooltip-style",
    "title": "Tooltip style",
    "componentName": "TooltipStyleExample",
    "files": [
      "tooltip-style-example.ts"
    ],
    "selector": "tooltip-style-example",
    "additionalComponents": [],
    "primaryFile": "tooltip-style-example.ts",
    "importPath": "components/tooltip"
  },
  "tree-select-child-selection-overview": {
    "packagePath": "components/tree-select/tree-select-child-selection-overview",
    "title": "Tree-select child selection",
    "componentName": "TreeSelectChildSelectionOverviewExample",
    "files": [
      "tree-select-child-selection-overview-example.ts"
    ],
    "selector": "tree-select-child-selection-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-child-selection-overview-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-select-footer-overview": {
    "packagePath": "components/tree-select/tree-select-footer-overview",
    "title": "Tree-select footer",
    "componentName": "TreeSelectFooterOverviewExample",
    "files": [
      "tree-select-footer-overview-example.ts"
    ],
    "selector": "tree-select-footer-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-footer-overview-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-select-lazyload": {
    "packagePath": "components/tree-select/tree-select-lazyload",
    "title": "Tree-select lazyload",
    "componentName": "TreeSelectLazyloadExample",
    "files": [
      "tree-select-lazyload-example.ts"
    ],
    "selector": "tree-select-lazyload-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-lazyload-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-select-multiple-overview": {
    "packagePath": "components/tree-select/tree-select-multiple-overview",
    "title": "Tree-select multiple",
    "componentName": "TreeSelectMultipleOverviewExample",
    "files": [
      "tree-select-multiple-overview-example.ts"
    ],
    "selector": "tree-select-multiple-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-multiple-overview-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-select-overview": {
    "packagePath": "components/tree-select/tree-select-overview",
    "title": "Tree-select",
    "componentName": "TreeSelectOverviewExample",
    "files": [
      "tree-select-overview-example.ts"
    ],
    "selector": "tree-select-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-overview-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-select-search-overview": {
    "packagePath": "components/tree-select/tree-select-search-overview",
    "title": "Tree-select search",
    "componentName": "TreeSelectSearchOverviewExample",
    "files": [
      "tree-select-search-overview-example.ts"
    ],
    "selector": "tree-select-search-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-select-search-overview-example.ts",
    "importPath": "components/tree-select"
  },
  "tree-access-rights": {
    "packagePath": "components/tree/tree-access-rights",
    "title": "Tree access rights",
    "componentName": "TreeAccessRightsExample",
    "files": [
      "tree-access-rights-example.ts"
    ],
    "selector": "tree-access-rights-example",
    "additionalComponents": [],
    "primaryFile": "tree-access-rights-example.ts",
    "importPath": "components/tree"
  },
  "tree-action-button": {
    "packagePath": "components/tree/tree-action-button",
    "title": "Tree action button",
    "componentName": "TreeActionButtonExample",
    "files": [
      "tree-action-button-example.ts"
    ],
    "selector": "tree-action-button-example",
    "additionalComponents": [],
    "primaryFile": "tree-action-button-example.ts",
    "importPath": "components/tree"
  },
  "tree-checked-filtering": {
    "packagePath": "components/tree/tree-checked-filtering",
    "title": "Tree checked filtering",
    "componentName": "TreeCheckedFilteringExample",
    "files": [
      "tree-checked-filtering-example.ts"
    ],
    "selector": "tree-checked-filtering-example",
    "additionalComponents": [],
    "primaryFile": "tree-checked-filtering-example.ts",
    "importPath": "components/tree"
  },
  "tree-custom-filtering": {
    "packagePath": "components/tree/tree-custom-filtering",
    "title": "Tree custom filtering",
    "componentName": "TreeCustomFilteringExample",
    "files": [
      "tree-custom-filtering-example.ts"
    ],
    "selector": "tree-custom-filtering-example",
    "additionalComponents": [],
    "primaryFile": "tree-custom-filtering-example.ts",
    "importPath": "components/tree"
  },
  "tree-descendants-subcategories": {
    "packagePath": "components/tree/tree-descendants-subcategories",
    "title": "Tree descendants subcategories",
    "componentName": "TreeDescendantsSubcategoriesExample",
    "files": [
      "tree-descendants-subcategories-example.ts"
    ],
    "selector": "tree-descendants-subcategories-example",
    "additionalComponents": [],
    "primaryFile": "tree-descendants-subcategories-example.ts",
    "importPath": "components/tree"
  },
  "tree-filtering": {
    "packagePath": "components/tree/tree-filtering",
    "title": "Tree filtering",
    "componentName": "TreeFilteringExample",
    "files": [
      "tree-filtering-example.ts"
    ],
    "selector": "tree-filtering-example",
    "additionalComponents": [],
    "primaryFile": "tree-filtering-example.ts",
    "importPath": "components/tree"
  },
  "tree-lazyload": {
    "packagePath": "components/tree/tree-lazyload",
    "title": "Tree lazyload",
    "componentName": "TreeLazyloadExample",
    "files": [
      "tree-lazyload-example.ts"
    ],
    "selector": "tree-lazyload-example",
    "additionalComponents": [],
    "primaryFile": "tree-lazyload-example.ts",
    "importPath": "components/tree"
  },
  "tree-multiple-checkbox": {
    "packagePath": "components/tree/tree-multiple-checkbox",
    "title": "Tree multiple checkbox",
    "componentName": "TreeMultipleCheckboxExample",
    "files": [
      "tree-multiple-checkbox-example.ts"
    ],
    "selector": "tree-multiple-checkbox-example",
    "additionalComponents": [],
    "primaryFile": "tree-multiple-checkbox-example.ts",
    "importPath": "components/tree"
  },
  "tree-multiple-checklist": {
    "packagePath": "components/tree/tree-multiple-checklist",
    "title": "Tree multiple checklist",
    "componentName": "TreeMultipleChecklistExample",
    "files": [
      "tree-multiple-checklist-example.ts"
    ],
    "selector": "tree-multiple-checklist-example",
    "additionalComponents": [],
    "primaryFile": "tree-multiple-checklist-example.ts",
    "importPath": "components/tree"
  },
  "tree-multiple-keyboard": {
    "packagePath": "components/tree/tree-multiple-keyboard",
    "title": "Tree multiple keyboard",
    "componentName": "TreeMultipleKeyboardExample",
    "files": [
      "tree-multiple-keyboard-example.ts"
    ],
    "selector": "tree-multiple-keyboard-example",
    "additionalComponents": [],
    "primaryFile": "tree-multiple-keyboard-example.ts",
    "importPath": "components/tree"
  },
  "tree-overview": {
    "packagePath": "components/tree/tree-overview",
    "title": "Tree",
    "componentName": "TreeOverviewExample",
    "files": [
      "tree-overview-example.ts"
    ],
    "selector": "tree-overview-example",
    "additionalComponents": [],
    "primaryFile": "tree-overview-example.ts",
    "importPath": "components/tree"
  },
  "typography-overview": {
    "packagePath": "components/typography/typography-overview",
    "title": "Typography",
    "componentName": "TypographyOverviewExample",
    "files": [
      "typography-overview-example.ts",
      "typography-overview-example.html"
    ],
    "selector": "typography-overview-example",
    "additionalComponents": [],
    "primaryFile": "typography-overview-example.ts",
    "importPath": "components/typography"
  },
  "validation-composite": {
    "packagePath": "components/validation/validation-composite",
    "title": "Validation composite",
    "componentName": "ValidationCompositeExample",
    "files": [
      "validation-composite-example.ts",
      "validation-composite-example.html"
    ],
    "selector": "validation-composite-example",
    "additionalComponents": [],
    "primaryFile": "validation-composite-example.ts",
    "importPath": "components/validation"
  },
  "validation-global-one-required": {
    "packagePath": "components/validation/validation-global-one-required",
    "title": "Validation global one required",
    "componentName": "ValidationGlobalOneRequiredExample",
    "files": [
      "validation-global-one-required-example.ts",
      "validation-global-one-required-example.html"
    ],
    "selector": "validation-global-one-required-example",
    "additionalComponents": [],
    "primaryFile": "validation-global-one-required-example.ts",
    "importPath": "components/validation"
  },
  "validation-global": {
    "packagePath": "components/validation/validation-global",
    "title": "Validation global",
    "componentName": "ValidationGlobalExample",
    "files": [
      "validation-global-example.ts",
      "validation-global-example.html"
    ],
    "selector": "validation-global-example",
    "additionalComponents": [],
    "primaryFile": "validation-global-example.ts",
    "importPath": "components/validation"
  },
  "validation-on-blur": {
    "packagePath": "components/validation/validation-on-blur",
    "title": "Validation on blur",
    "componentName": "ValidationOnBlurExample",
    "files": [
      "validation-on-blur-example.ts",
      "validation-on-blur-example.html"
    ],
    "selector": "validation-on-blur-example",
    "additionalComponents": [],
    "primaryFile": "validation-on-blur-example.ts",
    "importPath": "components/validation"
  },
  "validation-on-type": {
    "packagePath": "components/validation/validation-on-type",
    "title": "Validation on type",
    "componentName": "ValidationOnTypeExample",
    "files": [
      "validation-on-type-example.ts",
      "validation-on-type-example.html"
    ],
    "selector": "validation-on-type-example",
    "additionalComponents": [],
    "primaryFile": "validation-on-type-example.ts",
    "importPath": "components/validation"
  },
  "validation-overview": {
    "packagePath": "components/validation/validation-overview",
    "title": "Validation",
    "componentName": "ValidationOverviewExample",
    "files": [
      "validation-overview-example.ts",
      "validation-overview-example.html"
    ],
    "selector": "validation-overview-example",
    "additionalComponents": [],
    "primaryFile": "validation-overview-example.ts",
    "importPath": "components/validation"
  },
  "validation-small": {
    "packagePath": "components/validation/validation-small",
    "title": "Validation small",
    "componentName": "ValidationSmallExample",
    "files": [
      "validation-small-example.ts",
      "validation-small-example.html"
    ],
    "selector": "validation-small-example",
    "additionalComponents": [],
    "primaryFile": "validation-small-example.ts",
    "importPath": "components/validation"
  }
};
export async function loadExample(id: string): Promise<any> {
  switch (id) {
  case 'accordion-content':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-header':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-in-panel':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-in-section':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-inactive-section':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-overview':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-sections':
return import('@koobiq/docs-examples/components/accordion');
  case 'accordion-states':
return import('@koobiq/docs-examples/components/accordion');
  case 'alert-close':
return import('@koobiq/docs-examples/components/alert');
  case 'alert-content':
return import('@koobiq/docs-examples/components/alert');
  case 'alert-size':
return import('@koobiq/docs-examples/components/alert');
  case 'alert-status':
return import('@koobiq/docs-examples/components/alert');
  case 'alert-variants':
return import('@koobiq/docs-examples/components/alert');
  case 'autocomplete-overview':
return import('@koobiq/docs-examples/components/autocomplete');
  case 'badge-content':
return import('@koobiq/docs-examples/components/badge');
  case 'badge-fill-and-style':
return import('@koobiq/docs-examples/components/badge');
  case 'badge-list':
return import('@koobiq/docs-examples/components/badge');
  case 'badge-size':
return import('@koobiq/docs-examples/components/badge');
  case 'badge-table':
return import('@koobiq/docs-examples/components/badge');
  case 'badge-tooltip':
return import('@koobiq/docs-examples/components/badge');
  case 'button-toggle-alignment-overview':
return import('@koobiq/docs-examples/components/button-toggle');
  case 'button-toggle-disabled-all-overview':
return import('@koobiq/docs-examples/components/button-toggle');
  case 'button-toggle-disabled-partial-overview':
return import('@koobiq/docs-examples/components/button-toggle');
  case 'button-toggle-overview':
return import('@koobiq/docs-examples/components/button-toggle');
  case 'button-toggle-tooltip-overview':
return import('@koobiq/docs-examples/components/button-toggle');
  case 'button-content':
return import('@koobiq/docs-examples/components/button');
  case 'button-fill-and-style':
return import('@koobiq/docs-examples/components/button');
  case 'button-fill-content':
return import('@koobiq/docs-examples/components/button');
  case 'button-fixed-content':
return import('@koobiq/docs-examples/components/button');
  case 'button-hug-content':
return import('@koobiq/docs-examples/components/button');
  case 'button-loading-state':
return import('@koobiq/docs-examples/components/button');
  case 'button-overview':
return import('@koobiq/docs-examples/components/button');
  case 'checkbox-indeterminate':
return import('@koobiq/docs-examples/components/checkbox');
  case 'checkbox-overview':
return import('@koobiq/docs-examples/components/checkbox');
  case 'pseudo-checkbox':
return import('@koobiq/docs-examples/components/checkbox');
  case 'code-block-with-custom-locale-configuration':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-filled':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-line-numbers':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-link':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-max-height':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-no-border':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-soft-wrap':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-tabs-and-shadow':
return import('@koobiq/docs-examples/components/code-block');
  case 'code-block-with-tabs':
return import('@koobiq/docs-examples/components/code-block');
  case 'absolute-date-formatter':
return import('@koobiq/docs-examples/components/date-formatter');
  case 'duration-date-formatter':
return import('@koobiq/docs-examples/components/date-formatter');
  case 'range-date-formatter':
return import('@koobiq/docs-examples/components/date-formatter');
  case 'relative-date-formatter':
return import('@koobiq/docs-examples/components/date-formatter');
  case 'datepicker-and-timepicker':
return import('@koobiq/docs-examples/components/datepicker');
  case 'datepicker-inactive':
return import('@koobiq/docs-examples/components/datepicker');
  case 'datepicker-minimax':
return import('@koobiq/docs-examples/components/datepicker');
  case 'datepicker-overview':
return import('@koobiq/docs-examples/components/datepicker');
  case 'datepicker-range':
return import('@koobiq/docs-examples/components/datepicker');
  case 'datepicker-required':
return import('@koobiq/docs-examples/components/datepicker');
  case 'divider-overview':
return import('@koobiq/docs-examples/components/divider');
  case 'divider-vertical':
return import('@koobiq/docs-examples/components/divider');
  case 'dl-horizontal-overview':
return import('@koobiq/docs-examples/components/dl');
  case 'dl-overview':
return import('@koobiq/docs-examples/components/dl');
  case 'dl-small':
return import('@koobiq/docs-examples/components/dl');
  case 'dl-vertical-overview':
return import('@koobiq/docs-examples/components/dl');
  case 'dropdown-disabled':
return import('@koobiq/docs-examples/components/dropdown');
  case 'dropdown-lazyload-data':
return import('@koobiq/docs-examples/components/dropdown');
  case 'dropdown-navigation-wrap':
return import('@koobiq/docs-examples/components/dropdown');
  case 'dropdown-nested':
return import('@koobiq/docs-examples/components/dropdown');
  case 'dropdown-open-by-arrow-down':
return import('@koobiq/docs-examples/components/dropdown');
  case 'dropdown-overview':
return import('@koobiq/docs-examples/components/dropdown');
  case 'empty-state-actions':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-actions2':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-align':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-big':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-content':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-default':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-error':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-icon':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-text-only':
return import('@koobiq/docs-examples/components/empty-state');
  case 'empty-state-title':
return import('@koobiq/docs-examples/components/empty-state');
  case 'file-upload-cva-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-indeterminate-loading-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-multiple-compact-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-multiple-custom-text-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-multiple-default-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-multiple-default-validation-reactive-forms-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-multiple-error-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-single-error-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-single-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'file-upload-single-validation-reactive-forms-overview':
return import('@koobiq/docs-examples/components/file-upload');
  case 'form-field-password-overview':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-cleaner':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-custom-error-state-matcher-set-by-attribute':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-custom-error-state-matcher-set-by-dependency-injection-provider':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-error':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-hint':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-label':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-with-prefix-and-suffix':
return import('@koobiq/docs-examples/components/form-field');
  case 'form-field-without-borders':
return import('@koobiq/docs-examples/components/form-field');
  case 'horizontal-form-labels':
return import('@koobiq/docs-examples/components/forms');
  case 'horizontal-form':
return import('@koobiq/docs-examples/components/forms');
  case 'vertical-form':
return import('@koobiq/docs-examples/components/forms');
  case 'icon-item-color':
return import('@koobiq/docs-examples/components/icon-item');
  case 'icon-item-default':
return import('@koobiq/docs-examples/components/icon-item');
  case 'icon-item-size':
return import('@koobiq/docs-examples/components/icon-item');
  case 'icon-item-variant':
return import('@koobiq/docs-examples/components/icon-item');
  case 'input-number-overview':
return import('@koobiq/docs-examples/components/input');
  case 'input-overview':
return import('@koobiq/docs-examples/components/input');
  case 'input-password-overview':
return import('@koobiq/docs-examples/components/input');
  case 'layout-flex-alignment':
return import('@koobiq/docs-examples/components/layout-flex');
  case 'layout-flex-behaviour-modifiers':
return import('@koobiq/docs-examples/components/layout-flex');
  case 'layout-flex-offsets':
return import('@koobiq/docs-examples/components/layout-flex');
  case 'layout-flex-order':
return import('@koobiq/docs-examples/components/layout-flex');
  case 'layout-flex-overview':
return import('@koobiq/docs-examples/components/layout-flex');
  case 'link-application':
return import('@koobiq/docs-examples/components/link');
  case 'link-caption':
return import('@koobiq/docs-examples/components/link');
  case 'link-color':
return import('@koobiq/docs-examples/components/link');
  case 'link-disabled':
return import('@koobiq/docs-examples/components/link');
  case 'link-external':
return import('@koobiq/docs-examples/components/link');
  case 'link-general':
return import('@koobiq/docs-examples/components/link');
  case 'link-icons':
return import('@koobiq/docs-examples/components/link');
  case 'link-multi-line':
return import('@koobiq/docs-examples/components/link');
  case 'link-overview':
return import('@koobiq/docs-examples/components/link');
  case 'link-prepositions':
return import('@koobiq/docs-examples/components/link');
  case 'link-print':
return import('@koobiq/docs-examples/components/link');
  case 'link-pseudo':
return import('@koobiq/docs-examples/components/link');
  case 'link-target-blank':
return import('@koobiq/docs-examples/components/link');
  case 'link-visited':
return import('@koobiq/docs-examples/components/link');
  case 'list-action-button':
return import('@koobiq/docs-examples/components/list');
  case 'list-groups':
return import('@koobiq/docs-examples/components/list');
  case 'list-multiple-checkbox':
return import('@koobiq/docs-examples/components/list');
  case 'list-multiple-keyboard':
return import('@koobiq/docs-examples/components/list');
  case 'list-overview':
return import('@koobiq/docs-examples/components/list');
  case 'loader-overlay-default':
return import('@koobiq/docs-examples/components/loader-overlay');
  case 'loader-overlay-fixed-top':
return import('@koobiq/docs-examples/components/loader-overlay');
  case 'loader-overlay-large':
return import('@koobiq/docs-examples/components/loader-overlay');
  case 'loader-overlay-overview':
return import('@koobiq/docs-examples/components/loader-overlay');
  case 'markdown-article':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-code-block':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-code':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-divider':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-headers-combinations':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-headers':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-image':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-line-break':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-link':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-list':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-paragraph':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-quote':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-selection':
return import('@koobiq/docs-examples/components/markdown');
  case 'markdown-table':
return import('@koobiq/docs-examples/components/markdown');
  case 'modal-component':
return import('@koobiq/docs-examples/components/modal');
  case 'modal-multiple':
return import('@koobiq/docs-examples/components/modal');
  case 'modal-overview':
return import('@koobiq/docs-examples/components/modal');
  case 'modal-scroll':
return import('@koobiq/docs-examples/components/modal');
  case 'modal-sizes':
return import('@koobiq/docs-examples/components/modal');
  case 'modal-template':
return import('@koobiq/docs-examples/components/modal');
  case 'navbar-overview':
return import('@koobiq/docs-examples/components/navbar');
  case 'navbar-vertical-open-over':
return import('@koobiq/docs-examples/components/navbar');
  case 'navbar-vertical':
return import('@koobiq/docs-examples/components/navbar');
  case 'number-formatter-overview':
return import('@koobiq/docs-examples/components/number-formatter');
  case 'popover-close':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-common':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-content':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-header':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-height':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-placement-center':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-placement-edges':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-scroll':
return import('@koobiq/docs-examples/components/popover');
  case 'popover-width':
return import('@koobiq/docs-examples/components/popover');
  case 'progress-bar-indeterminate':
return import('@koobiq/docs-examples/components/progress-bar');
  case 'progress-bar-overview':
return import('@koobiq/docs-examples/components/progress-bar');
  case 'progress-spinner-indeterminate':
return import('@koobiq/docs-examples/components/progress-spinner');
  case 'progress-spinner-overview':
return import('@koobiq/docs-examples/components/progress-spinner');
  case 'radio-content':
return import('@koobiq/docs-examples/components/radio');
  case 'radio-group':
return import('@koobiq/docs-examples/components/radio');
  case 'radio-size':
return import('@koobiq/docs-examples/components/radio');
  case 'radio-style':
return import('@koobiq/docs-examples/components/radio');
  case 'scrollbar-scroll-to-top':
return import('@koobiq/docs-examples/components/scrollbar');
  case 'scrollbar-with-custom-config':
return import('@koobiq/docs-examples/components/scrollbar');
  case 'scrollbar-with-options':
return import('@koobiq/docs-examples/components/scrollbar');
  case 'select-cleaner':
return import('@koobiq/docs-examples/components/select');
  case 'select-disabled':
return import('@koobiq/docs-examples/components/select');
  case 'select-footer':
return import('@koobiq/docs-examples/components/select');
  case 'select-groups':
return import('@koobiq/docs-examples/components/select');
  case 'select-height':
return import('@koobiq/docs-examples/components/select');
  case 'select-icon':
return import('@koobiq/docs-examples/components/select');
  case 'select-multiple':
return import('@koobiq/docs-examples/components/select');
  case 'select-overview':
return import('@koobiq/docs-examples/components/select');
  case 'select-prioritized-selected':
return import('@koobiq/docs-examples/components/select');
  case 'select-search':
return import('@koobiq/docs-examples/components/select');
  case 'select-validation':
return import('@koobiq/docs-examples/components/select');
  case 'select-virtual-scroll':
return import('@koobiq/docs-examples/components/select');
  case 'select-with-panel-width-attribute':
return import('@koobiq/docs-examples/components/select');
  case 'sidepanel-modal-mode':
return import('@koobiq/docs-examples/components/sidepanel');
  case 'sidepanel-normal-mode':
return import('@koobiq/docs-examples/components/sidepanel');
  case 'sidepanel-overlayed':
return import('@koobiq/docs-examples/components/sidepanel');
  case 'sidepanel-sizes':
return import('@koobiq/docs-examples/components/sidepanel');
  case 'splitter-dynamic-data':
return import('@koobiq/docs-examples/components/splitter');
  case 'splitter-fixed':
return import('@koobiq/docs-examples/components/splitter');
  case 'splitter-nested':
return import('@koobiq/docs-examples/components/splitter');
  case 'splitter-overview':
return import('@koobiq/docs-examples/components/splitter');
  case 'splitter-vertical':
return import('@koobiq/docs-examples/components/splitter');
  case 'table-full-width':
return import('@koobiq/docs-examples/components/table');
  case 'table-overview':
return import('@koobiq/docs-examples/components/table');
  case 'table-with-borders':
return import('@koobiq/docs-examples/components/table');
  case 'tabs-actionbar':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-active-tab-id':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-active-tab-index':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-custom-label':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-disabled':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-empty-label':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-nav-bar-overview':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-overview':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-stretch':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-underlined':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-vertical-icons':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-vertical':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-with-scroll-vertical':
return import('@koobiq/docs-examples/components/tabs');
  case 'tabs-with-scroll':
return import('@koobiq/docs-examples/components/tabs');
  case 'tag-autocomplete-option-operations':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-autocomplete':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-content':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-fill-and-style':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-hug-content':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-input-with-form-control-validators':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-input':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-list':
return import('@koobiq/docs-examples/components/tag');
  case 'tag-overview':
return import('@koobiq/docs-examples/components/tag');
  case 'tags-autocomplete-onpaste-off':
return import('@koobiq/docs-examples/components/tag');
  case 'tags-input-onpaste-off':
return import('@koobiq/docs-examples/components/tag');
  case 'text-area-overview':
return import('@koobiq/docs-examples/components/textarea');
  case 'timepicker-validation-symbols':
return import('@koobiq/docs-examples/components/timepicker');
  case 'timepicker-variations':
return import('@koobiq/docs-examples/components/timepicker');
  case 'timezone-overview':
return import('@koobiq/docs-examples/components/timezone');
  case 'timezone-search-overview':
return import('@koobiq/docs-examples/components/timezone');
  case 'timezone-trigger-overview':
return import('@koobiq/docs-examples/components/timezone');
  case 'toast-actions-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-hide-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-link-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-progress-bar-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-report-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-types-overview':
return import('@koobiq/docs-examples/components/toast');
  case 'toast-user-data':
return import('@koobiq/docs-examples/components/toast');
  case 'toggle-overview':
return import('@koobiq/docs-examples/components/toggle');
  case 'tooltip-arrow-and-offset':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-extended':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-long':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-multiple-lines':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-overview':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-placement-center':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-placement-edges':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-relative-to-pointer':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tooltip-style':
return import('@koobiq/docs-examples/components/tooltip');
  case 'tree-select-child-selection-overview':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-select-footer-overview':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-select-lazyload':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-select-multiple-overview':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-select-overview':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-select-search-overview':
return import('@koobiq/docs-examples/components/tree-select');
  case 'tree-access-rights':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-action-button':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-checked-filtering':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-custom-filtering':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-descendants-subcategories':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-filtering':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-lazyload':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-multiple-checkbox':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-multiple-checklist':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-multiple-keyboard':
return import('@koobiq/docs-examples/components/tree');
  case 'tree-overview':
return import('@koobiq/docs-examples/components/tree');
  case 'typography-overview':
return import('@koobiq/docs-examples/components/typography');
  case 'validation-composite':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-global-one-required':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-global':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-on-blur':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-on-type':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-overview':
return import('@koobiq/docs-examples/components/validation');
  case 'validation-small':
return import('@koobiq/docs-examples/components/validation');
    default:
return undefined;
  }
}