Тултип (tooltip) — подсказка, которая появляется при наведении указателя или при фокусе на элемент интерфейса.
В тултипе не может быть интерактивных элементов.

### Когда использовать

-   Для коротких поясняющих текстов об элементах интерфейса.
-   Для вывода подписей к иконкам, рядом с которыми нет текста со значением.
-   Если текст не помещается в отведенном месте и обрезается многоточием (например, в колонках таблицы). В этом случае
    в тултипе выводится полный текст.
-   Если нужно показать подсказку с заголовками, списками, таблицей и т. д.

### Структура компонента

#### Вариации

Нестандартный тултип всегда предпочтительнее системного. Не используйте системный и нестандартный тултип в одном интерфейсе.

##### Простой

-   Тело тултипа с текстом
-   Указатель-дятел

Ширина тултипа зависит от содержимого; максимум — 300 пикселей.

Высота тултипа зависит от содержимого.

Текст тултипа должен оставаться очень кратким, в идеале не больше 70 символов.

<div style="margin-top: 15px;">
    <img src="./assets/images/tooltip/tooltip__structure.png" alt="tooltip structure" style="max-width: 240px"/>
</div>

<br>

Тултип может занимать более одной строки:

<!-- example(tooltip-multiple-lines) -->

Иногда удобнее, если текст в тултипе не переносится, а написан в одну строку, например при сравнении хеш-сумм,
выводе адресов электронной почты или путей к файлам и папкам. Для подобных случаев максимальную ширину тултипа можно
не устанавливать:

<!-- example(tooltip-long) -->

##### Сложный

-   Тело тултипа
-   Указатель-дятел
-   Шапка (необязательно)

Не используйте интерактивные элементы (кнопки, ссылки и пр.) в сложном тултипе, пользоваться ими, как правило, просто
невозможно. Если нужно использовать интерактивные элементы, возьмите [поповер](/components/popover).

<div style="margin-top: 5px;">
    <img src="./assets/images/tooltip/tooltip-hard__structure.jpg" alt="tooltip hard structure"/>
</div>

##### Размеры

В отличие от простого тултипа, сложный имеет фиксированную ширину. Чтобы оптимально использовать пространство,
полезно заложить несколько вариантов ширины.

Высота тултипа зависит от контента. Рекомендуемая максимальная высота — 480px (может быть увеличена
по усмотрению дизайнера).

### Описание работы

#### Как открыть

-   Навести указатель на триггерный элемент
-   Фокус

#### Как закрыть

-   Убрать указатель с триггерного элемента
-   Убрать фокус
-   Проскроллить страницу
-   Нажать клавишу Esc

#### Задержка

-   При наведении курсора на элемент тултип появляется с задержкой 0,4 секунды.
-   При переключении фокуса или наведении на другой элемент с тултипом задержка работает по следующему принципу:
    -   первый тултип появляется с задержкой 0,4 секунды,
    -   последующие тултипы появляются мгновенно,
    -   если тултип от предыдущего элемента исчез и прошло больше 2 секунд, то снова появляется задержка 0,4 секунды.
-   Тултип исчезает мгновенно.

### Выравнивание

Учитывайте контекст, в котором появляется тултип. Настройте выравнивание так, чтобы он не закрывал важный контент.

#### По центру элемента

Указатель по центру тултипа, целится в центр триггерного элемента.

<!-- example(tooltip-placement-center) -->

#### По краю элемента

Край тултипа выравнивается по краю триггерного элемента, указатель на фиксированном расстоянии от края тултипа.
Если элемент слишком маленький, указатель выравнивается по центру элемента.

<!-- example(tooltip-placement-edges) -->

#### Относительно курсора

<!-- example(tooltip-relative-to-pointer) -->

**Динамическое выравнивание**

Если для тултипа не хватает места, он попытается перейти в другое положение. Например, из положения «снизу в центре»
в положение «сверху в центре».

### Стилизация тултипов

#### Простой тултип

Для светлой темы используется темный тултип. Для темной темы используется светлый тултип.

Для предупреждений используется отдельный вид тултипов. Например, он появляется при попытке ввода запрещенного символа
в поле (подробнее см. [Валидация](/other/validation))

<!-- example(tooltip-overview) -->

#### Сложный тултип

В сложном тултипе все наоборот: для светлой темы используется светлый тултип, а для темной темы используется темный.

Предупреждающий не используется.

<!-- example(tooltip-extended) -->

#### Стиль

<!-- example(tooltip-style) -->

#### Указатель и смещение

<!-- example(tooltip-arrow-and-offset) -->

### Связанные компоненты

[Дропдаун](/components/dropdown) — кнопка-меню, открывающая список доступных действий.

[Поповер](/components/popover) — небольшой немодальный диалог без затемнения, который открывается рядом с триггерным
элементом. Он может содержать текст, поля ввода, любые элементы управления.
