Селект — позволяет пользователю выбрать одно или несколько значений из предопределенного списка.

<!-- example(select-overview) -->

### Состояния

#### Валидация

<!-- example(select-validation) -->

#### Неактивные состояния

<!-- example(select-disabled) -->

#### Сброс выбранного значения

При единичном выборе значения контрол сброса скрыт. Его отображение можно включить отдельно.

<!-- example(select-cleaner) -->

#### Множественный выбор

<!-- example(select-multiple) -->

#### Группировка значений

<!-- example(select-groups) -->

#### Наполнение списка значений

##### Список с поиском

Используйте поиск, когда в списке больше 10 элементов.

Поиск может осуществляться по первым символам или полному совпадению, в зависимости от конкретной задачи и предпочтений пользователей.

<!-- example(select-search) -->

##### Список с нижним колонтитулом

Если необходимо расположить дополнительные контролы, можно включить отображение нижнего колонтитула. В нижнем колонтитуле можно отображать различные вспомогательные контролы: кнопки, ссылки, подсказки.

<!-- example(select-footer) -->

#### Высота выпадающего списка

По умолчанию максимальная высота спиcка равна 256px. Когда в селекте много вариантов выбора, то в выпадающем меню появится прокрутка.

При необходимости можно настроить высоту. Например, в обычном меню видно 7–8 элементов. Если предполагается выбор из 10 опций, то можно увеличить высоту списка и показать все элементы, не скрывая малую часть под скроллом.

<!-- example(select-height) -->

### Ширина выпадающего списка

По умолчанию ширина выпадающего списка равна селекту и она увеличивается, когда в списке будет длинный текст. Это поведение можно изменить при помощи `panelWidth` атрибута.

Для определенного выпадающего списка:

<!-- example(select-with-panel-width-attribute) -->

Для всех выпадающих списков в модуле, используя _Dependency Injection_ при помощи `kbqSelectOptionsProvider` провайдера:

```ts
import { kbqSelectOptionsProvider } from '@koobiq/components/select';

@NgModule({
    providers: [
        kbqSelectOptionsProvider({ panelWidth: 'auto' })
    ]
})
```

#### Дополнительная иконка

<!-- example(select-icon) -->

#### Преднастроенный выбор

<!-- example(select-prioritized-selected) -->

#### Использование cdk-virtual-scroll-viewport

Добавьте `cdk-virtual-scroll-viewport` в шаблон компонента, чтобы отображать только видимые элементы и улучшить производительность.

<!-- example(select-virtual-scroll) -->

### Рекомендации

-   Если вы используете селект без лейбла, то советуем добавить placeholder для указания, какую информацию пользователь должен выбрать. Например, «Страна».
-   Если в списке значений более 10 элементов, то включите отображение поиска в шапке выпадающего списка. Это позволит упростить поиск значений.
