Модальный диалог открывается окном поверх страницы, затемняет нижний слой и блокирует всякое взаимодействие с ним. Модальный диалог фокусирует внимание пользователя на своем содержимом.

<!-- example(modal-component) -->

### Когда использовать

Используйте модальные диалоги для решения краткосрочных задач, операций, вызванных пользователем (можно открыть короткую форму, настройки). Бывает удобно показать скрытый контент в модальном окне. Модалки помогают эффективно решать задачи без потери контекста основной страницы. Несмотря на универсальность, модальные окна подходят [не для всех ситуаций](/components/modal/overview#связанные-компоненты).

### Структура компонента

-   Шапка. Заголовок диалога
-   Действие «Закрыть»
-   Тело. Содержит текст сообщения, вопрос, элементы управления и поля ввода
-   Футер. Кнопки действий, возможность отменить операцию или закрыть диалог

Многих этих частей может не быть. Обязательно должны остаться тело и возможность закрыть диалог. Обязательный способ закрыть диалог — крестик в шапке или кнопка «Отмена» («Закрыть») в футере.

#### Простой диалог без шапки

Похож на алерт браузера. Используйте, когда система задает один вопрос или сообщает короткую новость, чтобы избежать избыточного дублирования текста в заголовке и теле модального окна. У таких диалогов в правом верхнем углу нет значка-крестика «Закрыть».

<!-- example(modal-overview) -->

### Описание работы

Страница затемняется, с ней нельзя взаимодействовать: нельзя нажимать кнопки, нет ховера, прокрутки и т. п. Поверх затемнения открывается окно модального диалога.

Диалог может открыться по действию пользователя. Система также может блокировать работу пользователя модальным диалогом, но по возможности стоит избегать такого резкого вмешательства.

#### Как закрыть диалог

-   Выполнение основного или второстепенных действий диалога (кнопки в футере)
-   Кнопка «Отмена» или «Закрыть» в футере
-   Крестик в шапке — если без заголовка диалога никак
-   Клик вне модального окна. По умолчанию модальные окна так не закрываются. Но возможность закрыть по клику вне окна бывает полезна, когда нет риска потери данных и система не ждет команды от пользователя (например, в окне нет терминальных кнопок).
-   Клавиша Esc (эквивалентна кнопке «Отмена»)

Не следует закрывать модальное окно автоматически по тайм-ауту, пользователь может не успеть изучить информацию внутри него.

Иногда система не может позволить вернуться к взаимодействию со страницей. Даже в этой ситуации модальное окно не должно быть тупиком в сценарии использования, надо предложить варианты действий. Например, если система показывает окно об истекшей сессии, вернуться к странице на заднем фоне нельзя — но нужно предложить перейти на страницу входа в систему.

#### Запоминать данные пользователя

Если в окне были введены какие-то данные, необходимо запоминать их и заново показывать при повторном открытии диалога. Например, когда была попытка заполнить форму создания. Если была открыта форма редактирования в модалке, ее начали менять, но не сохранили, а закрыли, то при повторном открытии не надо подставлять несохраненные данные.

#### Прокрутка

Задний фон страницы не прокручивается. Высота модального окна определяется содержимым. Окно растягивается по высоте и занимает всю доступную высоту экрана, за вычетом отступов 48px по краям.

Прокручивается только центральная часть (тело) диалога. Шапка и футер остаются в видимой области. Они отбрасывают тень. Полоса прокрутки появляется внутри блока содержимого модального окна. Она должна быть прижата к правой границе окна, без отступа.

Длинная модалка — верный признак, что надо использовать [другой компонент или отдельную страницу](/components/modal/overview#связанные-компоненты).

<!-- example(modal-scroll) -->

#### Фокус и работа с клавиатурой

При открытом модальном диалоге фокус перемещается только по элементам внутри окна, включая крестик и кнопки в футере. Фокус не выходит за пределы модалки.

##### Фокус при открытии модального диалога

Когда открывается диалог, фокус перемещается к элементу внутри диалога. Расположение фокуса зависит от характера и размера содержимого.

-   Фокус устанавливается на первый доступный элемент внутри тела диалога, если нет особых предписаний
-   Если в диалоге есть форма, то надо ставить фокус в первое поле ввода
-   Если окно диалога содержит важное необратимое действие, то лучше поставить фокус на другое, менее деструктивное
-   Если в диалоге есть только терминальные кнопки, то будет полезно поставить фокус на кнопку, которую пользователь вероятнее всего нажмет («OK» или «Отмена», в зависимости от ситуации)
-   Если внутри модального окна много контента, есть прокрутка, то установка фокуса на первый доступный элемент может автоматически промотать содержимое окна и убрать его начальные части из поля зрения. В этому случае надо добавить статическому элементу, расположенному в начале контента, атрибут `tabindex=-1` и сфокусировать на нем. Этим элементом может быть заголовок, первый абзац и т. п.

##### Фокус после закрытия модального окна

Когда диалог закрывается, по умолчанию фокус возвращается на элемент, который вызвал его.

Если триггерный элемент больше не существует, то фокус возвращается на другой элемент, подходящий логике взаимодействия.

В некоторых ситуация фокус может специально возвращаться на другой элемент, не тот, что который изначально открыл диалог:

-   Маловероятно, что пользователь захочет сразу же открыть тот же диалог
-   Задача, выполненная в диалоговом окне, напрямую связана с последующим этапом рабочего процесса. Например, в таблице есть панель инструментов с кнопкой «Добавить строки». Кнопка открывает диалоговое окно и спрашивает количество новых строк. После закрытия диалога фокус помещается в первую ячейку первой новой строки.

##### Управление с клавиатуры

| <div style="min-width: 100px;">Клавиша</div>                                     | Действие                                                                                                                               |
| -------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- |
| <span class="hot-key-button">Ctrl</span> + <span class="hot-key-button">↵</span> | Выполняется основное действие диалога                                                                                                  |
| <span class="hot-key-button">Esc</span>                                          | Закрыть диалог:<br>1. Если в диалоге не было изменения данных<br>2. Если у элемента в фокусе нет собственного обработчика этой клавиши |
| <span class="hot-key-button">↵</span>                                            | Отправка формы по нажатию Enter в любом текстовом инпуте                                                                               |

### Валидация

В теле окна может располагаться форма. Терминальные кнопки отправки формы должны располагаться в подвале окна. [Валидация подчиняется общим правилам](/other/validation/overview).

### Дизайн и анимация

#### Положение

Окно открывается по центру экрана с отступом 48px от верхней границы экрана. Если у страницы была прокрутка, то не должно быть сдвига по горизонтали, когда отрылся диалог (часто это происходит, когда скроллбар появляется и исчезает при открытии или закрытии модалки).

#### Размер

Горизонтального скролла не бывает, содержимое панели должно умещаться по ширине.

| Предустановка | Ширина             |
| ------------- | ------------------ |
| Small         | 400                |
| Medium        | 640 (по умолчанию) |
| Large         | 960                |

<!-- example(modal-sizes) -->

#### Панель кнопок

Терминальные кнопки располагаются в правом нижнем углу в футере. Порядок: основное действие, второстепенное действие, отмена. Кнопки дополнительных действий располагаются в левом нижнем углу.

<!-- example(modal-template) -->

#### Наложение модальных окон

Открывать один модальный диалог из другого неправильно. Но если вдруг пришлось (экономия, вынужденная мера), то надо оставлять всего одно затемнение. А под ним уже располагать фон страницы и родительскую модалку. Делать несколько затемнений — ошибка.

<!-- example(modal-multiple) -->

### Связанные компоненты

Модальный диалог резко концентрирует на себе, заставляет терять фокус внимания, не дает взаимодействовать со станицей под ним. Поэтому в большинстве случаев нужно попытаться избежать модальности. Эти приемы помогут бережно обойтись с пользователем и избежать наслоения модальных окон:

[Поповер](/components/popover) менее деструктивно перехватывает внимания пользователя. Он не мешает взаимодействовать с остальной частью страницы, не ограничивает свободу. Поповер легче закрыть случайно. Если система ждет важного ответа или неочевидно, какое действие произойдет, если закрыть поповер, то используйте старый добрый модальный диалог.

[Боковая панель](/components/sidepanel) — что-то среднее между новой страницей и модальным окном. Она растянута по высоте на 100% окна браузера, длинные и узкие страницы в ней выглядят лучше, чем в модальном окне, а широкие и невысокие хуже. Боковая панель отлично справляется с наложением одной на другую, а модальные окна не стоит использовать с таким наслоением.

**Инлайн-сообщение и инлайн-форма** помогают показать новый контент на том же слое страницы и делают это менее раздражающе. Прием активно используется для вывода ошибок ко всей форме — или чтобы заранее предупредить пользователя о чем-то важном. Инлайн-формы помогают избежать модальных режимов, новых экранов, вложенности на сложных формах. Например, когда надо добавить в коллекцию новый объект из нескольких полей (имя, фамилия, отчество).

**Аккордеон**, прием «Показать еще», [тултип](/components/tooltip) помогут, когда надо всего лишь показать дополнительный контент. Этот вариант подойдет для менее важных вещей, чем при использовании инлайн-сообщений.

Тост-уведомление на короткое время сообщит о результате операции или покажет совсем неважное сообщение. Тост-уведомления используется, когда нестрашно, если человек пропустит сообщение, когда сообщение может быстро потерять актуальность или есть другая возможность прочитать его (например, в центре уведомлений).

**Новая страница** приходит на замену модальному окну, когда нужно показать много контента, длинную форму или список. Такой способ поможет полноценно представить контент, сфокусироваться на нем без потери функциональности (например, навигации).

**Прием «Отменить изменения»**. Вместо модального диалога «Вы уверены?» часто лучше сразу выполнить операцию — и дать возможность ее отменить.
