Ссылка связывает веб-страницы или выступает как более легкий аналог кнопки.

### Когда использовать

-   Для перехода между страницами
-   Если нужно встроить кнопку в текст. В таком случае используется <a href="/components/link/overview#псевдоссылка">псевдоссылка</a>

#### Когда не нужно использовать ссылки

-   Для основного действия в модальном диалоге — <a href="/components/button/overview">используйте кнопку</a>
-   Для интерактивности вне текста — используйте <a href="/components/button/overview">кнопку без фона</a>

### Структура компонента

-   Текст
-   Подчеркивание (для обычных ссылок)
-   Иконка (необязательно)

#### Вариации

##### Обычный размер

Используется по умолчанию.

<!-- example(link-general) -->

##### Маленький размер

Используется там, где нужна ссылка маленького размера (например, в подписи к полю).

<!-- example(link-caption) -->

### Описание работы

#### Типы ссылок по странице перехода

##### Страница внутри продукта

Для основных переходов.

<!-- example(link-general) -->

##### Страница внутри продукта в новой вкладке

Когда важно сохранить родительскую страницу. Используйте ссылки, открывающиеся в новой вкладке, как можно реже.

<!-- example(link-target-blank) -->

##### Внешняя страница

Для перехода на внешние страницы. Внешние страницы — все, которые не входят в контур продукта (другие продукты компании — тоже не входят). Отличие поддерживается иконкой.

<div class="kbq-callout kbq-callout_theme">
<div class="kbq-callout__header">Обрати внимание</div>
<div class="kbq-callout__content kbq-docs-element-last-child-margin-bottom-0">

Для обозначения внешних ссылок используйте иконку `kbq-north-east_16`.
Эта иконка имеет специально подобранные отступы, поэтому для правильного отображения добавьте к элементу ссылки класс `.kbq-link_external`.

</div>
</div>

<!-- example(link-external) -->

##### Внешнее приложение

Для открытия в других приложениях. Желательно писать название приложения прямо в ссылке. Для большей наглядности иконку можно заменить на логотип продукта.

<!-- example(link-application) -->

Полезно определять, установлено ли десктопное приложение на устройстве пользователя. Если приложения нет, ссылка заменяется обычным текстом.

| <img src="./assets/images/link/desktop-link-active.jpg" width="500"> |
| :------------------------------------------------------------------: |
|     AI на Windows. Ссылки проектов активны и ведут в AI Desktop      |

| <img src="./assets/images/link/desktop-link-disabled.jpg" width="500"> |
| :--------------------------------------------------------------------: |
|      AI на macOS. Ссылки проектов отображаются как обычный текст       |

Иногда указание продукта и добавление логотипа может быть избыточным. Если вы уверены, что контекст позволяет понять назначение ссылки, эти элементы можно опустить.

##### Псевдоссылка

Аналог кнопки. Не перезагружает страницу, не открывается в новой вкладке или по ссылке.

<!-- example(link-pseudo) -->

Ссылка не должна вести на ту же страницу, на которой она находится. Такие ссылки бесполезны и только запутывают пользователя: кликнул, страница загрузилась и оказалось, что ты остался там же, где и был. Исключение — интерфейсы с обновляемым контентом, где ссылка дублирует обновление страницы.

Используйте псевдоссылку, если нужно встроить действие в текст. Для остальных случаев используйте кнопку без фона.

#### Ссылки во время печати страниц

При печати страницы текст ссылки может меняться на полный адрес ссылки. Это может быть полезно, если использование распечатанного варианта страницы — ожидаемый кейс. Например, можно сохранить ссылки на базы CVE в отчете сканирования уязвимостей. При этом ссылка должна быть без мусора: «http://www» можно опустить.

В распечатанной странице :

CVE-2019-1020010:
cvedetails.com/cve/CVE-2019-1020010/

<!-- example(link-print) -->

#### Работа в браузере

Важно, чтобы ссылка не только выглядела как ссылка, но и работала как ссылка. Характеристики правильной ссылки:

-   Можно скопировать адрес ссылки
-   Можно открыть ссылку в новой вкладке через контекстное меню или Ctrl+клик
-   В разметке использован тег `<a>`

| <img src="./assets/images/link/proper-link.jpg" width="500" alt="Правильная ссылка. Можно скопировать адрес, можно открыть в новой вкладке"> |
| :------------------------------------------------------------------------------------------------------------------------------------------: |
|                                **Правильная ссылка.** Можно скопировать адрес, можно открыть в новой вкладке                                 |

| <img src="./assets/images/link/improper-link.jpg" width="500" alt="Неправильная ссылка. Браузер не определил элемент как ссылку"> |
| :-------------------------------------------------------------------------------------------------------------------------------: |
|                                 **Неправильная ссылка.** Браузер не определил элемент как ссылку                                  |

#### Фокус и работа с клавиатурой

| <div style="min-width: 110px;">Клавиша</div>                                        | Действие                              |
| ----------------------------------------------------------------------------------- | ------------------------------------- |
| <span class="hot-key-button">Space</span> \ <span class="hot-key-button">⏎</span>   | Переход по ссылке                     |
| <span class="hot-key-button">Shift</span> + <span class="hot-key-button">F10</span> | Открыть контекстное меню (для ссылок) |
|                                                                                     | (Применимо только для Windows.)       |

#### Дизайн и анимация

##### Многострочные ссылки

В многострочных ссылках подчеркивается каждая строка:

<!-- example(link-multi-line) -->

Важно, чтобы в многострочных ссылках ховер-зона захватывала межстрочный просвет.

##### Синтаксис

**Ссылки:** что? где?
**Псевдоссылки:** синтаксис кнопки.

Связанные предлоги заключаются в ссылку:

<!-- example(link-prepositions) -->

##### Иконки

По умолчанию — слева. Исключение — иконка внешнего перехода.

Иконка входит в область клика, но не подчеркивается.

<!-- example(link-icons) -->

##### Цвет

Синий или primary. Если primary цвет слишком яркий или бледный, стоит предусмотреть альтернативный цвет для ссылок (обычно — менее насыщенный и более темный вариант primary цвета).

<!-- example(link-color) -->

##### Visited

По умолчанию посещенные ссылки никак не выделяются. Это традиция пошла от истоков интернета, когда гиперссылки были основным способом перемещения между страницами.

Отмечать посещенные ссылки полезно в страницах-сборниках — подборках статей, списке для чтения: выделение цветом отмечает прогресс чтения.

<!-- example(link-visited) -->

##### Disabled

<!-- example(link-disabled) -->
