`<kbq-code-block>` - компонент который показывает переформатированный текстовый контент и подсвечивает синтаксис.

<div class="kbq-callout kbq-callout_theme">
<div class="kbq-callout__header">Обрати внимание</div>
<div class="kbq-callout__content kbq-docs-element-last-child-margin-bottom-0">

Для работы компонента, необходимо наличие [`highlight.js@^11`](https://github.com/highlightjs/highlight.js/tree/11.10.0) зависимости:

```bash
npm install highlight.js@^11
```

</div>
</div>

### Нумерация строк

Пронумеровать строки полезно, чтобы дать ссылку на конкретное место в документе. Нумерация строк отключена по умолчанию, включается при помощи атрибута `lineNumbers`.

<!-- example(code-block-with-line-numbers) -->

### Изменение высоты блока

Блок может растягиваться и занимать доступную область экрана, если изучение кода — это одна из главных задач в интерфейсе. Когда место на экране ограничено, или код только дополняет основную информацию, разработчик может использовать блок с фиксированной высотой, настраивается при помощи атрибута `maxHeight`.

Для компактности бывает полезно показать часть документа с возможностью развернуть все, при помощи атрибута `viewAll`. Блок увеличится по высоте и весь код будет виден — так удастся избавиться от двойной прокрутки. В свернутом виде нет прокрутки, недоступна функция смена режима переноса. Если сменить режим переноса строк, а потом свернуть-развернуть код, то настройка сохранится.

<!-- example(code-block-with-max-height) -->

### Мягкий перенос строк

По умолчанию строки не переносятся. Режим переноса в блоке можно настроить заранее, при помощи атрибута `softWrap`, а также дать пользователю возможность управлять этим с помощью кнопки-переключателя в панели действий, включается при помощи атрибута `canToggleSoftWrap`.

Иконка в кнопке означает будущее состояние после активации, иконка меняется после смены режима переноса.

<!-- example(code-block-with-soft-wrap) -->

### Показ нескольких документов

Несколько документов размещаются в блоке во вкладках. Заголовок вкладки формируется из поля `filename`. При необходимости вкладки можно скрыть, при помощи атрибута `hideTabs`, а установить активный таб при помощи атрибута `activeFileIndex`.

Вкладки скрываются автоматически, для одного документа с пустым `filename`.

<!-- example(code-block-with-tabs) -->

Блок заголовков вкладок отображается без тени по умолчанию. Если содержимое выходит за пределы области, то при скроллинге содержимого блока кода появляется тень под блоком заголовков вкладок.

<!-- example(code-block-with-tabs-and-shadow) -->

### Визуальное оформление

Предусмотрено два стиля оформление блока: с рамкой или с контрастной к фону страницы подложкой. Контрастный фон не дает блоку потеряться на экране с разномастным содержимым, настраивается при помощи атрибута `filled`.

<!-- example(code-block-with-filled) -->

### Без рамок

Когда блок кода должен занять весь контейнер или экран, то лучше использовать оформление без рамки и фона, настраивается при помощи атрибута `noBorder`.

<!-- example(code-block-with-no-border) -->

### Панель действий

Панель действий расположена в правом верхнем углу блока, она видна по ховеру на блок или при фокусе на одну из кнопок, залипает при прокрутке. Конфигурация компонента определяет, какие действия будут доступны.

#### Изменение режима переноса

Пользователь может изменять режим переноса при помощи кнопки-переключателя, по умолчанию эта возможность выключена, настраивается при помощи атрибута `canToggleSoftWrap`.

```html
<kbq-code-block [files]="files" canToggleSoftWrap />
```

#### Скачивание документа

Пользователь может сохранить/скачать документ в файл, по умолчанию эта возможность выключена, настраивается при помощи атрибута `canDownload`.

Имя и расширение файла берется из поля `filename`. Имя файла по умолчанию — _code_, расширение - _txt_.

```html
<kbq-code-block [files]="files" canDownload />
```

#### Копирование текста документа

Пользователь может скопировать текст документа, по умолчанию эта опция включена, настраивается при помощи атрибута `canCopy`.

```html
<kbq-code-block [files]="files" canCopy="false" />
```

#### Открыть документ во внешней системе

Адрес берется из поля `link`. Ссылка открывается в новой вкладке.

<!-- example(code-block-with-link) -->
