# Contribution checklist

Please make sure you have created an issue to discuss the contribution following our [guide](./00-contributing.md).

## Development

There's a few aspects of development we'll cover here:

-   Documentation
-   Review
-   Testing

### Documenting

When documenting a component, there's two things you need to worry about:

-   Docs - general documentation for the component.
-   Storybook - interactive use-cases showing how to use the component.

### Testing

The following types of tests are required for all packages:

-   Unit test

Your component may also require further testing:

-   Integration test (work in progress)
-   Functional test (work in progress)
-   Visual regression test (work in progress)
-   Performance test (work in progress)

On top of automated testing, we should also be manually testing our examples on the following platforms / browsers:

-   Windows
    -   Chrome
    -   Firefox
    -   Edge
-   Mac
    -   Chrome
    -   Firefox
    -   Safari

## Review

-   Ensure a core maintainer is added to the review.
