import webpack from 'webpack';
import path from 'path';

export default {
  mode: 'development',
  module: {
    rules: [
      {
        test: /\.((png)|(eot)|(woff)|(woff2)|(ttf)|(svg)|(gif))(\?v=\d+\.\d+\.\d+)?$/,
        loader: 'file-loader?name=/[hash].[ext]'
      },
      {
        test: /\.json$/,
        loader: 'json-loader'
      },
      {
        test: /\.js?$/,
        loader: 'babel-loader',
        exclude: /node_modules/,
        query: {
          cacheDirectory: true
        }
      }
    ]
  },
  optimization: {
    minimize: false
  },
  plugins: [
    new webpack.ProvidePlugin({
      fetch: 'imports-loader?this=>global!exports?global.fetch!whatwg-fetch'
    })
  ],
  context: path.join(__dirname, 'src'),
  entry: {
    app: ['./js/app']
  },
  output: {
    path: path.join(__dirname, 'dist/assets/js/'),
    publicPath: '/',
    filename: '[name].js'
  },
  externals: [/^vendor\/.+\.js$/]
};
