---
title: 'Chronolgie der Website'
date: 2006-01-01T18:00:00+02:00
description: ''
url: '/chronologie/'
body_class: 'grid--small'
---

## 1999

### 22. Dezember 1999

Meine Ninjutsu-Website geht am 22. Dezember 1999 online. Zuerst auf einem Shared Space ohne eigene Domain. Später läuft sie unter zwei verschiedenen Domains, ehe sie ihren finalen Namen bekommt: **kogakure** (木隠, jap. <q>Hinter Blättern und Bäumen verborgen</q>).

Ich erinnere mich noch, wie ich in einem sehr dicken, japanischen Wörterbuch nach einem Begriff gesucht habe, den es im Internet noch nicht gab und der auch eine Bedeutung hat.

Das Design hatte _natürlich_ animierte Ninja-Sterne, unlesbare Schrift und einen Page Counter.

![Website 1999](/assets/images/chronology/history-1999.jpg)

---

## 2001

### Januar 2001

Die Website hatte eigentlich nur als Sammlung von Notizen angefangen, sich in den nächsten zwei Jahren aber langsam zu einer größeren Website entwickelt. Im Januar 2001 war die Arbeit an der Website fast abgeschlossen. Zu dieser Zeit hatte ich eine geradezu aberwitzige Menge an Stunden in die Recherche und das Schreiben der Artikel investiert. Außerdem hatte ich zahlreiche komplizierte 3D-Modelle von Waffen, Werkzeugen und Techniken in _Poser_ und _3d Studio Max_ erstellt.

![Website 2001](/assets/images/chronology/history-2001.jpg)

---

## 2002

### Januar 2002

Im Januar 2002 stelle ich eine neues Design (Version 2) der Website online. Die erste Website hatte nur wenige Tabellenzellen eingesetzt, um das Layout zu erstellen, diese Version setzte auf die damals üblichen Spacer-GIFs, mit denen man Umrandungen von Boxen gestaltete.

Die zweite Version hatte ich auch schon in Teilen mit PHP erstellt, um wiederkehrende Teile nur einmal pflegen zu müssen.

Ich hatte zu dieser Zeit auch noch ein Gästebuch, ein Forum und einen Counter, wie es damals auf vielen Seiten üblich war. Die Navigation hatte ich mit JavaScript erstellt und sie war sehr schlecht zu bedienen. Außerdem hatte ich zeitweise Flash für einen _tollen_ Lichteffekt und eine pure Flash-Startseite mit Musik und Animationen im Einsatz.

Neben einer fragwürdigen Auswahl an Schriften und _hippem_ Stil hatte ich damals erstmals den Bambus als Markenzeichen meiner Website eingeführt.

![Website 2002](/assets/images/chronology/history-2002.jpg)

---

## 2004

### September 2004

Im September 2004 erstellte ich die Version 3 der Website. Da ich langsam mehr Verständnis von Design erlangt hatte, sah die Website auch nicht mehr grauenvoll aus. Ich hatte anstatt eines riesigen Header-Bildes jetzt einen stilisierten Bambus im Einsatz, den ich aufgrund fehlenden handwerklichen Fähigkeiten irgendwo im Internet _gefunden_ hatte und dann zum Schutz vor Copyright-Brüchen durch diverse Fotofilter und Veränderungen so weit verändert hatte, bis es als _eigene Kreation_ durchgehen könnte.

Außerdem hatte ich mir bei einem Künstler über das Internet einen japanischen Siegenstein schnitzen lassen. Ich erinnere mich, dass es ihn eine Menge Mühe gekostet hatte, die Schriftzeichen von kogakure in der chinesischen Siegelschrift zu finden.

Technisch hatte ich hier zum ersten Mal ein semantisches CSS-Layout eingesetzt, das mit Floats die einzelnen Spalten auf der Seite ordnete.

![Website 2004](/assets/images/chronology/history-2004.jpg)

---

## 2006

### 30. April 2006

Zwei Jahre später waren gerade CMS (Content Management Systeme) der absolute Hit und ich kaufte mir eine Lizenz von [ExpressionEngine](https://expressionengine.com/), um meinen Blog damit zu betreiben.

Für Version 4 meiner Website hatte ich in Adobe Illustrator mit dem Verlaufsgitterwerkzeug einen komplett neuen Bambus erstellt.

Außerdem gab es Verbesserungen an den Schriften und das Design wurde insgesamt leichter und frischer.

![Website 2006](/assets/images/chronology/history-2006.jpg)

### 25. August 2006

#### Nominierung für das Webdesignbook

Die Website wurde für das **Webdesignbook** nominiert. Das Webdesignbook war ein Projekt, das beeindruckende Designs auszeichnet. Die nominierten Seiten mussten in tabellenlosem Layout, mit validem Markup und CSS umgesetzt sein. Einmal im Jahr wurden 150 Websites von einer namenhaften Jury ausgewählt und irgendwann im Herbst des Jahres in Buchform auf rund 248 Seiten publiziert. Zusätzlich wird das Buch Interviews mit Designern enthalten, Artikel über Designer, die Designs werden nach Farbe, Stil und Autor geordnet sein. In diesem Jahr bestand die Jury aus Andy Budd, Tammie Lister, John Oxton, Marco van Hylckama Vlieg, James Archer, Kyle Neath, Chris J. Davis und Thomas Silkjær.

### 29. Oktober 2006

#### Bujinkan bei _Welt der Wunder_

Am Sonntag, 29. Oktober 2006 um 19:00 Uhr wurde in der Sendung **Welt der Wunder** auf RTL2 eine Fernsehreportage über die Ninja ausgestrahlt.

Das Welt der Wunder-Team hat dafür Hatsumi Sensei in Japan besucht und stellte historische Schlachten und Ninja-Einsätze nach. Einige deutsche Bujinkan Dōjō standen dem Filmteam sowohl vor der Kamera als auch dahinter zur Seite.

Ich hatte das Vergnügen die Redakteure mit dem theoretischen Fachwissen zu versorgen, bevor die Filmarbeiten begannen.

---

## 2007

### 25. Februar 2007

#### 100.000ter Besucher

Am 25. Januar 2007 hatte meine Website ihren 100.000 Besucher seit Beginn der Zählung im Oktober 2005 die Seite besucht. Insgesamt hatten 100.015 Besucher 497.349 Seiten seit diesem Zeitpunkt aufgerufen.

Die Beiträge über Ninja auf RTL2 (**Welt der Wunder**) und PRO7 (**Galileo Mystery**) hatten Spitzenwerte erzeugt. Das Interesse an den Artikeln war bei den Besuchern nach dem _Welt der Wunder_-Beitrag um ein vielfaches größer als bei den Besuchern des Beitrag von _Galileo Mystery_.

---

## 2008

### 24. April 2008

Die Version 5 meiner Website wird live gestellt. Dieses mal war es nur eine kleine visuelle Veränderung, dafür war der technische Teil komplett neu.

Ich setzte dazu zum ersten Mal ein Web-Framework ein, wodurch ich jede einzelne Zeile selbst schreiben musste und mich neben Templates auch um Datenbank, Controller und diverse andere Dinge kümmern musste. Damals überzeugte mich das Python-Webframework [Django](https://www.djangoproject.com/), so dass ich mir Python beibrachte und die Website komplett neu erstellte. Insbesondere das Admin-Interface von Django war damals ein besonderes Highlight.

![Website 2008](/assets/images/chronology/history-2008.jpg)

---

## 2010

### 10. März 2010

#### Abmahnung

Da ich auf meiner Website eine kleine Sammlung von Sprüchen und Zitaten hatte, wurde ich wegen Urheberrechtsverletzung von den Erben von **Karl Valentin** abgemahnt. Ich musste eine Unterlassungserklärung unterschreiben und mein Anwalt konnte größeren Schaden abwehren. An die Kläger zahle ich nichts.

Ich kam zum ersten mal mit wirklich furchtbaren Menschen in Kontakt, deren ganzer Lebensinhalt darin bestand, anderen Menschen ihr Leben schwer zu machen. Da Karl Valentins Werke 2018 gemeinfrei werden, wollten die Erben so viel wie möglich verdienen, ehe diese Quelle versiegt.

Das es sich hier um **gewerbsmäßige Abmahnungen** handelte wurde mir klar, als mir mein Anwalt mitteilte, dass alleine seine Kanzlei in Hamburg zu diesem einen besagten Spruch vier Klienten vertrat.

Leider war ich nach dieser Erfahrung gezwungen, die Sprüche ganz von der Website zu nehmen, da ich nicht für jeden Spruch zweifelsfrei feststellen konnte, ob der Urheber schon länger als 70 Jahre unter der Erde liegt.

---

## 2015

### 7. April 2015

Fünf Jahre später sind die Sprüche zurück (ich hatte jeden einzelen Urheber geprüft und alle neueren Autoren entfernt). Zusammen mit den Sprüchen gab es ein komplett neues Design und die Version 6 meiner Website.

Ich hatte mich von Django verabschiedet, da ich beruflich mit Ruby zu tun hatte und Python nur ein Hobbie war. Außerdem war es ein gehöriger Aufwand eine solche Website am Laufen zu halten.

Glücklicherweise hatten das auch viele andere Entwickler erkannt und immer mehr Personen hatten begonnen ihre Websites und Blogs auf statische Seiten umzustellen. Es gibt eine fast unbegrenzte Anzahl von [Statischen Seitengeneratoren](https://www.staticgen.com/), die es ermöglichen mit Templates, Logik und Daten zu arbeiten und am Ende dann trotzdem pure statische HTML-Seiten auszuwerfen. So kann auch niemand die Website hacken. Und es ist keine Datenbank oder teure und komplizierte Serversoftware nötig, sondern die Seiten können quasi überall gehostet werden und skalieren fantastisch. Selbst ein paar tausend Zugriffe pro Sekunde werden keinen Server in Bedrängnis bringen.

Ich setze [Jekyll ](https://jekyllrb.com/) als Seitengenerator ein, verwende [PostCSS](https://postcss.org/) für mein CSS, [Browserify](http://browserify.org/) für mein JavaScript und [Gulp.js](https://gulpjs.com/) als Build-Tool.

Die ganze Website ist mobil-optimiert und läuft auf jedem Device.

Den Bambus erstellt ich in [Affinity Designer](https://affinity.serif.com/designer/) komplett neu, um ihn als SVG direkt in die Seite einzubinden (und das Verlaufswerkzeug wird nicht von SVG unterstützt).

![Website 2015](/assets/images/chronology/history-2015.jpg)

---

## 2017

### 27. Juni 2017

Nach sechs Monaten Arbeit veröffentliche ich ein **eBook** von kogakure.

Ich nutze **GitBook**, um mein Buch zu schreiben und ebenso für das Hosting und das Bereitstellen der eBook-Varianten.

Im Rahmen der Überarbeitung behebe ich zahlreiche Fehler, schaue über jeden Artikel, füge neue Bilder ein und ersetze wo immer möglich Grafiken mit SVG.

![eBook von kogakure in GitBook geschrieben](/assets/images/chronology/gitbook-kogakure.jpg)

### 13. August 2017

Da Jekyll sehr langsam rendert und ich auch schon meine [private Website](https://www.stefanimhoff.de) mit dem statischen Seitengenerator [Hugo](https://gohugo.io/) ersetzt hatte, war es nur der nächste logische Schritt das auch für kogakure.de zu machen.

Gleichzeitig konnte ich die ganze Website noch einmal überarbeiten, einige kleinere grafische Änderungen vornehmen und die Homepage komplett neu gestalten.

Außerdem konnte ich zum ersten Mal das [CSS Grid Layout](https://gridbyexample.com/) im größeren Umfang einsetzen. Die Arbeit mit diesem neuen CSS-Standard für Seitenlayouts hat unglaublichen Spaß gemacht.

Die Website hat jetzt auch einen Service Worker und kann sogar ohne Internetverbindung angesehen werden.

Ich nutze jetzt [Netlify](https://www.netlify.com/) als Hoster für meine Website, und veröffentliche Änderungen automatisch direkt über [GitHub](https://github.com/).

![Website 2017](/assets/images/chronology/history-2017.jpg)
