---
title: "Iga-ryū"
slug: "iga-ryu"
date: 2006-03-26T20:20:00+02:00
author: "Peter Carlsson"
translator: "Stefan Imhoff"
excerpt: "Der Iga ryū entstand in einer der günstigsten strategischen Lagen der Region, in unzugänglichen Gebirgs- und Waldregionen, nahe wichtiger Hauptverkehrswege."
body_class: "grid--small"
categories:
- Biographie
- Geschichte
---

## Lage der Region Iga

![Iga-Ueno Castle, by 利用者:＋－](/assets/images/articles/iga-ueno-castle.jpg "Iga-Ueno Castle, by 利用者:＋－")

Der Ursprung des Iga-*ryū-ninjutsu* kann nur verstanden werden, wenn man die Region Iga näher betrachtet. Von Anfang an gehörte die Iga-Region zur Ise-Provinz, aber ungefähr im Jahr 680 wurden sie zweigeteilt. Ise war immer schon eine der wichtigsten Regionen in Japan, weil sie eine lange Küste hatte und die Tokaidō-Straße zwischen Edo und Kyōto durch diese Region führte. Die Iga-Provinz entwickelte sich zu einer relativ abgeschlossenen Region, umgeben von Bergen an allen Seiten, außer an der Nordseite, nahe der Kōga-Region im Süden der Omi-Provinz. In diesen Regionen wurde die *ninpō*-Kultur entwickelt. Beide Regionen, die Iga- und Kōga-Region waren relativ sicher gelegen, nur ein wenig südöstlich von Kyōto, der Hauptstadt Japans und südlich der Tokaidō-Straße. Diese Regionen lagen also sehr zentral und spielten eine wichtige Rolle in der Geschichte Japans.

Zu all diesen äußerlichen Umständen braucht man nun nur noch als Beschleuniger den General Ikai, ein Flüchtling aus China mit Wissen in Strategie und den Kriegskünsten, und sie hatten alle Möglichkeiten für eine Entwicklung ihrer eigenen unabhängigen *ryūha* (Sekte, Zweig). Beides – als Schutz für ihre eigene Existenz und als Weg, um eine aktive Rolle in der politischen Entwicklung Japans zu spielen. Nebenbei muss noch erwähnt werden, dass es in Sada (in Iga) Orte gibt, die Tojin Iwa (der Chinesische Fels) und Karadobuchi (die Tür zu Chinas tiefem Wasser) heißen, und immer noch an die Verbindung zu China erinnern.

Ganz in der Nähe, südöstlich von Iga in den Yoshino-Bergen ist der Ort, an dem die Führer des *shugendō*-Sekte lebten. Und südlich von Iga, in den Kumano-Bergen gelegen, ist ein anderer heiliger Ort der *shugendō*-Sekte. Es ist sehr wahrscheinlich, dass diese *yamabushi* (Bergkrieger) ihre Philosophien und Methoden mit den Bewohnern von Iga austauschten.


## Der Iga-ryū

Im Iga-*ryū* gab es viele andere *ryū* mit ihren eigenen Spezialitäten und Traditionen, aber der Ursprung aller Iga-*ryū* Kriegskünste soll auf Ikai zurückreichen, der aus China in eine Höhle auf dem Berg Takeo floh. Was er aus China mitbrachte, war zuallererst das Wissen des *koshi jutsu* (Techniken gegen Muskeln und Sehnen), das er neben vielen anderen auch Gamon Doshi (Moralist) lehrte. Gamon Doshi und sein Schüler Garyū Doshi werden als Gründer fast aller Kriegskünste in der Region von Iga gesehen.

Aber es gibt ein Problem mit dieser Theorie. Nach Meister Hatsumi und anderen Quellen im Bujinkan, floh Ikai aus China irgendwann zwischen den Jahren 1040 und 1050. Die Gründe für seine Flucht waren, dass er mit den Bewohnern von Kitan und Xia gegen König Jinso (Song-Dynastie in China) gekämpft hatte und besiegt wurde. Nach den Geschichtsbüchern waren die Staaten Kitan und Xia zu dieser Zeit aber noch siegreich, und erst als sich der Kaiser Hui Zong mit Aguda von den Ruzhen zwischen 1123 und 1125 verbündete konnten die Staaten Kitan und Xia besiegt werden. Also müssen entweder die Daten von Hatsumi umgewertet werden oder es muss nach einer Verbindung zwischen Yo Gyokko und dem Sturz der Tang-Dynastie herausgefunden werden und wer *koshi jutsu* nach Japan brachte.

{{% blockquote author="Hatsumi Masaaki" %}}
Es kann auch so gewesen sein, dass Yo Gyokko *koshi jutsu* und Ikai das Wissen über Strategie und Hicho Kakuregata nach Japan brachte und sich aus beiden Systemen der Ursprung der Kriegskünste in Iga ergab.
{{% /blockquote %}}

Garyū Doshi führte den Hakuun-*ryū* ein, eine Schule die von Hakuun Doshi entwickelt und benannt wurde. Hachiryū Nyudo ist ein andere Name, der erwähnt werden sollte, weil er wahrscheinlich Garyūs Wissen zu Tozawa Hakuunsai weitergab, dem ersten offiziellen Großmeister des Gyokko-*ryū*. Gyokko-*ryū* wird in den meisten Fällen als eine *koshi jutsu*-Schule gesehen, aber es ist auch eine offizielle *ninpō*-Schule.

Hakuun-*ryū* wurde an Kagakure Doshi (auch als Kain Doshi oder Kumogakure Doshi bekannt) weitergereicht, und es war Kagakure der dieses System Nishina Daisuke lehrte. Daisuke gründete den Togakure-*ryū* und dieser ist zusammen mit dem Gyokko-*ryū* einer der ältesten Traditionen in Iga. Beide Stile beeinflussten die anderen Schulen in Iga in großem Maß.

In Hatsumi Masaakis Buch <cite>Essence of Ninjutsu</cite> wird Iga Heinabe Yasukiyo, ein anderer Schüler des Gamon Doji erwähnt. Weil man ihm ein Stück Land gegeben hatte half Iga Hattori Minamoto Yoritomo in seinem Kampf gegen den Taira-Clan. Ihm wird nachgesagt, er habe eine Burg gebaut, die der Ursprung des Iga-*ryū* wurde. Aber Iga Heinabe Yasukiyo soll im späten 11. Jahrhundert gelebt haben und Minamoto Yoritomo im späten 12. Jahrhundert. Deshalb wird diese Geschichte angezweifelt. Andererseits, Iga Heinabe Yasukiyo scheint die Basis des Wissens zu sein, das Iga Heinai Saemon no Jo Ienaga, sein Nachkomme in der zwölften Generation benutzte, als er eine Schule gründete, die auch Iga-*ryū* hieß, dann aber später in Kumogakure-*ryū-ninpō* umgenannt wurde.

Es gibt eine andere Geschichte, die festlegt, dass Ise Saburo Yoshimoru mit Minamoto Yoritomos Bruder in der Schlacht von Yoritomo verbündet war. Das passt besser in die Geschichte, auch wenn es noch nicht sicher ist.

All die verschiedenen Iga-*ryū* hatten ihre eigene Linie von *soke* ('Kopf der Familie', Oberhaupt), aber der Iga-*ryū* als Ganzes hatte ebenfalls einen Stammbaum von wichtigen Personen, die *jōnin* genannt wurden. Es ist nicht ungewöhnlich hier auch die Namen von *soke* zu finden die auch *soke* in anderen Iga-*ryū* waren.


## Die Großmeister des Iga ryū

Unten eine Liste der Iga-*ryū* *jōnin* bis zum Ende des 16. Jahrhunderts. Das erwähnte Jahr ist nicht genau oder das Jahr in dem die Personen Großmeister waren, aber das Jahr, in denen sie aktiv waren.

1. Gamon Doji (1065-1068)
Garyū Doji (Gründer des Hakuun-*ryū*) (1074-1076)
3. Unryū Doji (1074-1076)
4. Iga Heinabe Yasukio (1096)
5. Tozawa Hakuunsai (Gründer des Gyokko-*ryū*) (1159)
6. Ise Saburo Yoshimoro (1159)
7. Togakure Daisuke (Gründer des Togakure-*ryū*) (1207-1210)
8. Kumogakure Gen an (1249-1255)
9. Tozawanyodo Gen eisai (1334-1335)
10. Hachimon Hyouun (1379-1380)
11. Kuryūzu Hakuun (1394-1427)
12. Tozawa ryūtaro (1487-1488)
13. Momochi Sandayu I (1532-1554)
14. Iga Heinai Saemon no jo Ianega (Gründer des Kumogakure-*ryū*) (1532-1554)
15. Kamihattori Heitaro Koreyu (Hattori Hanzos Familie) (1532-1554)
16. Nakahattori Heijiro Yasuyori (1532-1554)
17. Shimohattori Heijuro Yasunori (1532-1554)
18. Momochi Sandayu II (1573-1591)


## Die Familien des Iga-ryū

Das gesammelte Wissen des Iga-*ryū* wurde entwickelt und beschützt von 45 Familien. Diese Familien waren:

Tozawa, Fujiwara, Minamoto, Kuriyama, Taira, Momochi, Ishitani, Hattori, Toyata, Izumo, Ohkuni, Tsutsumi, Arima, Kimata, Hata, Mizuhari, Hanbe, Shima, Sawada, Togakure, Ise, Sakagami, Narita, Toda, Oda, Ooyama, Mori, Abe, Kataoka, Ueno, Otsuka, Ibuki, Kaneko, Kanbe, Kotani, Hisahara, Sugino, Kazama, Iida, Kimura, Iga, Fukii, Kashiwabara, Shindo, Suzuki.

Einige Namen sind sehr interessant. Zum Beispiel Tozawa, denn Tozawa Hakuunsai war auch der erste *soke* des Gyokko-*ryū*, einer der 9 Schulen im Bujinkan.

Die Toda-Familie ist auch interessant. Außer, dass sie die *soke* des Kumogakure-*ryū* waren, erbten sie auch den Togakure-*ryū* im 17ten Jahrhundert von der Natori-Familie, die den Togakure-*ryū* wieder erbten, als alle Toda-Familienmitglieder gestorben waren. Die Toda waren auch eng mit den Tozawa verbunden.

Momochi war eine der berühmtesten Familien und Momochi Sandayu war ohne Frage der berühmteste Ninja-Führer, zusammen mit Hanzo Hattori. Momochi Sandayu und drei seiner Nachkommen waren im 16ten Jahrhundert *soke* im Gyokko-*ryū* und Koto-*ryū*. Sie hatten auch Schulen der Sakagami-Familie geerbt. Im 17ten Jahrhundert wurden der Gyokko-*ryū*, Koto-*ryū*, Kumogakure-*ryū* und Togakure-*ryū* unter Toda Seiryū Nobutsuna weitergeführt. Später wurde auch der Gyokushin-*ryū* an die Toda-Familie weitergereicht. Andere Namen, die eine direkte Verbindung zum Bujinkan haben sind Ishitani, Izumo und Iga.


## Mit dem Iga ryū verwandte Schulen

Hier sind einige *ryū*, die Teil des Iga-*ryū* und der Traditionen der Iga-Provinz waren:

Hakuun-ryū, Togakure-ryū, Kumogakure-ryū, Genjitsu-ryū, Tenton Happo-ryū, Goton-juppo-ryū, Kadone-ryū, Kukishinden-ryū, Gyokko-ryū, Koto-ryū, Rikyoku-ryū, Tsuji-ichimu-ryū, Hattori-ryū, Taki-ryū, Yoshimori-ryū, Uchikawa-ryū, Gikan-ryū, Gyokushin-ryū, Takino-ryū, Sawa-ryū, Gen-ryū, Momochi-ryū, Ryūmon-ryū, Iga-ryū.

Diese Liste ist nicht komplett, denn viele *ryū* verschwanden in der Geschichte. Die Iga-*ryū* und Kumogakure-*ryū* waren ein einziger *ryū*, weil Iga-*ryū* einfach in Kumogakure-*ryū* umbenannt wurde. Die Gikan-*ryū* und Gyokushin-*ryū* wurden beide aus dem Gyokko-*ryū* entwickelt.

Eine exakte Niederschrift der Geschichten der *ryū* ist fast unmöglich. Dies hat verschiedene Gründe, zum einen weil die Kriegskünste oft als *kuden* (Mund-zu-Mund Lehren) weitergegeben und nicht niedergeschrieben wurden. Eine andere Sache ist, dass die *soke* oft mehr als ein *menkyo kaiden* (Entgültige Meisterschaft einer Kampfkunst) ausstellten, um dem *ryū* eine bessere Chance zu überleben zu geben. Andere *ryū* wiederum hatten nur eine einzige Person, die der nächste *soke* werden sollte, und wenn der Meister unerwartet starb, so starb auch sein *ryū*.
