# 推广搜 军火库

> 作者：杨夕
> 
> NLP论文学习笔记：https://github.com/km1994/nlp_paper_study
> 
> 个人介绍：大佬们好，我叫杨夕，该项目主要是本人在研读顶会论文和复现经典论文过程中，所见、所思、所想、所闻，可能存在一些理解错误，希望大佬们多多指正。
> 
> NLP 百面百搭 地址：https://github.com/km1994/NLP-Interview-Notes
> 
> 推荐系统 百面百搭 地址：https://github.com/km1994/RES-Interview-Notes
> 
> **推广搜 军火库**：https://github.com/km1994/recommendation_advertisement_search 
> 
> **关注公众号 【关于NLP那些你不知道的事】 加入 【NLP && 推荐学习群】一起学习！！！**

## 一、项目篇

### 1.1 目前业界可以下载到的一些大模型

- chatgpt:
  - https://openai.com/blog/chatgpt
  - 体验地址：https://chat.openai.com/
- GLM-10B/130B 
  - 介绍：双语（中文和英文）双向稠密模型
- OPT-2.7B/13B/30B/66B ：
  - 介绍：Meta开源的预训练语言模型
  - github: https://github.com/facebookresearch/metaseq
  - paper: https://arxiv.org/pdf/2205.01068.pdf
- LLaMA-7B/13B/30B/65B ：
  - 介绍：Meta开源的基础大语言模型
  - github: https://github.com/facebookresearch/llama
  - paper: https://arxiv.org/pdf/2302.13971v1.pdf
- Alpaca（LLaMA-7B）：
  - 介绍：斯坦福提出的一个强大的可复现的指令跟随模型，种子任务都是英语，收集的数据也都是英文，因此训练出来的模型未对中文优化
  - github: https://github.com/tatsu-lab/stanford_alpaca
  - Chinese-LLaMA-Alpaca github: https://github.com/ymcui/Chinese-LLaMA-Alpaca
- BELLE（BLOOMZ-7B/LLaMA-7B）：
  - 介绍：本项目基于 Stanford Alpaca，针对中文做了优化，模型调优仅使用由ChatGPT生产的数据（不包含任何其他数据）
- ChatGLM-6B ：
  - 介绍：中英双语的对话语言模型
  - github: https://github.com/THUDM/ChatGLM-6B/
- Bloom-7B/13B/176B：
  - 介绍：可以处理46 种语言，包括法语、汉语、越南语、印度尼西亚语、加泰罗尼亚语、13 种印度语言（如印地语）和 20 种非洲语言。其中，Bloomz系列模型是基于 xP3 数据集微调。 推荐用于英语的提示（prompting）；Bloomz-mt系列模型是基于 xP3mt 数据集微调。推荐用于非英语的提示（prompting）
  - github: https://huggingface.co/bigscience/bloom
  - paper: https://arxiv.org/pdf/2211.05100.pdf
- Vicuna(7B/13B)：
  - 介绍：由UC Berkeley、CMU、Stanford和 UC San Diego的研究人员创建的 Vicuna-13B，通过在 ShareGPT 收集的用户共享对话数据中微调 LLaMA 获得。其中，使用 GPT-4 进行评估，发现 Vicuna-13B 的性能在超过90%的情况下实现了与ChatGPT和Bard相匹敌的能力；同时，在 90% 情况下都优于 LLaMA 和 Alpaca 等其他模型。而训练 Vicuna-13B 的费用约为 300 美元。不仅如此，它还提供了一个用于训练、服务和评估基于大语言模型的聊天机器人的开放平台：FastChat。
- Baize：
  - 介绍：白泽是在LLaMA上训练的。目前包括四种英语模型：白泽-7B、13B 、 30B（通用对话模型）以及一个垂直领域的白泽-医疗模型，供研究 / 非商业用途使用，并计划在未来发布中文的白泽模型。白泽的数据处理、训练模型、Demo 等全部代码已经开源。
- LLMZoo：
  - 介绍：来自香港中文大学和深圳市大数据研究院团队推出的一系列大模型，如：Phoenix（凤凰） 和 Chimera等 -MOSS：由复旦 NLP 团队推出的 MOSS 大语言模型。
- 小羊驼 FastChat
  - github: https://github.com/lm-sys/FastChat
- MiniGPT-4  
  - github: https://github.com/Vision-CAIR/MiniGPT-4

### 1.2【LLMs 入门实战序列连载】

清华大学开源中文版ChatGLM-6B模型学习与实战
【ChatGLM-6B入门-二】清华大学开源中文版ChatGLM-6B模型微调实战
【ChatGLM-6B入门-三】ChatGLM 特定任务微调实战
【ChatGLM-6B入门-四】ChatGLM + LoRA 进行finetune
【LLMs 入门实战 —— 五 】Stanford Alpaca 7B 模型学习与实战
【LLMs学习】关于大模型实践的一些总结
ChatGLM-6B 小编填坑记
【LLMs 入门实战 —— 六 】Chinese-LLaMA-Alpaca 模型学习与实战
【LLMs 入门实战 —— 七 】小羊驼 FastChat 模型学习与实战
【LLMs 入门实战 —— 八 】MiniGPT-4 模型学习与实战

### 1.3 NLP 项目军火库学习

- 【知识图谱构建 DeepKg】https://github.com/powerycy/DeepKg
  - 介绍：本项目致力于知识图谱的构建，目前正一点一点搭建其方法，也希望能帮助更多的人，

### 1.4 推荐系统 项目军火库学习

- 【fun-rec】https://github.com/datawhalechina/fun-rec
  - 介绍：主要是针对具有机器学习基础并想找推荐算法岗位的同学，教程由推荐算法基础、推荐算法入门赛、新闻推荐项目及推荐算法面经组成，形成了一个完整的从基础到实战再到面试的闭环。
- 【RecSys】https://github.com/qcymkxyc/RecSys
  - 介绍：项亮的《推荐系统实践》的代码实现

### 1.5 搜索引擎 项目军火库学习

- 【搜索引擎项目 开源】https://github.com/zuo369301826/Search_Project
  - 项目介绍：模拟百度搜索的方式实现站内搜索引擎，整个项目分为两大部分，HTTP服务器和搜索服务器：HTTP服务器来获取用户的请求，并分析请求以便获取我们所需要的特定信息，之后将信息传给搜索服务器；搜索服务器会根据这些信息进行处理并检索数据，将结果反馈给HTTP服务器，HTTP服务器收到索引结果将其打印到页面上
  - 项目特点：1. 使用到Google提供的 protobuf, gflag, glog 等开源框架来完成开发；2. 搜索服务器利用RPC协议，基于百度开源的高性能RPC框架 sofa-pbrpc 实现；3.搜索原理是以正排索引加倒排索引相结合的方式进行检索；4. HTTP服务器使用epoll模型，提高了并发的响应速度；5. HTTP服务器以CGI的方式调用搜索客户端完成检索功能
- 【Elastic】https://www.elastic.co/cn/
  - 介绍：Elasticsearch 是一个分布式、RESTful 风格的搜索和数据分析引擎，能够解决不断涌现出的各种用例。 作为 Elastic Stack 的核心，它集中存储您的数据，帮助您发现意料之中以及意料之外的情况。
- 【Nutch】http://nutch.sourceforge.net/docs/zh/about.html
  - 介绍：Nutch 是一个刚刚诞生开放源代码(open-source)的web搜索引擎。在它的主页有中文详细的说明。
- 【Lucene】http://jakarta.apache.org/lucene/docs/index.html
  - 介绍：Apache Lucene是一个开放源程序的搜寻器引擎，利用它可以轻易地为Java软件加入全文搜寻功能。Lucene的最主要工作是替文件的每一个字作索引，索引让搜寻的效率比传统的逐字比较大大提高，Lucen提供一组解读，过滤，分析文件，编排和使用索引的API，它的强大之处除了高效和简单外，是最重要的是使使用者可以随时应自已需要自订其功能。
- 【Egothor】http://www.egothor.org/
  - 介绍：Egothor是一个用Java编写的开源而高效的全文本搜索引擎。借助Java的跨平台特性，Egothor能应用于任何环境的应用，既可配置为单独的搜索引擎，又能用于你的应用作为全文检索之用。
- 【Oxyus】http://oxyus.sourceforge.net/
  - 介绍：是一个纯java写的web搜索引擎。
- 【BDDBot】http://www.twmacinta.com/bddbot/
  - 介绍：BDDBot是一个简单的易于理解和使用的搜索引擎。它目前在一个文本文件(urls.txt)列出的URL中爬行，将结果保存在一个数据库中。它也支持一个简单的Web服务器，这个服务器接受来自浏览器的查询并返回响应结果。它可以方便地集成到你的Web站点中。

### 1.6 计算广告 项目军火库学习

- 【美团DSP广告策略实践】https://tech.meituan.com/2017/05/05/mt-dsp.html
- 【互联网广告与计算广告学入门】http://web.stanford.edu/class/msande239/

## 二、Ai 神器

- ChatGPT Ai 神器
  - 【Ai神器】对话式AI——ChatGPT https://999.weny66.cn/chat?bd_vid=11997231054327469370
  - 【AI神器】GPT-4 在线体验网站 chatmindai.cn 
  - 【AI神器】ChatGPT3.5免登陆，国内可用 https://chat23.yqcloud.top/
  - Forefront Chat chat.forefront.ai 
  - Poe poe.com/GPT-4   
- 3D Ai 神器
  - Masterpiece Studio: https://xiaobot.net/p/SuperIndividual
  - Masterpiece Studio：https://masterpiecestudio.com
  - G3DAI {Jedi}：https://g3d.ai
  - Ponzu：https://www.ponzu.gg
  - PrometheanAI：https://www.prometheanai.com
  - Leonardo.Ai：https://leonardo.ai
- Art Ai 神器
  - Dream Up (Deviant Art)：https://www.dreamup.com
  - NightCafe Studio：https://creator.nightcafe.studio
  - Midjourney：https://www.midjourney.com/home/
  - Artbreeder：https://www.artbreeder.com
  - Wombo：https://www.wombo.art
- Audio Editing Ai 神器
  - Podcastle : Editing	https://podcastle.ai
  - Cleanvoice : Audio Editing	https://cleanvoice.ai
- Code Assistant Ai 神器
  - CodeSquire		https://codesquire.ai
  - Buildt	Code Assistant	https://www.buildt.ai
  - Hey, GitHub!	Code Assistant	https://githubnext.com/projects/hey-github
- 持续更新



## 三、小白 AI 入门学习

### 3.1 机器学习入门

- 【吴恩达机器学习系列课程】 https://www.bilibili.com/video/BV164411b7dx?from=search&seid=18138466354258018449&spm_id_from=333.337.0.0

### 3.2 NLP 入门

- 【2021吴恩达深度学习-NLP序列模型】https://www.bilibili.com/video/BV1Co4y1279R?from=search&seid=17563746002586971760&spm_id_from=333.337.0.0
- 【知识图谱入门】
  - [浙大图谱讲义 | 第一讲-知识图谱概论 — 第1节-语言与知识](https://mp.weixin.qq.com/s/xSeUX4cQeupWS4n331hz4Q)
  - [浙大图谱讲义 | 第一讲-知识图谱概论 — 第2节-知识图谱的起源](https://mp.weixin.qq.com/s/w4hL7Nl9djukJhkyxdYFyA)
  - [图谱讲义 | 第一讲-第3节-知识图谱的价值](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490691&idx=2&sn=69f78ad259aa0255f738a1aabb025b06&chksm=9bbff9b9acc870af1bc9fd066e8008f476f50a23e979037b5efc34ad806ccce655b1fd0cba4c&scene=21#wechat_redirect)
  - [图谱讲义 | 第一讲-第4节-知识图谱的技术内涵](https://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490691&idx=2&sn=69f78ad259aa0255f738a1aabb025b06&chksm=9bbff9b9acc870af1bc9fd066e8008f476f50a23e979037b5efc34ad806ccce655b1fd0cba4c&scene=21#wechat_redirect)
  - [图谱讲义 | 第二讲-第1节-什么是知识表示](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490820&idx=2&sn=02ac83e07bc2a8e94c605f7507372e64&chksm=9bbff83eacc87128f7241c17fe9950904e8f65da86b17a662454ce31d6263a344549cab1f316&scene=21#wechat_redirect)

### 3.3 计算广告 入门

- 【互联网广告与计算广告学入门】http://web.stanford.edu/class/msande239/
  - Lecture 1: Introduction, Supplementary notes
  - Lecture 2: Marketplace design, In class presentation, Supplementary notes
  - Lecture 3: Sponsored search 1, In class presentation
  - Lecture 4: Sponsored search 2, In class presentation
  - Lecture 5: Display advertising 1, In class presentation
  - Lecture 6: Display advertising 2, In class presentation
  - Lecture 7: Targeting, In class presentation
  - Lecture 8: Recommender systems, In class presentation 1, In class presentation 2
  - Lecture 9: Mobile, video, and other emerging formats, In class presentation 1, In class presentation 2
- 【刘鹏 – 计算广告学（推荐）】http://study.163.com/course/introduction.htm?courseId=321007
  - 介绍：刘鹏老师目前在360任商业产品首席架构师，在互联网广告领域实战经验丰富。其课程《计算广告学》内容深入浅出，由广告历史模式到新近技术，非常适合刚接触领域的朋友学习。
  - 广告的基本知识
  - 合约广告系统
  - 受众定向
  - 竞价广告系统
  - 搜索广告与广告网络Demand技术
  - 广告交易市场
- 【百度 – 计算广告学】http://openresearch.baidu.com/courses/1231.jhtml
  - 计算广告学概述
  - 搜索引擎广告原理、技术和工程实践
  - 内容匹配广告与展示广告原理、技术和实践
- 【王勇睿 – 互联网广告算法与系统实践】http://yuedu.baidu.com/ebook/3e31c551964bcf84b9d57bc0.html
  - 介绍：王老师是淘宝定向广告算法负责人。其课程结合了淘宝的广告实践经验，从广告理论到系统的技术实践，非常值得从业技术人员学习。
  - 互联网广告简介
  - 搜索广告
  - 定向广告
  - 实时广告竞价
  - 广告系统架构及挑战
- 【UCS -计算广告学入门】http://classes.soe.ucsc.edu/ism293/Spring09/index_archivos/Page456.html
  - Introduction and Overview
  - Information Retrieval (IR) for Computational
  - Marketplace design
  - Machine Learning Techniques
  - Sponsored Search I
  - Sponsored Search II
  - Graphical ads and guaranteed delivery
  - Contextual Advertising I
  - Contextual Advertising II
  - Behavioral Targeting (BT)

## 四、推广搜论文学习笔记

- 【[NLP 学习笔记](https://github.com/km1994/nlp_paper_study)】
  - 【Transformer】
    - [【关于 Efficient Transformers: A Survey】 那些你不知道的事](https://mp.weixin.qq.com/s/MqMHwYodAO7X9zTNUPKShg)
  - 【Bert 模型压缩】
    - [【关于自训练 + 预训练 = 更好的自然语言理解模型 】 那些的你不知道的事](https://mp.weixin.qq.com/s/JubvouJqpUPtZKmiAAsaSw)
    - [【关于 BERT to TextCNN】那些你不知道的事](https://mp.weixin.qq.com/s/g2hm6b95GQKBt2RfXymhnw)
  - 【命名实体识别】
    - [【关于 嵌套实体识别 之 Biaffine 】 那些你不知道的事](https://mp.weixin.qq.com/s/3w8v91yDMjuftjBmmMtuVw)
    - [paperShape 之 Biaffine](https://mp.weixin.qq.com/s/65E9D8gDwTfPIZo8W1M9gg)
    - [paperShape 之 盘点近年来的命名实体识别](https://mp.weixin.qq.com/s/AcwhD19lIAs0fgmEDbPi-g)
    - [【关于 Continual Learning for NER】那些你不知道的事](https://mp.weixin.qq.com/s/qKRrCvfxFrmnIZirDKZAxg)
  - 【关系抽取】
    - [【关于 关系抽取 之 HBT】 那些的你不知道的事](https://mp.weixin.qq.com/s/tQcw79CfvMLmDZ3KE89MOA)
    - [从头来看关系抽取](https://mp.weixin.qq.com/s/CCiVj-PLFhCKvVBB5qG9MA)
    - [从头来看关系抽取-远程监督来袭](https://mp.weixin.qq.com/s/wOTVUSOrVcS6I7JLZLPgWg)
  - 【文档级关系抽取】
    - [【关于 ATLOP】 那些的你不知道的事](https://mp.weixin.qq.com/s/qm3rxtAjTi7HGqZWshtC-Q)
    - [论文小综 | 文档级关系抽取方法（上）](https://mp.weixin.qq.com/s/FnQeOQKLpdQXwS0Xs3WxFg)
    - [论文小综 | 文档级关系抽取方法（下）](https://mp.weixin.qq.com/s/kq0ZQrgJjhTxdDvLMEfslw)
  - 【文本匹配】
    - [【关于 Sentence-BERT】 那些你不知道的事](https://mp.weixin.qq.com/s/jhX9oHtAKBxAOhj8hm1BdQ)
    - [Facebook： 亿级向量相似度检索库Faiss 原理+应用](https://mp.weixin.qq.com/s/r-zruEw_BSb1UflTkp7Ymg)
    - [句向量新方案CoSENT实践记录](https://mp.weixin.qq.com/s/Biasjj8qlY5wej3zsaeAIw)
  - 【实体链指】
    - [【关于 GENER 】 那些你不知道的事](https://mp.weixin.qq.com/s/bnc1Qy70IljsuEqZ_xZpig)
  - 【文本纠错】
    - [【关于 GECToR】 那些你不知道的事](https://mp.weixin.qq.com/s/HbFFC-SdscsiC80SGRnLLw)
  - 【问答机器人】
    - [TopicShare分享 之 场景式与检索式问答机器人](https://mp.weixin.qq.com/s/dvwSICJnuIOIoA-O5Or2Vg)
  - 【对话系统】
    - [《【社区说】一起来聊聊 Rasa 3.0》 不完全笔记](https://mp.weixin.qq.com/s/pdS9VRIU8hm2-bk8DsPNdQ)
    - [（一）对话机器人概述](https://mp.weixin.qq.com/s/drwKUXIsmMBY_W4-BmMppQ)
    - [（二）RASA开源引擎介绍](https://mp.weixin.qq.com/s/d_EtuAax3mJ3eCdIu8YKNQ)
    - [（三）RASA NLU语言模型](https://mp.weixin.qq.com/s/Hc0ggnu9Twav4y3p6LLguA)
    - [（四）RASA NLU分词器](https://mp.weixin.qq.com/s/E0yWpSEFyQNJW5KI7RuMzg)
    - [（五）RASA NLU特征生成器](https://mp.weixin.qq.com/s/pYHJiOWn755uv1KbBkhFlg)
    - [（六）RASA NLU意图分类器](https://mp.weixin.qq.com/s/NaF6ugxjwufeA5Ezj0gEHQ)
    - [（七）RASA NLU实体提取器](https://mp.weixin.qq.com/s/OxFgOe00L2UjpHoxYHzh_g)
    - [（九）RASA自定义pipeline组件](https://mp.weixin.qq.com/s/Q5Z_n9yiLk2YcnpFLGzBqQ)
    - [（十）RASA CORE Policy](https://mp.weixin.qq.com/s/YBoGv_IUVZElQMxHZ68Wcw)
    - [（十一）RASA CORE Action](https://mp.weixin.qq.com/s/B-RITgn4OagCrEiMZPn_Lw)
    - [（十二）RASA Domain](https://mp.weixin.qq.com/s/4O18bSNH-U8kjxRzRn4Mfg)
    - [（十三）RASA 训练数据](https://mp.weixin.qq.com/s/2HyQAUV02ziqQ0ZPGvLH7Q)
    - [（十四）RASA story](https://mp.weixin.qq.com/s/ovFF8fb1qrxh-MH-R_Namw)
    - [（十五）Rasa Rules](https://mp.weixin.qq.com/s/lDDDI1S51gsiXfYkbIYWfQ)
    - [（十六）RASA最佳实践](https://mp.weixin.qq.com/s/ork9WzlaIOvtbm0jJro7JQ)
    - [（十七）基于RASA开始中文机器人](https://mp.weixin.qq.com/s/4l4ePC-BOzlb8QMgPIZ8Ew)
    - [（十八）基于RASA开始中文机器人实现机制](https://mp.weixin.qq.com/s/1mywqJO1AemYghHDquOhjw)
    - [（十九）基于知识图谱的问答系统（KBQA）](https://mp.weixin.qq.com/s/MyxvBHzVnepo9jTQ-SlNPQ)
    - [（二十）基于阅读理解的问答系统](https://mp.weixin.qq.com/s/SDjGoz8mPQ9yD5alMs9MlA)
    - [DIET：Dual Intent and Entity Transformer——RASA论文翻译](https://mp.weixin.qq.com/s/LMgNlxMSnnEpAMoiySMdaw)
    - [（二十一）RASA应用常见问题](https://mp.weixin.qq.com/s/c9OdDa0mmyAefRcmcE4CJg)
    - [（二十二）RASA的超参数优化](https://mp.weixin.qq.com/s/dk-DpfolasBiGiFfUqcBGg)
    - [（二十三）机器人测试与评估](https://mp.weixin.qq.com/s/OK5p2Dbv-VW1QRN7L8GemA)
    - [（二十四）利用Rasa Forms创建上下文对话助手](https://mp.weixin.qq.com/s/TN0y7BSGAogOKwceNuOwhw)
  - 【KBQA】
    - [【关于 Complex KBQA】 那些你不知道的事 (上)](https://mp.weixin.qq.com/s/ADbD1HJK-d_cG4OB3ST-rw)
    - [【关于 Complex KBQA】 那些你不知道的事 (中)](https://mp.weixin.qq.com/s/w5Eliyfpnsn56mNz372MCg)
    - [【关于 Complex KBQA】 那些你不知道的事 (下)](https://mp.weixin.qq.com/s/td5TXFqIMfZ9tkkOWX752A)
  - 【事件抽取】
    - [【关于 MLBiNet】那些你不知道的事](https://mp.weixin.qq.com/s/6Ep8XVPxjZ84rnJKYH1caQ)
  - 【Prompt Tuning】
    - [Prompt Tuning 简介](https://mp.weixin.qq.com/s/8aWp8Ys581zCkuh4TpuOhA)
  - 【新词发现】
    - [打造自己的 PTM！新词挖掘+预训练](https://mp.weixin.qq.com/s/eEmuuMae0cWOXscl9ZZCgg)
  - 【Text to SQL】
    - [文本转SQL？这里有一份Baseline解析](https://mp.weixin.qq.com/s/F2KOszLcshrTigJIpMhA7g)
- 【[推荐系统 学习笔记](https://github.com/km1994/RS_paper_study)】
  - [推荐系统技术演进趋势：召回篇](https://mp.weixin.qq.com/s/XT0RNJoi3pUgm4K_xvNhcQ)
  - [推荐系统技术演进趋势：排序篇](https://mp.weixin.qq.com/s/POuacV9BFgKm9ZuCNfhW6g)
  - [推荐系统技术演进趋势：重排篇](https://mp.weixin.qq.com/s/Gk_c9dPnYyGBQMATga76bQ)
  - [推荐系统是如何找到相似用户的？](https://mp.weixin.qq.com/s/yfsOr9g-iujr8vpsLaEPuA)
  - [万字长文详述对话推荐系统的逻辑与演化](https://mp.weixin.qq.com/s/doulyVPexH9vDOFm94JPSQ)
  - [推荐系统中模型自适应相关技术梳理总结](https://mp.weixin.qq.com/s/LVOjyoNO-SpdU8zN10hE6Q)
- 【[GCN 学习笔记](https://github.com/km1994/GCN_study)】
  - [【关于 GCN in NLP 】那些你不知道的事](https://mp.weixin.qq.com/s/6rK2GTjFrYgfYgoDfbogvg)
- 【[计算广告论文及资料列表github repo](https://github.com/wzhe06/Ad-papers)】
  - [三大视角，聊聊我眼中的广告系统](https://mp.weixin.qq.com/s/ofse_CY19j5YGlire2dNVQ)
- 【[推荐系统论文及资料列表github repo](https://github.com/wzhe06/Reco-papers)】
- 【搜索引擎】
  - [【关于 PLM for Web-scale Retrieval in Baidu Search 】 那些你不知道的事](https://mp.weixin.qq.com/s/BjKp-9kgInPIY7E0Jn7noA)
  - [EMNLP 2021 | RocketQAv2：稠密段落检索和段落精排的联合训练方法](https://mp.weixin.qq.com/s/y6g7h3dCVYmhWs3wyplxrg)

## 五、推广搜 面经篇

- 【 [NLP百面百搭](https://github.com/km1994/NLP-Interview-Notes)】
  - 【机器学习】
    - [【关于 正则化】那些你不知道的事](https://mp.weixin.qq.com/s/32tcqdEvHBKaLsnC6_RAlg)
    - [【关于 优化算法】那些你不知道的事](https://mp.weixin.qq.com/s/GGeUlD-XzNy5_h1RM_pTsA)
    - [【关于 BatchNorm vs LayerNorm】那些你不知道的事](https://mp.weixin.qq.com/s/XapnWn2E7mGLU9LGvKhSdA)
    - [【关于 归一化】那些你不知道的事](https://mp.weixin.qq.com/s/Hb5DRJ_0BkU5jrid9ZKQug)
    - [【关于 过拟合和欠拟合】那些你不知道的事](https://mp.weixin.qq.com/s/dU_QSNNIFRxRbgBwxJw4dg)
  - 【深度学习】
    - [【关于 CNN】那些你不知道的事](https://mp.weixin.qq.com/s/C8mVsruaiBkXCNCzxpZ6Wg)
    - [【关于 Attention 】那些你不知道的事](https://mp.weixin.qq.com/s/xXjCaxzlPdxv9auhn-q77Q)
    - [【关于Transformer】 那些的你不知道的事（上）](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490647&idx=1&sn=a711ed1c556cdae1821bab251ee3893f&chksm=9bbff96dacc8707bdb133acfa55d599ca8dcea47027aa1fc2344d06d84584dbd4981c939fee0&scene=21#wechat_redirect)
    - [【关于Transformer】 那些的你不知道的事（中）](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490690&idx=1&sn=8ec490c4d7ed9e66b28ad063d12aae8d&chksm=9bbff9b8acc870ae0f92344554969d3f52a6b7674a61a16c326870880f2ee90259f42fb849ba&scene=21#wechat_redirect)
    - [【关于Transformer】 那些的你不知道的事 (下)](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490691&idx=1&sn=a42ddc38566b4b71c0410ab3fefd659f&chksm=9bbff9b9acc870afaa380497225a5dde790b7a6e45baacc579050a2d25b33f9a5895314e5231&scene=21#wechat_redirect)
  - 【NLP任务篇】
    - 【预训练模型】
      - [【关于 TF-idf】 那些你不知道的事](https://mp.weixin.qq.com/s/BOkFCAUqbMQgFUMvJGKsIA)
      - [【关于 Word2vec】 那些你不知道的事](https://mp.weixin.qq.com/s/2FEnUc7c272tKdr5nt3m-g)
      - [【关于 fastText】 那些你不知道的事](https://mp.weixin.qq.com/s/km3Eidn2qWz6quqqX8wXlw)
      - [【关于 Elmo】 那些你不知道的事](https://mp.weixin.qq.com/s/DvaBvIZvfzCRhAHSIcECEA)
      - [【关于Bert】 那些的你不知道的事(上)](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490819&idx=1&sn=f806e11465c50b932bd12fe4fd319278&chksm=9bbff839acc8712f4f563eaec757c4ca17f840e0e27dc9b7b5907b6b071f6b55d06ef2f68aa2&scene=21#wechat_redirect)
      - [【关于Bert】 那些的你不知道的事(下)](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490820&idx=1&sn=f791ded495f54b880820f816c06891ed&chksm=9bbff83eacc87128bf47a28780a91afb4b8a3678ecbabf1d057dfa9c74f74a2ab78e1f4016bf&scene=21#wechat_redirect)
      - [【关于 Bert 源码解析I 之 主体篇 】 那些的你不知道的事](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490821&idx=1&sn=0154017f77c66ffc9e40f2379d6e2b00&chksm=9bbff83facc871291898e865d0239312e457ce7aded28fda6af2b7f38bf2acf77f7988b0024a&scene=21#wechat_redirect)
      - [【关于 Bert 源码解析II 之 预训练篇 】 那些的你不知道的事](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490821&idx=2&sn=0746fb7ca5b712d8eac8ec682f2603f0&chksm=9bbff83facc8712972c4b546b181e674efb90d639dad9efdd8c7c04dc042cf4fd4ecae2df02b&scene=21#wechat_redirect)
      - [【关于 Bert 源码解析III 之 微调 篇 】 那些的你不知道的事](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490821&idx=3&sn=d36f9e3a5c6b17b8bfc1dccba091d56b&chksm=9bbff83facc87129c8390063e1d6198188e4efe3377668c85e407d5cb71db4941b768cd01108&scene=21#wechat_redirect)
      - [【关于 Bert 源码解析IV 之 句向量生成篇 】 那些的你不知道的事](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490821&idx=4&sn=850510c30b2984eb8b23ee2a361c4804&chksm=9bbff83facc871292255339cb1ce288ae61118ac1ada3e27b3408a6338133d1bb4124f3be796&scene=21#wechat_redirect)
      - [【关于 Bert 越大越精序列】那些的你不知道的事（一）](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490853&idx=1&sn=a13eee9955df34c1aa06976cad35e32b&chksm=9bbff81facc871090654e7fb83b79b360fbe25b26fc122f6a3efb215873e133088e2f0c0b3ec&scene=21#wechat_redirect)
      - [【关于 Bert 越大越精序列】那些的你不知道的事（二）](http://mp.weixin.qq.com/s?__biz=MzAxMTU5Njg4NQ==&mid=2247490887&idx=1&sn=28d526ff1744bfab8c0c4bff3b83946d&chksm=9bbff87dacc8716bf26207f22fa4756e4b571ed3d52e1727815072d3113158b4558e6f0ba4a6&scene=21#wechat_redirect)
      -  [【关于 Bert 越大越精序列】那些的你不知道的事（三）](https://mp.weixin.qq.com/s/sc18ceRF5kuuIzQkWkalow)
    - 【新词发现】
      - [【关于 新词发现】那些你不知道的事](https://mp.weixin.qq.com/s/hDFtni0a0ChS6ck8vgRVUw)
    - 【关键词提取】
      - [【关于 关键词提取】 那些你不知道的事](https://mp.weixin.qq.com/s/tM-zHFlivfqULnkOXfKHyw)
      - [【关于 KeyBERT 】 那些你不知道的事](https://mp.weixin.qq.com/s/HWziKPrDxVf6GiNebeFIbQ)
- 【[推荐系统百面百搭](https://github.com/km1994/RES-Interview-Notes)】 
- 待续

## 六、框架篇

### 6.1 Pytorch 学习

- 【PyTorch英文版官方手册】https://pytorch.org/tutorials/
  - 介绍：PyTorch英文版官方手册：https://pytorch.org/tutorials/。对于英文比较好的同学，非常推荐该PyTorch官方文档，一步步带你从入门到精通。该文档详细的介绍了从基础知识到如何使用PyTorch构建深层神经网络，以及PyTorch语法和一些高质量的案例。
- 【PyTorch中文官方文档】https://pytorch-cn.readthedocs.io/zh/latest/
  - 介绍：PyTorch中文官方文档：https://pytorch-cn.readthedocs.io/zh/latest/。阅读上述英文文档比较困难的同学也不要紧，我们为大家准备了比较官方的PyTorch中文文档，文档非常详细的介绍了各个函数，可作为一份PyTorch的速查宝典。
- 【偏算法实战的PyTorch代码教程】https://github.com/yunjey/pytorch-tutorial
  - 介绍：这是一个比较偏算法实战的PyTorch代码教程，在github上有很高的star，https://github.com/yunjey/pytorch-tutorial。建议大家在阅读本文档之前，先学习上述两个PyTorch基础教程。
- 【Pytorch 开源书籍】https://github.com/zergtant/pytorch-handbook
  - 介绍：介绍一本开源书籍：https://github.com/zergtant/pytorch-handbook。这是一本开源的书籍，目标是帮助那些希望和使用PyTorch进行深度学习开发和研究的朋友快速入门。但本文档不是内容不是很全，还在持续更新中。
- 【《动手学深度学习》pytorch】http://tangshusen.me/Dive-into-DL-PyTorch/#/
- 【Pytorch模型训练实用教程】https://github.com/km1994/PyTorch_Tutorial
- 【Pytorch 进阶 NLP 实战】https://github.com/km1994/NLP_pytorch_project
- 【ark-nlp NLP 工具库】https://github.com/xiangking/ark-nlp
  - 介绍：王翔大佬开源的 军火库，主要是收集和复现学术与工作中常用的NLP模型

### 6.2 tensorflow 学习

- 【TensorFlow 官网】https://www.tensorflow.org/tutorials
  - 介绍：官网教程绝对是最香的学习资料
- 【TensorFlow Examples】https://github.com/aymericdamien/TensorFlow-Examples
  - 介绍：适合初学者的Tensorflow教程和代码示例：https://github.com/aymericdamien/TensorFlow-Examples。该教程不光提供了一些经典的数据集，更是从实现最简单的“Hello World”开始，到机器学习的经典算法，再到神经网络的常用模型，一步步带你从入门到精通，是初学者学习Tensorflow的最佳教程。
- 【TensorFlow Tutorials】https://github.com/pkmital/tensorflow_tutorials
  - 介绍：从Tensorflow基础知识到有趣的项目应用：https://github.com/pkmital/tensorflow_tutorials。同样是适合新手的教程，从安装到项目实战，教你搭建一个属于自己的神经网络。
- 【Tensorflow Tutorials using Jupyter Notebook】https://github.com/sjchoi86/Tensorflow-101
  - 介绍：使用Jupyter Notebook用Python语言编写的TensorFlow教程：https://github.com/sjchoi86/Tensorflow-101。本教程是基于Jupyter Notebook开发环境的Tensorflow教程，Jupyter Notebook是一款非常好用的交互式开发工具，不仅支持40多种编程语言，还可以实时运行代码、共享文档、数据可视化、支持markdown等，适用于机器学习、统计建模数据处理、特征提取等多个领域。
- 【TensorFlow_Exercises】https://github.com/terryum/TensorFlow_Exercises
  - 介绍：Tensorflow代码练习：https://github.com/terryum/TensorFlow_Exercises。一个从易到难的Tensorflow代码练习手册。非常适合学习Tensorflow的小伙伴。
- 【BERT和ALBERT在下游任务中的应用】https://github.com/km1994/bert-for-task
  - 介绍：Bert 在 NLP 任务中的 实现

### 6.3 keras 学习

- 【bert4keras】https://github.com/bojone/bert4keras
  - 介绍：苏神开源的军火库，重新实现的keras版的transformer模型库，致力于用尽可能清爽的代码来实现结合transformer和keras。

### 6.4 分布式训练框架 学习

- 第一类：深度学习框架自带的分布式训练功能。如：TensorFlow、PyTorch、MindSpore、Oneflow、PaddlePaddle等。
- 第二类：基于现有的深度学习框架（如：PyTorch、Flax）进行扩展和优化，从而进行分布式训练。如：Megatron-LM（张量并行）、DeepSpeed（Zero-DP）、Colossal-AI（高维模型并行，如2D、2.5D、3D）、Alpa（自动并行）等

## 七、竞赛篇

### 5.1 国内竞赛

- 【科大讯飞开发者大赛】http://challenge.xfyun.cn/
- 【阿里天池】https://tianchi.aliyun.com/
- 【biendata】https://www.biendata.xyz/
- 【datafountain】https://www.datafountain.cn/
- 【百度飞桨】https://aistudio.baidu.com/

### 5.2 竞赛公众号

- 【麻婆豆腐AI】
  - 介绍：会介绍 最近可以参加的一些赛事

### 5.3 NLP 竞赛军火库

- 【NLP人军火库 工具库】https://github.com/TingFree/NLPer-Arsenal
  - 介绍：NLP人军火库，主要收录NLP竞赛策略实现、各任务教程、经验贴、学习资料以及会议时间等
- [【CHIP2021-Task3-临床术语标准化任务 开源方案】](https://mp.weixin.qq.com/s/p_H8LfLRBlV4AsXNwxdPKg)
  - [github 源码](https://github.com/DataArk/CHIP2021-Task3-Top3)
  - 评测网站: http://cips-chip.org.cn/2021/eval3
  - 所有的代码都是基于我们开源的ark-nlp实现。 本次CHIP2021的临床术语标准化任务是没有A榜的，所以代码调试都是在天池的中文医疗信息处理数据集CBLUE的临床术语标准化任务上完成的
  - ark-nlp地址：https://github.com/xiangking/ark-nlp
  - 中文医疗信息处理数据集CBLUE:https://tianchi.aliyun.com/dataset/dataDetail?dataId=95414
- [【CHIP2021医学对话临床发现阴阳性判别任务冠军 开源方案】](https://mp.weixin.qq.com/s/avPsFDJS10V3aM2a1RWleQ)
  - [github 源码](https://github.com/DataArk/CHIP2021-Task1-Top1)
  - 名称：CBLUE: A Chinese Biomedical Language Understanding Evaluation Benchmark
  - 测评任务：CBLUE 1.0是由CHIP会议往届的学术评测比赛和阿里夸克医疗搜索业务的数据集组成，包括医学文本信息抽取（实体识别、关系抽取）、医学术语归一化、医学文本分类、医学句子关系判定和医学QA共5大类任务8个子任务。
  - 任务类型：文本分类、文本相似、命名实体识别、关系抽取和术语标准化（可以看成没有上下文的实体链接任务）
  - 测评链接：https://tianchi.aliyun.com/dataset/dataDetail?dataId=95414
- 【CBLUE-阿里天池中文医疗NLP打榜Baseline】https://github.com/DataArk/CBLUE-Baseline
- 【山东大数据竞赛—网格事件智能分类 baseline】 https://github.com/xiangking/ShandongDataCompetition2021-grid-events-classification-baseline
  - 测评任务：基于网格事件数据，对网格中的事件内容进行提取分析，对事件的类别进行划分，具体为根据提供的事件描述，对事件所属政务类型进行划分
  - 任务类型：文本分类
  - 测评链接：http://data.sd.gov.cn/cmpt/cmptDetail.html?id=67

## 八、语料篇

### 8.1 NLP 语料

- 【nlp_chinese_corpus 】https://github.com/brightmart/nlp_chinese_corpus
  - 介绍：大规模中文自然语言处理语料 Large Scale Chinese Corpus for NLP

### 8.2 推荐系统 语料

- 【MovieLens】https://grouplens.org/datasets/movielens/
  - 介绍：MovieLens数据集由GroupLens研究组在 University of Minnesota — 明尼苏达大学（与我们使用数据集无关）中组织的。 MovieLens是电影评分的集合，有各种大小。 数据集命名为1M，10M和20M，是因为它们包含1,10和20万个评分。 最大的数据集使用约14万用户的数据，并覆盖27,000部电影。 除了评分之外，MovieLens数据还包含类似“Western”的流派信息和用户应用的标签，如“over the top”和“Arnold Schwarzenegger”。 这些流派标记和标签在构建内容向量方面是有用的。内容向量对项目的信息进行编码，例如颜色，形状，流派或真正的任何其他属性 - 可以是用于基于内容的推荐算法的任何形式。
- 【Book-Crossings】
  - 介绍：Book-Crossings是由Cai-Nicolas Ziegler根据http://bookcrossing.com的数据编写的图书评分数据集。 它包含90000个用户的270000本书的110万个评分。评分范围从1到10，还包括隐性评分。
- 【Last.fm】http://www2.informatik.uni-freiburg.de/~cziegler/BX/
  - 介绍：Last.fm提供音乐推荐的数据集。 对于数据集中的每个用户，包含他们最受欢迎的艺术家的列表以及播放次数。它还包括可用于构建内容向量的用户应用标签。
- 【Dating Agency】[（http://www2.informatik.uni-freiburg.de/~cziegler/BX/）](http://www.occamslab.com/petricek/data/)
  - 介绍：该数据集包含2006年4月4日导出的135,359位LibimSeTi用户对168,791个配置文件的17,359,346个匿名评分。
- 其他：https://zhuanlan.zhihu.com/p/258566760

### 8.3 标注工具篇

- [你还在为找不到实体关系标注器而烦恼么？](https://mp.weixin.qq.com/s/1HVvA09NLGqrnJhjHSDzIQ)
- [https://labelstud.io/](https://labelstud.io/)
- [doccano](https://github.com/doccano/doccano)

## 九、公众号篇

- 关于NLP那些你不知道的事
  - 介绍：关于NLP那些你不知道的事
- CS的陋室
  - 介绍：叉烧大佬的经验分享帖，遇到问题先翻该公众号，可能会有意想不到的收获。
- DataArk
  - 介绍：DataArk以数据为驱动、以开源分享为导向，致力于数据挖掘、算法创新和实用工具的开发。
- 智能推荐系统
  - 介绍：专注于智能推荐系统，这里有最新最全的个性化推荐相关算法和行业应用分享，欢迎关注，和你在推荐的海洋中一起遨游，共同探索未知新世界。
- DataFunTalk
  - 介绍：专注于大数据、人工智能技术应用的分享与交流。致力于成就百万数据科学家。定期组织技术分享直播，并整理大数据、推荐/搜索算法、广告算法、NLP自然语言处理算法、智能风控、自动驾驶、机器学习/深度学习等技术应用文章。
- RUC Al Box
  - 介绍：本公众号主要关注使用人工智能技术来解决自然语言处理与社交媒体数据挖掘的研究内容。分享Al前沿，解读热点论文。
- NewBeeNLP
  - 介绍：会介绍 很多 NLP 优秀笔记
- 开放知识图谱
  - 介绍：openKG:开放促进互联、链接创造价值
- WeData365
  - 介绍：学习 【搜索引擎】 的小伙伴一定要关注，因为有很多 【搜索引擎】 干货分享
- 科学空间
  - 介绍：苏神的公众号，每周四苏神都会开源他的研究笔记。
- 老刘说NLP
  - 介绍：360人工智能研究院大佬刘焕勇刘大佬的公众号，定期发布语言资源、工程实践、技术总结等内容。
- 数据拾光者
  - 介绍：学习 【广告】 的小伙伴一定要关注，因为有很多 【广告】 干货分享
- 泛函的范
  - 介绍：鹅厂大佬的学习笔记分享
- 计算广告那些事
  - 介绍：学习 【广告】 的小伙伴一定要关注，因为有很多 【广告】 干货分享
- 药老算法
  - 介绍：学习 【搜索引擎】 的小伙伴一定要关注，因为有很多 【搜索引擎】 干货分享
- 机器学习算法与自然语言处理
  - 介绍：一个有情怀的公众号。机器学习、自然语言处理、算法等知识集中营、期待与你相遇~
- 王喆的机器学习笔记
  - 介绍：推荐系统，计算广告，机器学习领域前沿进展
- AINLP
  - 介绍：关注AI、NLP、机器学习、推荐系统、计算广告等相关技术。公众号可直接对话双语聊天机器人，尝试自动对联、作诗机、藏头诗生成器，调戏夸夸机器人、彩虹屁生成器，使用中英翻译，查询相似词，测试NLP相关工具包。
- 李rumor
  - 介绍：李rumor 小姐姐 的学习笔记分享
- 夕小瑶的卖萌屋
  - 介绍：自然语言处理、计算机视觉、信息检索、推荐系统、机器学习

## 十、学习笔记

- 科学空间：
  - 地址：https://spaces.ac.cn/
  - 介绍：苏神经验学习笔记分享
- 魔法学院的Chilia
  - 地址：https://www.zhihu.com/people/wang-zi-han-81-18/posts
  - 方向：推荐系统 | 广告 | 搜索| NLP
- 水哥
  - 地址：https://www.zhihu.com/people/shui-ge-99
  - 方向：推荐系统 
- JayJay
  - 地址：https://www.zhihu.com/people/lou-jie-9
- 我想了很多事
  - 地址：https://www.zhihu.com/people/yuan-chao-yi-83


## 十一、部署笔记

- [Bert与TensorRT部署手册，享受丝滑的顺畅](https://mp.weixin.qq.com/s/jW-I-uRLOtQtvVX5qyHoHg)

## 参考

1. [关于大模型实践的一些总结](https://zhuanlan.zhihu.com/p/616929229)